/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.lib.pdf;

import jp.kitec.lib.kwt.KColor;
import jp.kitec.lib.kwt.KFill;
import jp.kitec.lib.kwt.KFont;
import jp.kitec.lib.kwt.KImage;
import jp.kitec.lib.pdf.PdfGraphics;

public class PdfCommandGraphics {
    private PdfGraphics mGraphics;

    public PdfCommandGraphics(PdfGraphics g) {
        this.mGraphics = g;
    }

    protected void reset() {
        this.mGraphics.reset();
    }

    public void dispose() {
        this.mGraphics.dispose();
    }

    public void translate(int x, int y) {
        this.mGraphics.translate(x, y);
    }

    public void translate(double x, double y) {
        this.mGraphics.translate(x, y);
    }

    public void setClip(int x, int y, int width, int height) {
        this.mGraphics.setClip(x, y, width, height);
    }

    public void setClip(double x, double y, double width, double height) {
        this.mGraphics.setClip(x, y, width, height);
    }

    public void releaseClip() {
        this.mGraphics.releaseClip();
    }

    public KColor getColor() {
        return this.mGraphics.getColor();
    }

    public void setColor(KColor c) {
        if (c == null) {
            throw new NullPointerException();
        }
        this.mGraphics.setColor((KFill)c);
    }

    public KFont getFont() {
        return this.mGraphics.getFont();
    }

    public String getFontName() {
        return this.mGraphics.getFontName();
    }

    public int getFontStyle() {
        return this.mGraphics.getFontStyle();
    }

    public double getFontSize() {
        return this.mGraphics.getFontSize();
    }

    public boolean isFontEmbedded() {
        return this.mGraphics.isFontEmbedded();
    }

    public void setFont(KFont font) {
        this.mGraphics.setFontName(font.getName());
        this.mGraphics.setFontStyle(font.getStyle());
        this.mGraphics.setFontSize(font.getSize());
    }

    public void setFont(String name, int style, double size) {
        this.mGraphics.setFont(name, style, size);
    }

    public void setFontName(String name) {
        this.mGraphics.setFontName(name);
    }

    public void setFontStyle(int style) {
        this.mGraphics.setFontStyle(style);
    }

    public void setFontSize(double size) {
        this.mGraphics.setFontSize(size);
    }

    public void setFontEmbed(boolean embed) {
        this.mGraphics.setFontEmbed(embed);
    }

    public void setLinePattern(float[] dash) {
        this.mGraphics.setLinePattern(dash);
    }

    public double[] getLinePattern() {
        return this.mGraphics.getLinePattern();
    }

    public void setLineWidth(double width) {
        this.mGraphics.setLineWidth(width);
    }

    public double getLineWidth() {
        return this.mGraphics.getLineWidth();
    }

    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.mGraphics.drawArc(x, y, width, height, startAngle, arcAngle);
    }

    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.mGraphics.fillArc(x, y, width, height, startAngle, arcAngle);
    }

    public void drawArc(double x, double y, double width, double height, double startAngle, double arcAngle, boolean fill) {
        this.mGraphics.drawArc(x, y, width, height, startAngle, arcAngle, fill);
    }

    public void drawPatternedGroupPolygon(String name, double[] xPoints, double[] yPoints, int[] nPoints) {
        this.mGraphics.drawPatternedGroupPolygon(name, xPoints, yPoints, nPoints);
    }

    public void drawShadingGroupPolygon(String name, double[] xPoints, double[] yPoints, int[] nPoints) {
        this.mGraphics.drawShadingGroupPolygon(name, xPoints, yPoints, nPoints);
    }

    public void drawGroupPolygon(double[] xPoints, double[] yPoints, int[] nPoints, boolean fill) {
        this.mGraphics.drawGroupPolygon(xPoints, yPoints, nPoints, fill);
    }

    public boolean drawImage(KImage img, int x, int y) {
        return this.mGraphics.drawImage(img, x, y);
    }

    public boolean drawImage(KImage img, int x, int y, int width, int height) {
        return this.mGraphics.drawImage(img, x, y, width, height);
    }

    public boolean drawImage(KImage img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2) {
        return this.mGraphics.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2);
    }

    public boolean drawImage(KImage img, double x, double y, double width, double height) {
        if (img == null) {
            return false;
        }
        return this.mGraphics.drawImage(img, x, y, width, height);
    }

    public boolean drawImage(String file, double x, double y) {
        return this.mGraphics.drawImage(file, x, y, 0.0, 0.0, 0.0);
    }

    public boolean drawImage(String file, double x, double y, double width, double height) {
        return this.mGraphics.drawImage(file, x, y, width, height, 0.0);
    }

    public boolean drawImageAsJpeg(String file, double x, double y, double width, double height) {
        return this.mGraphics.drawImageAsJpeg(file, x, y, width, height, 0.0);
    }

    public boolean drawImage(KImage img, double x, double y) {
        if (img == null) {
            return false;
        }
        return this.mGraphics.drawImage(img, x, y);
    }

    public boolean drawImageAsJpeg(byte[] pixels, double x, double y, double w, double h, double ow, double oh, double theta) {
        return this.mGraphics.drawImageAsJpeg(pixels, x, y, w, h, ow, oh, theta);
    }

    public void drawItemImage(String file, String formatName, String ItemName) {
        this.mGraphics.drawItemImage(file, formatName, ItemName);
    }

    public void drawItemString(String str, String formatName, String ItemName) {
        this.mGraphics.drawItemString(str, formatName, ItemName);
    }

    public void drawLink(String url, double x1, double y1, double x2, double y2, double boderWidth) {
        this.mGraphics.drawLink(url, x1, y1, x2, y2, boderWidth);
    }

    public void drawLine(double x1, double y1, double x2, double y2) {
        this.mGraphics.drawLine(x1, y1, x2, y2);
    }

    public void drawOval(double x, double y, double width, double height) {
        this.mGraphics.drawArc(x, y, width, height, 0.0, 360.0, false);
    }

    public void fillOval(double x, double y, double width, double height) {
        this.mGraphics.drawArc(x, y, width, height, 0.0, 360.0, true);
    }

    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        this.mGraphics.drawPolyline(xPoints, yPoints, nPoints);
    }

    public void drawPolyline(double[] xPoints, double[] yPoints, int nPoints) {
        this.mGraphics.drawPolyline(xPoints, yPoints, nPoints);
    }

    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.mGraphics.drawPolygon(xPoints, yPoints, nPoints);
    }

    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.mGraphics.fillPolygon(xPoints, yPoints, nPoints);
    }

    public void drawPatternedPolygon(String name, double[] xPoints, double[] yPoints, int nPoints) {
        this.mGraphics.drawPatternedPolygon(name, xPoints, yPoints, nPoints);
    }

    public void drawShadingPolygon(String name, double[] xPoints, double[] yPoints, int nPoints) {
        this.mGraphics.drawShadingPolygon(name, xPoints, yPoints, nPoints);
    }

    public void drawPolygon(double[] xPoints, double[] yPoints, int nPoints, boolean fill) {
        this.mGraphics.drawPolygon(xPoints, yPoints, nPoints, fill);
    }

    public void drawRect(double x, double y, double width, double height) {
        this.mGraphics.drawRect(x, y, width, height, false);
    }

    public void fillRect(double x, double y, double width, double height) {
        this.mGraphics.drawRect(x, y, width, height, true);
    }

    public void drawRect(double x, double y, double width, double height, boolean fill) {
        this.mGraphics.drawRect(x, y, width, height, fill);
    }

    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.mGraphics.drawRoundRect(x, y, width, height, arcWidth, arcHeight, false);
    }

    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.mGraphics.drawRoundRect(x, y, width, height, arcWidth, arcHeight, true);
    }

    public void drawRoundRect(double x, double y, double width, double height, double arcWidth, double arcHeight, boolean isFill) {
        this.mGraphics.drawRoundRect(x, y, width, height, arcWidth, arcHeight, isFill);
    }

    public void drawString(String str, double x, double y, boolean centering, double rotate) {
        this.mGraphics.drawString(str, x, y, centering, rotate, 0.0, null);
    }

    public void drawString(String str, double x, double y, double rotate) {
        this.drawString(str, x, y, false, rotate);
    }

    public void drawString(String str, double x, double y, boolean centering) {
        this.drawString(str, x, y, centering, 0.0);
    }

    public void drawString(String str, double x, double y) {
        this.drawString(str, x, y, false, 0.0, 0.0, null);
    }

    public void drawString(String str, double x, double y, double width, String type) {
        this.drawString(str, x, y, false, 0.0, width, type);
    }

    public void drawString(String str, double x, double y, boolean center, double rotate, double width, String type) {
        this.mGraphics.drawString(str, x, y, center, rotate, width, type);
    }

    public boolean draw3D(byte[] idtf, double x1, double y1, double x2, double y2, double fov) {
        return this.mGraphics.draw3D(idtf, x1, y1, x2, y2, fov);
    }

    public void draw(String s) {
        this.mGraphics.draw(s);
    }
}

