/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.lib.pdf;

import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.Vector;
import jp.kitec.lib.io.AbstFile;
import jp.kitec.lib.kwt.KDimension;
import jp.kitec.lib.pdf.PdfGraphics;

public class PdfCommand {
    public static final int A1 = 0;
    public static final int A2 = 1;
    public static final int A3 = 2;
    public static final int A4 = 3;
    public static final int A5 = 4;
    public static final int A6 = 5;
    public static final int A7 = 6;
    public static final int A8 = 7;
    public static final int A9 = 8;
    public static final int A10 = 9;
    public static final int B1 = 10;
    public static final int B2 = 11;
    public static final int B3 = 12;
    public static final int B4 = 13;
    public static final int B5 = 14;
    public static final int B6 = 15;
    public static final int B7 = 16;
    public static final int B8 = 17;
    public static final int B9 = 18;
    public static final int B10 = 19;
    private static final String[] MEDIA_SIZE_INDEXES = new String[]{"A1", "A2", "A3", "A4", "A5", "A6", "B1", "B2", "B3", "B4", "B5", "B6"};
    private static final double[][] MEDIA_SIZE = new double[][]{{594.0, 841.0}, {420.0, 594.0}, {297.0, 420.0}, {210.0, 297.0}, {148.0, 210.0}, {105.0, 148.0}, {74.0, 105.0}, {52.0, 74.0}, {37.0, 52.0}, {26.0, 37.0}, {728.0, 1030.0}, {515.0, 728.0}, {364.0, 515.0}, {257.0, 364.0}, {182.0, 257.0}, {128.0, 182.0}, {91.0, 128.0}, {64.0, 91.0}, {45.0, 64.0}, {32.0, 45.0}};
    public static final int PORTRAIT = 0;
    public static final int LANDSCAPE = 1;
    private static final int DEFAULT_DPI = 72;
    private static final int DEFAULT_VIEWPORT_MAX = 8;
    public static final int TOP_TO_BOTTOM = 0;
    public static final int BOTTOM_TO_TOP = 1;
    private final PdfGraphics mPdfGraphics = new PdfGraphics(this);
    private Hashtable mTable;
    private AbstFile mOutFile;
    private PrintStream mOutStream;
    private String mFileName;
    private int mPageCount;
    private boolean mIsPDFOpened;
    private boolean mIsFileOpened;
    private boolean mIsPageStarted;
    private int mPageSize;
    private int mDirection;
    private double mDpi;
    private int mImageCount;
    private double mUserMinX;
    private double mUserMinY;
    private double mUserMaxX;
    private double mUserMaxY;
    private double[] mViewMinX;
    private double[] mViewMinY;
    private double[] mViewMaxX;
    private double[] mViewMaxY;
    private int mViewportMax;
    private int mViewportCount;
    private int mCurrentViewport;
    private double mPageWidth;
    private double mPageHeight;
    private Vector<String> mFormats;
    private int mUserCoordDirY = 0;
    int count = 0;
    private String mCode;

    public PdfCommand(String fileName, String code) {
        this.mCode = code;
        this.openPdf();
        this.openFile(fileName);
        this.setPageInfomation(3, 0, 72.0);
        this.createViewport(8);
        this.count = 0;
    }

    private void openPdf() {
        if (this.mIsPDFOpened) {
            throw new IllegalStateException("PDF is alread opened");
        }
        this.mOutFile = new AbstFile();
        try {
            this.mOutStream = this.mCode == null ? new PrintStream(this.mOutFile.openOutputStream(""), true, "UTF-8") : new PrintStream(this.mOutFile.openOutputStream(""), true, this.mCode);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.mOutStream.println("pdfstart");
        this.mTable = new Hashtable();
        this.mPageCount = 0;
        this.mImageCount = 0;
        this.mFileName = null;
        this.mIsFileOpened = false;
        this.mIsPageStarted = false;
        this.mIsPDFOpened = true;
        this.mFormats = new Vector();
    }

    private void closePdf() {
        if (!this.mIsPDFOpened) {
            return;
        }
        this.mOutStream.println("pdfend");
        this.mOutStream.close();
        this.mIsPDFOpened = false;
    }

    public void setPageInfo(int pageSize, int direction) {
        this.setPageInfo(pageSize, direction, 72.0);
    }

    public void setPageInfo(int pageSize, int direction, double dpi) {
        this.setPageInfomation(pageSize, direction, dpi);
        this.setUserCoordinate(0.0, 0.0, this.mPageWidth, this.mPageHeight);
    }

    protected void setPageInfomation(int pageSize, int direction, double dpi) {
        if (pageSize < 0 || pageSize >= MEDIA_SIZE_INDEXES.length) {
            throw new IllegalArgumentException("illegal page size");
        }
        if (direction != 0 && direction != 1) {
            throw new IllegalArgumentException("illegal page direciton");
        }
        if (dpi <= 0.0) {
            throw new IllegalArgumentException("illegal dpi");
        }
        this.mPageSize = pageSize;
        this.mDirection = direction;
        this.mDpi = dpi;
        double[] wh = MEDIA_SIZE[this.mPageSize];
        if (this.mDirection == 0) {
            this.setPageDimension(wh[0], wh[1]);
        } else {
            this.setPageDimension(wh[1], wh[0]);
        }
    }

    public void end() {
        this.endPage();
        this.closeFile();
        this.closePdf();
    }

    private void openFile(String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("file name is null");
        }
        if (!this.mIsPDFOpened) {
            throw new IllegalStateException("PDF is not opend");
        }
        if (this.mIsFileOpened) {
            throw new IllegalStateException("file is already opend");
        }
        this.mFileName = fileName;
        this.mOutStream.println("filestart," + this.mFileName);
        this.mPageCount = 0;
        this.mIsFileOpened = true;
    }

    private void closeFile() {
        if (!this.mIsFileOpened) {
            return;
        }
        this.mOutStream.println("fileend," + this.mFileName);
        this.mIsFileOpened = false;
    }

    private void startPage(String pageSize, int direction) {
        if (!this.mIsFileOpened) {
            throw new IllegalStateException("file is not opend");
        }
        if (this.mIsPageStarted) {
            throw new IllegalStateException("page is already opend");
        }
        StringBuffer sb = new StringBuffer("pagestart,");
        sb.append(this.mPageCount);
        this.mOutStream.println(sb.toString());
        sb = new StringBuffer("pagesize,");
        sb.append(pageSize);
        sb.append(",");
        sb.append(direction);
        if (this.mDpi != 72.0) {
            sb.append(",");
            sb.append(this.mDpi);
        }
        this.mOutStream.println(sb.toString());
        this.setFormat();
        this.mIsPageStarted = true;
    }

    protected void endPage() {
        if (!this.mIsPageStarted) {
            return;
        }
        this.mOutStream.println("pageend," + this.mPageCount++);
        this.mIsPageStarted = false;
        this.resetViewport();
        this.setUserCoordinate(0.0, 0.0, this.mPageWidth, this.mPageHeight);
    }

    public void setFormat(String format) {
        if (this.mFormats.size() > 0) {
            this.mFormats.removeAllElements();
        }
        this.addFormat(format);
    }

    public void addFormat(String format) {
        if (format != null && format.length() > 0) {
            this.mFormats.addElement(format);
        }
    }

    private void setFormat() {
        for (int i = 0; i < this.mFormats.size(); ++i) {
            String format = this.mFormats.elementAt(i);
            this.mOutStream.println("format," + format);
        }
    }

    public PdfGraphics getGraphics() {
        if (!this.mIsPageStarted) {
            this.startPage(MEDIA_SIZE_INDEXES[this.mPageSize], this.mDirection);
        }
        return this.mPdfGraphics;
    }

    public Hashtable getData() {
        this.mTable.put("DATA", this.mOutFile.getData());
        return this.mTable;
    }

    public String getNextImageName() {
        return String.valueOf(this.mImageCount);
    }

    public KDimension getPageDimension() {
        return new KDimension((int)this.mPageWidth, (int)this.mPageHeight);
    }

    public void createViewport(int max) {
        this.mViewportMax = max;
        this.mViewMinX = new double[this.mViewportMax];
        this.mViewMinY = new double[this.mViewportMax];
        this.mViewMaxX = new double[this.mViewportMax];
        this.mViewMaxY = new double[this.mViewportMax];
        this.resetViewport();
    }

    public void resetViewport() {
        this.mCurrentViewport = 0;
        this.mViewMinX[0] = 0.0;
        this.mViewMinY[0] = 0.0;
        this.mViewMaxX[0] = 1.0;
        this.mViewMaxY[0] = 1.0;
        this.mViewportCount = 1;
    }

    public void setViewport(double x1, double y1, double x2, double y2) {
        this.mViewMinX[this.mViewportCount] = x1;
        this.mViewMinY[this.mViewportCount] = y1;
        this.mViewMaxX[this.mViewportCount] = x2;
        this.mViewMaxY[this.mViewportCount] = y2;
        this.mCurrentViewport = this.mViewportCount++;
    }

    public void setUserCoordinate(double x1, double y1, double x2, double y2) {
        this.mUserMinX = x1;
        this.mUserMinY = y1;
        this.mUserMaxX = x2;
        this.mUserMaxY = y2;
    }

    public void setUserCoordinateDirectionY(int dir) {
        this.mUserCoordDirY = dir;
    }

    public int getUserCoordinateDirectionY() {
        return this.mUserCoordDirY;
    }

    protected void setPageDimension(double width, double height) {
        this.mPageWidth = width;
        this.mPageHeight = height;
    }

    protected double userWidthToPageWidth(double w) {
        double vw = this.mViewMaxX[this.mCurrentViewport] - this.mViewMinX[this.mCurrentViewport];
        return Math.abs(vw * this.mPageWidth * w / (this.mUserMaxX - this.mUserMinX));
    }

    protected double userHeightToPageHeight(double h) {
        double vh = this.mViewMaxY[this.mCurrentViewport] - this.mViewMinY[this.mCurrentViewport];
        return Math.abs(vh * this.mPageHeight * h / (this.mUserMaxY - this.mUserMinY));
    }

    protected double userXToPageX(double x) {
        return this.viewXToPageX(this.userXToViewX(x));
    }

    protected double userYToPageY(double y) {
        return this.viewYToPageY(this.userYToViewY(y));
    }

    protected double userXToViewX(double x) {
        double s = (x - this.mUserMinX) / (this.mUserMaxX - this.mUserMinX);
        return this.mViewMinX[this.mCurrentViewport] + s * (this.mViewMaxX[this.mCurrentViewport] - this.mViewMinX[this.mCurrentViewport]);
    }

    protected double userYToViewY(double y) {
        if (this.getUserCoordinateDirectionY() == 0) {
            y = this.mUserMaxY - y;
        }
        double s = (y - this.mUserMinY) / (this.mUserMaxY - this.mUserMinY);
        return this.mViewMinY[this.mCurrentViewport] + s * (this.mViewMaxY[this.mCurrentViewport] - this.mViewMinY[this.mCurrentViewport]);
    }

    protected double viewXToPageX(double x) {
        return this.mPageWidth * x;
    }

    protected double viewYToPageY(double y) {
        return this.mPageHeight * y;
    }

    protected void draw(String data) {
        if (!this.canWrite()) {
            throw new IllegalStateException("graphics is not ready");
        }
        this.mOutStream.println(data);
        ++this.count;
    }

    protected String draw(int[] data) {
        if (!this.canWrite()) {
            throw new IllegalStateException("graphics is not ready");
        }
        String token = String.valueOf(this.mImageCount);
        this.mTable.put("im" + token, data);
        ++this.mImageCount;
        return token;
    }

    protected String draw(byte[] data) {
        if (!this.canWrite()) {
            throw new IllegalStateException("graphics is not ready");
        }
        String token = String.valueOf(this.mImageCount);
        this.mTable.put("im" + token, data);
        ++this.mImageCount;
        return token;
    }

    protected boolean canWrite() {
        if (!this.mIsPDFOpened || !this.mIsFileOpened) {
            return false;
        }
        return this.mIsPageStarted;
    }
}

