/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.lib.pdf;

import java.text.DecimalFormat;
import jp.kitec.lib.kwt.KColor;
import jp.kitec.lib.kwt.KDimension;
import jp.kitec.lib.kwt.KFill;
import jp.kitec.lib.kwt.KFont;
import jp.kitec.lib.kwt.KImage;
import jp.kitec.lib.pdf.PdfCommand;

public class PdfGraphics {
    public static final String PATTERN_STAR = "Pt101d";
    public static final String SHADING_TYPE2 = "Sh201d";
    public static final float[] SOLID_LINE = new float[]{0.0f, 0.0f};
    public static final String SPACE_FOR_PITCH = "spaceX";
    public static final String SPACE_FOR_CHAR = "scaleX";
    private static final String SEPARATOR_TEXT = "*";
    public static final String SEPARATOR_GRAPHICS = ",";
    private static final String SEPARATOR_COMMAND = " ";
    private static final String STRING_QUOTAION = "#";
    private static final String CMD_ARC = "arc";
    private static final String CMD_IMAGE = "image";
    private static final String CMD_JPEG = "jpeg";
    private static final String CMD_ITEM_IMAGE = "itemimage";
    private static final String CMD_ITEM_TEXT = "itemtext";
    private static final String CMD_LINE = "line";
    private static final String CMD_LINK = "link";
    private static final String CMD_POLYGON = "polygon";
    private static final String CMD_POLYLINE = "polyline";
    private static final String CMD_RECT = "rect";
    private static final String CMD_TEXT = "text";
    private static final String CMD_GROUP_POLYGON = "grouppolygon";
    private static final String CMD_PATTERN = "pattern";
    private static final String CMD_SHADING = "shading";
    public static final String CMD_CLIP = "clip";
    public static final String CMD_UNCLIP = "unclip";
    private static final String CMD_3D = "3d";
    private static final double FONT_SKEW = 20.0;
    private static final double PT_TO_MM = 0.3527834713459015;
    private static final String DRAW = "0";
    private static final String FILL = "1";
    private static final String PLAIN = "0";
    private static final String BOLD = "2";
    private static final String EMBED = "1";
    static final double TEXT_WIDTH = 0.0;
    private final double mFontSkew = 20.0;
    private final PdfCommand mPdfCmd;
    private KFill mColor;
    private double mLineWidth;
    private float[] mLinePattern;
    private String mFontName;
    private int mFontStyle;
    private double mFontSize;
    private boolean mIsFontEmbedded;
    private double mOriginX;
    private double mOriginY;
    private String mLastImageName;
    private final DecimalFormat mFormat;

    protected PdfGraphics(PdfCommand pdfcmd) {
        this.mPdfCmd = pdfcmd;
        this.mFormat = new DecimalFormat("####0.####");
        this.reset();
    }

    protected void reset() {
        this.mColor = new KColor(0, 0, 0);
        this.mFontName = "MS GOTHIC";
        this.mFontStyle = 0;
        this.mFontSize = 12.0;
        this.mLineWidth = 1.0;
        this.mLinePattern = SOLID_LINE;
        this.mOriginX = 0.0;
        this.mOriginY = 0.0;
    }

    public void dispose() {
        this.mPdfCmd.endPage();
        this.reset();
    }

    public void translate(double x, double y) {
        this.mOriginX += x;
        this.mOriginY += y;
    }

    public void setClip(double x, double y, double width, double height) {
        StringBuilder sb = new StringBuilder();
        sb.append(CMD_CLIP);
        sb.append(SEPARATOR_COMMAND);
        this.drawRect(x, y, width, height, sb, SEPARATOR_GRAPHICS);
        this.mPdfCmd.draw(sb.toString());
    }

    public void releaseClip() {
        this.mPdfCmd.draw(CMD_UNCLIP);
    }

    public KColor getColor() {
        return (KColor)this.mColor;
    }

    public void setColor(KFill c) {
        if (c == null) {
            throw new NullPointerException();
        }
        this.mColor = c;
    }

    public KFont getFont() {
        return KFont.getFont((String)this.mFontName, (int)this.mFontStyle, (double)((int)this.mFontSize));
    }

    public String getFontName() {
        return this.mFontName;
    }

    public int getFontStyle() {
        return this.mFontStyle;
    }

    public double getFontSize() {
        return this.mFontSize;
    }

    public boolean isFontEmbedded() {
        return this.mIsFontEmbedded;
    }

    public void setFont(KFont font) {
        this.setFontName(font.getName());
        this.setFontStyle(font.getStyle());
        this.setFontSize(font.getSize());
    }

    public void setFont(String name, int style, double size) {
        this.setFontName(name);
        this.setFontStyle(style);
        this.setFontSize(size);
    }

    public void setFontName(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        this.mFontName = name;
    }

    public void setFontStyle(int style) {
        this.mFontStyle = style;
    }

    public void setFontSize(double size) {
        if (size < 0.0) {
            throw new IllegalArgumentException();
        }
        this.mFontSize = size;
    }

    public void setFontEmbed(boolean embed) {
        this.mIsFontEmbedded = embed;
    }

    public void setLinePattern(float[] dash) {
        this.mLinePattern = new float[dash.length];
        for (int i = 0; i < dash.length; ++i) {
            if (dash[i] < 0.0f) {
                throw new IllegalArgumentException("negative line pattern");
            }
            this.mLinePattern[i] = dash[i];
        }
    }

    public double[] getLinePattern() {
        double[] lp = new double[this.mLinePattern.length];
        for (int i = 0; i < lp.length; ++i) {
            lp[i] = this.mLinePattern[i];
        }
        return lp;
    }

    public void setLineWidth(double width) {
        if (width <= 0.0) {
            throw new IllegalArgumentException("negative or 0 line width");
        }
        this.mLineWidth = width;
    }

    public double getLineWidth() {
        return this.mLineWidth;
    }

    public String getLastImageName() {
        return this.mLastImageName;
    }

    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.drawArc(x, y, width, height, startAngle, arcAngle, false);
    }

    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.drawArc(x, y, width, height, startAngle, arcAngle, true);
    }

    public void drawArc(double x, double y, double width, double height, double startAngle, double arcAngle, boolean fill) {
        StringBuilder sb = new StringBuilder();
        sb.append(CMD_ARC);
        sb.append(SEPARATOR_COMMAND);
        if (this.mPdfCmd.getUserCoordinateDirectionY() == 1) {
            y -= height;
        }
        this.appendPosition(sb, SEPARATOR_GRAPHICS, x + width / 2.0, y + height / 2.0);
        sb.append(SEPARATOR_GRAPHICS);
        this.appendSize(sb, SEPARATOR_GRAPHICS, width / 2.0, height / 2.0);
        sb.append(SEPARATOR_GRAPHICS);
        sb.append(this.format(startAngle));
        sb.append(SEPARATOR_GRAPHICS);
        sb.append(this.format(arcAngle));
        sb.append(SEPARATOR_GRAPHICS);
        this.appendColor(sb, SEPARATOR_GRAPHICS);
        sb.append(SEPARATOR_GRAPHICS);
        sb.append(fill ? "1" : "0");
        sb.append(SEPARATOR_GRAPHICS);
        this.appendLineWidth(sb);
        sb.append(SEPARATOR_GRAPHICS);
        this.appendLinePattern(sb, SEPARATOR_GRAPHICS);
        this.mPdfCmd.draw(sb.toString());
    }

    public void drawPatternedGroupPolygon(String name, double[] xPoints, double[] yPoints, int[] nPoints) {
        StringBuilder sb = new StringBuilder();
        sb.append(CMD_PATTERN);
        sb.append(SEPARATOR_COMMAND);
        sb.append(name);
        sb.append(SEPARATOR_GRAPHICS);
        this.drawGroupPolygon(sb, xPoints, yPoints, nPoints, true);
        this.mPdfCmd.draw(sb.toString());
    }

    public void drawShadingGroupPolygon(String name, double[] xPoints, double[] yPoints, int[] nPoints) {
        StringBuilder sb = new StringBuilder();
        sb.append(CMD_SHADING);
        sb.append(SEPARATOR_COMMAND);
        sb.append(name);
        sb.append(SEPARATOR_GRAPHICS);
        this.drawGroupPolygon(sb, xPoints, yPoints, nPoints, true);
        this.mPdfCmd.draw(sb.toString());
    }

    public void drawGroupPolygon(double[] xPoints, double[] yPoints, int[] nPoints, boolean fill) {
        StringBuilder sb = new StringBuilder();
        this.drawGroupPolygon(sb, xPoints, yPoints, nPoints, fill);
        this.mPdfCmd.draw(sb.toString());
    }

    private void drawGroupPolygon(StringBuilder sb, double[] xPoints, double[] yPoints, int[] nPoints, boolean fill) {
        sb.append(CMD_GROUP_POLYGON);
        sb.append(SEPARATOR_COMMAND);
        this.appendColor(sb, SEPARATOR_GRAPHICS);
        sb.append(SEPARATOR_GRAPHICS);
        sb.append(fill ? "1" : "0");
        sb.append(SEPARATOR_GRAPHICS);
        sb.append(nPoints.length);
        int idx = 0;
        for (int nPoint : nPoints) {
            sb.append(SEPARATOR_GRAPHICS);
            sb.append(nPoint);
            int j = 0;
            while (j < nPoint) {
                sb.append(SEPARATOR_GRAPHICS);
                this.appendPosition(sb, SEPARATOR_GRAPHICS, xPoints[idx], yPoints[idx]);
                ++j;
                ++idx;
            }
        }
        sb.append(SEPARATOR_GRAPHICS);
        this.appendLineWidth(sb);
        sb.append(SEPARATOR_GRAPHICS);
        this.appendLinePattern(sb, SEPARATOR_GRAPHICS);
    }

    public boolean drawImage(KImage img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2) {
        int[] pixels;
        int ph;
        int pw;
        int py;
        int px = dx1 < dx2 ? dx1 : dx2;
        if (!img.getPixels(px, py = dy1 < dy2 ? dy1 : dy2, pw = Math.abs(dx2 - dx1), ph = Math.abs(dy2 - dy1), pixels = new int[pw * ph], 0, pw)) {
            return false;
        }
        int ox = sx1 < sx2 ? sx1 : sx2;
        int oy = sy1 < sy2 ? sy1 : sy2;
        int ow = Math.abs(sx2 - sx1);
        int oh = Math.abs(sy2 - sy1);
        return this.drawImagePixels(pixels, ox, oy, pw, ph, ow, oh, 30.0);
    }

    public boolean drawImage(KImage img, double x, double y, double width, double height) {
        if (img == null) {
            return false;
        }
        KDimension size = img.getSize();
        int w = size.width;
        int h = size.height;
        return this.drawImage(img, x, y, w, h, width, height, 0.0);
    }

    public boolean drawImage(String file, double x, double y, double width, double height, double theta) {
        if (file == null) {
            return false;
        }
        return this.drawImageCommand(CMD_IMAGE, file, x, y, 0.0, 0.0, width, height, theta);
    }

    public boolean drawImageAsJpeg(String file, double x, double y, double width, double height, double theta) {
        if (file == null) {
            return false;
        }
        return this.drawImageCommand(CMD_JPEG, file, x, y, 0.0, 0.0, width, height, theta);
    }

    public boolean drawImage(KImage img, double x, double y) {
        if (img == null) {
            return false;
        }
        KDimension size = img.getSize();
        int w = size.width;
        int h = size.height;
        double ow = (double)w * 0.3527834713459015;
        double oh = (double)h * 0.3527834713459015;
        return this.drawImage(img, x, y, w, h, ow, oh, 0.0);
    }

    private boolean drawImage(KImage img, double x, double y, double w, double h, double ow, double oh, double theta) {
        int iw = (int)w;
        int ih = (int)h;
        int[] pixels = new int[iw * ih];
        if (!img.getPixels(0, 0, iw, ih, pixels, 0, iw)) {
            return false;
        }
        return this.drawImagePixels(pixels, x, y, w, h, ow, oh, theta);
    }

    public boolean drawImageAsJpeg(byte[] pixels, double x, double y, double w, double h, double ow, double oh, double theta) {
        this.mLastImageName = this.mPdfCmd.draw(pixels);
        return this.drawImageCommand(CMD_JPEG, this.mLastImageName, x, y, w, h, ow, oh, theta);
    }

    private boolean drawImagePixels(int[] pixels, double x, double y, double w, double h, double ow, double oh, double theta) {
        this.mLastImageName = this.mPdfCmd.draw(pixels);
        return this.drawImageCommand(CMD_IMAGE, this.mLastImageName, x, y, w, h, ow, oh, theta);
    }

    private boolean drawImageCommand(String command, String name, double x, double y, double w, double h, double ow, double oh, double theta) {
        StringBuilder sb = new StringBuilder();
        sb.append(command);
        sb.append(SEPARATOR_COMMAND);
        sb.append(name);
        sb.append(SEPARATOR_GRAPHICS);
        sb.append(w);
        sb.append(SEPARATOR_GRAPHICS);
        sb.append(h);
        sb.append(SEPARATOR_GRAPHICS);
        double y1 = y;
        double y2 = y;
        y2 = this.mPdfCmd.getUserCoordinateDirectionY() == 0 ? (y2 += oh) : (y2 -= oh);
        this.appendPosition(sb, SEPARATOR_GRAPHICS, x, y1);
        sb.append(SEPARATOR_GRAPHICS);
        this.appendPosition(sb, SEPARATOR_GRAPHICS, x + ow, y2);
        sb.append(SEPARATOR_GRAPHICS);
        sb.append(theta);
        this.mPdfCmd.draw(sb.toString());
        return true;
    }

    public void drawItemImage(String file, String formatName, String ItemName) {
        StringBuilder sb = new StringBuilder();
        sb.append(CMD_ITEM_IMAGE);
        sb.append(SEPARATOR_COMMAND);
        sb.append(file);
        sb.append(SEPARATOR_COMMAND);
        sb.append(formatName);
        sb.append(SEPARATOR_COMMAND);
        sb.append(ItemName);
        this.mPdfCmd.draw(sb.toString());
    }

    public void drawItemString(String str, String formatName, String ItemName) {
        if (str == null || str.length() == 0) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(CMD_ITEM_TEXT);
        sb.append(SEPARATOR_COMMAND);
        sb.append(STRING_QUOTAION);
        sb.append(str);
        sb.append(STRING_QUOTAION);
        sb.append(formatName);
        sb.append(SEPARATOR_TEXT);
        sb.append(ItemName);
        this.mPdfCmd.draw(sb.toString());
    }

    public void drawLink(String url, double x1, double y1, double x2, double y2, double boderWidth) {
        StringBuilder sb = new StringBuilder();
        sb.append(CMD_LINK);
        sb.append(SEPARATOR_COMMAND);
        sb.append(url);
        sb.append(SEPARATOR_GRAPHICS);
        this.appendPosition(sb, SEPARATOR_GRAPHICS, x1, y1);
        sb.append(SEPARATOR_GRAPHICS);
        this.appendPosition(sb, SEPARATOR_GRAPHICS, x2, y2);
        sb.append(SEPARATOR_GRAPHICS);
        this.appendWidth(sb, boderWidth);
        this.mPdfCmd.draw(sb.toString());
    }

    public void drawLine(double x1, double y1, double x2, double y2) {
        StringBuilder sb = new StringBuilder();
        sb.append(CMD_LINE);
        sb.append(SEPARATOR_COMMAND);
        this.appendPosition(sb, SEPARATOR_GRAPHICS, x1, y1);
        sb.append(SEPARATOR_GRAPHICS);
        this.appendPosition(sb, SEPARATOR_GRAPHICS, x2, y2);
        sb.append(SEPARATOR_GRAPHICS);
        this.appendColor(sb, SEPARATOR_GRAPHICS);
        sb.append(SEPARATOR_GRAPHICS);
        this.appendLineWidth(sb);
        sb.append(SEPARATOR_GRAPHICS);
        this.appendLinePattern(sb, SEPARATOR_GRAPHICS);
        this.mPdfCmd.draw(sb.toString());
    }

    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        StringBuilder sb = new StringBuilder();
        sb.append(CMD_POLYLINE);
        sb.append(SEPARATOR_COMMAND);
        this.appendColor(sb, SEPARATOR_GRAPHICS);
        sb.append(SEPARATOR_GRAPHICS);
        sb.append(nPoints);
        sb.append(SEPARATOR_GRAPHICS);
        this.appendPoints(sb, SEPARATOR_GRAPHICS, this.toFloatArray(xPoints), this.toFloatArray(yPoints), nPoints);
        sb.append(SEPARATOR_GRAPHICS);
        this.appendLineWidth(sb);
        sb.append(SEPARATOR_GRAPHICS);
        this.appendLinePattern(sb, SEPARATOR_GRAPHICS);
        this.mPdfCmd.draw(sb.toString());
    }

    public void drawPolyline(double[] xPoints, double[] yPoints, int nPoints) {
        StringBuilder sb = new StringBuilder();
        sb.append(CMD_POLYLINE);
        sb.append(SEPARATOR_COMMAND);
        this.appendColor(sb, SEPARATOR_GRAPHICS);
        sb.append(SEPARATOR_GRAPHICS);
        sb.append(nPoints);
        sb.append(SEPARATOR_GRAPHICS);
        this.appendPoints(sb, SEPARATOR_GRAPHICS, xPoints, yPoints, nPoints);
        sb.append(SEPARATOR_GRAPHICS);
        this.appendLineWidth(sb);
        sb.append(SEPARATOR_GRAPHICS);
        this.appendLinePattern(sb, SEPARATOR_GRAPHICS);
        this.mPdfCmd.draw(sb.toString());
    }

    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.drawPolygon(this.toFloatArray(xPoints), this.toFloatArray(yPoints), nPoints, false);
    }

    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.drawPolygon(this.toFloatArray(xPoints), this.toFloatArray(yPoints), nPoints, true);
    }

    private double[] toFloatArray(int[] array) {
        double[] fa = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            fa[i] = array[i];
        }
        return fa;
    }

    public void drawPatternedPolygon(String name, double[] xPoints, double[] yPoints, int nPoints) {
        StringBuilder sb = new StringBuilder();
        sb.append(CMD_PATTERN);
        sb.append(SEPARATOR_COMMAND);
        sb.append(name);
        sb.append(SEPARATOR_GRAPHICS);
        this.drawPolygon(sb, xPoints, yPoints, nPoints, true);
        this.mPdfCmd.draw(sb.toString());
    }

    public void drawShadingPolygon(String name, double[] xPoints, double[] yPoints, int nPoints) {
        StringBuilder sb = new StringBuilder();
        sb.append(CMD_SHADING);
        sb.append(SEPARATOR_COMMAND);
        sb.append(name);
        sb.append(SEPARATOR_GRAPHICS);
        this.drawPolygon(sb, xPoints, yPoints, nPoints, true);
        this.mPdfCmd.draw(sb.toString());
    }

    public void drawPolygon(double[] xPoints, double[] yPoints, int nPoints, boolean fill) {
        StringBuilder sb = new StringBuilder();
        this.drawPolygon(sb, xPoints, yPoints, nPoints, fill);
        this.mPdfCmd.draw(sb.toString());
    }

    private void drawPolygon(StringBuilder sb, double[] xPoints, double[] yPoints, int nPoints, boolean fill) {
        sb.append(CMD_POLYGON);
        sb.append(SEPARATOR_COMMAND);
        this.appendColor(sb, SEPARATOR_GRAPHICS);
        sb.append(SEPARATOR_GRAPHICS);
        sb.append(fill ? "1" : "0");
        sb.append(SEPARATOR_GRAPHICS);
        sb.append(nPoints);
        sb.append(SEPARATOR_GRAPHICS);
        this.appendPoints(sb, SEPARATOR_GRAPHICS, xPoints, yPoints, nPoints);
        sb.append(SEPARATOR_GRAPHICS);
        this.appendLineWidth(sb);
        sb.append(SEPARATOR_GRAPHICS);
        this.appendLinePattern(sb, SEPARATOR_GRAPHICS);
    }

    public void drawRect(double x, double y, double width, double height, boolean fill) {
        StringBuilder sb = new StringBuilder();
        sb.append(CMD_RECT);
        sb.append(SEPARATOR_COMMAND);
        this.drawRect(x, y, width, height, sb, SEPARATOR_GRAPHICS);
        sb.append(SEPARATOR_GRAPHICS);
        this.appendColor(sb, SEPARATOR_GRAPHICS);
        sb.append(SEPARATOR_GRAPHICS);
        sb.append(fill ? "1" : "0");
        sb.append(SEPARATOR_GRAPHICS);
        this.appendLineWidth(sb);
        sb.append(SEPARATOR_GRAPHICS);
        this.appendLinePattern(sb, SEPARATOR_GRAPHICS);
        this.mPdfCmd.draw(sb.toString());
    }

    private void drawRect(double x, double y, double width, double height, StringBuilder buffer, String separator) {
        this.appendPosition(buffer, separator, x, y);
        buffer.append(separator);
        double y2 = y;
        y2 = this.mPdfCmd.getUserCoordinateDirectionY() == 0 ? (y2 += height) : (y2 -= height);
        this.appendPosition(buffer, separator, x + width, y2);
    }

    public void drawRoundRect(double x, double y, double width, double height, double arcWidth, double arcHeight, boolean isFill) {
        double ry;
        double by;
        double ty;
        double y2;
        double y1;
        double x1 = x + arcWidth / 2.0;
        double x2 = x + width - arcWidth / 2.0;
        if (this.mPdfCmd.getUserCoordinateDirectionY() == 0) {
            y1 = y + arcHeight / 2.0;
            y2 = y + height - arcHeight / 2.0;
            ty = y;
            by = y + height;
            ry = y + height - arcHeight;
        } else {
            y1 = y - arcHeight / 2.0;
            y2 = y - height + arcHeight / 2.0;
            ty = y;
            by = y - height;
            ry = y - height + arcHeight;
        }
        this.drawArc(x, y, arcWidth, arcHeight, 90.0, 180.0, isFill);
        this.drawArc(x + width - arcWidth, y, arcWidth, arcHeight, 0.0, 90.0, isFill);
        this.drawArc(x, ry, arcWidth, arcHeight, 180.0, 270.0, isFill);
        this.drawArc(x + width - arcWidth, ry, arcWidth, arcHeight, 270.0, 360.0, isFill);
        if (isFill) {
            this.drawRect(x1, ty, width - arcWidth, height, isFill);
            this.drawRect(x, y1, width, height - arcHeight, isFill);
        } else {
            this.drawLine(x1, ty, x2, ty);
            this.drawLine(x1, by, x2, by);
            this.drawLine(x, y1, x, y2);
            this.drawLine(x + width, y1, x + width, y2);
        }
    }

    public void drawString(String str, double x, double y, boolean center, double rotate, double width, String type) {
        if (str == null || str.length() == 0) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(CMD_TEXT);
        sb.append(SEPARATOR_COMMAND);
        sb.append(STRING_QUOTAION);
        sb.append(str);
        sb.append(STRING_QUOTAION);
        this.appendPosition(sb, SEPARATOR_TEXT, x, y);
        sb.append(SEPARATOR_TEXT);
        this.appendFontNameAndSize(sb, SEPARATOR_TEXT);
        sb.append(SEPARATOR_TEXT);
        this.appendColor(sb, SEPARATOR_TEXT);
        int whatdraw = 0;
        if (this.isFontEmbedded()) {
            whatdraw += 32;
        }
        if (width > 0.0 && type != null && (type.equals(SPACE_FOR_CHAR) || type.equals(SPACE_FOR_PITCH))) {
            whatdraw += 16;
        } else if (rotate != 0.0) {
            whatdraw += 8;
        } else if ((this.getFontStyle() & 2) != 0) {
            whatdraw += 4;
        } else if ((this.getFontStyle() & 1) != 0) {
            whatdraw += 2;
        } else if (center) {
            ++whatdraw;
        }
        if (whatdraw >= 1) {
            sb.append(SEPARATOR_TEXT);
            if (center) {
                sb.append("1");
            } else {
                sb.append("0");
            }
        }
        if (whatdraw >= 2) {
            sb.append(SEPARATOR_TEXT);
            sb.append((this.mFontStyle & 1) == 0 ? "0" : BOLD);
        }
        if (whatdraw >= 4) {
            sb.append(SEPARATOR_TEXT);
            sb.append((this.mFontStyle & 2) == 0 ? 0.0 : 20.0);
        }
        if (whatdraw >= 8) {
            sb.append(SEPARATOR_TEXT);
            sb.append(rotate);
        }
        if (whatdraw >= 16) {
            sb.append(SEPARATOR_TEXT);
            this.appendStringWidth(sb, width);
            sb.append(SEPARATOR_TEXT);
            sb.append(type);
        }
        if (whatdraw >= 32) {
            sb.append(SEPARATOR_TEXT);
            sb.append("1");
        }
        this.mPdfCmd.draw(sb.toString());
    }

    protected void appendPosition(StringBuilder sb, String separator, double x, double y) {
        sb.append(this.format(this.mPdfCmd.userXToPageX(this.mOriginX + x)));
        sb.append(separator);
        sb.append(this.format(this.mPdfCmd.userYToPageY(this.mOriginY + y)));
    }

    private void appendPoints(StringBuilder sb, String separator, double[] xPoints, double[] yPoints, int nPoints) {
        int i;
        int max = nPoints - 1;
        for (i = 0; i < max; ++i) {
            this.appendPosition(sb, separator, xPoints[i], yPoints[i]);
            sb.append(separator);
        }
        this.appendPosition(sb, separator, xPoints[i], yPoints[i]);
    }

    private void appendSize(StringBuilder sb, String separator, double width, double height) {
        this.appendWidth(sb, width);
        sb.append(separator);
        this.appendHeight(sb, height);
    }

    protected void appendColor(StringBuilder sb, String separator) {
        KColor c = this.getColor();
        sb.append(c.getRed());
        sb.append(separator);
        sb.append(c.getGreen());
        sb.append(separator);
        sb.append(c.getBlue());
    }

    private void appendFontNameAndSize(StringBuilder sb, String separator) {
        sb.append(this.mFontName);
        sb.append(separator);
        this.appendWidth(sb, this.mFontSize);
    }

    private void appendStringWidth(StringBuilder sb, double width) {
        this.appendWidth(sb, width);
    }

    protected void appendLineWidth(StringBuilder sb) {
        this.appendWidth(sb, this.mLineWidth);
    }

    protected void appendLinePattern(StringBuilder sb, String separator) {
        int max = this.mLinePattern.length - 1;
        for (int i = 0; i < max; ++i) {
            this.appendWidth(sb, this.mLinePattern[i]);
            sb.append(separator);
        }
        this.appendWidth(sb, this.mLinePattern[max]);
    }

    private void appendWidth(StringBuilder sb, double width) {
        sb.append(this.format(this.mPdfCmd.userWidthToPageWidth(width)));
    }

    private void appendHeight(StringBuilder sb, double height) {
        sb.append(this.format(this.mPdfCmd.userHeightToPageHeight(height)));
    }

    private String format(double number) {
        return this.mFormat.format(number);
    }

    public boolean draw3D(byte[] idtf, double x1, double y1, double x2, double y2, double fov) {
        if (idtf == null) {
            return false;
        }
        this.mLastImageName = this.mPdfCmd.draw(idtf);
        return this.draw3D(this.mLastImageName, x1, y1, x2, y2, fov);
    }

    private boolean draw3D(String name, double x1, double y1, double x2, double y2, double fov) {
        StringBuilder sb = new StringBuilder();
        sb.append(CMD_3D);
        sb.append(SEPARATOR_COMMAND);
        sb.append(name);
        sb.append(SEPARATOR_GRAPHICS);
        double yy1 = y1;
        double yy2 = y2;
        sb.append(this.format(this.mPdfCmd.userXToPageX(this.mOriginX + x1)));
        sb.append(SEPARATOR_GRAPHICS);
        sb.append(this.format(this.mPdfCmd.userYToPageY(this.mOriginY + yy1)));
        sb.append(SEPARATOR_GRAPHICS);
        sb.append(this.format(this.mPdfCmd.userXToPageX(this.mOriginX + x2)));
        sb.append(SEPARATOR_GRAPHICS);
        sb.append(this.format(this.mPdfCmd.userYToPageY(this.mOriginY + yy2)));
        sb.append(SEPARATOR_GRAPHICS);
        sb.append(0);
        sb.append(SEPARATOR_GRAPHICS);
        this.appendColor(sb, SEPARATOR_GRAPHICS);
        sb.append(SEPARATOR_GRAPHICS);
        sb.append(fov);
        this.mPdfCmd.draw(sb.toString());
        return true;
    }

    public void draw(String s) {
        this.mPdfCmd.draw(s);
    }
}

