/*
 * Decompiled with CFR 0.152.
 */
package option.pdf;

import java.text.DecimalFormat;
import java.util.List;
import jp.kitec.kwt.IRichGraphics;
import jp.kitec.kwt.KArcType;
import jp.kitec.kwt.KArea;
import jp.kitec.kwt.KColor;
import jp.kitec.kwt.KFill;
import jp.kitec.kwt.KFont;
import jp.kitec.kwt.KImage;
import jp.kitec.kwt.KLineType;
import jp.kitec.kwt.KPathIterator;
import jp.kitec.kwt.MinRichGraphics;
import jp.kitec.kwt.RichGraphicsUtil;
import jp.kitec.lib.geom.K2DPathFigurePoint;
import jp.kitec.lib.geom.KLocalAxis;
import jp.kitec.lib.util.RefList;
import jp.kitec.vecmath.KPoint2d;
import option.pdf.PdfGraphics;

public class PdfRichGraphicsAdapter
extends MinRichGraphics
implements IRichGraphics {
    private static final int BUF_SIZE = 128;
    private static double[] XBUF = new double[128];
    private static double[] YBUF = new double[128];
    private static final KLineType NULL_LINE = new KLineType("", new float[]{0.0f, 0.0f}, 0.1f, 0);
    public static final double EPS = (double)0.001f;
    public static final double D2R = Math.PI / 180;
    protected PdfGraphics mGraphics;
    private double mScale;
    int mWindingRule;
    KPoint2d mCurrentPoint;
    private boolean pdfPathMode = false;

    public PdfRichGraphicsAdapter(PdfGraphics g) {
        this.mGraphics = g;
    }

    public void scale(double scale) {
        this.mScale = scale;
    }

    public double getScale() {
        return this.mScale;
    }

    public void setFontEmbed(boolean flag) {
        this.mGraphics.setFontEmbed(flag);
    }

    public void clip(KPathIterator shape) {
        throw new UnsupportedOperationException();
    }

    public void setClipArea(double x1, double y1, double x2, double y2) {
        this.mGraphics.setClip(Math.min(x1, x2), Math.max(y1, y2), Math.abs(x2 - x1), Math.abs(y2 - y1));
    }

    public void releaseClipArea() {
        this.mGraphics.releaseClip();
    }

    public void setColor(KFill c) {
        this.mGraphics.setColor(c);
    }

    public void save() {
        throw new UnsupportedOperationException();
    }

    public void restore() {
        throw new UnsupportedOperationException();
    }

    public void drawLine(double x1, double y1, double x2, double y2, KLineType lt) {
        this.setLineType(lt);
        this.mGraphics.drawLine(x1, y1, x2, y2);
    }

    public void drawCircle(double xc1, double yc1, double ra, double ss, double ee, KArcType arcType, KLineType lt) {
        this.setLineType(lt);
        if (Math.abs(ss - ee) < (double)0.001f) {
            ss = 0.0;
            ee = 360.0;
        }
        this.mGraphics.drawArc(xc1 - ra, yc1 + ra, ra * 2.0, ra * 2.0, ss, ee, false);
    }

    public void drawFillCircle(double xc1, double yc1, double ra, double ss, double ee, KArcType arcType, KLineType lt) {
        this.setLineType(lt);
        if (Math.abs(ss - ee) < (double)0.001f) {
            ss = 0.0;
            ee = 360.0;
        }
        this.mGraphics.drawArc(xc1 - ra, yc1 + ra, ra * 2.0, ra * 2.0, ss, ee, true);
    }

    public void drawEllipse(double xc1, double yc1, double v, double h, double ss, double ee, KArcType arcType, KLineType lt) {
        this.drawEllipse(xc1, yc1, v, h, ss, ee, lt, false);
    }

    public void drawFillEllipse(double xc1, double yc1, double v, double h, double ss, double ee, KArcType arcType, KLineType lt) {
        this.drawEllipse(xc1, yc1, v, h, ss, ee, lt, true);
    }

    private void drawEllipse(double xc1, double yc1, double v, double h, double ss, double ee, KLineType lt, boolean fill) {
        this.setLineType(lt);
        if (Math.abs(ss - ee) < (double)0.001f) {
            ss = 0.0;
            ee = 360.0;
        }
        this.mGraphics.drawArc(xc1 - h, yc1 + v, h * 2.0, v * 2.0, ss, ee, fill);
    }

    public void drawRect(double x1, double y1, double x2, double y2, KLineType lt) {
        this.setLineType(lt);
        this.mGraphics.drawRect(Math.min(x1, x2), Math.max(y1, y2), Math.abs(x2 - x1), Math.abs(y2 - y1), false);
    }

    public void drawFillRect(double x1, double y1, double x2, double y2, KLineType lt) {
        this.setLineType(lt);
        this.mGraphics.drawRect(Math.min(x1, x2), Math.max(y1, y2), Math.abs(x2 - x1), Math.abs(y2 - y1), true);
    }

    public void drawRoundRect(double x1, double y1, double x2, double y2, double round, KLineType lt) {
        this.setLineType(lt);
        this.mGraphics.drawRoundRect(Math.min(x1, x2), Math.max(y1, y2), Math.abs(x2 - x1), Math.abs(y2 - y1), round * 2.0, round * 2.0, false);
    }

    public void drawFillRoundRect(double x1, double y1, double x2, double y2, double round, KLineType lt) {
        this.setLineType(lt);
        this.mGraphics.drawRoundRect(Math.min(x1, x2), Math.max(y1, y2), Math.abs(x2 - x1), Math.abs(y2 - y1), round * 2.0, round * 2.0, true);
    }

    public void drawPolygon(List<? extends K2DPathFigurePoint> poly, KLineType lt) {
        this.setLineType(lt);
        this.createFloatPointArrayBuffer(poly);
        this.mGraphics.drawPolygon(XBUF, YBUF, poly.size(), false);
    }

    public void drawFillPolygon(List<? extends K2DPathFigurePoint> poly, KLineType lt) {
        this.setLineType(lt);
        this.createFloatPointArrayBuffer(poly);
        this.mGraphics.drawPolygon(XBUF, YBUF, poly.size(), true);
    }

    public void drawPolyLine(List<? extends K2DPathFigurePoint> poly, KLineType lt) {
        this.setLineType(lt);
        this.createFloatPointArrayBuffer(poly);
        for (int i = 0; i < poly.size() - 1; ++i) {
            this.drawLine(XBUF[i], YBUF[i], XBUF[i + 1], YBUF[i + 1], lt);
        }
    }

    public void drawImage(KImage img, String id, double x1, double y1, double x2, double y2) {
        this.drawImage(img, x1, y1, x2, y2);
    }

    public void drawImage(KImage img, double x1, double y1, double x2, double y2) {
        this.mGraphics.drawImage(img, Math.min(x1, x2), Math.max(y1, y2), Math.abs(x2 - x1), Math.abs(y2 - y1));
    }

    public void drawImage(KImage img, double cx, double cy, double width, double height, double angle) {
    }

    public void drawText(String s, double x1, double y1, String fontname, int fonttype, double size, double angle) {
        if (s == null || s.length() == 0) {
            return;
        }
        this.mGraphics.setFont(fontname, fonttype, size);
        KFont f = KFont.getFont((String)fontname, (int)fonttype, (double)size);
        this.mGraphics.drawString(s, x1, y1, false, -angle, f.getFontMetrics(null).stringWidth(s), "spaceX");
    }

    public void drawShadePolygon(List<RefList<double[]>> polygon, double x1, double y1, double x2, double y2, KColor c1, KColor c2) {
        int pointsize = 0;
        int[] npts = new int[polygon.size()];
        for (int i = 0; i < polygon.size(); ++i) {
            RefList<double[]> r = polygon.get(i);
            pointsize += r.size();
        }
        double[] x = new double[pointsize];
        double[] y = new double[pointsize];
        int count = 0;
        for (int i = 0; i < polygon.size(); ++i) {
            RefList<double[]> r = polygon.get(i);
            npts[i] = r.size();
            for (int j = 0; j < r.size(); ++j) {
                double[] f = (double[])r.elementAt(j);
                x[count] = f[0];
                y[count] = f[1];
                ++count;
            }
        }
        DecimalFormat formatter = new DecimalFormat("000");
        StringBuilder shadename = new StringBuilder("TYPE2_");
        shadename.append(formatter.format(c1.getRed()));
        shadename.append(formatter.format(c1.getGreen()));
        shadename.append(formatter.format(c1.getBlue()));
        shadename.append(formatter.format(c2.getRed()));
        shadename.append(formatter.format(c2.getGreen()));
        shadename.append(formatter.format(c2.getBlue()));
        this.mGraphics.drawShadingGroupPolygon(shadename.toString(), x, y, npts);
    }

    public void setLineType(KLineType lt) {
        if (lt != null) {
            this.mGraphics.setLineWidth(lt.getWidth());
            if (lt.getStroke() != null) {
                this.mGraphics.setLinePattern(lt.getStroke());
            } else {
                this.mGraphics.setLinePattern(NULL_LINE.getStroke());
            }
        } else {
            this.mGraphics.setLineWidth(NULL_LINE.getWidth());
            this.mGraphics.setLinePattern(NULL_LINE.getStroke());
        }
    }

    private void createFloatPointArrayBuffer(List<? extends K2DPathFigurePoint> pts) {
        if (pts.size() > XBUF.length) {
            XBUF = new double[pts.size()];
            YBUF = new double[pts.size()];
        }
        for (int i = 0; i < pts.size(); ++i) {
            PdfRichGraphicsAdapter.XBUF[i] = pts.get(i).getX();
            PdfRichGraphicsAdapter.YBUF[i] = pts.get(i).getY();
        }
    }

    public void drawImage(KImage img, String prefix, String id, double x1, double y1, double x2, double y2) {
        this.drawImage(img, x1, y1, x2, y2);
    }

    public void pathInit(int i) {
        this.mCurrentPoint = null;
        switch (i) {
            case 4096: {
                this.mWindingRule = 0;
                break;
            }
            case 8192: {
                this.mWindingRule = 1;
            }
        }
        this.mGraphics.draw("[multiline]");
        this.mGraphics.draw("path,start");
        this.pdfPathMode = true;
    }

    public void pathClear() {
        this.mCurrentPoint = null;
        this.mGraphics.draw("path,end");
        this.mGraphics.draw("[multiline]");
        this.pdfPathMode = false;
    }

    public void pathMoveTo(double x, double y, KLocalAxis la) {
        double xx = this.getGlobalX(x, y, la);
        double yy = this.getGlobalY(x, y, la);
        if (Double.isNaN(xx) || Double.isNaN(yy)) {
            throw new IllegalArgumentException();
        }
        if (Double.isInfinite(xx) || Double.isInfinite(yy)) {
            throw new IllegalArgumentException();
        }
        KPoint2d p = this.mCurrentPoint;
        if (p != null && RichGraphicsUtil.isSame2D((double)xx, (double)yy, (double)p.getX(), (double)p.getY())) {
            return;
        }
        StringBuilder sb = new StringBuilder("moveto");
        sb.append(",");
        this.updateCurrentPoint(xx, yy);
        this.appendPoint(sb, xx, yy);
        this.mGraphics.draw(sb.toString());
        if (!this.pdfPathMode) {
            System.out.println("pathmode error!");
        }
    }

    public void pathLineTo(double x, double y, KLocalAxis la) {
        StringBuilder sb = new StringBuilder("lineto");
        sb.append(",");
        double xx = this.getGlobalX(x, y, la);
        double yy = this.getGlobalY(x, y, la);
        if (Double.isNaN(xx) || Double.isNaN(yy)) {
            throw new IllegalArgumentException();
        }
        if (Double.isInfinite(xx) || Double.isInfinite(yy)) {
            throw new IllegalArgumentException();
        }
        this.updateCurrentPoint(xx, yy);
        this.appendPoint(sb, xx, yy);
        this.mGraphics.draw(sb.toString());
        if (!this.pdfPathMode) {
            System.out.println("pathmode error!");
        }
    }

    public void pathQuadTo(double x1, double y1, double x2, double y2, KLocalAxis la) {
    }

    public void pathCurveTo(double x1, double y1, double x2, double y2, double x3, double y3, KLocalAxis la) {
        double xa = this.getGlobalX(x1, y1, la);
        double ya = this.getGlobalY(x1, y1, la);
        double xb = this.getGlobalX(x2, y2, la);
        double yb = this.getGlobalY(x2, y2, la);
        double xc = this.getGlobalX(x3, y3, la);
        double yc = this.getGlobalY(x3, y3, la);
        if (Double.isNaN(xa) || Double.isNaN(ya)) {
            throw new IllegalArgumentException();
        }
        if (Double.isInfinite(xa) || Double.isInfinite(ya)) {
            throw new IllegalArgumentException();
        }
        if (Double.isNaN(xb) || Double.isNaN(yb)) {
            throw new IllegalArgumentException();
        }
        if (Double.isInfinite(xb) || Double.isInfinite(yb)) {
            throw new IllegalArgumentException();
        }
        if (Double.isNaN(xc) || Double.isNaN(yc)) {
            throw new IllegalArgumentException();
        }
        if (Double.isInfinite(xc) || Double.isInfinite(yc)) {
            throw new IllegalArgumentException();
        }
        this.updateCurrentPoint(xc, yc);
        StringBuilder sb = new StringBuilder("bezier1");
        sb.append(",");
        this.appendPoint(sb, xa, ya);
        sb.append(",");
        this.appendPoint(sb, xb, yb);
        sb.append(",");
        this.appendPoint(sb, xc, yc);
        this.mGraphics.draw(sb.toString());
        if (!this.pdfPathMode) {
            System.out.println("pathmode error!");
        }
    }

    private double getGlobalX(double x, double y, KLocalAxis la) {
        if (la == null) {
            return x;
        }
        return la.getGlobalX(x, y);
    }

    private double getGlobalY(double x, double y, KLocalAxis la) {
        if (la == null) {
            return y;
        }
        return la.getGlobalY(x, y);
    }

    private void appendPoint(StringBuilder sb, double x, double y) {
        this.mGraphics.appendPosition(sb, ",", x, y);
    }

    public void pathClose() {
        this.mGraphics.draw("close");
    }

    public void fillPath(KLineType lt) {
        this.setLineType(lt);
        StringBuilder sb = new StringBuilder("fill");
        sb.append(",");
        sb.append(Integer.toString(this.mWindingRule));
        sb.append(",");
        this.mGraphics.appendColor(sb, ",");
        this.mGraphics.draw(sb.toString());
    }

    protected void updateCurrentPoint(double xx, double yy) {
        if (this.mCurrentPoint == null) {
            this.mCurrentPoint = new KPoint2d(xx, yy);
        } else {
            this.mCurrentPoint.setXY(xx, yy);
        }
    }

    public void drawPath(KLineType lt) {
        this.setLineType(lt);
        StringBuilder sb = new StringBuilder("stroke");
        sb.append(",");
        this.mGraphics.appendColor(sb, ",");
        sb.append(",");
        this.mGraphics.appendLineWidth(sb);
        sb.append(",");
        this.mGraphics.appendLinePattern(sb, ",");
        this.mGraphics.draw(sb.toString());
    }

    @Deprecated
    public void shadePath(KLineType lt, double x1, double y1, double x2, double y2, KColor c1, KColor c2, boolean cyclic) {
        String SEP = "_";
        DecimalFormat fRgb = new DecimalFormat("000");
        DecimalFormat fAxis = new DecimalFormat("00.00");
        StringBuilder shadename = new StringBuilder("TYPE2");
        shadename.append("_");
        shadename.append(fRgb.format(c1.getRed()));
        shadename.append(fRgb.format(c1.getGreen()));
        shadename.append(fRgb.format(c1.getBlue()));
        shadename.append(fRgb.format(c2.getRed()));
        shadename.append(fRgb.format(c2.getGreen()));
        shadename.append(fRgb.format(c2.getBlue()));
        shadename.append("_");
        shadename.append(fAxis.format(x1));
        shadename.append(":");
        shadename.append(fAxis.format(y1));
        shadename.append(":");
        shadename.append(fAxis.format(x2));
        shadename.append(":");
        shadename.append(fAxis.format(y2));
        shadename.append("_");
        shadename.append(cyclic ? "1" : "0");
        StringBuilder sb = new StringBuilder("shadestroke");
        sb.append(",");
        sb.append(shadename.toString());
        sb.append(",");
        this.mGraphics.appendLineWidth(sb);
        sb.append(",");
        this.mGraphics.appendLinePattern(sb, ",");
        this.mGraphics.draw(sb.toString());
    }

    public void drawMark(double x, double y, int r, int type) {
    }

    public KArea getDrawArea() {
        return null;
    }

    public double getDotPerLen() {
        return 0.0;
    }
}

