/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.math.searches.regiontree;

import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import jp.kitec.math.searches.regiontree.RectangleSupplier;
import jp.kitec.math.searches.regiontree.RegionTree;
import jp.kitec.math.searches.regiontree.RegionTreeBuilder;

public class TestRegionTree {
    public static void main(String[] arg) {
        TestRegionTree test = new TestRegionTree();
        test.test2();
    }

    public void test() {
        RegionTree tree = new RegionTree();
        RegionTreeBuilder builder = new RegionTreeBuilder();
        Rect rect = new Rect();
        rect.x1 = 0.0;
        rect.x2 = 10.0;
        rect.y1 = 0.0;
        rect.y2 = 10.0;
        builder.addNodes(rect);
        rect = new Rect();
        rect.x1 = 15.0;
        rect.x2 = 25.0;
        rect.y1 = 15.0;
        rect.y2 = 25.0;
        builder.addNodes(rect);
        rect = new Rect();
        rect.x1 = 2.0;
        rect.x2 = 8.0;
        rect.y1 = 2.0;
        rect.y2 = 8.0;
        builder.addNodes(rect);
        rect = new Rect();
        rect.x1 = 12.0;
        rect.x2 = 20.0;
        rect.y1 = 0.0;
        rect.y2 = 5.0;
        builder.addNodes(rect);
        builder.build(tree);
        Vector vector = new Vector(10, 10);
        for (int i = 0; i < vector.size(); ++i) {
            rect = (Rect)vector.get(i);
            System.out.println("(" + rect.x1 + ", " + rect.y1 + ")-(" + rect.x2 + ", " + rect.y2 + ")");
        }
    }

    public void test2() {
        Rect rect;
        SimpleDateFormat format = new SimpleDateFormat();
        RegionTree tree = new RegionTree();
        RegionTreeBuilder builder = new RegionTreeBuilder();
        int x = 100;
        int y = 100;
        format.applyLocalizedPattern("kk:mm:ss.SSS");
        Date date = new Date();
        System.out.println("Data registering ! " + format.format(date));
        for (int i = 0; i < x; ++i) {
            for (int j = 0; j < y; ++j) {
                rect = new Rect();
                rect.x1 = i * 100;
                rect.y1 = j * 100;
                rect.x2 = (i + 1) * 100;
                rect.y2 = (j + 1) * 100;
                builder.addNodes(rect);
            }
        }
        date = new Date();
        System.out.println("Build start ! " + format.format(date));
        builder.build(tree);
        Vector<RectangleSupplier> vector = new Vector<RectangleSupplier>(100, 100);
        date = new Date();
        System.out.println("Search start ! " + format.format(date));
        tree.search(vector, 50.0, 50.0, 150.0, 150.0);
        date = new Date();
        System.out.println("Search Ended !! " + format.format(date));
        for (int i = 0; i < vector.size(); ++i) {
            rect = (Rect)vector.get(i);
            System.out.println("(" + rect.x1 + ", " + rect.y1 + ")-(" + rect.x2 + ", " + rect.y2 + ")");
        }
    }

    public void test3() {
        Rect rect;
        SimpleDateFormat format = new SimpleDateFormat();
        RegionTree tree = new RegionTree();
        RegionTreeBuilder builder = new RegionTreeBuilder();
        int x = 100;
        int y = 100;
        format.applyLocalizedPattern("kk:mm:ss.SSS");
        Date date = new Date();
        System.out.println("Data registering ! " + format.format(date));
        for (int i = 0; i < x; ++i) {
            for (int j = 0; j < y; ++j) {
                rect = new Rect();
                rect.x1 = i * 100;
                rect.y1 = j * 100;
                rect.x2 = (i + 2) * 100;
                rect.y2 = (j + 2) * 100;
                builder.addNodes(rect);
            }
        }
        date = new Date();
        System.out.println("Build start ! " + format.format(date));
        builder.build(tree);
        Vector<RectangleSupplier> vector = new Vector<RectangleSupplier>(100, 100);
        date = new Date();
        System.out.println("Search start ! " + format.format(date));
        tree.search(vector, 5050.0, 5050.0, 5150.0, 5150.0);
        date = new Date();
        System.out.println("Search Ended !! " + format.format(date));
        for (int i = 0; i < vector.size(); ++i) {
            rect = (Rect)vector.get(i);
            System.out.println("(" + rect.x1 + ", " + rect.y1 + ")-(" + rect.x2 + ", " + rect.y2 + ")");
        }
    }

    public void test4() {
        Rect rect;
        SimpleDateFormat format = new SimpleDateFormat();
        TreeSet<Rect> tree = new TreeSet<Rect>(new TestComp());
        int x = 20000;
        int y = 1;
        format.applyLocalizedPattern("kk:mm:ss.SSS");
        Date date = new Date();
        System.out.println("Data registering ! " + format.format(date));
        date = new Date();
        System.out.println("Registering start ! " + format.format(date));
        for (int i = 0; i < x; ++i) {
            for (int j = 0; j < y; ++j) {
                rect = new Rect();
                rect.x1 = i * 100;
                rect.y2 = 0.0;
                rect.x2 = 0.0;
                rect.y1 = 0.0;
                tree.add(rect);
            }
        }
        date = new Date();
        System.out.println("Registering Ended !! " + format.format(date));
        Iterator iter = tree.iterator();
        date = new Date();
        System.out.println("Iterator made !! " + format.format(date));
        int i = 0;
        while (iter.hasNext()) {
            rect = (Rect)iter.next();
            ++i;
        }
        date = new Date();
        System.out.println("Finished !! " + format.format(date));
    }

    public class Rect
    implements RectangleSupplier {
        double x1;
        double y1;
        double x2;
        double y2;

        @Override
        public double getLeft() {
            return this.x1;
        }

        @Override
        public double getRight() {
            return this.x2;
        }

        @Override
        public double getLower() {
            return this.y1;
        }

        @Override
        public double getUpper() {
            return this.y2;
        }
    }

    class TestComp
    implements Comparator {
        TestComp() {
        }

        public int compare(Object arg0, Object arg1) {
            Rect rect1 = (Rect)arg0;
            Rect rect2 = (Rect)arg1;
            if (rect1.x1 < rect2.x1) {
                return -1;
            }
            if (rect1.x1 > rect2.x1) {
                return 1;
            }
            return 0;
        }
    }
}

