/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.math.geom.offset;

import jp.kitec.math.algebra.AlgebraException;
import jp.kitec.math.geom.ToolGeom2D;
import jp.kitec.math.geom.ToolJudge2D;
import jp.kitec.math.geom.datapassing.ICollectionEditable;
import jp.kitec.math.geom.datapassing.IFigure2D;
import jp.kitec.math.geom.datapassing.IFigure2DArc;
import jp.kitec.math.geom.datapassing.IFigureType;
import jp.kitec.math.geom.datapassing.IPolyline2D;
import jp.kitec.math.geom.datapassing.IPolyline2DCollection;
import jp.kitec.math.geom.datapassing.PolylineEditable;
import jp.kitec.math.geom.datapassing.ToolGeomFigure2D;
import jp.kitec.math.geom.datapassing.complete.MPolylineCollection;
import jp.kitec.math.geom.datapassing.plane.ToolPlane2D;
import jp.kitec.math.geom.datapassing.polylines.ToolGeomPolyline2D;
import jp.kitec.math.geom.logicaloperation.PolygonCollector;
import jp.kitec.math.geom.logicaloperation.ToolPlaneLogic;
import jp.kitec.math.searches.regiontree.RegionTreeBuilder;

public class ToolOffset2D {
    public boolean getOffset(ICollectionEditable collectionOut, IPolyline2DCollection collectionIn, double offsetDistance, boolean rightSide) throws AlgebraException {
        for (int i = 0; i < collectionIn.size(); ++i) {
            IPolyline2D polyline = collectionIn.get(i);
            if (ToolOffset2D.getOffset(collectionOut, polyline, offsetDistance, rightSide)) continue;
            return false;
        }
        return true;
    }

    public static boolean getOffset(ICollectionEditable collectionOut, IPolyline2D polylineIn, double offsetDistance, boolean rightSide) throws AlgebraException {
        MPolylineCollection collectionTmp = new MPolylineCollection();
        if (!ToolOffset2D.getEachPrimitiveOffsetConnectWithExtension((ICollectionEditable)collectionTmp, polylineIn, offsetDistance, rightSide)) {
            return false;
        }
        collectionTmp.makeTree(new RegionTreeBuilder());
        ToolPlaneLogic pl = new ToolPlaneLogic();
        pl.process(collectionTmp);
        PolygonCollector cllct = new PolygonCollector();
        cllct.or(collectionTmp);
        cllct.get(collectionOut);
        return true;
    }

    public static boolean getPrimitiveOffset(ICollectionEditable collectionOut, IPolyline2DCollection collectionIn, double offsetDistance, boolean rightSide) throws AlgebraException {
        for (int i = 0; i < collectionIn.size(); ++i) {
            IPolyline2D polyline = collectionIn.get(i);
            if (ToolOffset2D.getPrimitiveOffset(collectionOut, polyline, offsetDistance, rightSide)) continue;
            return false;
        }
        return true;
    }

    public static boolean getPrimitiveOffset(ICollectionEditable collectionOut, IPolyline2D polylineIn, double offsetDistance, boolean rightSide) throws AlgebraException {
        IFigure2DArc arcOut;
        IFigure2D figureOut;
        IFigure2D figure;
        IFigure2D figurePrev;
        IPolyline2D polylineOut = collectionOut.add();
        IFigure2DArc arc = null;
        IFigure2DArc arcPrev = null;
        double[] offset1 = new double[5];
        double[] offset2 = new double[5];
        double[] intersect = new double[4];
        int cnt = 0;
        boolean firstIntersect = false;
        boolean bClose = ToolGeom2D.equalPoints(((IFigure2D)polylineIn.firstElement()).getX1(), ((IFigure2D)polylineIn.firstElement()).getY1(), ((IFigure2D)polylineIn.lastElement()).getX2(), ((IFigure2D)polylineIn.lastElement()).getY2());
        if (!(polylineOut instanceof PolylineEditable)) {
            return false;
        }
        PolylineEditable pe = (PolylineEditable)((Object)polylineOut);
        if (bClose) {
            figurePrev = (IFigure2D)polylineIn.lastElement();
            figure = (IFigure2D)polylineIn.firstElement();
        } else {
            figurePrev = (IFigure2D)polylineIn.firstElement();
            figure = ToolGeomFigure2D.getNext(figurePrev);
            ++cnt;
        }
        ToolGeomFigure2D.getOffset(offset1, figurePrev, offsetDistance, rightSide);
        while (figure != null) {
            int num;
            if (IFigureType.isArc(figure.getType())) {
                arc = (IFigure2DArc)figure;
            }
            ToolGeomFigure2D.getOffset(offset2, figure, offsetDistance, rightSide);
            if (IFigureType.isLine(figurePrev.getType()) && IFigureType.isLine(figure.getType())) {
                num = ToolGeom2D.getIntersectPoints(intersect, offset1[0], offset1[1], offset1[2], offset1[3], offset2[0], offset2[1], offset2[2], offset2[3]) ? 1 : 0;
            } else if (IFigureType.isLine(figurePrev.getType()) && IFigureType.isArc(figure.getType())) {
                num = ToolGeom2D.getIntersectPoints(intersect, offset1[0], offset1[1], offset1[2], offset1[3], offset2[0], offset2[1], offset2[2], offset2[3], arc.getCX(), arc.getCY(), offset2[4], arc.isCw());
            } else if (IFigureType.isArc(figurePrev.getType()) && IFigureType.isLine(figure.getType())) {
                num = ToolGeom2D.getIntersectPoints(intersect, offset2[0], offset2[1], offset2[2], offset2[3], offset1[0], offset1[1], offset1[2], offset1[3], arc.getCX(), arc.getCY(), offset1[4], arc.isCw());
            } else if (IFigureType.isArc(figurePrev.getType()) && IFigureType.isArc(figure.getType())) {
                num = ToolGeom2D.getIntersectPoints(intersect, offset1[0], offset1[1], offset1[2], offset1[3], arcPrev.getCX(), arcPrev.getCY(), offset1[4], arcPrev.isCw(), offset2[0], offset2[1], offset2[2], offset2[3], arc.getCX(), arc.getCY(), offset2[4], arc.isCw());
            } else {
                return false;
            }
            switch (num) {
                case 2: {
                    double parameter1 = IFigureType.isLine(figure.getType()) ? ToolGeom2D.getParameter(intersect[0], intersect[1], offset2[0], offset2[1], offset2[2], offset2[3]) : ToolGeom2D.getParameter(intersect[0], intersect[1], offset2[0], offset2[1], offset2[2], offset2[3], arc.getCX(), arc.getCY(), offset2[4], arc.isCw());
                    double parameter2 = IFigureType.isLine(figure.getType()) ? ToolGeom2D.getParameter(intersect[2], intersect[3], offset2[0], offset2[1], offset2[2], offset2[3]) : ToolGeom2D.getParameter(intersect[2], intersect[3], offset2[0], offset2[1], offset2[2], offset2[3], arc.getCX(), arc.getCY(), offset2[4], arc.isCw());
                    if (parameter2 < parameter1) {
                        intersect[0] = intersect[2];
                        intersect[1] = intersect[3];
                    }
                }
                case 1: {
                    if (cnt > 0) {
                        figureOut = pe.add(figurePrev.getType());
                        figureOut.setX1(offset1[0]);
                        figureOut.setY1(offset1[1]);
                        figureOut.setX2(intersect[0]);
                        figureOut.setY2(intersect[1]);
                        if (IFigureType.isArc(figureOut.getType())) {
                            arcOut = (IFigure2DArc)figureOut;
                            arcOut.setCX(arcPrev.getCX());
                            arcOut.setCY(arcPrev.getCY());
                            arcOut.setCw(arcPrev.isCw());
                            arcOut.setRadius(offset1[4]);
                        }
                    } else {
                        firstIntersect = true;
                    }
                    offset2[0] = intersect[0];
                    offset2[1] = intersect[1];
                    break;
                }
                case 0: {
                    figureOut = pe.add(figurePrev.getType());
                    figureOut.setX1(offset1[0]);
                    figureOut.setY1(offset1[1]);
                    figureOut.setX2(offset1[2]);
                    figureOut.setY2(offset1[3]);
                    if (IFigureType.isArc(figureOut.getType())) {
                        arcOut = (IFigure2DArc)figureOut;
                        arcOut.setCX(arcPrev.getCX());
                        arcOut.setCY(arcPrev.getCY());
                        arcOut.setCw(arcPrev.isCw());
                        arcOut.setRadius(offset1[4]);
                    }
                    figureOut = pe.add(rightSide ? 3 : 2);
                    figureOut.setX1(offset1[2]);
                    figureOut.setY1(offset1[3]);
                    figureOut.setX2(offset2[0]);
                    figureOut.setY2(offset2[1]);
                    arcOut = (IFigure2DArc)figureOut;
                    arcOut.setCX(figure.getX1());
                    arcOut.setCY(figure.getY1());
                    arcOut.setCw(!rightSide);
                    arcOut.setRadius(offsetDistance);
                }
            }
            figurePrev = figure;
            arcPrev = arc;
            figure = ToolGeomFigure2D.getNext(figure);
            double[] swap = offset1;
            offset1 = offset2;
            offset2 = swap;
            ++cnt;
        }
        if (bClose) {
            if (firstIntersect) {
                figureOut = pe.add(figurePrev.getType());
                figureOut.setX1(offset1[0]);
                figureOut.setY1(offset1[1]);
                figure = (IFigure2D)polylineOut.firstElement();
                figureOut.setX2(figure.getX1());
                figureOut.setY2(figure.getY1());
                if (IFigureType.isArc(figureOut.getType())) {
                    arcOut = (IFigure2DArc)figureOut;
                    arcOut.setCX(arcPrev.getCX());
                    arcOut.setCY(arcPrev.getCY());
                    arcOut.setCw(arcPrev.isCw());
                }
            } else {
                figure = (IFigure2D)polylineOut.firstElement();
                figurePrev = (IFigure2D)polylineOut.lastElement();
                if (!ToolJudge2D.equalPoints(figure.getX1(), figure.getY1(), figurePrev.getX2(), figurePrev.getY2())) {
                    figureOut = pe.add(rightSide ? 3 : 2);
                    figureOut.setX1(offset2[2]);
                    figureOut.setY1(offset2[3]);
                    figureOut.setX2(figure.getX1());
                    figureOut.setY2(figure.getY1());
                    arcOut = (IFigure2DArc)figureOut;
                    arcOut.setCX(figurePrev.getX1());
                    arcOut.setCY(figurePrev.getY1());
                    arcOut.setCw(!rightSide);
                    arcOut.setRadius(offsetDistance);
                }
            }
            int direction = ToolPlane2D.getDirection(polylineOut);
            pe.setRegion(rightSide ? (byte)2 : 1);
        }
        return true;
    }

    public static boolean getPrimitiveOffsetWithExtension(ICollectionEditable collectionOut, IPolyline2D polylineIn, double offsetDistance, boolean rightSide) throws AlgebraException {
        IFigure2DArc arcOut;
        IFigure2D figureOut;
        IFigure2D figure;
        IFigure2D figurePrev;
        if (polylineIn.size() == 0) {
            return false;
        }
        IPolyline2D polylineOut = collectionOut.add();
        IFigure2DArc arc = null;
        IFigure2DArc arcPrev = null;
        double[] offset1 = new double[5];
        double[] offset2 = new double[5];
        double[] intersect = new double[4];
        int cnt = 0;
        boolean firstIntersect = false;
        boolean bClose = ToolGeom2D.equalPoints(((IFigure2D)polylineIn.firstElement()).getX1(), ((IFigure2D)polylineIn.firstElement()).getY1(), ((IFigure2D)polylineIn.lastElement()).getX2(), ((IFigure2D)polylineIn.lastElement()).getY2());
        if (!(polylineOut instanceof PolylineEditable)) {
            return false;
        }
        PolylineEditable pe = (PolylineEditable)((Object)polylineOut);
        if (bClose) {
            figurePrev = (IFigure2D)polylineIn.lastElement();
            figure = (IFigure2D)polylineIn.firstElement();
        } else {
            figurePrev = (IFigure2D)polylineIn.firstElement();
            figure = ToolGeomFigure2D.getNext(figurePrev);
            ++cnt;
        }
        ToolGeomFigure2D.getOffset(offset1, figurePrev, offsetDistance, rightSide);
        while (figure != null) {
            int num;
            if (IFigureType.isArc(figure.getType())) {
                arc = (IFigure2DArc)figure;
            }
            ToolGeomFigure2D.getOffset(offset2, figure, offsetDistance, rightSide);
            if (IFigureType.isLine(figurePrev.getType()) && IFigureType.isLine(figure.getType())) {
                num = ToolGeom2D.getIntersectPointsExtension(intersect, offset1[0], offset1[1], offset1[2], offset1[3], offset2[0], offset2[1], offset2[2], offset2[3]) ? 1 : 0;
            } else if (IFigureType.isLine(figurePrev.getType()) && IFigureType.isArc(figure.getType())) {
                num = ToolGeom2D.getIntersectPointsExtension(intersect, offset1[0], offset1[1], offset1[2], offset1[3], arc.getCX(), arc.getCY(), offset2[4]);
            } else if (IFigureType.isArc(figurePrev.getType()) && IFigureType.isLine(figure.getType())) {
                num = ToolGeom2D.getIntersectPointsExtension(intersect, offset2[0], offset2[1], offset2[2], offset2[3], arc.getCX(), arc.getCY(), offset1[4]);
            } else if (IFigureType.isArc(figurePrev.getType()) && IFigureType.isArc(figure.getType())) {
                num = ToolGeom2D.getIntersectPointsExtension(intersect, arcPrev.getCX(), arcPrev.getCY(), offset1[4], arc.getCX(), arc.getCY(), offset2[4]);
            } else {
                return false;
            }
            switch (num) {
                case 2: {
                    double parameter1 = IFigureType.isLine(figure.getType()) ? ToolGeom2D.getParameter(intersect[0], intersect[1], offset2[0], offset2[1], offset2[2], offset2[3]) : ToolGeom2D.getParameter(intersect[0], intersect[1], offset2[0], offset2[1], offset2[2], offset2[3], arc.getCX(), arc.getCY(), offset2[4], arc.isCw());
                    double parameter2 = IFigureType.isLine(figure.getType()) ? ToolGeom2D.getParameter(intersect[2], intersect[3], offset2[0], offset2[1], offset2[2], offset2[3]) : ToolGeom2D.getParameter(intersect[2], intersect[3], offset2[0], offset2[1], offset2[2], offset2[3], arc.getCX(), arc.getCY(), offset2[4], arc.isCw());
                    if (parameter2 < parameter1) {
                        intersect[0] = intersect[2];
                        intersect[1] = intersect[3];
                    }
                }
                case 1: {
                    if (cnt > 0) {
                        figureOut = pe.add(figurePrev.getType());
                        figureOut.setX1(offset1[0]);
                        figureOut.setY1(offset1[1]);
                        figureOut.setX2(intersect[0]);
                        figureOut.setY2(intersect[1]);
                        if (IFigureType.isArc(figureOut.getType())) {
                            arcOut = (IFigure2DArc)figureOut;
                            arcOut.setCX(arcPrev.getCX());
                            arcOut.setCY(arcPrev.getCY());
                            arcOut.setCw(arcPrev.isCw());
                            arcOut.setRadius(offset1[4]);
                        }
                    } else {
                        firstIntersect = true;
                    }
                    offset2[0] = intersect[0];
                    offset2[1] = intersect[1];
                    break;
                }
                case 0: {
                    figureOut = pe.add(rightSide ? 3 : 2);
                    figureOut.setX1(offset1[2]);
                    figureOut.setY1(offset1[3]);
                    figureOut.setX2(offset2[0]);
                    figureOut.setY2(offset2[1]);
                    arcOut = (IFigure2DArc)figureOut;
                    arcOut.setCX(figure.getX1());
                    arcOut.setCY(figure.getY1());
                    arcOut.setCw(!rightSide);
                    arcOut.setRadius(offsetDistance);
                }
            }
            figurePrev = figure;
            arcPrev = arc;
            figure = ToolGeomFigure2D.getNext(figure);
            double[] swap = offset1;
            offset1 = offset2;
            offset2 = swap;
            ++cnt;
        }
        if (bClose) {
            if (firstIntersect) {
                figureOut = pe.add(figurePrev.getType());
                figureOut.setX1(offset1[0]);
                figureOut.setY1(offset1[1]);
                figure = (IFigure2D)polylineOut.firstElement();
                figureOut.setX2(figure.getX1());
                figureOut.setY2(figure.getY1());
                if (IFigureType.isArc(figureOut.getType())) {
                    arcOut = (IFigure2DArc)figureOut;
                    arcOut.setCX(arcPrev.getCX());
                    arcOut.setCY(arcPrev.getCY());
                    arcOut.setCw(arcPrev.isCw());
                }
            } else {
                figure = (IFigure2D)polylineOut.firstElement();
                figurePrev = (IFigure2D)polylineOut.lastElement();
                if (!ToolJudge2D.equalPoints(figure.getX1(), figure.getY1(), figurePrev.getX2(), figurePrev.getY2())) {
                    figureOut = pe.add(rightSide ? 3 : 2);
                    figureOut.setX1(offset2[2]);
                    figureOut.setY1(offset2[3]);
                    figureOut.setX2(figure.getX1());
                    figureOut.setY2(figure.getY1());
                    arcOut = (IFigure2DArc)figureOut;
                    arcOut.setCX(figurePrev.getX1());
                    arcOut.setCY(figurePrev.getY1());
                    arcOut.setCw(!rightSide);
                    arcOut.setRadius(offsetDistance);
                }
            }
            int direction = ToolPlane2D.getDirection(polylineOut);
            pe.setRegion(rightSide ? (byte)2 : 1);
        } else {
            figure = pe.add(((IFigure2D)polylineIn.lastElement()).getType());
            figure.setX2(offset1[2]);
            figure.setY2(offset1[3]);
        }
        return true;
    }

    public static boolean getPrimitiveOffsetWithExtension(ICollectionEditable collectionOut, IPolyline2D polylineIn, double offsetDistanceX, double offsetDistanceY, double offsetDistanceOther, boolean rightSide) throws AlgebraException {
        IFigure2DArc arcOut;
        IFigure2D figureOut;
        IFigure2D figure;
        IFigure2D figurePrev;
        if (polylineIn.size() == 0) {
            return false;
        }
        IPolyline2D polylineOut = collectionOut.add();
        IFigure2DArc arc = null;
        IFigure2DArc arcPrev = null;
        double[] offset1 = new double[5];
        double[] offset2 = new double[5];
        double[] intersect = new double[4];
        int cnt = 0;
        boolean firstIntersect = false;
        boolean bClose = ToolGeom2D.equalPoints(((IFigure2D)polylineIn.firstElement()).getX1(), ((IFigure2D)polylineIn.firstElement()).getY1(), ((IFigure2D)polylineIn.lastElement()).getX2(), ((IFigure2D)polylineIn.lastElement()).getY2());
        if (!(polylineOut instanceof PolylineEditable)) {
            return false;
        }
        PolylineEditable pe = (PolylineEditable)((Object)polylineOut);
        if (bClose) {
            figurePrev = (IFigure2D)polylineIn.lastElement();
            figure = (IFigure2D)polylineIn.firstElement();
        } else {
            figurePrev = (IFigure2D)polylineIn.firstElement();
            figure = ToolGeomFigure2D.getNext(figurePrev);
            ++cnt;
        }
        int iDiffX = ToolGeom2D.compare(figurePrev.getX1(), figurePrev.getX2());
        int iDiffY = ToolGeom2D.compare(figurePrev.getY1(), figurePrev.getY2());
        double distTmp = iDiffX == 0 ? offsetDistanceX : (iDiffY == 0 ? offsetDistanceY : offsetDistanceOther);
        ToolGeomFigure2D.getOffset(offset1, figurePrev, distTmp, rightSide);
        while (figure != null) {
            int num;
            if (IFigureType.isArc(figure.getType())) {
                arc = (IFigure2DArc)figure;
            }
            iDiffX = ToolGeom2D.compare(figure.getX1(), figure.getX2());
            iDiffY = ToolGeom2D.compare(figure.getY1(), figure.getY2());
            distTmp = iDiffX == 0 ? offsetDistanceX : (iDiffY == 0 ? offsetDistanceY : offsetDistanceOther);
            ToolGeomFigure2D.getOffset(offset2, figure, distTmp, rightSide);
            if (IFigureType.isLine(figurePrev.getType()) && IFigureType.isLine(figure.getType())) {
                num = ToolGeom2D.getIntersectPointsExtension(intersect, offset1[0], offset1[1], offset1[2], offset1[3], offset2[0], offset2[1], offset2[2], offset2[3]) ? 1 : 0;
            } else if (IFigureType.isLine(figurePrev.getType()) && IFigureType.isArc(figure.getType())) {
                num = ToolGeom2D.getIntersectPointsExtension(intersect, offset1[0], offset1[1], offset1[2], offset1[3], arc.getCX(), arc.getCY(), offset2[4]);
            } else if (IFigureType.isArc(figurePrev.getType()) && IFigureType.isLine(figure.getType())) {
                num = ToolGeom2D.getIntersectPointsExtension(intersect, offset2[0], offset2[1], offset2[2], offset2[3], arc.getCX(), arc.getCY(), offset1[4]);
            } else if (IFigureType.isArc(figurePrev.getType()) && IFigureType.isArc(figure.getType())) {
                num = ToolGeom2D.getIntersectPointsExtension(intersect, arcPrev.getCX(), arcPrev.getCY(), offset1[4], arc.getCX(), arc.getCY(), offset2[4]);
            } else {
                return false;
            }
            switch (num) {
                case 2: {
                    double parameter1 = IFigureType.isLine(figure.getType()) ? ToolGeom2D.getParameter(intersect[0], intersect[1], offset2[0], offset2[1], offset2[2], offset2[3]) : ToolGeom2D.getParameter(intersect[0], intersect[1], offset2[0], offset2[1], offset2[2], offset2[3], arc.getCX(), arc.getCY(), offset2[4], arc.isCw());
                    double parameter2 = IFigureType.isLine(figure.getType()) ? ToolGeom2D.getParameter(intersect[2], intersect[3], offset2[0], offset2[1], offset2[2], offset2[3]) : ToolGeom2D.getParameter(intersect[2], intersect[3], offset2[0], offset2[1], offset2[2], offset2[3], arc.getCX(), arc.getCY(), offset2[4], arc.isCw());
                    if (parameter2 < parameter1) {
                        intersect[0] = intersect[2];
                        intersect[1] = intersect[3];
                    }
                }
                case 1: {
                    if (cnt > 0) {
                        figureOut = pe.add(figurePrev.getType());
                        figureOut.setX1(offset1[0]);
                        figureOut.setY1(offset1[1]);
                        figureOut.setX2(intersect[0]);
                        figureOut.setY2(intersect[1]);
                        if (IFigureType.isArc(figureOut.getType())) {
                            arcOut = (IFigure2DArc)figureOut;
                            arcOut.setCX(arcPrev.getCX());
                            arcOut.setCY(arcPrev.getCY());
                            arcOut.setCw(arcPrev.isCw());
                            arcOut.setRadius(offset1[4]);
                        }
                    } else {
                        firstIntersect = true;
                    }
                    offset2[0] = intersect[0];
                    offset2[1] = intersect[1];
                    break;
                }
                case 0: {
                    figureOut = pe.add(rightSide ? 3 : 2);
                    figureOut.setX1(offset1[2]);
                    figureOut.setY1(offset1[3]);
                    figureOut.setX2(offset2[0]);
                    figureOut.setY2(offset2[1]);
                    arcOut = (IFigure2DArc)figureOut;
                    arcOut.setCX(figure.getX1());
                    arcOut.setCY(figure.getY1());
                    arcOut.setCw(!rightSide);
                    arcOut.setRadius(offsetDistanceOther);
                }
            }
            figurePrev = figure;
            arcPrev = arc;
            figure = ToolGeomFigure2D.getNext(figure);
            double[] swap = offset1;
            offset1 = offset2;
            offset2 = swap;
            ++cnt;
        }
        if (bClose) {
            if (firstIntersect) {
                figureOut = pe.add(figurePrev.getType());
                figureOut.setX1(offset1[0]);
                figureOut.setY1(offset1[1]);
                figure = (IFigure2D)polylineOut.firstElement();
                figureOut.setX2(figure.getX1());
                figureOut.setY2(figure.getY1());
                if (IFigureType.isArc(figureOut.getType())) {
                    arcOut = (IFigure2DArc)figureOut;
                    arcOut.setCX(arcPrev.getCX());
                    arcOut.setCY(arcPrev.getCY());
                    arcOut.setCw(arcPrev.isCw());
                }
            } else {
                figure = (IFigure2D)polylineOut.firstElement();
                figurePrev = (IFigure2D)polylineOut.lastElement();
                if (!ToolJudge2D.equalPoints(figure.getX1(), figure.getY1(), figurePrev.getX2(), figurePrev.getY2())) {
                    figureOut = pe.add(rightSide ? 3 : 2);
                    figureOut.setX1(offset2[2]);
                    figureOut.setY1(offset2[3]);
                    figureOut.setX2(figure.getX1());
                    figureOut.setY2(figure.getY1());
                    arcOut = (IFigure2DArc)figureOut;
                    arcOut.setCX(figurePrev.getX1());
                    arcOut.setCY(figurePrev.getY1());
                    arcOut.setCw(!rightSide);
                    arcOut.setRadius(offsetDistanceOther);
                }
            }
            int direction = ToolPlane2D.getDirection(polylineOut);
            pe.setRegion(rightSide ? (byte)2 : 1);
        } else {
            figure = pe.add(((IFigure2D)polylineIn.lastElement()).getType());
            figure.setX2(offset1[2]);
            figure.setY2(offset1[3]);
        }
        return true;
    }

    public static boolean getEachPrimitiveOffsetConnect(ICollectionEditable collectionOut, IPolyline2DCollection collectionIn, double offsetDistance, boolean cw) throws AlgebraException {
        for (int i = 0; i < collectionIn.size(); ++i) {
            IPolyline2D polyline = collectionIn.get(i);
            if (ToolOffset2D.getEachPrimitiveOffsetConnect(collectionOut, polyline, offsetDistance, cw)) continue;
            return false;
        }
        return true;
    }

    public static boolean getEachPrimitiveOffsetConnect(ICollectionEditable collectionOut, IPolyline2D polylineIn, double offsetDistance, boolean cw) throws AlgebraException {
        IFigure2DArc arc = null;
        double[] offset1 = new double[5];
        double[] offset2 = new double[5];
        int cnt = 0;
        int out = 0;
        boolean firstIntersect = false;
        IFigure2D figure = (IFigure2D)polylineIn.firstElement();
        while (figure != null) {
            if (ToolGeomFigure2D.getLength(figure) != 0.0) {
                IFigure2DArc arcOut;
                IPolyline2D polylineOut = collectionOut.add();
                ++out;
                if (!(polylineOut instanceof PolylineEditable)) {
                    return false;
                }
                PolylineEditable pe = (PolylineEditable)((Object)polylineOut);
                if (IFigureType.isArc(figure.getType())) {
                    arc = (IFigure2DArc)figure;
                }
                ToolGeomFigure2D.getOffset(offset1, figure, offsetDistance, !cw);
                ToolGeomFigure2D.getOffset(offset2, figure, offsetDistance, cw);
                IFigure2D figureOut = pe.add(figure.getType());
                figureOut.setX1(offset1[0]);
                figureOut.setY1(offset1[1]);
                figureOut.setX2(offset1[2]);
                figureOut.setY2(offset1[3]);
                if (IFigureType.isArc(figure.getType())) {
                    arcOut = (IFigure2DArc)figureOut;
                    arcOut.setCX(arc.getCX());
                    arcOut.setCY(arc.getCY());
                    arcOut.setCw(arc.isCw());
                    arcOut.setRadius(offset1[4]);
                }
                figureOut = pe.add(cw ? 2 : 3);
                figureOut.setX2(offset2[2]);
                figureOut.setY2(offset2[3]);
                arcOut = (IFigure2DArc)figureOut;
                arcOut.setCX(figure.getX2());
                arcOut.setCY(figure.getY2());
                arcOut.setRadius(offsetDistance);
                figureOut = pe.add(IFigureType.getReverseType(figure.getType()));
                figureOut.setX2(offset2[0]);
                figureOut.setY2(offset2[1]);
                if (IFigureType.isArc(figure.getType())) {
                    arcOut = (IFigure2DArc)figureOut;
                    arcOut.setCX(arc.getCX());
                    arcOut.setCY(arc.getCY());
                    arcOut.setCw(arc.isCw());
                    arcOut.setRadius(offset2[4]);
                }
                figureOut = pe.add(cw ? 2 : 3);
                figureOut.setX2(offset1[0]);
                figureOut.setY2(offset1[1]);
                arcOut = (IFigure2DArc)figureOut;
                arcOut.setCX(figure.getX1());
                arcOut.setCY(figure.getY1());
                arcOut.setRadius(offsetDistance);
                int direction = ToolPlane2D.getDirection(polylineOut);
                pe.setRegion(cw ? (byte)1 : 2);
            }
            figure = ToolGeomFigure2D.getNext(figure);
            double[] swap = offset1;
            offset1 = offset2;
            offset2 = swap;
            ++cnt;
        }
        return true;
    }

    public static boolean getEachPrimitiveOffsetConnectWithExtension(ICollectionEditable collectionOut, IPolyline2DCollection collectionIn, double offsetDistance, boolean cw) throws AlgebraException {
        for (int i = 0; i < collectionIn.size(); ++i) {
            IPolyline2D polyline = collectionIn.get(i);
            if (ToolOffset2D.getEachPrimitiveOffsetConnectWithExtension(collectionOut, polyline, offsetDistance, cw)) continue;
            return false;
        }
        return true;
    }

    public static boolean getEachPrimitiveOffsetConnectWithExtension(ICollectionEditable collectionOut, IPolyline2D polylineIn, double offsetDistance, boolean cw) throws AlgebraException {
        double y;
        double x;
        double param4;
        double param3;
        double param2;
        double param1;
        IFigure2D figurePrev = (IFigure2D)polylineIn.lastElement();
        IFigure2D figure = (IFigure2D)polylineIn.firstElement();
        double[] offset1 = new double[5];
        double[] offset2 = new double[5];
        double[] offset1Prev = new double[5];
        double[] offset2Prev = new double[5];
        double[] intersect = new double[4];
        double x1Prev = 0.0;
        double y1Prev = 0.0;
        double x2Prev = 0.0;
        double y2Prev = 0.0;
        double x1 = 0.0;
        double y1 = 0.0;
        double x2 = 0.0;
        double y2 = 0.0;
        double x1First = 0.0;
        double y1First = 0.0;
        double x2First = 0.0;
        double y2First = 0.0;
        int cnt = 0;
        boolean firstIntersect = false;
        boolean bClosed = ToolGeomPolyline2D.isClosed(polylineIn);
        if (bClosed) {
            ToolGeomFigure2D.getOffset(offset1Prev, figurePrev, offsetDistance, !cw);
            ToolGeomFigure2D.getOffset(offset2Prev, figurePrev, offsetDistance, cw);
        } else {
            figurePrev = null;
        }
        while (figure != null) {
            while (ToolGeom2D.equalPoints(figure.getX1(), figure.getY1(), figure.getX2(), figure.getY2())) {
                figure = ToolGeomFigure2D.getNext(figure);
            }
            ToolGeomFigure2D.getOffset(offset1, figure, offsetDistance, !cw);
            ToolGeomFigure2D.getOffset(offset2, figure, offsetDistance, cw);
            if (figurePrev == null) {
                x1 = offset1[0];
                y1 = offset1[1];
                x2 = offset2[0];
                y2 = offset2[1];
            } else {
                if (ToolOffset2D.getIntersect(intersect, figurePrev, figure, offset1Prev, offset1)) {
                    x1 = intersect[0];
                    y1 = intersect[1];
                } else {
                    x1 = offset1[0];
                    y1 = offset1[1];
                }
                if (ToolOffset2D.getIntersect(intersect, figurePrev, figure, offset2Prev, offset2)) {
                    x2 = intersect[0];
                    y2 = intersect[1];
                } else {
                    x2 = offset2[0];
                    y2 = offset2[1];
                }
                if (cnt == 0) {
                    x1First = x1;
                    y1First = y1;
                    x2First = x2;
                    y2First = y2;
                }
            }
            if (cnt > 0) {
                if (IFigureType.isLine(figurePrev.getType())) {
                    param1 = ToolGeom2D.getParameter(x1Prev, y1Prev, offset1Prev[0], offset1Prev[1], offset1Prev[2], offset1Prev[3]);
                    param2 = ToolGeom2D.getParameter(x1, y1, offset1Prev[0], offset1Prev[1], offset1Prev[2], offset1Prev[3]);
                    param3 = ToolGeom2D.getParameter(x2Prev, y2Prev, offset2Prev[0], offset2Prev[1], offset2Prev[2], offset2Prev[3]);
                    param4 = ToolGeom2D.getParameter(x2, y2, offset2Prev[0], offset2Prev[1], offset2Prev[2], offset2Prev[3]);
                } else if (IFigureType.isArc(figurePrev.getType())) {
                    IFigure2DArc arc = (IFigure2DArc)figurePrev;
                    param1 = ToolGeom2D.getParameter(x1Prev, y1Prev, offset1Prev[0], offset1Prev[1], offset1Prev[2], offset1Prev[3], arc.getCX(), arc.getCY(), arc.getRadius(), arc.isCw());
                    param2 = ToolGeom2D.getParameter(x1, y1, offset1Prev[0], offset1Prev[1], offset1Prev[2], offset1Prev[3], arc.getCX(), arc.getCY(), arc.getRadius(), arc.isCw());
                    param3 = ToolGeom2D.getParameter(x2Prev, y2Prev, offset2Prev[0], offset2Prev[1], offset2Prev[2], offset2Prev[3], arc.getCX(), arc.getCY(), arc.getRadius(), arc.isCw());
                    param4 = ToolGeom2D.getParameter(x2, y2, offset2Prev[0], offset2Prev[1], offset2Prev[2], offset2Prev[3], arc.getCX(), arc.getCY(), arc.getRadius(), arc.isCw());
                } else {
                    return false;
                }
                boolean b1 = false;
                boolean b2 = false;
                if (param1 > param2) {
                    x = x1Prev;
                    x1Prev = x1;
                    x1 = x;
                    y = y1Prev;
                    y1Prev = y1;
                    y1 = y;
                    b1 = true;
                }
                if (param3 > param4) {
                    x = x2Prev;
                    x2Prev = x2;
                    x2 = x;
                    y = y2Prev;
                    y2Prev = y2;
                    y2 = y;
                    b2 = true;
                }
                ToolOffset2D.makeOnePolygonWithExtension(collectionOut, figure, x1Prev, y1Prev, x1, y1, offset1[4], x2Prev, y2Prev, x2, y2, offset2[4], cw);
                if (b1) {
                    x = x1Prev;
                    x1Prev = x1;
                    x1 = x;
                    y = y1Prev;
                    y1Prev = y1;
                    y1 = y;
                }
                if (b2) {
                    x = x2Prev;
                    x2Prev = x2;
                    x2 = x;
                    y = y2Prev;
                    y2Prev = y2;
                    y2 = y;
                }
            }
            x1Prev = x1;
            y1Prev = y1;
            x2Prev = x2;
            y2Prev = y2;
            double[] swap = offset1;
            offset1 = offset1Prev;
            offset1Prev = swap;
            swap = offset2;
            offset2 = offset2Prev;
            offset2Prev = swap;
            figurePrev = figure;
            figure = ToolGeomFigure2D.getNext(figure);
            ++cnt;
        }
        if (bClosed) {
            x1 = x1First;
            y1 = y1First;
            x2 = x2First;
            y2 = y2First;
            if (IFigureType.isLine(figurePrev.getType())) {
                param1 = ToolGeom2D.getParameter(x1Prev, y1Prev, offset1Prev[0], offset1Prev[1], offset1Prev[2], offset1Prev[3]);
                param2 = ToolGeom2D.getParameter(x1, y1, offset1Prev[0], offset1Prev[1], offset1Prev[2], offset1Prev[3]);
                param3 = ToolGeom2D.getParameter(x2Prev, y2Prev, offset2Prev[0], offset2Prev[1], offset2Prev[2], offset2Prev[3]);
                param4 = ToolGeom2D.getParameter(x2, y2, offset2Prev[0], offset2Prev[1], offset2Prev[2], offset2Prev[3]);
            } else if (IFigureType.isArc(figurePrev.getType())) {
                IFigure2DArc arc = (IFigure2DArc)figurePrev;
                param1 = ToolGeom2D.getParameter(x1Prev, y1Prev, offset1Prev[0], offset1Prev[1], offset1Prev[2], offset1Prev[3], arc.getCX(), arc.getCY(), arc.getRadius(), arc.isCw());
                param2 = ToolGeom2D.getParameter(x1, y1, offset1Prev[0], offset1Prev[1], offset1Prev[2], offset1Prev[3], arc.getCX(), arc.getCY(), arc.getRadius(), arc.isCw());
                param3 = ToolGeom2D.getParameter(x2Prev, y2Prev, offset2Prev[0], offset2Prev[1], offset2Prev[2], offset2Prev[3], arc.getCX(), arc.getCY(), arc.getRadius(), arc.isCw());
                param4 = ToolGeom2D.getParameter(x2, y2, offset2Prev[0], offset2Prev[1], offset2Prev[2], offset2Prev[3], arc.getCX(), arc.getCY(), arc.getRadius(), arc.isCw());
            } else {
                return false;
            }
            if (param1 > param2) {
                x = x1Prev;
                x1Prev = x1;
                x1 = x;
                y = y1Prev;
                y1Prev = y1;
                y1 = y;
            }
            if (param3 > param4) {
                x = x2Prev;
                x2Prev = x2;
                x2 = x;
                y = y2Prev;
                y2Prev = y2;
                y2 = y;
            }
        } else {
            x1 = offset1Prev[2];
            y1 = offset1Prev[3];
            x2 = offset2Prev[2];
            y2 = offset2Prev[3];
        }
        ToolOffset2D.makeOnePolygonWithExtension(collectionOut, (IFigure2D)polylineIn.lastElement(), x1Prev, y1Prev, x1, y1, offset1[4], x2Prev, y2Prev, x2, y2, offset2[4], cw);
        return true;
    }

    static boolean getIntersect(double[] intersectPoint, IFigure2D figure1, IFigure2D figure2, double[] offset1, double[] offset2) throws AlgebraException {
        IFigure2DArc arc2 = null;
        int num = 0;
        if (IFigureType.isLine(figure1.getType()) && IFigureType.isLine(figure2.getType())) {
            return ToolGeom2D.getIntersectPointsExtension(intersectPoint, offset1[0], offset1[1], offset1[2], offset1[3], offset2[0], offset2[1], offset2[2], offset2[3]);
        }
        if (IFigureType.isLine(figure1.getType()) && IFigureType.isArc(figure2.getType())) {
            arc2 = (IFigure2DArc)figure2;
            num = ToolGeom2D.getIntersectPointsExtension(intersectPoint, offset1[0], offset1[1], offset1[2], offset1[3], arc2.getCX(), arc2.getCY(), offset2[4]);
        } else if (IFigureType.isArc(figure1.getType()) && IFigureType.isLine(figure2.getType())) {
            IFigure2DArc arc = (IFigure2DArc)figure1;
            num = ToolGeom2D.getIntersectPointsExtension(intersectPoint, offset2[0], offset2[1], offset2[2], offset2[3], arc.getCX(), arc.getCY(), offset1[4]);
        } else if (IFigureType.isArc(figure1.getType()) && IFigureType.isArc(figure2.getType())) {
            IFigure2DArc arc = (IFigure2DArc)figure1;
            arc2 = (IFigure2DArc)figure2;
            num = ToolGeom2D.getIntersectPointsExtension(intersectPoint, arc.getCX(), arc.getCY(), offset1[4], arc2.getCX(), arc2.getCY(), offset2[4]);
        } else {
            return false;
        }
        if (num == 2) {
            double parameter2;
            double parameter1;
            if (arc2 == null) {
                parameter1 = ToolGeom2D.getParameter(intersectPoint[0], intersectPoint[1], figure2.getX1(), figure2.getY1(), figure2.getX2(), figure2.getY2());
                parameter2 = ToolGeom2D.getParameter(intersectPoint[2], intersectPoint[3], figure2.getX1(), figure2.getY1(), figure2.getX2(), figure2.getY2());
            } else {
                parameter1 = ToolGeom2D.getParameter(intersectPoint[0], intersectPoint[1], arc2.getX1(), arc2.getY1(), arc2.getX2(), arc2.getY2(), arc2.getCX(), arc2.getCY(), arc2.getRadius(), arc2.isCw());
                parameter2 = ToolGeom2D.getParameter(intersectPoint[2], intersectPoint[3], arc2.getX1(), arc2.getY1(), arc2.getX2(), arc2.getY2(), arc2.getCX(), arc2.getCY(), arc2.getRadius(), arc2.isCw());
            }
            if (parameter1 > parameter2) {
                intersectPoint[0] = intersectPoint[2];
                intersectPoint[1] = intersectPoint[3];
            }
        }
        return true;
    }

    static boolean makeOnePolygonWithExtension(ICollectionEditable collectionOut, IFigure2D figure, double x1Prev, double y1Prev, double x1, double y1, double radius1, double x2Prev, double y2Prev, double x2, double y2, double radius2, boolean cw) {
        IFigure2DArc arcOut;
        IPolyline2D polylineOut = collectionOut.add();
        IFigure2DArc arc = null;
        if (!(polylineOut instanceof PolylineEditable)) {
            return false;
        }
        PolylineEditable pe = (PolylineEditable)((Object)polylineOut);
        if (IFigureType.isArc(figure.getType())) {
            arc = (IFigure2DArc)figure;
        }
        IFigure2D figureOut = pe.add(figure.getType());
        figureOut.setX1(x1Prev);
        figureOut.setY1(y1Prev);
        figureOut.setX2(x1);
        figureOut.setY2(y1);
        if (IFigureType.isArc(figure.getType())) {
            arcOut = (IFigure2DArc)figureOut;
            arcOut.setCX(arc.getCX());
            arcOut.setCY(arc.getCY());
            arcOut.setCw(arc.isCw());
            arcOut.setRadius(radius1);
        }
        figureOut = pe.add(1);
        figureOut.setX2(x2);
        figureOut.setY2(y2);
        figureOut = pe.add(IFigureType.getReverseType(figure.getType()));
        figureOut.setX2(x2Prev);
        figureOut.setY2(y2Prev);
        if (IFigureType.isArc(figure.getType())) {
            arcOut = (IFigure2DArc)figureOut;
            arcOut.setCX(arc.getCX());
            arcOut.setCY(arc.getCY());
            arcOut.setCw(arc.isCw());
            arcOut.setRadius(radius2);
        }
        figureOut = pe.add(1);
        figureOut.setX2(x1Prev);
        figureOut.setY2(y1Prev);
        int direction = ToolPlane2D.getDirection(polylineOut);
        pe.setRegion(cw ? (byte)1 : 2);
        return true;
    }
}

