/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.math.geom.logicaloperation.crossway;

import jp.kitec.math.geom.ToolGeom2D;
import jp.kitec.math.geom.ToolIntersectDirect2D;
import jp.kitec.math.geom.datapassing.IFigure2D;
import jp.kitec.math.geom.datapassing.IFigure2DArc;
import jp.kitec.math.geom.datapassing.IFigureType;
import jp.kitec.math.geom.datapassing.IPolyline2D;
import jp.kitec.math.geom.datapassing.ToolGeomFigure2D;
import jp.kitec.math.geom.logicaloperation.CrossPointChecker;
import jp.kitec.math.geom.logicaloperation.IntersectRegionSort;
import jp.kitec.math.geom.logicaloperation.OverlapDeterminater;
import jp.kitec.math.geom.logicaloperation.PolylineManager;

public class CrossWayDeterminater
extends OverlapDeterminater {
    private double[] point = new double[2];

    @Override
    public boolean determinate(IPolyline2D polyline, PolylineManager manager, IntersectRegionSort intersect1, IntersectRegionSort intersect2, boolean bClosed, boolean bFirst) {
        PolylineManager managerComp = null;
        boolean openLast = false;
        IntersectRegionSort intersect = intersect1;
        while (intersect != null) {
            if (intersect.crossStatus == 0) {
                byte prevSide = 0;
                openLast = false;
                IFigure2D figureBase = intersect.figure;
                IFigure2D figure1 = intersect.pair.figure;
                if (this.checkOverlap(figureBase, figure1, intersect.x, intersect.y)) {
                    intersect.sideToVersaFigures = (byte)3;
                } else {
                    boolean bEnd;
                    double parameter = intersect.pair.parameterOfFigure - (double)intersect.pair.figure.getIndex();
                    boolean bStart = CrossPointChecker.compareParameters(parameter, 0.0) == 0;
                    boolean bl = bEnd = CrossPointChecker.compareParameters(parameter, 1.0) == 0;
                    if (bStart || bEnd) {
                        IFigure2D figure2 = figure1;
                        IFigure2D iFigure2D = figure1 = figure2.getPrev() == null ? (IFigure2D)figure2.getParent().lastElement() : (IFigure2D)figure2.getPrev();
                        if (IFigureType.isArc(figureBase.getType())) {
                            IFigure2DArc arc = (IFigure2DArc)figureBase;
                            ToolGeom2D.getMidPoint(this.point, intersect.x, intersect.y, arc.getX2(), arc.getY2(), arc.getCX(), arc.getCY(), arc.getRadius(), arc.isCw());
                        }
                        if ((!bEnd && (bClosed || intersect.parameterOfFigure != (double)figureBase.getParent().size()) || ToolGeomFigure2D.checkPointOn(figureBase.getX1(), figureBase.getY1(), figure1)) && ToolGeomFigure2D.checkPointOn(figureBase.getX2(), figureBase.getY2(), figure1) && (IFigureType.isLine(figureBase.getType()) || ToolGeomFigure2D.checkPointOn(this.point[0], this.point[1], figure1))) {
                            intersect.sideToVersaFigures = (byte)3;
                        } else {
                            intersect.sideToVersaFigures = this.checkDirection(intersect, figure1, figure2, figureBase, bEnd, false);
                            if (bFirst && !bClosed) {
                                prevSide = this.checkDirection(intersect, figure1, figure2, figureBase, bEnd, true);
                            }
                        }
                    } else {
                        intersect.sideToVersaFigures = this.determinate(figureBase, figure1, intersect.x, intersect.y, false);
                        if (ToolGeom2D.equalPoints(figureBase.getX2(), figureBase.getY2(), intersect.x, intersect.y)) {
                            openLast = true;
                        }
                    }
                }
                if (intersect.sideToVersaFigures == 5) {
                    intersect.sideToVersaFigures = (byte)3;
                }
                managerComp = (PolylineManager)figure1.getParent().get(4096);
                if (prevSide != 0) {
                    intersect.crossPrevStatus = this.getStatus(prevSide, managerComp.getRegion());
                }
                intersect.crossStatus = this.getStatus(intersect.sideToVersaFigures, managerComp.getRegion());
                if (openLast) {
                    intersect.crossPrevStatus = intersect.crossStatus;
                    intersect.crossStatus = (byte)(intersect.crossStatus == 1 ? 2 : 0);
                }
            }
            intersect = intersect.samePointsNext;
        }
        return true;
    }

    byte getStatus(byte sideToVersaFigures, byte region) {
        int status = 0;
        switch (sideToVersaFigures) {
            case 1: {
                status = region != 0 ? (region == 1 ? 1 : 2) : 0;
                break;
            }
            case 2: {
                status = region != 0 ? (region == 2 ? 1 : 2) : 0;
                break;
            }
            case 3: {
                status = 3;
            }
        }
        return (byte)status;
    }

    private byte checkDirection(IntersectRegionSort intersect, IFigure2D figure1, IFigure2D figure2, IFigure2D figureBase, boolean bEnd, boolean bForeSide) {
        byte side2;
        int result = intersect.sideToVersaFigures;
        byte side1 = side2 = this.determinate(figureBase, figure1, intersect.x, intersect.y, bForeSide);
        if (figure1 != figure2) {
            side2 = this.determinate(figureBase, figure2, intersect.x, intersect.y, bForeSide);
        }
        byte side = this.determinate(figure2, figure1, intersect.x, intersect.y, false);
        switch (side) {
            case 1: {
                if (side1 == 5 || side2 == 5) {
                    result = 3;
                    break;
                }
                if (!(side1 != 1 && side1 != 6 || side2 != 1 && side2 != 6)) {
                    result = 1;
                    break;
                }
                result = 2;
                break;
            }
            case 2: {
                if (side1 == 5 || side2 == 5) {
                    result = 3;
                    break;
                }
                if (!(side1 != 2 && side1 != 6 || side2 != 2 && side2 != 6)) {
                    result = 2;
                    break;
                }
                result = 1;
                break;
            }
            case 0: 
            case 6: {
                if (side1 != 6) {
                    result = side1;
                    break;
                }
                if (side2 != 6) {
                    result = side2;
                    break;
                }
                result = 6;
                break;
            }
            case 5: {
                if (side1 != side2) break;
                result = side1;
            }
        }
        return (byte)result;
    }

    private byte determinate(IFigure2D figureOrg, IFigure2D figureComp, double x, double y, boolean bForeSide) {
        double ye;
        double xe;
        double ys;
        double xs;
        if (ToolGeom2D.equalPoints(figureOrg.getX2(), figureOrg.getY2(), x, y)) {
            xs = figureOrg.getX1();
            ys = figureOrg.getY1();
            xe = x;
            ye = y;
        } else if (bForeSide) {
            xs = figureOrg.getX1();
            ys = figureOrg.getY1();
            xe = x;
            ye = y;
        } else {
            xs = x;
            ys = y;
            xe = figureOrg.getX2();
            ye = figureOrg.getY2();
        }
        if (ToolGeom2D.equalPoints(xs, ys, xe, ye)) {
            return 0;
        }
        switch (figureComp.getType()) {
            case 1: {
                switch (figureOrg.getType()) {
                    case 1: {
                        return ToolIntersectDirect2D.getDirectionOfLineToLine(figureComp.getX1(), figureComp.getY1(), figureComp.getX2(), figureComp.getY2(), xs, ys, xe, ye);
                    }
                    case 2: 
                    case 3: {
                        IFigure2DArc arcOrg = (IFigure2DArc)figureOrg;
                        return ToolIntersectDirect2D.getDirectionOfArcToLine(figureComp.getX1(), figureComp.getY1(), figureComp.getX2(), figureComp.getY2(), xs, ys, xe, ye, arcOrg.getCX(), arcOrg.getCY(), arcOrg.getRadius(), arcOrg.isCw());
                    }
                }
                break;
            }
            case 2: 
            case 3: {
                IFigure2DArc arcComp = (IFigure2DArc)figureComp;
                switch (figureOrg.getType()) {
                    case 1: {
                        return ToolIntersectDirect2D.getDirectionOfLineToArc(arcComp.getX1(), arcComp.getY1(), arcComp.getX2(), arcComp.getY2(), arcComp.getCX(), arcComp.getCY(), arcComp.getRadius(), arcComp.isCw(), xs, ys, xe, ye);
                    }
                    case 2: 
                    case 3: {
                        IFigure2DArc arcOrg = (IFigure2DArc)figureOrg;
                        return ToolIntersectDirect2D.getDirectionOfArcToArc(arcComp.getX1(), arcComp.getY1(), arcComp.getX2(), arcComp.getY2(), arcComp.getCX(), arcComp.getCY(), arcComp.getRadius(), arcComp.isCw(), xs, ys, xe, ye, arcOrg.getCX(), arcOrg.getCY(), arcOrg.getRadius(), arcOrg.isCw());
                    }
                }
            }
        }
        return 0;
    }

    private boolean checkOverlap(IFigure2D figure1, IFigure2D figure2, double x, double y) {
        int p2;
        int p1;
        int n = ToolGeom2D.equalPoints(figure1.getX1(), figure1.getY1(), x, y) ? 1 : (p1 = ToolGeom2D.equalPoints(figure1.getX2(), figure1.getY2(), x, y) ? 2 : 0);
        int n2 = ToolGeom2D.equalPoints(figure2.getX1(), figure2.getY1(), x, y) ? 1 : (p2 = ToolGeom2D.equalPoints(figure2.getX2(), figure2.getY2(), x, y) ? 2 : 0);
        return p1 != 2 && ToolGeomFigure2D.checkPointOn(figure1.getX2(), figure1.getY2(), figure2);
    }
}

