/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.math.geom.logicaloperation;

import jp.kitec.math.geom.datapassing.IAdditData;
import jp.kitec.math.geom.datapassing.IPolyline2D;

public class HierarchyStructure
implements IAdditData {
    public static final int ELEMENTS = 10;
    private HierarchyStructure parent;
    private Object data;
    private Object[] children;
    private Object[] last;
    private int count;
    private int countLast;
    private int level;

    public HierarchyStructure(Object data) {
        this.data = data;
        this.clear();
    }

    public void clear() {
        this.parent = null;
        this.last = null;
        this.children = null;
        this.countLast = 0;
        this.count = 0;
        this.level = 0;
    }

    public void addChild(HierarchyStructure node) {
        if (this.children == null) {
            this.last = new Object[11];
            this.children = this.last;
            this.countLast = 0;
        } else if (this.countLast + 1 < 10) {
            this.last[10] = new Object[11];
            this.countLast = 0;
        }
        this.last[this.countLast++] = node;
        ++this.count;
        node.parent = this;
        node.adjustLevel();
    }

    public boolean contain(HierarchyStructure node) {
        Object[] current = this.children;
        int cnt = 0;
        while (cnt < this.count) {
            for (int i = 0; i < 10 && cnt < this.count; ++i, ++cnt) {
                if (current[i] != node) continue;
                return true;
            }
            current = (Object[])current[10];
        }
        return false;
    }

    public Object get() {
        return this.data;
    }

    public HierarchyStructure getParent() {
        return this.parent;
    }

    public HierarchyStructure getChild(int index) {
        Object[] current = this.children;
        int cnt = 0;
        while (cnt + 10 < index) {
            current = (Object[])current[10];
            cnt += 10;
        }
        return (HierarchyStructure)current[index - cnt];
    }

    public int getLevel() {
        return this.level;
    }

    public int size() {
        return this.count;
    }

    private void adjustLevel() {
        if (this.parent.level + 1 == this.level) {
            return;
        }
        this.level = this.parent.level + 1;
        Object[] current = this.children;
        int i = 0;
        while (i < this.count) {
            for (int j = 0; j < 10 && i < this.count; ++i, ++j) {
                HierarchyStructure hierarchy = (HierarchyStructure)current[j];
                hierarchy.adjustLevel();
            }
            current = (Object[])current[10];
        }
    }

    @Override
    public int getKey() {
        return 4098;
    }

    public static HierarchyStructure get(IPolyline2D polyline) {
        return (HierarchyStructure)polyline.get(4098);
    }
}

