/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.math.geom.logicaloperation;

import jp.kitec.math.geom.ToolGeom2D;
import jp.kitec.math.geom.datapassing.IFigure2D;
import jp.kitec.math.geom.datapassing.IPolyline2D;
import jp.kitec.math.geom.datapassing.plane.ToolPlane2D;
import jp.kitec.math.geom.logicaloperation.IntersectRegionSort;
import jp.kitec.math.geom.logicaloperation.PolylineManager;
import jp.kitec.math.searches.regiontree.RectangleSupplier;

public class CrossPolylineGroup {
    PolylineList first = null;
    PolylineList last = null;
    int count = 0;
    double x = 0.0;
    double y = 0.0;
    double[] rect = new double[4];
    int includedLevel = 0;
    int levelMax = 0;
    boolean innerRegionFound = false;
    boolean regionInside = true;
    IntersectRegionSort outerMostPoint;
    PolylineList iterator = null;

    public IPolyline2D getFirst() {
        if (this.first != null) {
            return this.first.manager.getPolyline();
        }
        return null;
    }

    public IPolyline2D iterFirst() {
        this.iterator = this.first;
        if (this.first != null) {
            return this.iterator.manager.getPolyline();
        }
        return null;
    }

    public IPolyline2D next() {
        if (this.iterator == null) {
            return null;
        }
        this.iterator = this.iterator.next;
        if (this.iterator != null) {
            return this.iterator.manager.getPolyline();
        }
        return null;
    }

    public void add(PolylineManager manager) {
        PolylineList list = new PolylineList();
        RectangleSupplier rs = manager.getPolyline() instanceof RectangleSupplier ? (RectangleSupplier)((Object)manager.getPolyline()) : null;
        list.manager = manager;
        if (this.first == null) {
            this.first = list;
            this.x = ((IFigure2D)manager.getPolyline().firstElement()).getX1();
            this.y = ((IFigure2D)manager.getPolyline().firstElement()).getY1();
            if (rs != null) {
                this.rect[0] = rs.getLeft();
                this.rect[1] = rs.getLower();
                this.rect[2] = rs.getRight();
                this.rect[3] = rs.getUpper();
            } else {
                ToolPlane2D.getFitRectangle(this.rect, manager.getPolyline());
            }
        } else if (rs != null) {
            ToolGeom2D.getFitRectangleOr(this.rect, this.rect[0], this.rect[1], this.rect[2], this.rect[3], rs.getLeft(), rs.getLower(), rs.getRight(), rs.getUpper());
        } else {
            double x1 = this.rect[0];
            double y1 = this.rect[1];
            double x2 = this.rect[2];
            double y2 = this.rect[3];
            ToolPlane2D.getFitRectangle(this.rect, manager.getPolyline());
            ToolGeom2D.getFitRectangleOr(this.rect, x1, y1, x2, y2, this.rect[0], this.rect[1], this.rect[2], this.rect[3]);
        }
        if (this.last != null) {
            this.last.next = list;
        }
        this.last = list;
        ++this.count;
    }

    public boolean search(IPolyline2D polyline) {
        PolylineList list = this.first;
        while (list != null) {
            if (list.manager.getPolyline() == polyline) {
                return true;
            }
            list = list.next;
        }
        return false;
    }

    public void addIncludedLevel(int addLevel) {
        this.includedLevel += addLevel;
    }

    public int getIncludedLevel() {
        return this.includedLevel;
    }

    public int getMaxLevel() {
        return this.levelMax;
    }

    public void setMaxLevel(int maxLevel) {
        this.levelMax = maxLevel;
    }

    public void integrate(CrossPolylineGroup group) {
        PolylineList tmp = group.first;
        while (tmp != null) {
            tmp.manager.setGroup(this);
            tmp = tmp.next;
        }
        this.last.next = group.first;
        this.last = group.last;
        this.count += group.count;
    }

    public IPolyline2D[] getAllPolyline() {
        IPolyline2D[] polylines = new IPolyline2D[this.count];
        int cnt = 0;
        PolylineList tmp = this.first;
        while (tmp != null) {
            polylines[cnt] = tmp.manager.getPolyline();
            tmp = tmp.next;
            ++cnt;
        }
        return polylines;
    }

    private class PolylineList {
        PolylineManager manager;
        PolylineList next;

        private PolylineList() {
        }
    }
}

