/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.math.geom.logicaloperation;

import java.util.Vector;
import jp.kitec.math.geom.ToolGeom2D;
import jp.kitec.math.geom.datapassing.IFigure2D;
import jp.kitec.math.geom.datapassing.IPolyline2D;
import jp.kitec.math.geom.datapassing.IPolyline2DCollection;
import jp.kitec.math.geom.datapassing.ToolGeomFigure2D;
import jp.kitec.math.geom.datapassing.polylines.ToolGeomPolyline2D;
import jp.kitec.math.geom.logicaloperation.IntersectRegionSort;
import jp.kitec.math.geom.logicaloperation.PolylineManager;

public abstract class CrossPointChecker {
    public static final int ERROR = -1;
    Vector vectorPolylines = new Vector(10, 10);
    Vector vectorFigures = new Vector(10, 10);
    public double[] intersect = new double[4];

    public boolean searchForEach(IPolyline2DCollection polylines) {
        double tolerance = 1.0E-7;
        for (int i = 0; i < polylines.size(); ++i) {
            IPolyline2D polyline = polylines.get(i);
            PolylineManager manager = (PolylineManager)polyline.get(4096);
            int j = 0;
            IFigure2D figure1 = (IFigure2D)polyline.firstElement();
            while (figure1 != null) {
                this.vectorFigures.clear();
                ToolGeomPolyline2D.search(this.vectorFigures, polyline, figure1, tolerance);
                for (int k = 0; k < this.vectorFigures.size(); ++k) {
                    IFigure2D figure2 = (IFigure2D)this.vectorFigures.get(k);
                    if (figure1 == figure2 || figure1.getIndex() >= figure2.getIndex()) continue;
                    int result = this.crossRect(polyline, polyline, figure1, figure2, manager, manager);
                    if (result == -1) {
                        return false;
                    }
                    if (result <= 0) continue;
                    this.putIntersectRegionSort(polyline, polyline, figure1, figure2, manager, manager, result);
                    manager.addGroup(manager);
                }
                figure1 = ToolGeomFigure2D.getNext(figure1);
                ++j;
            }
        }
        return true;
    }

    public boolean search(IPolyline2DCollection polylines) {
        double tolerance = 1.0E-7;
        for (int i = 0; i < polylines.size(); ++i) {
            IPolyline2D polyline1 = polylines.get(i);
            PolylineManager manager1 = (PolylineManager)polyline1.get(4096);
            this.vectorPolylines.clear();
            ToolGeomPolyline2D.search(this.vectorPolylines, polylines, polyline1, tolerance);
            for (int j = 0; j < this.vectorPolylines.size(); ++j) {
                IPolyline2D polyline2 = (IPolyline2D)this.vectorPolylines.get(j);
                if (polyline1 == polyline2 || polyline2.getIndex() < i) continue;
                PolylineManager manager2 = (PolylineManager)polyline2.get(4096);
                IFigure2D figure = (IFigure2D)polyline1.firstElement();
                while (figure != null) {
                    this.vectorFigures.clear();
                    ToolGeomPolyline2D.search(this.vectorFigures, polyline2, figure, tolerance);
                    for (int k = 0; k < this.vectorFigures.size(); ++k) {
                        int result = this.crossRect(polyline1, polyline2, figure, (IFigure2D)this.vectorFigures.get(k), manager1, manager2);
                        if (result == -1) {
                            return false;
                        }
                        if (result <= 0) continue;
                        this.putIntersectRegionSort(polyline1, polyline2, figure, (IFigure2D)this.vectorFigures.get(k), manager1, manager2, result);
                        manager1.addGroup(manager2);
                    }
                    figure = ToolGeomFigure2D.getNext(figure);
                }
            }
        }
        return true;
    }

    public boolean search(IPolyline2DCollection polylines1, IPolyline2DCollection polylines2) {
        for (int i = 0; i < polylines1.size(); ++i) {
            IPolyline2D polyline1 = polylines1.get(i);
            PolylineManager manager1 = (PolylineManager)polyline1.get(4096);
            this.vectorPolylines.clear();
            ToolGeomPolyline2D.search(this.vectorPolylines, polylines2, polyline1);
            for (int j = 0; j < this.vectorPolylines.size(); ++j) {
                IPolyline2D polyline2 = (IPolyline2D)this.vectorPolylines.get(j);
                PolylineManager manager2 = (PolylineManager)polyline2.get(4096);
                IFigure2D figure = (IFigure2D)polyline1.firstElement();
                while (figure != null) {
                    this.vectorFigures.clear();
                    ToolGeomPolyline2D.search(this.vectorFigures, polyline2, figure);
                    for (int k = 0; k < this.vectorFigures.size(); ++k) {
                        int result = this.crossRect(polyline1, polyline2, figure, (IFigure2D)this.vectorFigures.get(k), manager1, manager2);
                        if (result == -1) {
                            return false;
                        }
                        if (result <= 0) continue;
                        this.putIntersectRegionSort(polyline1, polyline2, figure, (IFigure2D)this.vectorFigures.get(k), manager1, manager2, result);
                        manager1.addGroup(manager2);
                    }
                    figure = ToolGeomFigure2D.getNext(figure);
                }
            }
        }
        return true;
    }

    public abstract int crossRect(IPolyline2D var1, IPolyline2D var2, IFigure2D var3, IFigure2D var4, PolylineManager var5, PolylineManager var6);

    private boolean putIntersectRegionSort(IPolyline2D polyline1, IPolyline2D polyline2, IFigure2D figure1, IFigure2D figure2, PolylineManager manager1, PolylineManager manager2, int intersectCount) {
        for (int i = 0; i < intersectCount; ++i) {
            IntersectRegionSort node2;
            double x = this.intersect[i * 2];
            double y = this.intersect[i * 2 + 1];
            double parameter1 = ToolGeomFigure2D.getParameter(x, y, figure1);
            double parameter2 = ToolGeomFigure2D.getParameter(x, y, figure2);
            IFigure2D figureTmp1 = CrossPointChecker.compareParameters(parameter1, 1.0) < 0 ? figure1 : ToolGeomFigure2D.getNext(figure1);
            IFigure2D figureTmp2 = CrossPointChecker.compareParameters(parameter2, 1.0) < 0 ? figure2 : ToolGeomFigure2D.getNext(figure2);
            boolean extreme1 = parameter1 == 0.0 || parameter1 == 1.0;
            boolean extreme2 = parameter2 == 0.0 || parameter2 == 1.0;
            parameter1 += figure1 != null ? (double)figure1.getIndex() : (double)(polyline1.size() - 1);
            parameter2 += figure2 != null ? (double)figure2.getIndex() : (double)(polyline2.size() - 1);
            if (figureTmp1 == null && ToolGeomPolyline2D.isClosed(figure1.getParent())) {
                figureTmp1 = (IFigure2D)figure1.getParent().firstElement();
                parameter1 = 0.0;
            }
            if (figureTmp2 == null && ToolGeomPolyline2D.isClosed(figure2.getParent())) {
                figureTmp2 = (IFigure2D)figure2.getParent().firstElement();
                parameter2 = 0.0;
            }
            if (polyline1 == polyline2 && parameter1 == parameter2) continue;
            IntersectRegionSort node1 = manager1.get(parameter1);
            if (node1 != null) {
                while (node1 != null && node1.pair.figure != figureTmp2) {
                    node1 = node1.samePointsNext;
                }
            }
            if (node1 == null) {
                node1 = manager1.add(figureTmp1 != null ? figureTmp1 : figure1, x, y, parameter1);
            }
            if ((node2 = manager2.get(parameter2)) != null) {
                while (node2 != null && node2.pair.figure != figureTmp1) {
                    node2 = node2.samePointsNext;
                }
            }
            if (node2 == null) {
                node2 = manager2.add(figureTmp2 != null ? figureTmp2 : figure2, x, y, parameter2);
            }
            node1.pair = node2;
            node2.pair = node1;
        }
        return true;
    }

    public static int compareParameters(double parameter1, double parameter2) {
        return ToolGeom2D.compare(parameter1, parameter2, 1.0E-10);
    }
}

