/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.math.geom.datapassing.polylines;

import java.util.Vector;
import jp.kitec.math.algebra.AlgebraException;
import jp.kitec.math.geom.ToolGeom2D;
import jp.kitec.math.geom.datapassing.ICollectionEditable;
import jp.kitec.math.geom.datapassing.IFigure2D;
import jp.kitec.math.geom.datapassing.IFigure2DArc;
import jp.kitec.math.geom.datapassing.IFigureType;
import jp.kitec.math.geom.datapassing.IPolyline2D;
import jp.kitec.math.geom.datapassing.IPolyline2DCollection;
import jp.kitec.math.geom.datapassing.PolylineEditable;
import jp.kitec.math.geom.datapassing.ToolGeomFigure2D;
import jp.kitec.math.geom.datapassing.complete.MPolylineCollection;
import jp.kitec.math.geom.datapassing.plane.IntersectSortedParameter;
import jp.kitec.math.geom.datapassing.plane.IntersectSortedParameters;
import jp.kitec.math.geom.datapassing.polylines.ToolGeomPolyline2D;

public class ToolHashPolylines {
    IntersectSortedParameters parameters = new IntersectSortedParameters();
    Vector vectorPolylines = new Vector(10, 10);
    Vector vectorFigures = new Vector(10, 10);
    double[] intersect = new double[10];

    public void process(ICollectionEditable collection) throws AlgebraException {
        MPolylineCollection collectionTmp = new MPolylineCollection();
        this.process(collectionTmp, (IPolyline2DCollection)((Object)collection), null);
        collection.clear();
        collection.addAll(collectionTmp);
    }

    public void process(ICollectionEditable collection1, IPolyline2DCollection collection2) throws AlgebraException {
        MPolylineCollection collectionTmp = new MPolylineCollection();
        this.process(collectionTmp, (IPolyline2DCollection)((Object)collection1), collection2);
        collection1.clear();
        collection1.addAll(collectionTmp);
    }

    public void process(ICollectionEditable collectionOut, IPolyline2DCollection collectionIn1, IPolyline2DCollection collectionIn2) throws AlgebraException {
        IPolyline2DCollection collectionComp = collectionIn2 != null ? collectionIn2 : collectionIn1;
        for (int i = 0; i < collectionIn1.size(); ++i) {
            IPolyline2D polyline1 = collectionIn1.get(i);
            this.parameters.clear();
            this.vectorPolylines.clear();
            ToolGeomPolyline2D.search(this.vectorPolylines, collectionIn2, polyline1);
            for (int j = 0; j < this.vectorPolylines.size(); ++j) {
                IPolyline2D polyline2 = (IPolyline2D)this.vectorPolylines.get(j);
                if (polyline1 == polyline2) continue;
                this.process(this.parameters, polyline1, polyline2);
            }
            this.createNewPolylines(collectionOut, this.parameters, polyline1);
        }
    }

    private void process(IntersectSortedParameters parametersIn, IPolyline2D polylineIn1, IPolyline2D polylineIn2) throws AlgebraException {
        for (IFigure2D figure1 = (IFigure2D)polylineIn1.firstElement(); figure1 != null; figure1 = (IFigure2D)figure1.getNext()) {
            this.vectorFigures.clear();
            ToolGeomPolyline2D.search(this.vectorFigures, polylineIn2, figure1);
            for (int k = 0; k < this.vectorFigures.size(); ++k) {
                IFigure2D figure2 = (IFigure2D)this.vectorFigures.get(k);
                int num = ToolGeomFigure2D.getIntersectPoints(this.intersect, figure1, figure2);
                for (int l = 0; l < num; ++l) {
                    parametersIn.add(figure1, figure2, null, this.intersect[l * 2], this.intersect[l * 2 + 1]);
                }
            }
        }
    }

    private void createNewPolylines(ICollectionEditable collectionOut, IntersectSortedParameters parametersIn, IPolyline2D polylineIn) {
        double tolerance = 1.0E-4;
        IFigure2D figure1 = (IFigure2D)polylineIn.firstElement();
        double x = polylineIn.getFirstX();
        double y = polylineIn.getFirstY();
        boolean bCheck = true;
        IntersectSortedParameter isp = parametersIn.getFirst();
        while (bCheck) {
            if (isp == null) {
                bCheck = false;
            }
            if (isp == null || !ToolGeom2D.equalPoints(x, y, isp.getX(), isp.getY())) {
                PolylineEditable pe = (PolylineEditable)((Object)collectionOut.add());
                do {
                    IFigure2D figure2 = pe.add(figure1.getType());
                    figure2.setX1(x);
                    figure2.setY1(y);
                    if (IFigureType.isArc(figure2.getType())) {
                        IFigure2DArc arc1 = (IFigure2DArc)figure1;
                        IFigure2DArc arc2 = (IFigure2DArc)figure2;
                        arc2.setCX(arc1.getCX());
                        arc2.setCY(arc1.getCY());
                        arc2.setRadius(arc1.getRadius());
                    }
                    if (isp == null || isp.getFigure() != figure1) {
                        x = figure1.getX2();
                        y = figure1.getY2();
                        figure1 = (IFigure2D)figure1.getNext();
                    } else {
                        x = isp.getX();
                        y = isp.getY();
                    }
                    figure2.setX2(x);
                    figure2.setY2(y);
                    double length = ToolGeomFigure2D.getLength(figure2);
                    if (!(length <= tolerance)) continue;
                    pe.remove(figure2);
                } while (isp == null && figure1 != null || isp != null && isp.getFigure() != figure1);
                IPolyline2D polyline = (IPolyline2D)((Object)pe);
                if (polyline.size() == 0) {
                    collectionOut.remove(polyline);
                }
            }
            isp = isp != null ? isp.getNext() : null;
        }
    }
}

