/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.math.geom.datapassing.contain;

import java.io.Serializable;
import java.util.Hashtable;
import jp.kitec.lib.geom.K2DPathFigure;
import jp.kitec.math.geom.ToolGeom2D;
import jp.kitec.math.geom.datapassing.IAdditData;
import jp.kitec.math.geom.datapassing.IFigure2D;
import jp.kitec.math.geom.datapassing.IFigure2DArc;
import jp.kitec.math.geom.datapassing.IFigure2DBase;
import jp.kitec.math.geom.datapassing.IPolyline2D;
import jp.kitec.math.searches.regiontree.RectangleSupplier;

public class MFigureCon
implements IFigure2D,
RectangleSupplier,
Serializable {
    private IPolyline2D parent;
    private IFigure2DBase figure;
    private IFigure2D prev;
    private IFigure2D next;
    private Hashtable hash;
    private double[] rect;
    private int index;

    public MFigureCon(IPolyline2D parent, int index) {
        this.parent = parent;
        this.figure = null;
        this.next = null;
        this.prev = null;
        this.hash = new Hashtable();
        this.rect = new double[4];
        this.rect[3] = 0.0;
        this.rect[2] = 0.0;
        this.rect[1] = 0.0;
        this.rect[0] = 0.0;
        this.index = index;
    }

    public int getType() {
        return this.figure.getType();
    }

    public int getReverseType() {
        switch (this.figure.getType()) {
            case 1: {
                return 1;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 5;
            }
            case 5: {
                return 4;
            }
        }
        return 0;
    }

    public double getX1() {
        return this.figure.getX1();
    }

    public double getY1() {
        return this.figure.getY1();
    }

    public double getX2() {
        return this.figure.getX2();
    }

    public double getY2() {
        return this.figure.getY2();
    }

    public void setX1(double x) {
        this.figure.setX1(x);
    }

    public void setY1(double y) {
        this.figure.setY1(y);
    }

    public void setX2(double x) {
        this.figure.setX2(x);
    }

    public void setY2(double y) {
        this.figure.setY2(y);
    }

    @Override
    public IPolyline2D getParent() {
        return this.parent;
    }

    public K2DPathFigure getPrev() {
        return this.prev;
    }

    public K2DPathFigure getNext() {
        return this.next;
    }

    public void setRect() {
        ToolGeom2D.getFitRectangle(this.rect, this.getX1(), this.getY1(), this.getX2(), this.getY2());
    }

    public IFigure2DBase getOriginalFigure() {
        return this.figure;
    }

    public void setOriginalFigure(IFigure2DBase base) {
        this.figure = base;
        IFigure2DArc arc = null;
        switch (base.getType()) {
            case 1: {
                ToolGeom2D.getFitRectangle(this.rect, base.getX1(), base.getY1(), base.getX2(), base.getY2());
                break;
            }
            case 2: {
                arc = (IFigure2DArc)this.figure;
                ToolGeom2D.getFitRectangle(this.rect, arc.getX1(), arc.getY1(), arc.getX2(), arc.getY2(), arc.getCX(), arc.getCY(), arc.getRadius(), true);
                break;
            }
            case 3: {
                arc = (IFigure2DArc)this.figure;
                ToolGeom2D.getFitRectangle(this.rect, arc.getX1(), arc.getY1(), arc.getX2(), arc.getY2(), arc.getCX(), arc.getCY(), arc.getRadius(), false);
            }
        }
    }

    void setPrev(IFigure2D figure) {
        this.prev = figure;
    }

    void setNext(IFigure2D figure) {
        this.next = figure;
    }

    @Override
    public double getLeft() {
        return this.rect[0];
    }

    @Override
    public double getRight() {
        return this.rect[2];
    }

    @Override
    public double getLower() {
        return this.rect[1];
    }

    @Override
    public double getUpper() {
        return this.rect[3];
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public IAdditData get(int key) {
        return (IAdditData)this.hash.get(Integer.toString(key));
    }

    @Override
    public IAdditData put(IAdditData value) {
        return this.hash.put(Integer.toString(value.getKey()), value);
    }
}

