/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.math.geom.datapassing.complete;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import jp.kitec.math.geom.datapassing.ICollectionEditable;
import jp.kitec.math.geom.datapassing.IPolyline2D;
import jp.kitec.math.geom.datapassing.IPolyline2DCollection;
import jp.kitec.math.geom.datapassing.ISearchable;
import jp.kitec.math.geom.datapassing.PolylineEditable;
import jp.kitec.math.geom.datapassing.complete.MPolyline;
import jp.kitec.math.searches.regiontree.RectangleSupplier;
import jp.kitec.math.searches.regiontree.RegionTree;
import jp.kitec.math.searches.regiontree.RegionTreeBuilder;

public class MPolylineCollection
implements IPolyline2DCollection,
ICollectionEditable,
ISearchable,
Serializable {
    private Vector vectorPolylines = new Vector(10, 10);
    private Hashtable hash = new Hashtable();
    private RegionTree tree = null;
    private double[] rect = new double[4];
    private boolean bChanged = false;

    public MPolylineCollection() {
    }

    public MPolylineCollection(MPolylineCollection base) {
        this();
        this.addAll(base);
    }

    @Override
    public boolean addAll(IPolyline2DCollection base) {
        for (int i = 0; i < base.size(); ++i) {
            IPolyline2D polyline = base.get(i);
            IPolyline2D polylineNew = this.add();
            if (!(polylineNew instanceof PolylineEditable)) {
                return false;
            }
            PolylineEditable pe = (PolylineEditable)((Object)polylineNew);
            pe.addAll(polyline);
        }
        this.setChangedFlag();
        return true;
    }

    @Override
    public IPolyline2D add(IPolyline2D polylineBase) {
        if (!(polylineBase instanceof PolylineEditable)) {
            return null;
        }
        this.vectorPolylines.add(polylineBase);
        PolylineEditable pe = (PolylineEditable)((Object)polylineBase);
        pe.setParent(this);
        this.setChangedFlag();
        return polylineBase;
    }

    @Override
    public boolean remove(IPolyline2D polyline) {
        if (!(polyline instanceof PolylineEditable)) {
            return false;
        }
        this.vectorPolylines.remove(polyline);
        PolylineEditable pe = (PolylineEditable)((Object)polyline);
        pe.setParent(null);
        this.setChangedFlag();
        return true;
    }

    @Override
    public void clear() {
        this.vectorPolylines.clear();
        this.hash.clear();
        this.tree = null;
        this.bChanged = false;
    }

    @Override
    public IPolyline2D get(int index) {
        if (index < this.vectorPolylines.size()) {
            return (IPolyline2D)this.vectorPolylines.get(index);
        }
        return null;
    }

    @Override
    public int size() {
        return this.vectorPolylines.size();
    }

    @Override
    public IPolyline2D add() {
        MPolyline polyline = new MPolyline(this, this.vectorPolylines.size());
        this.vectorPolylines.add(polyline);
        this.tree = null;
        return polyline;
    }

    @Override
    public void makeTree(RegionTreeBuilder builder) {
        if (!this.bChanged) {
            return;
        }
        RegionTreeBuilder builderPolyline = new RegionTreeBuilder();
        for (int i = 0; i < this.size(); ++i) {
            MPolyline polyline = (MPolyline)this.get(i);
            polyline.makeTree(builderPolyline);
            builder.addNodes(polyline);
            if (i == 0) {
                this.rect[0] = polyline.getLeft();
                this.rect[1] = polyline.getLower();
                this.rect[2] = polyline.getRight();
                this.rect[3] = polyline.getUpper();
                continue;
            }
            this.rect[0] = polyline.getLeft() < this.rect[0] ? polyline.getLeft() : this.rect[0];
            this.rect[1] = polyline.getLower() < this.rect[1] ? polyline.getLower() : this.rect[1];
            this.rect[2] = polyline.getRight() > this.rect[2] ? polyline.getRight() : this.rect[2];
            this.rect[3] = polyline.getUpper() > this.rect[3] ? polyline.getUpper() : this.rect[3];
        }
        if (this.tree == null) {
            this.tree = new RegionTree();
        }
        builder.build(this.tree);
        this.bChanged = false;
    }

    @Override
    public int search(List<RectangleSupplier> result, double left, double lower, double right, double upper) {
        if (this.tree == null || this.bChanged) {
            this.makeTree(new RegionTreeBuilder());
        }
        if (this.tree != null) {
            return this.tree.search(result, left, lower, right, upper);
        }
        return 0;
    }

    void setChangedFlag() {
        this.bChanged = true;
    }

    @Override
    public double getLeft() {
        if (this.bChanged) {
            this.makeTree(new RegionTreeBuilder());
        }
        return this.rect[0];
    }

    @Override
    public double getRight() {
        if (this.bChanged) {
            this.makeTree(new RegionTreeBuilder());
        }
        return this.rect[2];
    }

    @Override
    public double getLower() {
        if (this.bChanged) {
            this.makeTree(new RegionTreeBuilder());
        }
        return this.rect[1];
    }

    @Override
    public double getUpper() {
        if (this.bChanged) {
            this.makeTree(new RegionTreeBuilder());
        }
        return this.rect[3];
    }
}

