/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.math.algebra;

public class ToolAlgebra1D {
    private static double TOLERANCE_1 = 1.0E-10;
    private double A = 0.0;
    private double B = 0.0;
    private double C = 0.0;
    private double D = 0.0;
    private double E = 0.0;
    private double[] answer;
    double[] __GetSolutionOfQuarticEquation_dpTmp = new double[4];
    double[] __GetSolutionOfQuarticEquation_dpTmp1 = new double[4];
    double[] __GetSolutionOfQuarticEquation_dpTmp2 = new double[4];

    public ToolAlgebra1D(double a, double b) {
        this();
        this.set(a, b);
    }

    public ToolAlgebra1D(double a, double b, double c) {
        this();
        this.set(a, b, c);
    }

    public ToolAlgebra1D(double a, double b, double c, double d) {
        this();
        this.set(a, b, c, d);
    }

    public ToolAlgebra1D(double a, double b, double c, double d, double e) {
        this();
        this.set(a, b, c, d, e);
    }

    public ToolAlgebra1D() {
        this.answer = new double[4];
    }

    public void set(double a, double b) {
        this.A = 0.0;
        this.B = 0.0;
        this.C = 0.0;
        this.D = a;
        this.E = b;
    }

    public void set(double a, double b, double c) {
        this.A = 0.0;
        this.B = 0.0;
        this.C = a;
        this.D = b;
        this.E = c;
    }

    public void set(double a, double b, double c, double d) {
        this.A = 0.0;
        this.B = a;
        this.C = b;
        this.D = c;
        this.E = d;
    }

    public void set(double a, double b, double c, double d, double e) {
        this.A = a;
        this.B = b;
        this.C = c;
        this.D = d;
        this.E = e;
    }

    int compare(double x) {
        if (Math.abs(x) <= TOLERANCE_1) {
            return 0;
        }
        if (x < 0.0) {
            return -1;
        }
        return 1;
    }

    public int solve() {
        return this.solveQuarticEquation();
    }

    private int solveLinearEquation() {
        if (this.D == 0.0) {
            return 0;
        }
        this.answer[0] = -this.E / this.D;
        return 1;
    }

    private int solveQuadraticEquation() {
        return this.solveQuadraticEquation(this.answer, this.C, this.D, this.E);
    }

    private int solveQuadraticEquation(double[] dAnswer, double dC, double dD, double dE) {
        if (this.compare(dC) == 0) {
            return this.solveLinearEquation();
        }
        double d = dD * dD - 4.0 * dC * dE;
        if (Math.abs(d) <= 5.0E-14) {
            dAnswer[0] = -dD / (2.0 * dC);
            return 1;
        }
        if (d < 0.0) {
            return 0;
        }
        double r = Math.sqrt(d);
        dAnswer[0] = (-dD - r) / (2.0 * dC);
        dAnswer[1] = (-dD + r) / (2.0 * dC);
        return 2;
    }

    private int solveCubicEquation() {
        return this.solveCubicEquation(this.answer, this.B, this.C, this.D, this.E);
    }

    private int solveCubicEquation(double[] dAnswer, double dB, double dC, double dD, double dE) {
        if (this.compare(dB) == 0) {
            return this.solveQuadraticEquation();
        }
        double a = dC / dB;
        double b = dD / dB;
        double c = dE / dB;
        double q = (3.0 * b - a * a) / 9.0;
        double r = (9.0 * a * b - 27.0 * c - 2.0 * a * a * a) / 54.0;
        double d = q * q * q + r * r;
        double add = -0.3333333333333333 * a;
        if (d < 0.0) {
            double sqrQ = Math.sqrt(-q);
            double th = Math.acos(r / (sqrQ * sqrQ * sqrQ));
            dAnswer[0] = 2.0 * sqrQ * Math.cos(0.3333333333333333 * th) + add;
            dAnswer[1] = 2.0 * sqrQ * Math.cos(0.3333333333333333 * th + 2.0943951023931953) + add;
            dAnswer[2] = 2.0 * sqrQ * Math.cos(0.3333333333333333 * th + 4.1887902047863905) + add;
            return 3;
        }
        double sqrD = Math.sqrt(d);
        double s = r + sqrD > 0.0 ? Math.pow(r + sqrD, 0.3333333333333333) : -Math.pow(-(r + sqrD), 0.3333333333333333);
        double t = r - sqrD > 0.0 ? Math.pow(r - sqrD, 0.3333333333333333) : -Math.pow(-(r - sqrD), 0.3333333333333333);
        dAnswer[0] = s + t + add;
        if (d > 0.0) {
            return 1;
        }
        dAnswer[1] = dAnswer[2] = -(s + t) / 2.0 + add;
        return 2;
    }

    int solveQuarticEquation() {
        double[] dpTmp = this.__GetSolutionOfQuarticEquation_dpTmp;
        double[] dpTmp1 = this.__GetSolutionOfQuarticEquation_dpTmp1;
        double[] dpTmp2 = this.__GetSolutionOfQuarticEquation_dpTmp2;
        int iN = 0;
        int iN2 = 0;
        int iOut = 0;
        int iCnt = 0;
        if (this.compare(this.A) == 0) {
            return this.solveCubicEquation();
        }
        if (this.compare(this.E) == 0) {
            this.E = 0.0;
        }
        double dA2 = this.A * this.A;
        double dB2 = this.B * this.B;
        double dV = -this.B / (4.0 * this.A);
        double dP = -(3.0 * dB2) / (8.0 * dA2) + this.C / this.A;
        double dQ = dB2 * this.B / (8.0 * dA2 * this.A) - this.B * this.C / (2.0 * dA2) + this.D / this.A;
        double dR = -(3.0 * dB2 * dB2) / (256.0 * dA2 * dA2) + dB2 * this.C / (16.0 * dA2 * this.A) - this.B * this.D / (4.0 * dA2) + this.E / this.A;
        if (this.compare(dQ) == 0) {
            if (this.compare(dR) == 0) {
                if (this.compare(dP) >= 0) {
                    this.answer[0] = dV;
                    return 1;
                }
                this.answer[0] = Math.sqrt(-dP) + dV;
                this.answer[1] = -Math.sqrt(-dP) + dV;
                this.answer[2] = dV;
                return 3;
            }
            int iN0 = this.solveQuadraticEquation(dpTmp, 1.0, dP, dR);
            if (iN0 > 0 && this.compare(dpTmp[0]) > 0) {
                dpTmp1[iCnt++] = Math.sqrt(dpTmp[0]);
                dpTmp1[iCnt++] = -Math.sqrt(dpTmp[0]);
            }
            if (iN0 > 1 && this.compare(dpTmp[1]) > 0) {
                dpTmp1[iCnt++] = Math.sqrt(dpTmp[1]);
                dpTmp1[iCnt++] = -Math.sqrt(dpTmp[1]);
            }
            iN += iCnt;
        } else {
            int iNum = this.solveCubicEquation(dpTmp, 1.0, -dP, -4.0 * dR, 4.0 * dP * dR - dQ * dQ);
            if (iNum == 0) {
                return 0;
            }
            iCnt = 0;
            do {
                double dTmp;
                if ((dTmp = dpTmp[iCnt]) - dP <= 0.0) {
                    ++iCnt;
                    continue;
                }
                double dT = Math.sqrt(Math.abs(dTmp - dP));
                double dU = this.compare(dT) != 0 ? dQ / (2.0 * dT) : 0.0;
                iN = this.solveQuadraticEquation(dpTmp1, 1.0, -dT, dTmp / 2.0 + dU);
                iN2 = this.solveQuadraticEquation(dpTmp2, 1.0, dT, dTmp / 2.0 - dU);
                ++iCnt;
            } while (iCnt < iNum && iN == 0 && iN2 == 0);
        }
        iCnt = 0;
        while (iCnt < iN) {
            this.answer[iOut] = dpTmp1[iCnt] + dV;
            ++iCnt;
            ++iOut;
        }
        iCnt = 0;
        while (iCnt < iN2) {
            this.answer[iOut] = dpTmp2[iCnt] + dV;
            ++iCnt;
            ++iOut;
        }
        return iOut;
    }

    public double getSolution(int i) {
        return this.answer[i];
    }
}

