/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.math.searches.regiontree;

import java.util.List;
import jp.kitec.math.searches.regiontree.RectangleSupplier;
import jp.kitec.math.searches.regiontree.RegionTreeBuilder;
import jp.kitec.math.searches.regiontree.RegionTreeNode;
import jp.kitec.math.searches.regiontree.RegionTreeRestrictNode;

public class RegionTreeSearch {
    public void search(List<RectangleSupplier> vectorResult, RegionTreeNode[] allNodes, RegionTreeRestrictNode root, double left, double lower, double right, double upper) {
        this.search(vectorResult, allNodes, root, 0, left, lower, right, upper);
    }

    private void search(List<RectangleSupplier> vectorResult, RegionTreeNode[] allNodes, RegionTreeRestrictNode restrictNode, int depth, double left, double lower, double right, double upper) {
        double v2;
        double v1;
        boolean isX;
        boolean bl = isX = depth % 2 == 0;
        if (restrictNode == null) {
            return;
        }
        if (isX) {
            v1 = left;
            v2 = right;
        } else {
            v1 = lower;
            v2 = upper;
        }
        int checkV1 = RegionTreeBuilder.equals(v1, restrictNode.getValue());
        int checkV2 = RegionTreeBuilder.equals(restrictNode.getValue(), v2);
        if (checkV2 > 0) {
            for (int i = restrictNode.getLeftSortedNodesStart(); i < restrictNode.getLeftSortedNodesEnd(); ++i) {
                RegionTreeNode nodeTmp = allNodes[i];
                if (nodeTmp.getFlag() || nodeTmp.getPairNode().getFlag()) continue;
                double value = nodeTmp.getCompareValue(depth);
                int check1 = RegionTreeBuilder.equals(v1, v2);
                int check2 = RegionTreeBuilder.equals(value, v2);
                if (check1 != 0 && check2 < 0 || check1 == 0 && check2 <= 0) {
                    this.judge(vectorResult, nodeTmp, isX, left, lower, right, upper);
                    continue;
                }
                break;
            }
        } else if (checkV1 > 0) {
            for (int i = restrictNode.getRightSortedNodesStart(); i < restrictNode.getRightSortedNodesEnd(); ++i) {
                RegionTreeNode nodeTmp = allNodes[i];
                if (nodeTmp.getFlag() || nodeTmp.getPairNode().getFlag()) continue;
                double value = nodeTmp.getCompareValue(depth);
                int check1 = RegionTreeBuilder.equals(v1, v2);
                int check2 = RegionTreeBuilder.equals(v1, value);
                if (check1 != 0 && check2 < 0 || check1 == 0 && check2 <= 0) {
                    this.judge(vectorResult, nodeTmp, isX, left, lower, right, upper);
                    continue;
                }
                break;
            }
        } else if (checkV1 < 0 && checkV2 < 0) {
            for (int i = restrictNode.getLeftSortedNodesStart(); i < restrictNode.getLeftSortedNodesEnd(); ++i) {
                RegionTreeNode nodeTmp = allNodes[i];
                if (nodeTmp.getFlag() || nodeTmp.getPairNode().getFlag()) continue;
                this.judge(vectorResult, nodeTmp, isX, left, lower, right, upper);
            }
        } else if (checkV1 == 0) {
            for (int i = restrictNode.getRightSortedNodesStart(); i < restrictNode.getRightSortedNodesEnd(); ++i) {
                RegionTreeNode nodeTmp = allNodes[i];
                if (nodeTmp.getFlag() || nodeTmp.getPairNode().getFlag()) continue;
                this.judge(vectorResult, nodeTmp, isX, left, lower, right, upper);
            }
        } else if (checkV2 == 0) {
            for (int i = restrictNode.getLeftSortedNodesStart(); i < restrictNode.getLeftSortedNodesEnd(); ++i) {
                RegionTreeNode nodeTmp = allNodes[i];
                if (nodeTmp.getFlag() || nodeTmp.getPairNode().getFlag()) continue;
                this.judge(vectorResult, nodeTmp, isX, left, lower, right, upper);
            }
        }
        if (checkV1 < 0 && restrictNode.getLeft() != null) {
            this.search(vectorResult, allNodes, restrictNode.getLeft(), depth + 1, left, lower, right, upper);
        }
        if (checkV2 < 0 && restrictNode.getRight() != null) {
            this.search(vectorResult, allNodes, restrictNode.getRight(), depth + 1, left, lower, right, upper);
        }
    }

    private void judge(List<RectangleSupplier> vectorResult, RegionTreeNode node, boolean isX, double left, double lower, double right, double upper) {
        boolean check = false;
        if (isX) {
            int check1 = RegionTreeBuilder.equals(lower, node.getNode().getUpper());
            int check2 = RegionTreeBuilder.equals(node.getNode().getLower(), upper);
            check = check1 < 0 && check2 < 0 || (check1 == 0 || check2 == 0) && (lower == upper || node.getNode().getLower() == node.getNode().getUpper());
        } else {
            int check1 = RegionTreeBuilder.equals(left, node.getNode().getRight());
            int check2 = RegionTreeBuilder.equals(node.getNode().getLeft(), right);
            boolean bl = check = check1 < 0 && check2 < 0 || (check1 == 0 || check2 == 0) && (left == right || node.getNode().getLeft() == node.getNode().getRight());
        }
        if (check) {
            vectorResult.add(node.getNode());
            node.setFlag(true);
            node.getPairNode().setFlag(true);
        }
    }
}

