/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.math.searches.regiontree;

import java.util.Vector;
import jp.kitec.math.searches.NodeComparator;
import jp.kitec.math.searches.binarysort.BinarySort;
import jp.kitec.math.searches.binarysort.BinarySortBuilder;
import jp.kitec.math.searches.regiontree.RectangleSupplier;
import jp.kitec.math.searches.regiontree.RegionTree;
import jp.kitec.math.searches.regiontree.RegionTreeNode;
import jp.kitec.math.searches.regiontree.RegionTreeRestrictNode;

public class RegionTreeBuilder
implements NodeComparator<RegionTreeNode> {
    public static final double tolerance = 1.0E-10;
    Vector<RegionTreeNode> vectorAllNodes = new Vector(100, 100);
    Vector<RegionTreeRestrictNode> vectorAllRestrictNodes = new Vector(100, 100);
    Vector<Vector<RegionTreeNode>> vectorAllArray = new Vector(10, 10);
    Vector<Object> vectorAllSort = new Vector(100, 100);
    BinarySort<RegionTreeNode> sortLeft = new BinarySort<RegionTreeNode>(this, new BinarySortBuilder());
    BinarySort<RegionTreeNode> sortRight = new BinarySort<RegionTreeNode>(this, new BinarySortBuilder());
    BinarySort<RegionTreeNode> sortAll = new BinarySort<RegionTreeNode>(this, new BinarySortBuilder());
    int currentNode = 0;
    int currentRestrictNode = 0;
    int depth;
    boolean ascent;

    public void resetAllNodeFlags() {
        for (int i = 0; i < this.vectorAllNodes.size(); ++i) {
            RegionTreeNode node = this.vectorAllNodes.get(i);
            node.setFlag(false);
        }
    }

    public void clearNodes() {
        for (int i = 0; i < this.vectorAllArray.size(); ++i) {
            Vector<RegionTreeNode> vector = this.vectorAllArray.get(i);
            vector.clear();
        }
        this.currentNode = 0;
        this.vectorAllSort.clear();
        this.vectorAllNodes.clear();
        this.vectorAllRestrictNodes.clear();
    }

    private RegionTreeRestrictNode addRestrictNodes() {
        RegionTreeRestrictNode node = null;
        if (this.vectorAllRestrictNodes.size() <= this.currentRestrictNode) {
            node = new RegionTreeRestrictNode();
            this.vectorAllRestrictNodes.add(node);
        } else {
            node = this.vectorAllRestrictNodes.get(this.currentRestrictNode);
        }
        node.reset();
        ++this.currentRestrictNode;
        return node;
    }

    public void addNodes(RectangleSupplier supplier) {
        RegionTreeNode node1 = this.addNodes();
        RegionTreeNode node2 = this.addNodes();
        node1.set(supplier);
        node1.setLowerLeft(true);
        node1.setPairNode(node2);
        node2.set(supplier);
        node2.setLowerLeft(false);
        node2.setPairNode(node1);
    }

    private RegionTreeNode addNodes() {
        RegionTreeNode node = null;
        if (this.vectorAllNodes.size() <= this.currentNode) {
            node = new RegionTreeNode();
            this.vectorAllNodes.add(node);
        } else {
            node = this.vectorAllNodes.get(this.currentNode);
        }
        node.reset();
        ++this.currentNode;
        return node;
    }

    public RegionTreeNode getSortedNode(int index) {
        return (RegionTreeNode)this.vectorAllSort.get(index);
    }

    public void build(RegionTree tree) {
        tree.root = this.build();
        tree.allNodes = new RegionTreeNode[this.vectorAllSort.size()];
        for (int i = 0; i < tree.allNodes.length; ++i) {
            tree.allNodes[i] = (RegionTreeNode)this.vectorAllSort.get(i);
        }
        this.clearNodes();
    }

    private RegionTreeRestrictNode build() {
        return this.build(this.vectorAllNodes, 0, this.vectorAllNodes.size(), 0);
    }

    private synchronized RegionTreeRestrictNode build(Vector<RegionTreeNode> vectorNodes, int indexStart, int indexEnd, int depth) {
        double v1;
        RegionTreeNode node;
        Vector<RegionTreeNode> vectorSorted = null;
        if (depth < this.vectorAllArray.size()) {
            vectorSorted = this.vectorAllArray.get(depth);
        } else {
            vectorSorted = new Vector(100, 100);
            this.vectorAllArray.add(vectorSorted);
        }
        vectorSorted.clear();
        this.sortLeft.clearNodes();
        this.sortRight.clearNodes();
        this.sortAll.clearNodes();
        if (vectorNodes.size() <= 1 || indexStart >= indexEnd - 1) {
            return null;
        }
        this.depth = depth;
        this.ascent = true;
        for (int i = indexStart; i < indexEnd; ++i) {
            node = vectorNodes.get(i);
            v1 = node.getCompareValue(depth);
            this.sortAll.add(node);
        }
        this.sortAll.getAllNode(vectorSorted);
        int index = vectorSorted.size() / 2;
        node = vectorSorted.get(index);
        RegionTreeRestrictNode nodeNew = this.addRestrictNodes();
        nodeNew.setValue(node.getCompareValue(depth));
        for (int i = indexStart; i < indexEnd; ++i) {
            double v2;
            node = vectorNodes.get(i);
            v1 = node.isLowerLeft() ? node.getCompareValue(depth) : node.getPairNode().getCompareValue(depth);
            double d = v2 = !node.isLowerLeft() ? node.getCompareValue(depth) : node.getPairNode().getCompareValue(depth);
            if (node.getFlag() || node.getPairNode().getFlag() || RegionTreeBuilder.equals(v1, nodeNew.getValue()) > 0 || RegionTreeBuilder.equals(nodeNew.getValue(), v2) > 0) continue;
            this.ascent = true;
            this.sortLeft.add(node.isLowerLeft() ? node : node.getPairNode());
            this.ascent = false;
            this.sortRight.add(!node.isLowerLeft() ? node : node.getPairNode());
            node.setFlag(true);
            node.getPairNode().setFlag(true);
        }
        RegionTreeNode vs = this.sortLeft.getFirst();
        while (vs != null) {
            this.vectorAllSort.add(vs);
            node = vs;
            node.setFlag(false);
            vs = this.sortLeft.getNext();
        }
        nodeNew.setLeftSortedNodes(this.vectorAllSort.size() - this.sortLeft.getNodeCount(), this.vectorAllSort.size());
        vs = this.sortRight.getFirst();
        while (vs != null) {
            this.vectorAllSort.add(vs);
            node = vs;
            node.setFlag(false);
            vs = this.sortRight.getNext();
        }
        nodeNew.setRightSortedNodes(this.vectorAllSort.size() - this.sortRight.getNodeCount(), this.vectorAllSort.size());
        RegionTreeRestrictNode base = this.build(vectorSorted, 0, index, depth + 1);
        nodeNew.setLeft(base);
        base = this.build(vectorSorted, index + 1, vectorSorted.size(), depth + 1);
        nodeNew.setRight(base);
        return nodeNew;
    }

    static int equals(double v1, double v2) {
        if (Math.abs(v1 - v2) <= 1.0E-10) {
            return 0;
        }
        if (v1 < v2) {
            return -1;
        }
        return 1;
    }

    @Override
    public int compare(RegionTreeNode node1, RegionTreeNode node2) {
        double value2;
        double value1 = node1.getCompareValue(this.depth);
        if (value1 == (value2 = node2.getCompareValue(this.depth))) {
            return 0;
        }
        if (this.ascent && value1 < value2 || !this.ascent && value1 > value2) {
            return -1;
        }
        return 1;
    }

    @Override
    public int compare(RegionTreeNode node, double value) {
        double valueTmp = node.getCompareValue(this.depth);
        if (valueTmp == value) {
            return 0;
        }
        if (this.ascent && valueTmp < value || !this.ascent && valueTmp > value) {
            return -1;
        }
        return 1;
    }

    @Override
    public boolean addSameValue(RegionTreeNode object1, RegionTreeNode object2) {
        return false;
    }
}

