/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.math.searches.kdtree;

import java.util.List;
import jp.kitec.math.searches.kdtree.KdTreeBuilder;
import jp.kitec.math.searches.kdtree.KdTreeNode;
import jp.kitec.math.searches.kdtree.KdTreeRestrictNode;
import jp.kitec.math.searches.kdtree.PointSupplier;
import jp.kitec.math.searches.kdtree.TreeNodeBase;

public class KdTreeSearch {
    static final int EXCLUDE = 0;
    static final int OVERLAP = 1;
    static final int INCLUDE = 2;
    static final int ARRAY_NUMBER = 100;
    double[] dLeft = new double[100];
    double[] dLower = new double[100];
    double[] dRight = new double[100];
    double[] dUpper = new double[100];
    boolean[] bLeft = new boolean[100];
    boolean[] bLower = new boolean[100];
    boolean[] bRight = new boolean[100];
    boolean[] bUpper = new boolean[100];

    private void resetSearchRegion() {
        this.bUpper[0] = false;
        this.bRight[0] = false;
        this.bLower[0] = false;
        this.bLeft[0] = false;
    }

    public void search(List<? super PointSupplier> vectorResult, TreeNodeBase base, double left, double lower, double right, double upper) {
        this.resetSearchRegion();
        this.searchIncludePoints(vectorResult, base, 0, left, lower, right, upper);
    }

    private void searchIncludePoints(List<? super PointSupplier> vectorResult, TreeNodeBase base, int depth, double left, double lower, double right, double upper) {
        if (base.isLeafNode()) {
            KdTreeNode node = (KdTreeNode)base;
            int result = KdTreeBuilder.equals(left, node.getX());
            if (result >= 0) {
                return;
            }
            result = KdTreeBuilder.equals(node.getX(), right);
            if (result >= 0) {
                return;
            }
            result = KdTreeBuilder.equals(lower, node.getY());
            if (result >= 0) {
                return;
            }
            result = KdTreeBuilder.equals(node.getY(), upper);
            if (result >= 0) {
                return;
            }
            vectorResult.add(node.getNode());
            return;
        }
        KdTreeRestrictNode node = (KdTreeRestrictNode)base;
        int result = this.judge(node, depth, left, lower, right, upper, true);
        if (result == 2) {
            this.putAllNodes(vectorResult, node);
        } else if (result == 1) {
            this.searchIncludePoints(vectorResult, node.getLeft(), depth + 1, left, lower, right, upper);
        }
        result = this.judge(node, depth, left, lower, right, upper, false);
        if (result == 2) {
            this.putAllNodes(vectorResult, node);
        } else if (result == 1) {
            this.searchIncludePoints(vectorResult, node.getRight(), depth + 1, left, lower, right, upper);
        }
    }

    int judge(KdTreeRestrictNode node, int depth, double left, double lower, double right, double upper, boolean bLessRegion) {
        if (depth > 0) {
            this.dLeft[depth] = this.dLeft[depth - 1];
            this.dLower[depth] = this.dLower[depth - 1];
            this.dRight[depth] = this.dRight[depth - 1];
            this.dUpper[depth] = this.dUpper[depth - 1];
            this.bLeft[depth] = this.bLeft[depth - 1];
            this.bLower[depth] = this.bLower[depth - 1];
            this.bRight[depth] = this.bRight[depth - 1];
            this.bUpper[depth] = this.bUpper[depth - 1];
        }
        if (depth % 2 == 0) {
            if (bLessRegion) {
                this.dRight[depth] = node.getValue();
                this.bRight[depth] = true;
            } else {
                this.dLeft[depth] = node.getValue();
                this.bLeft[depth] = true;
            }
        } else if (bLessRegion) {
            this.dUpper[depth] = node.getValue();
            this.bUpper[depth] = true;
        } else {
            this.dLower[depth] = node.getValue();
            this.bLower[depth] = true;
        }
        if (this.bLeft[depth] && KdTreeBuilder.equals(right, this.dLeft[depth]) < 0 || this.bRight[depth] && KdTreeBuilder.equals(this.dRight[depth], left) < 0 || this.bLower[depth] && KdTreeBuilder.equals(upper, this.dLower[depth]) < 0 || this.bUpper[depth] && KdTreeBuilder.equals(this.dUpper[depth], lower) < 0) {
            return 0;
        }
        if (this.bLeft[depth] && this.bRight[depth] && this.bLower[depth] && this.bUpper[depth] && KdTreeBuilder.equals(left, this.dLeft[depth]) <= 0 && KdTreeBuilder.equals(this.dRight[depth], right) <= 0 && KdTreeBuilder.equals(lower, this.dLower[depth]) <= 0 && KdTreeBuilder.equals(this.dUpper[depth], upper) <= 0) {
            return 2;
        }
        return 1;
    }

    void putAllNodes(List<? super PointSupplier> vectorResult, TreeNodeBase base) {
        if (base.isLeafNode()) {
            KdTreeNode node = (KdTreeNode)base;
            vectorResult.add(node.getNode());
            return;
        }
        KdTreeRestrictNode node = (KdTreeRestrictNode)base;
        if (node.getLeft() != null) {
            this.putAllNodes(vectorResult, node.getLeft());
        }
        if (node.getRight() != null) {
            this.putAllNodes(vectorResult, node.getRight());
        }
    }
}

