/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.math.searches.kdtree;

import java.util.Vector;
import jp.kitec.math.searches.kdtree.KdTreeNode;
import jp.kitec.math.searches.kdtree.KdTreeRestrictNode;
import jp.kitec.math.searches.kdtree.TreeNodeBase;

public class KdTreeBuilder {
    public static final double tolerance = 1.0E-4;
    Vector<KdTreeNode> vectorAllNodes = new Vector(100, 100);
    Vector<KdTreeRestrictNode> vectorAllRegionNodes = new Vector(100, 100);
    Vector<Vector<KdTreeNode>> vectorAllArray = new Vector(10, 10);
    int currentNode = 0;
    int currentRegionNode = 0;

    public void clearNodes() {
        for (int i = 0; i < this.vectorAllArray.size(); ++i) {
            Vector<KdTreeNode> vector = this.vectorAllArray.get(i);
            vector.clear();
        }
        this.currentNode = 0;
    }

    public KdTreeRestrictNode addRegionNodes() {
        KdTreeRestrictNode node = null;
        if (this.vectorAllRegionNodes.size() <= this.currentRegionNode) {
            node = new KdTreeRestrictNode();
            this.vectorAllRegionNodes.add(node);
        } else {
            node = this.vectorAllRegionNodes.get(this.currentRegionNode);
        }
        node.reset();
        ++this.currentRegionNode;
        return node;
    }

    public KdTreeNode addNodes() {
        KdTreeNode node = null;
        if (this.vectorAllNodes.size() <= this.currentNode) {
            node = new KdTreeNode();
            this.vectorAllNodes.add(node);
        } else {
            node = this.vectorAllNodes.get(this.currentNode);
        }
        node.reset();
        ++this.currentNode;
        return node;
    }

    public TreeNodeBase build() {
        return this.build(this.vectorAllNodes, 0, this.vectorAllNodes.size(), 0);
    }

    private TreeNodeBase build(Vector<KdTreeNode> vectorNodes, int indexStart, int indexEnd, int depth) {
        Vector<KdTreeNode> vectorSorted = null;
        if (depth < this.vectorAllArray.size()) {
            vectorSorted = this.vectorAllArray.get(depth);
        } else {
            vectorSorted = new Vector(100, 100);
            this.vectorAllArray.add(vectorSorted);
        }
        vectorSorted.clear();
        if (vectorNodes.size() <= 1 || indexStart >= indexEnd - 1) {
            return vectorNodes.get(indexStart);
        }
        block0: for (int i = indexStart; i < indexEnd; ++i) {
            KdTreeNode node1 = vectorNodes.get(i);
            double v1 = this.getValue(node1, depth);
            for (int j = 0; j < vectorSorted.size(); ++j) {
                KdTreeNode node2 = vectorSorted.get(j);
                double v2 = this.getValue(node2, depth);
                if (KdTreeBuilder.equals(v1, v2) >= 0) continue;
                vectorSorted.add(j, node1);
                continue block0;
            }
            vectorSorted.add(node1);
        }
        int index = vectorSorted.size() / 2;
        KdTreeNode node = vectorSorted.get(index);
        KdTreeRestrictNode region = this.addRegionNodes();
        region.setValue(this.getValue(node, depth));
        TreeNodeBase base = this.build(vectorSorted, 0, index, depth + 1);
        region.setLeft(base);
        base = this.build(vectorSorted, index, vectorSorted.size(), depth + 1);
        region.setRight(base);
        return region;
    }

    private double getValue(KdTreeNode node, int depth) {
        return depth % 2 == 0 ? node.getNode().getX() : node.getNode().getY();
    }

    static int equals(double v1, double v2) {
        if (Math.abs(v1 - v2) <= 1.0E-4) {
            return 0;
        }
        if (v1 < v2) {
            return -1;
        }
        return 1;
    }
}

