/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.math.searches.cubicsearch;

import jp.kitec.math.searches.cubicsearch.APoint;
import jp.kitec.math.searches.cubicsearch.PointsSupplier;

public class CubicSearchNode {
    private float centerX;
    private float centerY;
    private float centerZ;
    private float radius;

    public CubicSearchNode(PointsSupplier supplier) {
        APoint point = null;
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        int count = 0;
        point = supplier.getFirst();
        while (point != null) {
            x += (double)point.x;
            y += (double)point.y;
            z += (double)point.z;
            point = supplier.getNext();
            ++count;
        }
        this.centerX = (float)(x / (double)count);
        this.centerY = (float)(y / (double)count);
        this.centerZ = (float)(z / (double)count);
        this.radius = 0.0f;
        point = supplier.getFirst();
        while (point != null) {
            x = point.x - this.centerX;
            y = point.y - this.centerY;
            z = point.z - this.centerZ;
            double r = Math.sqrt(x * x + y * y + z * z);
            if (r > (double)this.radius) {
                this.radius = (float)r;
            }
            point = supplier.getNext();
            ++count;
        }
    }

    public boolean isOverlap(CubicSearchNode node, float x, float y, float z) {
        float dx = this.centerX - x;
        float dy = this.centerY - y;
        float dz = this.centerZ - z;
        double dist1 = Math.sqrt(dx * dx + dy * dy + dz * dz);
        dx = node.centerX - x;
        dy = node.centerY - y;
        dz = node.centerZ - z;
        double dist2 = Math.sqrt(dx * dx + dy * dy + dz * dz);
        dx = this.centerX - node.centerX;
        dy = this.centerY - node.centerY;
        dz = this.centerZ - node.centerZ;
        double prod = this.centerX * node.centerX + this.centerY * node.centerY + this.centerZ * node.centerZ;
        double cos = prod / (dist1 * dist2);
        double dist = Math.sqrt(1.0 - cos * cos);
        if (cos < 0.0) {
            dist += 1.0;
        }
        return (double)this.radius / dist1 + (double)node.radius / dist2 > dist;
    }
}

