/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.math.searches.binarytree.bbtree;

import jp.kitec.math.searches.binarytree.bbtree.BBTree;
import jp.kitec.math.searches.binarytree.bbtree.BBTreeNode;

public class BBTreeIterator<T> {
    private static final int ELEM_SIZE = 30;
    protected BBTreeNode<T>[] tracer = new BBTreeNode[30];
    protected boolean[] tracerLeft = new boolean[30];
    protected int traceCount;

    public void set(BBTree<T> tree) {
        this.tracer[0] = tree.getRoot();
        this.tracerLeft[0] = false;
        this.init();
    }

    public void init() {
        this.traceCount = 0;
        this.mostLeft();
    }

    public T next() {
        if (this.traceCount < 0) {
            return null;
        }
        BBTreeNode<T> res = this.tracer[this.traceCount];
        if (this.tracer[this.traceCount].getRight() != null) {
            this.tracer[this.traceCount + 1] = (BBTreeNode)this.tracer[this.traceCount].getRight();
            this.tracerLeft[this.traceCount + 1] = false;
            ++this.traceCount;
            this.mostLeft();
        } else {
            do {
                --this.traceCount;
            } while (this.traceCount >= 0 && !this.tracerLeft[this.traceCount + 1]);
        }
        return res.get();
    }

    void mostLeft() {
        while (this.tracer[this.traceCount] != null) {
            this.tracer[this.traceCount + 1] = (BBTreeNode)this.tracer[this.traceCount].getLeft();
            this.tracerLeft[this.traceCount + 1] = true;
            ++this.traceCount;
        }
        --this.traceCount;
    }

    void mostRight() {
        while (this.tracer[this.traceCount] != null) {
            this.tracer[this.traceCount + 1] = (BBTreeNode)this.tracer[this.traceCount].getRight();
            this.tracerLeft[this.traceCount + 1] = false;
            ++this.traceCount;
        }
    }
}

