/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.math.searches.binarytree.bbtree;

import jp.kitec.math.searches.NodeComparator;
import jp.kitec.math.searches.binarytree.BinaryTree;
import jp.kitec.math.searches.binarytree.bbtree.BBTreeNode;

public class BBTree<T>
extends BinaryTree<T> {
    private static final int ELEM_SIZE = 30;
    protected BBTreeNode<T>[] tracer = new BBTreeNode[30];
    protected int traceCount = 0;
    protected int count = 0;

    public BBTree(NodeComparator<T> comparator) {
        super(comparator);
    }

    @Override
    public boolean search() {
        return false;
    }

    BBTreeNode<T> getRoot() {
        return (BBTreeNode)this.root;
    }

    protected BBTreeNode<T> searchNode(T obj) {
        this.traceCount = 0;
        this.tracer[this.traceCount++] = (BBTreeNode)this.root;
        while (this.tracer[this.traceCount] != null) {
            int cmp = this.comparator.compare(this.tracer[this.traceCount - 1].get(), obj);
            if (cmp == 0) {
                return this.tracer[this.traceCount - 1];
            }
            if (cmp < 0) {
                this.tracer[this.traceCount] = (BBTreeNode)this.tracer[this.traceCount - 1].getRight();
            } else if (cmp > 0) {
                this.tracer[this.traceCount] = (BBTreeNode)this.tracer[this.traceCount - 1].getLeft();
            }
            ++this.traceCount;
        }
        return this.tracer[this.traceCount - 1];
    }

    public void addNode(T obj) {
        BBTreeNode<T> nodeNew = new BBTreeNode<T>();
        nodeNew.set(obj);
        this.traceCount = 0;
        this.tracer[this.traceCount] = (BBTreeNode)this.root;
        while (this.tracer[this.traceCount] != null) {
            int cmp = this.comparator.compare(this.tracer[this.traceCount].get(), obj);
            if (cmp < 0) {
                if (this.tracer[this.traceCount].getRight() == null) {
                    this.tracer[this.traceCount++].setRight(nodeNew);
                    break;
                }
                this.tracer[this.traceCount + 1] = (BBTreeNode)this.tracer[this.traceCount].getRight();
            } else if (cmp > 0) {
                if (this.tracer[this.traceCount].getLeft() == null) {
                    this.tracer[this.traceCount++].setLeft(nodeNew);
                    break;
                }
                this.tracer[this.traceCount + 1] = (BBTreeNode)this.tracer[this.traceCount].getLeft();
            } else {
                this.comparator.addSameValue(this.tracer[this.traceCount].get(), obj);
                return;
            }
            ++this.traceCount;
        }
        if (this.traceCount == 0) {
            this.root = nodeNew;
        }
        this.tracer[this.traceCount] = nodeNew;
        ++this.count;
        this.balance(this.traceCount - 1);
    }

    public void remove(T obj) {
        byte rCount;
        BBTreeNode<T> node = this.searchNode(obj);
        byte lCount = ((BBTreeNode)node.getLeft()).getDepth();
        if (lCount - (rCount = ((BBTreeNode)node.getRight()).getDepth()) >= 2) {
            BBTreeNode nodeNext = (BBTreeNode)node.getRight();
            if (this.tracer[this.traceCount - 2].getLeft() == node) {
                this.tracer[this.traceCount - 2].setLeft(node.getLeft());
            } else {
                this.tracer[this.traceCount - 2].setRight(node.getLeft());
            }
            this.tracer[this.traceCount - 1] = (BBTreeNode)node.getLeft();
            while (this.tracer[this.traceCount - 1] != null) {
                this.tracer[this.traceCount] = (BBTreeNode)this.tracer[this.traceCount - 1].getRight();
                ++this.traceCount;
            }
            this.tracer[this.traceCount - 2].setRight(nodeNext);
            this.tracer[this.traceCount - 1] = nodeNext;
        } else {
            BBTreeNode nodeNext = (BBTreeNode)node.getLeft();
            if (this.tracer[this.traceCount - 2].getLeft() == node) {
                this.tracer[this.traceCount - 2].setLeft(node.getRight());
            } else {
                this.tracer[this.traceCount - 2].setRight(node.getRight());
            }
            this.tracer[this.traceCount - 1] = (BBTreeNode)node.getRight();
            while (this.tracer[this.traceCount - 1] != null) {
                this.tracer[this.traceCount] = (BBTreeNode)this.tracer[this.traceCount - 1].getLeft();
                ++this.traceCount;
            }
            this.tracer[this.traceCount - 2].setLeft(nodeNext);
            this.tracer[this.traceCount - 1] = nodeNext;
        }
        this.balance(this.traceCount - 1);
        --this.count;
    }

    protected boolean balance(int depth) {
        BBTreeNode a = null;
        BBTreeNode b = null;
        BBTreeNode c = null;
        boolean changed = false;
        for (int i = depth; i >= 0; --i) {
            int l = this.tracer[i].getLeft() != null ? ((BBTreeNode)this.tracer[i].getLeft()).getDepth() + 1 : 0;
            int r = this.tracer[i].getRight() != null ? ((BBTreeNode)this.tracer[i].getRight()).getDepth() + 1 : 0;
            this.tracer[i].setDepth((byte)Math.max(l, r));
            if (l - r >= 2) {
                a = this.tracer[i];
                b = (BBTreeNode)this.tracer[i].getLeft();
                if (b.getLeft() == null) {
                    c = (BBTreeNode)b.getLeft();
                    a.setLeft(c.getRight());
                    b.setRight(c.getLeft());
                    c.setLeft(b);
                    c.setRight(a);
                    if (i > 0) {
                        if (this.tracer[i - 1].getLeft() == this.tracer[i]) {
                            this.tracer[i - 1].setLeft(c);
                        } else {
                            this.tracer[i - 1].setRight(c);
                        }
                    } else {
                        this.root = c;
                    }
                } else {
                    if (i > 0) {
                        if (this.tracer[i - 1].getLeft() == this.tracer[i]) {
                            this.tracer[i - 1].setLeft(b);
                        } else {
                            this.tracer[i - 1].setRight(b);
                        }
                    } else {
                        this.root = b;
                    }
                    a.setLeft(b.getRight());
                    b.setRight(a);
                    c = null;
                }
                changed = true;
            } else {
                if (r - l < 2) continue;
                a = this.tracer[i];
                b = (BBTreeNode)this.tracer[i].getRight();
                if (b.getRight() == null) {
                    c = (BBTreeNode)b.getLeft();
                    a.setRight(c.getLeft());
                    b.setLeft(c.getRight());
                    c.setLeft(a);
                    c.setRight(b);
                    if (i > 0) {
                        if (this.tracer[i - 1].getLeft() == this.tracer[i]) {
                            this.tracer[i - 1].setLeft(c);
                        } else {
                            this.tracer[i - 1].setRight(c);
                        }
                    } else {
                        this.root = c;
                    }
                } else {
                    if (i > 0) {
                        if (this.tracer[i - 1].getLeft() == this.tracer[i]) {
                            this.tracer[i - 1].setLeft(b);
                        } else {
                            this.tracer[i - 1].setRight(b);
                        }
                    } else {
                        this.root = b;
                    }
                    a.setRight(b.getLeft());
                    b.setLeft(a);
                    c = null;
                }
                changed = true;
            }
            l = a.getLeft() != null ? ((BBTreeNode)a.getLeft()).getDepth() + 1 : 0;
            r = a.getRight() != null ? ((BBTreeNode)a.getRight()).getDepth() + 1 : 0;
            a.setDepth((byte)Math.max(l, r));
            l = b.getLeft() != null ? ((BBTreeNode)b.getLeft()).getDepth() + 1 : 0;
            r = b.getRight() != null ? ((BBTreeNode)b.getRight()).getDepth() + 1 : 0;
            b.setDepth((byte)Math.max(l, r));
            if (c == null) continue;
            l = c.getLeft() != null ? ((BBTreeNode)c.getLeft()).getDepth() + 1 : 0;
            r = c.getRight() != null ? ((BBTreeNode)c.getRight()).getDepth() + 1 : 0;
            c.setDepth((byte)Math.max(l, r));
        }
        return changed;
    }
}

