/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.math.searches.binarytree;

import java.util.Vector;
import jp.kitec.math.searches.binarytree.BinaryTreeNode;

public abstract class BinaryTreeBuilder<T> {
    protected Vector<BinaryTreeNode<T>> vectorAllNodes = new Vector(100, 100);
    protected int currentNode;
    private boolean ascent;

    public BinaryTreeBuilder() {
        this.reset();
        this.ascent = true;
    }

    public void reset() {
        this.currentNode = 0;
    }

    public BinaryTreeNode<T> addNode(T object) {
        BinaryTreeNode<T> nodeNew = null;
        if (this.currentNode < this.vectorAllNodes.size()) {
            nodeNew = this.vectorAllNodes.get(this.currentNode);
            nodeNew.reset();
            ++this.currentNode;
        } else {
            nodeNew = new BinaryTreeNode<T>();
            this.vectorAllNodes.add(nodeNew);
            ++this.currentNode;
        }
        nodeNew.set(object);
        return nodeNew;
    }

    public void setAscent(boolean ascent) {
        this.ascent = ascent;
    }

    public boolean getAscent() {
        return this.ascent;
    }

    public int getNodeCount() {
        return this.currentNode;
    }

    public abstract void build();

    public BinaryTreeNode<T> getNode(int index) {
        return this.vectorAllNodes.get(index);
    }
}

