/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.math.searches.binarysort;

import java.util.Collection;
import java.util.Vector;
import jp.kitec.math.searches.NodeComparator;
import jp.kitec.math.searches.binarysort.BinarySortBuilder;
import jp.kitec.math.searches.binarysort.BinarySortNode;
import jp.kitec.math.searches.binarytree.BinaryTree;
import jp.kitec.math.searches.binarytree.BinaryTreeNode;

public class BinarySort<T>
extends BinaryTree<T> {
    public static final int DIMENSION = 30;
    BinarySortBuilder<T> builder;
    BinaryTreeNode<T>[] searchNodes;
    BinaryTreeNode<T>[] tmpNodes;
    int searchNodesIndex;
    int tmpNodesIndex;
    int allNodes;

    public static void main(String[] arg) {
        BinarySort.Test1();
    }

    public static void Test1() {
        BinarySort<Test> sort = new BinarySort<Test>(new Comp());
        Test test = new Test(1.0);
        sort.add(test);
        test = new Test(2.0);
        sort.add(test);
        test = new Test(3.0);
        sort.add(test);
        Vector vector = new Vector(10, 10);
        sort.getAllNode(vector);
    }

    public BinarySort(NodeComparator<T> comparator, BinarySortBuilder<T> builder) {
        super(comparator);
        this.builder = builder;
        this.searchNodes = new BinaryTreeNode[30];
        this.tmpNodes = new BinaryTreeNode[30];
        this.searchNodesIndex = 0;
        this.tmpNodesIndex = 0;
        this.allNodes = 0;
    }

    public BinarySort(NodeComparator<T> comparator) {
        this(comparator, null);
    }

    @Override
    public void clearNodes() {
        super.clearNodes();
        if (this.builder != null) {
            this.builder.reset();
        }
        this.allNodes = 0;
    }

    public int getNodeCount() {
        return this.allNodes;
    }

    @Override
    public boolean search() {
        return false;
    }

    public BinaryTreeNode<T> search(double value) {
        BinarySortNode node = (BinarySortNode)this.root;
        int check = 0;
        while (node != null) {
            check = this.comparator.compare(node.get(), value);
            if (check == 0) {
                return node;
            }
            if (check > 0) {
                node = (BinarySortNode)node.getLeft();
                continue;
            }
            node = (BinarySortNode)node.getRight();
        }
        return node;
    }

    private T search(T obj) {
        int check = 0;
        this.tmpNodes[0] = this.root;
        this.tmpNodesIndex = 1;
        while (this.tmpNodes[this.tmpNodesIndex - 1] != null) {
            check = this.comparator.compare(this.tmpNodes[this.tmpNodesIndex - 1].get(), obj);
            if (check == 0) {
                return this.tmpNodes[this.tmpNodesIndex - 1].get();
            }
            this.tmpNodes[this.tmpNodesIndex] = check > 0 ? this.tmpNodes[this.tmpNodesIndex - 1].getLeft() : this.tmpNodes[this.tmpNodesIndex - 1].getRight();
            ++this.tmpNodesIndex;
        }
        return null;
    }

    public T getFirst() {
        BinaryTreeNode node;
        this.searchNodes[0] = node = this.root;
        this.searchNodesIndex = 1;
        while (node != null && node.getLeft() != null) {
            node = node.getLeft();
            this.searchNodes[this.searchNodesIndex] = node;
            ++this.searchNodesIndex;
        }
        if (node == null) {
            return null;
        }
        return node.get();
    }

    public T getNext() {
        if (this.searchNodesIndex <= 0 || this.searchNodes[this.searchNodesIndex - 1] == null) {
            return null;
        }
        if (this.searchNodes[this.searchNodesIndex - 1].getRight() != null) {
            this.searchNodes[this.searchNodesIndex] = this.searchNodes[this.searchNodesIndex - 1].getRight();
            ++this.searchNodesIndex;
            while (this.searchNodes[this.searchNodesIndex - 1] != null) {
                if (this.searchNodes[this.searchNodesIndex - 1].getLeft() == null) {
                    return this.searchNodes[this.searchNodesIndex - 1].get();
                }
                this.searchNodes[this.searchNodesIndex] = this.searchNodes[this.searchNodesIndex - 1].getLeft();
                ++this.searchNodesIndex;
            }
            return this.searchNodes[this.searchNodesIndex - 1].get();
        }
        --this.searchNodesIndex;
        while (this.searchNodesIndex > 0 && this.searchNodes[this.searchNodesIndex - 1] != null) {
            if (this.searchNodes[this.searchNodesIndex - 1].getLeft() == this.searchNodes[this.searchNodesIndex]) {
                return this.searchNodes[this.searchNodesIndex - 1].get();
            }
            --this.searchNodesIndex;
        }
        return null;
    }

    public T getPrev(T obj) {
        this.search(obj);
        if (this.tmpNodesIndex <= 0 || this.tmpNodes[this.tmpNodesIndex - 1] == null) {
            return null;
        }
        if (this.tmpNodes[this.tmpNodesIndex - 1].getLeft() != null) {
            this.tmpNodes[this.tmpNodesIndex] = this.tmpNodes[this.tmpNodesIndex - 1].getLeft();
            ++this.tmpNodesIndex;
            while (this.tmpNodes[this.tmpNodesIndex - 1] != null) {
                if (this.tmpNodes[this.tmpNodesIndex - 1].getRight() == null) {
                    return this.tmpNodes[this.tmpNodesIndex - 1].get();
                }
                this.tmpNodes[this.tmpNodesIndex] = this.tmpNodes[this.tmpNodesIndex - 1].getRight();
                ++this.tmpNodesIndex;
            }
            return this.tmpNodes[this.tmpNodesIndex - 1].get();
        }
        --this.tmpNodesIndex;
        while (this.tmpNodesIndex > 0 && this.tmpNodes[this.tmpNodesIndex - 1] != null) {
            if (this.tmpNodes[this.tmpNodesIndex - 1].getRight() == this.tmpNodes[this.tmpNodesIndex]) {
                return this.tmpNodes[this.tmpNodesIndex - 1].get();
            }
            --this.tmpNodesIndex;
        }
        return null;
    }

    public T getNext(T obj) {
        this.search(obj);
        if (this.tmpNodesIndex <= 0 || this.tmpNodes[this.tmpNodesIndex - 1] == null) {
            return null;
        }
        if (this.tmpNodes[this.tmpNodesIndex - 1].getRight() != null) {
            this.tmpNodes[this.tmpNodesIndex] = this.tmpNodes[this.tmpNodesIndex - 1].getRight();
            ++this.tmpNodesIndex;
            while (this.tmpNodes[this.tmpNodesIndex - 1] != null) {
                if (this.tmpNodes[this.tmpNodesIndex - 1].getLeft() == null) {
                    return this.tmpNodes[this.tmpNodesIndex - 1].get();
                }
                this.tmpNodes[this.tmpNodesIndex] = this.tmpNodes[this.tmpNodesIndex - 1].getLeft();
                ++this.tmpNodesIndex;
            }
            return this.tmpNodes[this.tmpNodesIndex - 1].get();
        }
        --this.tmpNodesIndex;
        while (this.tmpNodesIndex > 0 && this.tmpNodes[this.tmpNodesIndex - 1] != null) {
            if (this.tmpNodes[this.tmpNodesIndex - 1].getLeft() == this.tmpNodes[this.tmpNodesIndex]) {
                return this.tmpNodes[this.tmpNodesIndex - 1].get();
            }
            --this.tmpNodesIndex;
        }
        return null;
    }

    public void getAllNode(Collection<? super T> vector) {
        T node = this.getFirst();
        while (node != null) {
            vector.add(node);
            node = this.getNext();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void add(T object) {
        BinarySortNode node = (BinarySortNode)this.root;
        this.tmpNodes[0] = this.root;
        this.tmpNodesIndex = 1;
        if (this.root == null) {
            this.root = this.createNewNode(object);
            ++this.allNodes;
            return;
        }
        while (node != null) {
            block8: {
                Object objectTmp = node.get();
                int check = this.comparator.compare(objectTmp, object);
                if (check == 0 && this.comparator.addSameValue(objectTmp, object)) {
                    return;
                }
                if (check > 0) {
                    if (node.getLeft() != null) {
                        node = (BinarySortNode)node.getLeft();
                        break block8;
                    } else {
                        BinarySortNode<T> nodeNew = this.createNewNode(object);
                        node.setLeft(nodeNew);
                        break;
                    }
                }
                if (node.getRight() != null) {
                    node = (BinarySortNode)node.getRight();
                } else {
                    BinarySortNode<T> nodeNew = this.createNewNode(object);
                    node.setRight(nodeNew);
                    break;
                }
            }
            this.tmpNodes[this.tmpNodesIndex] = node;
            ++this.tmpNodesIndex;
        }
        ++this.allNodes;
        this.balance();
    }

    BinarySortNode<T> createNewNode(T object) {
        BinarySortNode<T> nodeNew;
        BinarySortNode<T> binarySortNode = nodeNew = this.builder != null ? (BinarySortNode<T>)this.builder.addNode(object) : null;
        if (nodeNew == null) {
            nodeNew = new BinarySortNode<T>();
            nodeNew.set(object);
        }
        return nodeNew;
    }

    private void balance() {
        while (this.tmpNodesIndex > 0) {
            BinarySortNode node;
            BinarySortNode nodeRight;
            int iRight;
            BinarySortNode nodeLeft = (BinarySortNode)this.tmpNodes[this.tmpNodesIndex - 1].getLeft();
            int iLeft = nodeLeft != null ? nodeLeft.getDepth() + 1 : 0;
            int deff = Math.abs(iLeft - (iRight = (nodeRight = (BinarySortNode)this.tmpNodes[this.tmpNodesIndex - 1].getRight()) != null ? nodeRight.getDepth() + 1 : 0));
            if (deff >= 2) {
                BinarySortNode nodeC;
                BinarySortNode nodeB;
                BinarySortNode nodeA;
                if (iRight > iLeft) {
                    nodeA = (BinarySortNode)this.tmpNodes[this.tmpNodesIndex - 1];
                    nodeB = (BinarySortNode)this.tmpNodes[this.tmpNodesIndex - 1].getRight();
                    nodeC = (BinarySortNode)nodeB.getLeft();
                    if (this.tmpNodesIndex > 1) {
                        if (this.tmpNodes[this.tmpNodesIndex - 2].getLeft() == this.tmpNodes[this.tmpNodesIndex - 1]) {
                            this.tmpNodes[this.tmpNodesIndex - 2].setLeft(nodeB);
                        } else {
                            this.tmpNodes[this.tmpNodesIndex - 2].setRight(nodeB);
                        }
                    } else {
                        this.root = nodeB;
                    }
                    nodeB.setLeft(nodeA);
                    nodeA.setRight(nodeC);
                } else {
                    nodeA = (BinarySortNode)this.tmpNodes[this.tmpNodesIndex - 1];
                    nodeB = (BinarySortNode)this.tmpNodes[this.tmpNodesIndex - 1].getLeft();
                    nodeC = (BinarySortNode)nodeB.getRight();
                    if (this.tmpNodesIndex > 1) {
                        if (this.tmpNodes[this.tmpNodesIndex - 2].getLeft() == this.tmpNodes[this.tmpNodesIndex - 1]) {
                            this.tmpNodes[this.tmpNodesIndex - 2].setLeft(nodeB);
                        } else {
                            this.tmpNodes[this.tmpNodesIndex - 2].setRight(nodeB);
                        }
                    } else {
                        this.root = nodeB;
                    }
                    nodeB.setRight(nodeA);
                    nodeA.setLeft(nodeC);
                }
                this.tmpNodes[this.tmpNodesIndex - 1] = nodeB;
                this.tmpNodes[this.tmpNodesIndex] = nodeA;
                nodeLeft = (BinarySortNode)this.tmpNodes[this.tmpNodesIndex].getLeft();
                nodeRight = (BinarySortNode)this.tmpNodes[this.tmpNodesIndex].getRight();
                iLeft = nodeLeft != null ? nodeLeft.getDepth() + 1 : 0;
                iRight = nodeRight != null ? nodeRight.getDepth() + 1 : 0;
                node = (BinarySortNode)this.tmpNodes[this.tmpNodesIndex];
                node.setDepth((byte)(iLeft > iRight ? iLeft : iRight));
                nodeLeft = (BinarySortNode)this.tmpNodes[this.tmpNodesIndex - 1].getLeft();
                nodeRight = (BinarySortNode)this.tmpNodes[this.tmpNodesIndex - 1].getRight();
                iLeft = nodeLeft != null ? nodeLeft.getDepth() + 1 : 0;
                iRight = nodeRight != null ? nodeRight.getDepth() + 1 : 0;
            }
            node = (BinarySortNode)this.tmpNodes[this.tmpNodesIndex - 1];
            node.setDepth((byte)(iLeft > iRight ? iLeft : iRight));
            --this.tmpNodesIndex;
        }
    }

    public static class Comp
    implements NodeComparator<Test> {
        @Override
        public synchronized int compare(Test obj1, Test obj2) {
            Test t1 = obj1;
            Test t2 = obj2;
            if (t1.value == t2.value) {
                return 0;
            }
            if (t1.value < t2.value) {
                return -1;
            }
            return 1;
        }

        @Override
        public synchronized int compare(Test obj, double value) {
            Test t = obj;
            if (t.value == value) {
                return 0;
            }
            if (t.value < value) {
                return -1;
            }
            return 1;
        }

        @Override
        public synchronized boolean addSameValue(Test object1, Test object2) {
            return false;
        }
    }

    public static class Test {
        public double value;

        public Test(double dIn) {
            this.value = dIn;
        }
    }
}

