/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.math.geom.logicaloperation;

import java.util.Vector;
import jp.kitec.math.geom.datapassing.IPolyline2D;
import jp.kitec.math.geom.datapassing.IPolyline2DCollection;
import jp.kitec.math.geom.datapassing.plane.ToolPlane2D;
import jp.kitec.math.geom.datapassing.polylines.ToolGeomPolyline2D;
import jp.kitec.math.geom.logicaloperation.CrossPointChecker;
import jp.kitec.math.geom.logicaloperation.CrossPolylineGroup;
import jp.kitec.math.geom.logicaloperation.InOutChecker;
import jp.kitec.math.geom.logicaloperation.InOutVertexTracking;
import jp.kitec.math.geom.logicaloperation.IntersectRegionSort;
import jp.kitec.math.geom.logicaloperation.OverlapDeterminater;
import jp.kitec.math.geom.logicaloperation.PolylineManager;
import jp.kitec.math.geom.logicaloperation.crossway.CrossWayDeterminater;
import jp.kitec.math.geom.logicaloperation.inoutdeterm.CrossChecker;
import jp.kitec.math.searches.binarysort.BinarySortBuilder;

public class ToolPlaneLogic {
    public static final int COMBINATION_ONE_GROUP = 1;
    public static final int COMBINATION_TWO_GROUP = 2;
    public static final int COMBINATION_SAME_GROUP = 3;
    public static final int COMBINATION_NONE = 4;
    public static final int COMBINATION_ALL = 5;
    CrossPointChecker crossPointChecker;
    BinarySortBuilder builder;
    OverlapDeterminater determinater;
    InOutChecker inoutChecker;
    Vector vectorPointTracer;
    Vector vectorDoubledPlane;
    Vector vectorDoubledSurface;

    public ToolPlaneLogic(CrossPointChecker crossPointChecker, OverlapDeterminater determinater, InOutChecker inoutChecker) {
        this.crossPointChecker = crossPointChecker;
        this.determinater = determinater;
        this.builder = new BinarySortBuilder();
        this.inoutChecker = inoutChecker;
        this.vectorPointTracer = new Vector(10, 10);
        this.vectorDoubledPlane = new Vector(10, 10);
        this.vectorDoubledSurface = new Vector(10, 10);
    }

    public ToolPlaneLogic() {
        this(new CrossChecker(), new CrossWayDeterminater(), new InOutVertexTracking());
    }

    public void clear() {
        this.builder.reset();
    }

    public void clear(IPolyline2DCollection collection) {
        for (int i = 0; i < collection.size(); ++i) {
            IPolyline2D polyline = collection.get(i);
            PolylineManager manager = (PolylineManager)polyline.get(4096);
            manager.reset();
        }
    }

    public boolean processForEach(IPolyline2DCollection collection) {
        this.preprocess(collection);
        if (!this.crossPointChecker.searchForEach(collection)) {
            return false;
        }
        if (!this.determinater.process(collection)) {
            return false;
        }
        if (!this.inoutChecker.process(collection)) {
            return false;
        }
        this.postprocess(collection);
        return true;
    }

    public boolean process(IPolyline2DCollection collection) {
        this.preprocess(collection);
        if (!this.crossPointChecker.search(collection)) {
            return false;
        }
        if (!this.determinater.process(collection)) {
            return false;
        }
        if (!this.inoutChecker.process(collection)) {
            return false;
        }
        this.postprocess(collection);
        return true;
    }

    public boolean process(IPolyline2DCollection collection1, IPolyline2DCollection collection2) {
        this.preprocess(collection1, collection2);
        if (!this.crossPointChecker.search(collection1)) {
            return false;
        }
        if (!this.crossPointChecker.search(collection1, collection2)) {
            return false;
        }
        if (!this.determinater.process(collection1)) {
            return false;
        }
        if (!this.determinater.process(collection2)) {
            return false;
        }
        if (!this.inoutChecker.process(collection1)) {
            return false;
        }
        if (!this.inoutChecker.process(collection2)) {
            return false;
        }
        if (!this.inoutChecker.process(collection1, collection2)) {
            return false;
        }
        if (!this.inoutChecker.process(collection2, collection1)) {
            return false;
        }
        this.postprocess(collection1, collection2);
        return true;
    }

    void preprocess(IPolyline2DCollection collection) {
        block6: for (int i = 0; i < collection.size(); ++i) {
            IPolyline2D polyline = collection.get(i);
            PolylineManager manager = (PolylineManager)polyline.get(4096);
            if (manager == null) {
                manager = new PolylineManager(this.builder, polyline);
                polyline.put(manager);
                int direction = ToolPlane2D.getDirection(polyline);
                manager.setCw(direction == 1);
                switch (polyline.getRegion()) {
                    case 3: {
                        manager.setRegion((byte)(direction != 0 ? (direction == 1 ? 1 : 2) : 0));
                        break;
                    }
                    case 4: {
                        manager.setRegion((byte)(direction != 0 ? (direction != 1 ? 1 : 2) : 0));
                        break;
                    }
                    case 1: {
                        manager.setRegion((byte)1);
                        break;
                    }
                    case 2: {
                        manager.setRegion((byte)2);
                        break;
                    }
                    default: {
                        if (!ToolGeomPolyline2D.isClosed(polyline)) continue block6;
                        manager.setRegion(direction == 1 ? (byte)1 : 2);
                        break;
                    }
                }
                continue;
            }
            byte region = manager.getRegion();
            manager.reset();
            manager.setCw(ToolPlane2D.getDirection(polyline) == 1);
            manager.setRegion(region);
        }
    }

    void preprocess(IPolyline2DCollection collection1, IPolyline2DCollection collection2) {
        this.preprocess(collection1);
        this.preprocess(collection2);
    }

    void postprocess(IPolyline2DCollection collection) {
        this.setPreviousStatus(collection);
        this.setTatchedSurfaceFlag(collection, false);
        this.setTemporaryIncludeLevel(collection, 1, false);
        this.levelIncludeLevel(collection, 1, false);
        this.addIncludeLevel(collection, false);
    }

    void postprocess(IPolyline2DCollection collection1, IPolyline2DCollection collection2) {
        this.setPreviousStatus(collection1);
        this.setPreviousStatus(collection2);
        this.setTatchedSurfaceFlag(collection1, false);
        this.setTatchedSurfaceFlag(collection2, false);
        this.setTemporaryIncludeLevel(collection1, 2, false);
        this.setTemporaryIncludeLevel(collection2, 4, false);
        this.levelIncludeLevel(collection1, 2, false);
        this.addIncludeLevel(collection1, false);
        this.addIncludeLevel(collection2, false);
    }

    boolean checkCombination(IPolyline2DCollection collection, IPolyline2D polyline1, IPolyline2D polyline2, int combination) {
        switch (combination) {
            case 4: {
                return false;
            }
            case 5: {
                return true;
            }
            case 3: {
                IPolyline2DCollection collection2 = polyline2.getParent();
                if (collection == collection2) {
                    int index2;
                    int index1 = polyline1.getIndex();
                    if (index1 < (index2 = polyline2.getIndex())) {
                        return true;
                    }
                    if (index1 == index2) {
                        return polyline1.hashCode() < polyline2.hashCode();
                    }
                    return false;
                }
                return false;
            }
            case 2: {
                IPolyline2DCollection collection2 = polyline2.getParent();
                if (collection != collection2) {
                    return true;
                }
            }
            case 1: {
                int index1 = polyline1.getIndex();
                int index2 = polyline2.getIndex();
                if (index1 < index2) {
                    return true;
                }
                if (index1 == index2) {
                    return polyline1.hashCode() < polyline2.hashCode();
                }
                return false;
            }
        }
        return false;
    }

    public static byte getCrossStatus(IPolyline2D polylineVersa, byte crossStatus, boolean absoluteLevel) {
        if (absoluteLevel) {
            return crossStatus;
        }
        if (polylineVersa.getRegion() == 4) {
            switch (crossStatus) {
                case 1: {
                    crossStatus = (byte)2;
                    break;
                }
                case 2: {
                    crossStatus = 1;
                }
            }
        }
        return crossStatus;
    }

    void setPreviousStatus(IPolyline2DCollection collection) {
        int Number2 = 1;
        block4: for (int i = 0; i < collection.size(); ++i) {
            IPolyline2D polyline = collection.get(i);
            PolylineManager manager = (PolylineManager)polyline.get(4096);
            if (manager.size() == 0) continue;
            boolean closed = ToolGeomPolyline2D.isClosed(polyline);
            this.vectorDoubledPlane.clear();
            this.vectorDoubledSurface.clear();
            int count = Number2;
            IntersectRegionSort intersect = manager.getFirst();
            while (true) {
                if (intersect == null) {
                    intersect = manager.getFirst();
                    if (count == 0) continue block4;
                    --count;
                }
                IntersectRegionSort intersectSame = intersect.samePointsRoot;
                while (intersectSame != null) {
                    IPolyline2D polylineVersa = intersectSame.pair.figure.getParent();
                    boolean found = false;
                    for (int j = 0; j < this.vectorDoubledPlane.size(); ++j) {
                        IntersectRegionSort intersectTmp = (IntersectRegionSort)this.vectorDoubledPlane.get(j);
                        if (intersectTmp.pair.figure.getParent() != polylineVersa) continue;
                        if (closed || count == Number2) {
                            intersectSame.crossPrevStatus = intersectTmp.crossStatus;
                        } else if (intersectSame.crossPrevStatus == 0) {
                            switch (intersectSame.crossStatus) {
                                case 1: {
                                    intersectSame.crossPrevStatus = (byte)2;
                                    break;
                                }
                                case 2: {
                                    intersectSame.crossPrevStatus = 1;
                                }
                            }
                        }
                        this.vectorDoubledPlane.set(j, intersectSame);
                        found = true;
                        break;
                    }
                    if (!found) {
                        this.vectorDoubledPlane.add(intersectSame);
                    }
                    intersectSame = intersectSame.samePointsNext;
                }
                intersect = manager.getNext(intersect);
            }
        }
    }

    void setTatchedSurfaceFlag(IPolyline2DCollection collection, boolean absoluteLevel) {
        int Number2 = 1;
        block0: for (int i = 0; i < collection.size(); ++i) {
            IPolyline2D polyline = collection.get(i);
            PolylineManager manager = (PolylineManager)polyline.get(4096);
            if (manager.size() == 0) continue;
            this.vectorDoubledSurface.clear();
            int count = Number2;
            IntersectRegionSort intersect = manager.getFirst();
            while (true) {
                if (intersect == null) {
                    if (count == 0 || this.vectorDoubledSurface.size() == 0) continue block0;
                    intersect = manager.getFirst();
                    --count;
                }
                IntersectRegionSort intersectSame = intersect.samePointsRoot;
                while (intersectSame != null) {
                    IPolyline2D polylineVersa = intersectSame.pair.figure.getParent();
                    byte status1 = intersectSame.crossPrevStatus;
                    byte status2 = intersectSame.crossStatus;
                    byte statusVersa1 = intersectSame.pair.crossPrevStatus;
                    byte statusVersa2 = intersectSame.pair.crossStatus;
                    if (status1 == 3 && status2 != 3) {
                        for (int j = 0; j < this.vectorDoubledSurface.size(); ++j) {
                            IntersectRegionSort intersectTmp = (IntersectRegionSort)this.vectorDoubledSurface.get(j);
                            if (intersectTmp.pair.figure.getParent() != polylineVersa) continue;
                            while (intersectTmp != intersectSame.samePointsRoot) {
                                intersectTmp.setSurface(true);
                                intersectTmp = IntersectRegionSort.getNextNode(intersectTmp, true);
                            }
                            this.vectorDoubledSurface.remove(j);
                            break;
                        }
                    } else if ((status1 == 2 || status1 == 1) && status2 == 3 && (status1 == statusVersa1 && statusVersa2 == 3 || status1 == statusVersa2 && statusVersa1 == 3)) {
                        this.vectorDoubledSurface.add(intersectSame);
                    }
                    intersectSame = intersectSame.samePointsNext;
                }
                intersect = manager.getNext(intersect);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void setTemporaryIncludeLevel(IPolyline2DCollection collection, int combination, boolean absoluteLevel) {
        int i = 0;
        block6: while (i < collection.size()) {
            IPolyline2D polyline = collection.get(i);
            PolylineManager manager = (PolylineManager)polyline.get(4096);
            this.vectorDoubledPlane.clear();
            this.vectorDoubledSurface.clear();
            int level = 0;
            int levelLowest = Short.MAX_VALUE;
            IntersectRegionSort intersect = manager.getFirst();
            while (true) {
                IntersectRegionSort intersectSame;
                if (intersect != null) {
                    intersectSame = intersect.samePointsRoot;
                } else {
                    if (levelLowest < 0) {
                        this.adjustLevel(manager, (short)(-levelLowest), absoluteLevel);
                    }
                    ++i;
                    continue block6;
                }
                while (intersectSame != null) {
                    block19: {
                        IPolyline2D polylineVersa = intersectSame.pair.figure.getParent();
                        byte check = intersectSame.crossStatus;
                        byte checkPrev = intersectSame.crossPrevStatus;
                        switch (check) {
                            case 1: {
                                if (checkPrev != 1) {
                                    if (this.vectorDoubledPlane.contains(polylineVersa)) {
                                        this.vectorDoubledPlane.remove(polylineVersa);
                                    }
                                    level = (short)(level + 1);
                                    break;
                                }
                                break block19;
                            }
                            case 2: {
                                if (checkPrev != 2) {
                                    if (this.vectorDoubledPlane.contains(polylineVersa)) {
                                        this.vectorDoubledPlane.remove(polylineVersa);
                                    }
                                    if (checkPrev != 1) break;
                                    level = (short)(level - 1);
                                    break;
                                }
                                break block19;
                            }
                            case 3: {
                                if (checkPrev == 1) {
                                    level = (short)(level - 1);
                                }
                                if (intersectSame.getSurface() || !this.checkCombination(collection, polyline, polylineVersa, combination) || this.vectorDoubledPlane.contains(polylineVersa)) break;
                                this.vectorDoubledPlane.add(polylineVersa);
                                break;
                            }
                            case 0: {
                                if (checkPrev != 3 || !this.vectorDoubledPlane.contains(polylineVersa)) break;
                                this.vectorDoubledPlane.remove(polylineVersa);
                            }
                        }
                        if (level < levelLowest) {
                            levelLowest = level;
                        }
                    }
                    intersectSame = intersectSame.samePointsNext;
                }
                intersect.setLevel((short)level, absoluteLevel);
                intersect.setDoubled((short)(intersect.getDoubled() + this.vectorDoubledPlane.size()));
                intersect = manager.getNext(intersect);
            }
            break;
        }
        return;
    }

    void levelIncludeLevel(IPolyline2DCollection collection, int combination, boolean absoluteLevel) {
        int cnt = 0;
        int precnt = 0;
        int repeat = 0;
        for (int i = 0; i < collection.size(); ++i) {
            IPolyline2D polyline = collection.get(i);
            PolylineManager manager1 = (PolylineManager)polyline.get(4096);
            CrossPolylineGroup group = manager1.getGroup();
            if (group == null || group.getFirst() != polyline) continue;
            precnt = 0;
            repeat = 0;
            IPolyline2D[] polylines = group.getAllPolyline();
            do {
                if (precnt >= cnt) {
                    if (repeat >= 3) break;
                    ++repeat;
                } else {
                    precnt = cnt;
                    repeat = 0;
                }
                cnt = 0;
                for (int j = 0; j < polylines.length; ++j) {
                    IPolyline2D polyline1 = polylines[j];
                    manager1 = (PolylineManager)polyline1.get(4096);
                    this.vectorDoubledPlane.clear();
                    IntersectRegionSort intersect = manager1.getFirst();
                    while (intersect != null) {
                        short level1 = intersect.getLevel(absoluteLevel);
                        IntersectRegionSort intersectSame = intersect.samePointsRoot;
                        while (intersectSame != null) {
                            IPolyline2D polyline2 = intersect.pair.figure.getParent();
                            if (this.checkCombination(collection, polyline1, polyline2, combination)) {
                                short level2 = intersectSame.pair.getLevel(absoluteLevel);
                                short relate1 = this.getOuterPartLevel(polyline1, intersectSame.samePointsRoot, absoluteLevel);
                                short relate2 = this.getOuterPartLevel(polyline2, intersectSame.pair.samePointsRoot, absoluteLevel);
                                short check1 = (short)(level1 - relate1);
                                short check2 = (short)(level2 - relate2);
                                int index1 = polyline1.getIndex();
                                int index2 = polyline2.getIndex();
                                if (check1 > check2) {
                                    PolylineManager manager2 = (PolylineManager)polyline2.get(4096);
                                    this.adjustLevel(manager2, (short)(check1 - check2), absoluteLevel);
                                    ++cnt;
                                } else if (check1 < check2) {
                                    this.adjustLevel(manager1, (short)(check2 - check1), absoluteLevel);
                                    ++cnt;
                                }
                            }
                            intersectSame = intersectSame.samePointsNext;
                        }
                        intersect = manager1.getNext(intersect);
                    }
                }
            } while (cnt > 0);
            this.searchOuterPolygon(group, absoluteLevel);
        }
    }

    private short getOuterPartLevel(IPolyline2D polylineOrg, IntersectRegionSort intersectRoot, boolean absoluteLevel) {
        short level = 0;
        IntersectRegionSort intersect = intersectRoot;
        while (intersect != null) {
            IPolyline2D polyline = intersect.pair.figure.getParent();
            byte check = intersect.crossStatus;
            switch (check) {
                case 1: {
                    if (this.vectorDoubledPlane.contains(intersect.pair.figure.getParent())) {
                        this.vectorDoubledPlane.remove(intersect.pair.figure.getParent());
                    }
                    level = (short)(level + 1);
                    break;
                }
                case 2: {
                    if (!this.vectorDoubledPlane.contains(intersect.pair.figure.getParent())) break;
                    this.vectorDoubledPlane.remove(intersect.pair.figure.getParent());
                    break;
                }
            }
            intersect = intersect.samePointsNext;
        }
        return level;
    }

    private void adjustLevel(PolylineManager manager, short levelDiff, boolean absoluteLevel) {
        IntersectRegionSort intersect = manager.getFirst();
        while (intersect != null) {
            intersect.setLevel((short)(intersect.getLevel(absoluteLevel) + levelDiff), absoluteLevel);
            intersect = manager.getNext(intersect);
        }
    }

    private void searchOuterPolygon(CrossPolylineGroup group, boolean absoluteLevel) {
        PolylineManager manager = (PolylineManager)group.getFirst().get(4096);
        IntersectRegionSort intersect = manager.getFirst();
        IntersectRegionSort intersectPrev = null;
        IntersectRegionSort intersectBase = null;
        short levelMax = 0;
        boolean goForth = true;
        boolean outerRegionFound = false;
        boolean innerRegionFound = false;
        this.vectorPointTracer.clear();
        block0: while (intersect != null) {
            int check;
            if (intersectBase == null && this.vectorPointTracer.contains(intersect)) {
                intersectBase = intersect;
            } else if (intersect == intersectBase) break;
            if (intersectBase != null && intersect.figure.getParent().getRegion() == 4) {
                outerRegionFound = true;
            }
            if (intersectBase != null && intersect.figure.getParent().getRegion() == 3 && (goForth && intersect.crossStatus != 3 || !goForth && intersect.crossPrevStatus != 3)) {
                innerRegionFound = true;
            }
            if (intersectBase == null) {
                this.vectorPointTracer.add(intersect);
            }
            if (intersectBase != null && intersectPrev != null && goForth && intersectPrev.samePointsRoot.getLevel(absoluteLevel) > levelMax) {
                levelMax = intersectPrev.samePointsRoot.getLevel(absoluteLevel);
            } else if (intersectBase != null && !goForth && intersect.samePointsRoot.getLevel(absoluteLevel) > levelMax) {
                levelMax = intersect.samePointsRoot.getLevel(absoluteLevel);
            }
            if (intersect.crossStatus == 0 && intersect.crossPrevStatus == 0) continue;
            IPolyline2D polyline = intersect.figure.getParent();
            IntersectRegionSort intersectSame = intersect.samePointsRoot;
            while (intersectSame != null) {
                check = this.checkAllCrossStatus(polyline, intersectSame.pair);
                if (check != 0) {
                    intersectPrev = intersectSame.pair.samePointsRoot;
                    if (check < 0) {
                        intersect = IntersectRegionSort.getPrevNode(intersectSame.pair, true);
                        goForth = false;
                        continue block0;
                    }
                    intersect = IntersectRegionSort.getNextNode(intersectSame.pair, true);
                    goForth = true;
                    continue block0;
                }
                intersectSame = intersectSame.samePointsNext;
            }
            check = this.checkAllCrossStatus(polyline, intersect.samePointsRoot);
            if (check != 0) {
                intersectPrev = intersect.samePointsRoot;
                if (check < 0) {
                    intersect = IntersectRegionSort.getPrevNode(intersect.samePointsRoot, true);
                    goForth = false;
                    continue;
                }
                intersect = IntersectRegionSort.getNextNode(intersect.samePointsRoot, true);
                goForth = true;
                continue;
            }
            intersectSame = intersect.samePointsRoot;
            while (intersectSame != null) {
                if (intersectSame.pair.samePointsRoot.getLevel(absoluteLevel) == 0) {
                    intersect = intersectSame.pair.samePointsRoot;
                    continue block0;
                }
                intersectSame = intersectSame.samePointsNext;
            }
            intersect = IntersectRegionSort.getNextNode(intersect.samePointsRoot, true);
        }
        group.setMaxLevel(levelMax);
        group.regionInside = !outerRegionFound;
        group.innerRegionFound = innerRegionFound;
        group.outerMostPoint = intersectBase;
    }

    int checkAllCrossStatus(IPolyline2D polylineVersa, IntersectRegionSort root) {
        int status1 = 0;
        int status2 = 0;
        IntersectRegionSort intersect = root;
        while (intersect != null) {
            byte side1 = ToolPlaneLogic.getCrossStatus(polylineVersa, intersect.crossPrevStatus, false);
            byte side2 = ToolPlaneLogic.getCrossStatus(polylineVersa, intersect.crossStatus, false);
            if (status1 == 0) {
                status1 = side1;
            } else if (side1 == 1) {
                status1 = side1;
            }
            if (status2 == 0) {
                status2 = side2;
            } else if (side2 == 1) {
                status2 = side2;
            }
            intersect = intersect.samePointsNext;
        }
        if (status2 == 2) {
            return 1;
        }
        if (status1 == 2) {
            return -1;
        }
        return 0;
    }

    void addIncludeLevel(IPolyline2DCollection collection, boolean absoluteLevel) {
        for (int i = 0; i < collection.size(); ++i) {
            int addition;
            IPolyline2D polyline = collection.get(i);
            PolylineManager manager = (PolylineManager)polyline.get(4096);
            CrossPolylineGroup group = manager.getGroup();
            if (group == null) continue;
            if (group != null) {
                addition = group.getIncludedLevel();
                if (ToolGeomPolyline2D.isClosed(polyline)) {
                    addition -= group.getMaxLevel();
                }
                if (!group.regionInside) {
                    --addition;
                    if (group.innerRegionFound) {
                        ++addition;
                    }
                }
            } else {
                addition = manager.getIncludedLevel();
            }
            IntersectRegionSort intersect = manager.getFirst();
            while (intersect != null) {
                intersect.setLevel((short)(intersect.getLevel(absoluteLevel) + addition), absoluteLevel);
                intersect.setLevel((short)(intersect.getLevel(absoluteLevel) + intersect.getDoubled()), absoluteLevel);
                intersect = manager.getNext(intersect);
            }
        }
    }
}

