/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.math.geom.logicaloperation;

import jp.kitec.math.geom.datapassing.IAdditData;
import jp.kitec.math.geom.datapassing.IFigure2D;
import jp.kitec.math.geom.datapassing.IPolyline2D;
import jp.kitec.math.geom.logicaloperation.CrossPolylineGroup;
import jp.kitec.math.geom.logicaloperation.IntersectRegionSort;
import jp.kitec.math.searches.NodeComparator;
import jp.kitec.math.searches.binarysort.BinarySort;
import jp.kitec.math.searches.binarysort.BinarySortBuilder;

public class PolylineManager
implements IAdditData {
    public static final byte REGION_NONE = 0;
    public static final byte REGION_RIGHT = 1;
    public static final byte REGION_LEFT = 2;
    private IntersectRegionComparator comparator = new IntersectRegionComparator();
    private BinarySort intersectRegionSort;
    private boolean cw;
    private byte region;
    private boolean includeInnerRegionPlane;
    private boolean includeOuterRegionPlane;
    private int includedLevel;
    private CrossPolylineGroup group;
    private IPolyline2D polyline;

    public PolylineManager(BinarySortBuilder builder, IPolyline2D polyline) {
        this.intersectRegionSort = new BinarySort<IntersectRegionSort>(this.comparator, builder);
        this.polyline = polyline;
        this.init();
    }

    public void reset() {
        this.init();
        this.intersectRegionSort.clearNodes();
    }

    public void init() {
        this.cw = true;
        this.region = 0;
        this.includeOuterRegionPlane = false;
        this.includeInnerRegionPlane = false;
        this.includedLevel = 0;
        this.group = null;
    }

    @Override
    public int getKey() {
        return 4096;
    }

    public IntersectRegionSort get(double parameter) {
        double node = this.intersectRegionSort.search(parameter);
        if (node == null) {
            return null;
        }
        return (IntersectRegionSort)node.get();
    }

    public IntersectRegionSort getFirst() {
        return (IntersectRegionSort)this.intersectRegionSort.getFirst();
    }

    public IntersectRegionSort getNext() {
        return (IntersectRegionSort)this.intersectRegionSort.getNext();
    }

    public IntersectRegionSort getPrev(IntersectRegionSort intersect) {
        return this.intersectRegionSort.getPrev(intersect);
    }

    public IntersectRegionSort getNext(IntersectRegionSort intersect) {
        return this.intersectRegionSort.getNext(intersect);
    }

    public IntersectRegionSort getTop() {
        return (IntersectRegionSort)this.intersectRegionSort.getLeftMost();
    }

    public IntersectRegionSort getBottom() {
        return (IntersectRegionSort)this.intersectRegionSort.getRightMost();
    }

    public void setCw(boolean cw) {
        this.cw = cw;
    }

    public boolean isCw() {
        return this.cw;
    }

    public void setRegion(byte region) {
        this.region = region;
    }

    public byte getRegion() {
        return this.region;
    }

    public boolean isRegionInside() {
        return this.region != 0 && this.cw == (this.region == 1);
    }

    public void setIncludeInnerRegionPlane(boolean innerPlane) {
        this.includeInnerRegionPlane = innerPlane;
    }

    public boolean checkIncludeInnerRegionPlane() {
        return this.includeInnerRegionPlane;
    }

    public void setIncludeOuterRegionPlane(boolean outerPlane) {
        this.includeOuterRegionPlane = outerPlane;
    }

    public boolean checkIncludeOuterRegionPlane() {
        return this.includeOuterRegionPlane;
    }

    public IntersectRegionSort add(IFigure2D figure, double x, double y, double parameter) {
        IntersectRegionSort node = new IntersectRegionSort();
        node.figure = figure;
        node.x = x;
        node.y = y;
        node.parameterOfFigure = parameter;
        node.samePointsRoot = node;
        this.intersectRegionSort.add(node);
        return node;
    }

    public int size() {
        return this.intersectRegionSort.getNodeCount();
    }

    public IPolyline2D getPolyline() {
        return this.polyline;
    }

    public CrossPolylineGroup getGroup() {
        return this.group;
    }

    public void setGroup(CrossPolylineGroup group) {
        this.group = group;
    }

    public CrossPolylineGroup addGroup(PolylineManager manager) {
        CrossPolylineGroup group1 = this.group;
        CrossPolylineGroup group2 = manager.group;
        if (group1 != null && group1 == group2 || this == manager) {
            return group1;
        }
        if (group1 == null && group2 != null) {
            group2.add(this);
            this.group = manager.group;
            return group2;
        }
        if (group1 != null && group2 == null) {
            group1.add(manager);
            manager.group = this.group;
            return group1;
        }
        if (group1 != null && group2 != null) {
            group1.integrate(group2);
            manager.group = this.group;
            return this.group;
        }
        this.group = manager.group = new CrossPolylineGroup();
        this.group.add(this);
        this.group.add(manager);
        return this.group;
    }

    public void addIncludedLevel(int addLevel) {
        this.includedLevel += addLevel;
    }

    public int getIncludedLevel() {
        return this.includedLevel;
    }

    class IntersectRegionComparator
    implements NodeComparator<IntersectRegionSort> {
        static final double TOLERANCE = 1.0E-8;

        IntersectRegionComparator() {
        }

        int compareParameter(double v1, double v2) {
            if (Math.abs(v1 - v2) <= 1.0E-8) {
                return 0;
            }
            if (v1 > v2) {
                return 1;
            }
            return -1;
        }

        @Override
        public int compare(IntersectRegionSort intersect1, IntersectRegionSort intersect2) {
            return this.compareParameter(intersect1.parameterOfFigure, intersect2.parameterOfFigure);
        }

        @Override
        public int compare(IntersectRegionSort intersect, double value) {
            return this.compareParameter(intersect.parameterOfFigure, value);
        }

        @Override
        public boolean addSameValue(IntersectRegionSort intersect1, IntersectRegionSort intersect2) {
            if (intersect1.samePointsNext == null) {
                intersect1.samePointsNext = intersect2;
                intersect1.samePointsRoot = intersect2.samePointsRoot = intersect1;
            } else {
                intersect2.samePointsNext = intersect1.samePointsNext.samePointsNext;
                intersect1.samePointsNext.samePointsNext = intersect2;
                intersect2.samePointsRoot = intersect1;
            }
            return true;
        }
    }
}

