/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.math.geom.logicaloperation;

import java.util.Vector;
import jp.kitec.math.geom.ToolGeom2D;
import jp.kitec.math.geom.datapassing.IFigure2D;
import jp.kitec.math.geom.datapassing.IFigure2DArc;
import jp.kitec.math.geom.datapassing.IFigureType;
import jp.kitec.math.geom.datapassing.IPolyline2D;
import jp.kitec.math.geom.datapassing.IPolyline2DCollection;
import jp.kitec.math.geom.datapassing.PolylineEditable;
import jp.kitec.math.geom.datapassing.ToolGeomFigure2D;
import jp.kitec.math.geom.datapassing.polylines.ToolGeomPolyline2D;
import jp.kitec.math.geom.logicaloperation.CrossPolylineGroup;
import jp.kitec.math.geom.logicaloperation.IntersectRegionSort;
import jp.kitec.math.geom.logicaloperation.PolylineManager;
import jp.kitec.math.searches.regiontree.RectangleSupplier;

public class LevelCollector {
    public static final double TOLERANCE_DISTANCE = 1.0E-8;
    public static final int FAIL = -1;
    public static final int INIT = 0;
    public static final int NOT_FOUND = 1;
    public static final int NEW_POLYLINE = 2;
    public static final int FIGURE = 3;
    public static final int JOINT = 4;
    public static final int PARENT_POLYGON = 5;
    public static final int CHILD_POLYGON = 6;
    public static final int LESS = 5;
    public static final int EQUAL = 6;
    public static final int GREATER = 7;
    public static final int LESS_EQUAL = 8;
    public static final int GREATER_EQUAL = 9;
    public static final int NOT_EQUAL = 10;
    public static final int OVERLAP_TOP = 11;
    public static final int NONE = 12;
    private IPolyline2DCollection collection1 = null;
    private IPolyline2DCollection collection2 = null;
    private short level1 = 0;
    private short level2 = 0;
    private int sign1 = 6;
    private int sign2 = 6;
    private double startX = 0.0;
    private double startY = 0.0;
    private int lastStatus = 0;
    private double search_x = 0.0;
    private double search_y = 0.0;
    private double search_xc = 0.0;
    private double search_yc = 0.0;
    private double search_radius = 0.0;
    private int search_type = 0;
    private int search_polygonAttr;
    private int search_fase = 0;
    private boolean markSecondCollection = true;
    private boolean getSurface = false;
    private double[] rect1 = new double[4];
    private double[] rect2 = new double[4];
    private IFigure2D search_figure = null;
    private IFigure2D search_currentFigure = null;
    private IntersectRegionSort search_intersectLast = null;
    private IntersectRegionSort search_intersectNext = null;
    private boolean search_goForth = true;
    private boolean search_independentPlane = false;
    private CrossPolylineGroup search_group = null;
    private IPolyline2DCollection search_collection = null;
    private int search_polyline = 0;
    IPolyline2D polylineTmp = null;
    private PolylineManager search_manager = null;
    private IntersectRegionSort search_intersect = null;
    private Vector search_vector = new Vector(10, 10);
    private boolean absLevel = false;

    boolean equalPoints(double x1, double y1, double x2, double y2) {
        return Math.abs(x1 - x2) <= 1.0E-8 && Math.abs(y1 - y2) <= 1.0E-8;
    }

    boolean judgeLevel(int levelOrg, int levelCmp, int sign) {
        switch (sign) {
            case 5: {
                return levelOrg < levelCmp;
            }
            case 6: 
            case 11: {
                return levelOrg == levelCmp;
            }
            case 7: {
                return levelOrg > levelCmp;
            }
            case 8: {
                return levelOrg <= levelCmp;
            }
            case 9: {
                return levelOrg >= levelCmp;
            }
            case 10: {
                return levelOrg != levelCmp;
            }
            case 12: {
                return false;
            }
        }
        return false;
    }

    public double getX() {
        return this.search_x;
    }

    public double getY() {
        return this.search_y;
    }

    public double getXC() {
        return this.search_xc;
    }

    public double getYC() {
        return this.search_yc;
    }

    public double getRadius() {
        return this.search_radius;
    }

    public int getType() {
        return this.search_type;
    }

    public byte getRegion() {
        IPolyline2D polyline = this.search_figure.getParent();
        if (polyline instanceof PolylineEditable) {
            byte region = polyline.getRegion();
            switch (region) {
                case 0: {
                    return 0;
                }
                case 1: 
                case 3: 
                case 4: {
                    return this.search_goForth ? (byte)1 : 2;
                }
                case 2: {
                    return this.search_goForth ? (byte)2 : 1;
                }
            }
        }
        return 0;
    }

    public int getPolygonAttr() {
        return this.search_polygonAttr;
    }

    public int getOriginal(Object[] result, boolean isFirstPointOriginal) {
        IFigure2D figure;
        IFigure2D figureResult;
        if (this.search_currentFigure != null) {
            if (this.search_goForth) {
                if (isFirstPointOriginal) {
                    result[0] = this.search_currentFigure.getPrev();
                    if (result[0] == null) {
                        IFigure2D figure2 = (IFigure2D)this.search_currentFigure.getParent().lastElement();
                        result[0] = this.equalPoints(this.search_currentFigure.getX1(), this.search_currentFigure.getY1(), figure2.getX2(), figure2.getY2()) ? figure2 : this.search_currentFigure.getParent();
                    }
                } else {
                    result[0] = this.search_currentFigure;
                }
            } else if (isFirstPointOriginal) {
                result[0] = this.search_currentFigure;
            } else {
                result[0] = this.search_currentFigure.getPrev();
                if (result[0] == null) {
                    IFigure2D figure3 = (IFigure2D)this.search_currentFigure.getParent().lastElement();
                    result[0] = this.equalPoints(this.search_currentFigure.getX1(), this.search_currentFigure.getY1(), figure3.getX2(), figure3.getY2()) ? figure3 : this.search_currentFigure.getParent();
                }
            }
            return 1;
        }
        if (this.search_intersect == null) {
            return 0;
        }
        IntersectRegionSort intersect = this.search_intersect.samePointsRoot;
        double parameter = intersect.parameterOfFigure - Math.floor(intersect.parameterOfFigure);
        int out = 0;
        if (parameter == 0.0) {
            figureResult = intersect.figure;
            figure = figureResult;
            if (this.equalPoints(this.search_intersect.x, this.search_intersect.y, figure.getX1(), figure.getY1())) {
                figureResult = (IFigure2D)figure.getPrev();
            }
            Object object = result[out++] = figureResult != null ? figureResult : figure.getParent();
        }
        while (intersect != null) {
            parameter = intersect.pair.samePointsRoot.parameterOfFigure;
            if (parameter == Math.floor(parameter)) {
                figureResult = intersect.pair.samePointsRoot.figure;
                figure = figureResult;
                if (this.equalPoints(this.search_intersect.x, this.search_intersect.y, figure.getX1(), figure.getY1())) {
                    figureResult = (IFigure2D)figure.getPrev();
                }
                result[out++] = figureResult != null ? figureResult : figure.getParent();
            }
            intersect = intersect.samePointsNext;
        }
        return out;
    }

    public void set(IPolyline2DCollection collection, int sign, short level, boolean permitSurface) {
        this.collection1 = collection;
        this.collection2 = null;
        this.level1 = level;
        this.level2 = (short)-1;
        this.sign1 = sign;
        this.sign2 = 0;
        this.lastStatus = 0;
        this.search_polygonAttr = 0;
        this.getSurface = permitSurface;
        this.search_fase = 1;
        this.search_independentPlane = false;
        this.search_collection = this.collection1;
        this.search_polyline = -1;
        this.search_manager = null;
        this.search_intersect = null;
    }

    public void set(IPolyline2DCollection collection1, IPolyline2DCollection collection2, int sign1, int sign2, short level1, short level2, boolean markSecondCollection, boolean permitSurface) {
        this.collection1 = collection1;
        this.collection2 = collection2;
        this.sign1 = sign1;
        this.sign2 = sign2;
        this.level1 = level1;
        this.level2 = level2;
        this.lastStatus = 0;
        this.markSecondCollection = markSecondCollection;
        this.search_polygonAttr = 0;
        this.getSurface = permitSurface;
        this.search_fase = 2;
        this.search_collection = collection1;
        this.search_polyline = -1;
        this.search_manager = null;
        this.search_intersect = null;
    }

    public void or(IPolyline2DCollection collection) {
        this.set(collection, 6, (short)0, false);
    }

    public void or(IPolyline2DCollection collection1, IPolyline2DCollection collection2) {
        this.set(collection1, collection2, 6, 6, (short)0, (short)0, true, false);
    }

    public void and(IPolyline2DCollection collection) {
        this.set(collection, 11, (short)0, false);
    }

    public void and(IPolyline2DCollection collection1, IPolyline2DCollection collection2) {
        this.set(collection1, collection2, 11, 11, (short)0, (short)0, true, false);
    }

    public void sub(IPolyline2DCollection collection1, IPolyline2DCollection collection2) {
        this.set(collection1, collection2, 6, 9, (short)0, (short)1, true, true);
    }

    public void cut(IPolyline2DCollection collection1, IPolyline2DCollection collection2) {
        this.set(collection1, collection2, 6, 9, (short)0, (short)1, false, true);
    }

    public int findNext() {
        return this.findNext(true, true);
    }

    private int findNext(boolean setFlag, boolean bSearch) {
        if (this.lastStatus == 0 || this.lastStatus == -1) {
            if (bSearch) {
                return this.search(setFlag);
            }
            return -1;
        }
        if (this.search_independentPlane) {
            if (this.search_figure == null) {
                this.search_independentPlane = false;
                this.search_manager = null;
                return this.search(setFlag);
            }
            this.search_x = this.search_figure.getX2();
            this.search_y = this.search_figure.getY2();
            this.search_type = this.search_figure.getType();
            if (this.search_type == 2 || this.search_type == 3) {
                IFigure2DArc arc = (IFigure2DArc)this.search_figure;
                this.search_xc = arc.getCX();
                this.search_yc = arc.getCY();
                this.search_radius = arc.getRadius();
            }
            this.lastStatus = 3;
            this.search_currentFigure = this.search_figure;
            this.search_figure = ToolGeomFigure2D.getNext(this.search_figure);
            return 3;
        }
        if (this.search_intersectNext != null && this.lastStatus == 2 && this.search_figure == this.search_intersectNext.figure && (this.search_intersectLast == null || this.search_goForth && this.search_intersectLast.parameterOfFigure < this.search_intersectNext.parameterOfFigure || !this.search_goForth && this.search_intersectLast.parameterOfFigure > this.search_intersectNext.parameterOfFigure)) {
            this.search_x = this.search_intersectNext.x;
            this.search_y = this.search_intersectNext.y;
            this.search_type = this.search_goForth ? this.search_figure.getType() : IFigureType.getReverseType(this.search_figure.getType());
            this.search_currentFigure = null;
            if (this.search_type == 2 || this.search_type == 3) {
                IFigure2DArc arc = (IFigure2DArc)this.search_figure;
                this.search_xc = arc.getCX();
                this.search_yc = arc.getCY();
                this.search_radius = arc.getRadius();
            }
            this.searchAtIntersect(setFlag);
            return 3;
        }
        if (this.search_intersectNext != null && (this.search_figure == this.search_intersectNext.figure && (this.search_intersectLast != null && this.search_intersectLast.figure != this.search_intersectNext.figure || this.search_goForth && (this.search_intersectLast == null || this.search_intersectLast.parameterOfFigure < this.search_intersectNext.parameterOfFigure) || this.search_goForth && this.equalPoints(this.search_x, this.search_y, this.search_figure.getX1(), this.search_figure.getY1()) || !this.search_goForth && (this.search_intersectLast == null || this.search_intersectLast.parameterOfFigure > this.search_intersectNext.parameterOfFigure) || !this.search_goForth && this.equalPoints(this.search_x, this.search_y, this.search_figure.getX2(), this.search_figure.getY2())) || this.search_goForth && this.equalPoints(this.search_figure.getX2(), this.search_figure.getY2(), this.search_intersectNext.x, this.search_intersectNext.y) || !this.search_goForth && this.equalPoints(this.search_figure.getX1(), this.search_figure.getY1(), this.search_intersectNext.x, this.search_intersectNext.y))) {
            this.search_x = this.search_intersectNext.x;
            this.search_y = this.search_intersectNext.y;
            this.search_type = this.search_goForth ? this.search_figure.getType() : IFigureType.getReverseType(this.search_figure.getType());
            this.search_currentFigure = null;
            if (this.search_type == 2 || this.search_type == 3) {
                IFigure2DArc arc = (IFigure2DArc)this.search_figure;
                this.search_xc = arc.getCX();
                this.search_yc = arc.getCY();
                this.search_radius = arc.getRadius();
            }
            this.searchAtIntersect(setFlag);
            return 3;
        }
        if (this.search_goForth) {
            this.search_x = this.search_figure.getX2();
            this.search_y = this.search_figure.getY2();
            this.search_type = this.search_figure.getType();
            if (this.search_type == 2 || this.search_type == 3) {
                IFigure2DArc arc = (IFigure2DArc)this.search_figure;
                this.search_xc = arc.getCX();
                this.search_yc = arc.getCY();
                this.search_radius = arc.getRadius();
            }
            this.search_currentFigure = this.search_figure;
            IPolyline2D polylineTmp = this.search_figure.getParent();
            IFigure2D figureTmp = ToolGeomFigure2D.getNext(this.search_figure);
            this.search_figure = ToolGeomPolyline2D.isClosed(polylineTmp) ? (figureTmp == null ? (IFigure2D)this.search_figure.getParent().firstElement() : ToolGeomFigure2D.getNext(this.search_figure)) : ToolGeomFigure2D.getNext(this.search_figure);
        } else {
            this.search_x = this.search_figure.getX1();
            this.search_y = this.search_figure.getY1();
            this.search_type = IFigureType.getReverseType(this.search_figure.getType());
            if (this.search_type == 2 || this.search_type == 3) {
                IFigure2DArc arc = (IFigure2DArc)this.search_figure;
                this.search_xc = arc.getCX();
                this.search_yc = arc.getCY();
                this.search_radius = arc.getRadius();
            }
            this.search_currentFigure = this.search_figure;
            IPolyline2D polylineTmp = this.search_figure.getParent();
            IFigure2D figureTmp = (IFigure2D)this.search_figure.getPrev();
            this.search_figure = ToolGeomPolyline2D.isClosed(polylineTmp) ? (figureTmp == null ? (IFigure2D)this.search_figure.getParent().lastElement() : (IFigure2D)this.search_figure.getPrev()) : (IFigure2D)this.search_figure.getPrev();
        }
        if (this.search_figure == null) {
            this.search_intersectNext = null;
            this.search_intersectLast = null;
            this.lastStatus = -1;
            return 3;
        }
        this.lastStatus = 3;
        return 3;
    }

    int search(boolean setFlag) {
        IPolyline2DCollection collectionTmp = null;
        boolean and = this.sign1 == 11 || this.sign2 == 11;
        boolean bFirstIntersect = false;
        while (this.search_fase > 0) {
            block1: while (true) {
                if (this.search_intersect != null) {
                    if (this.search_intersect != null) {
                        collectionTmp = this.search_intersect.figure.getParent().getParent();
                    }
                    IntersectRegionSort intersectPrev = IntersectRegionSort.getPrevNode(this.search_intersect, false);
                    if (!and) {
                        boolean bClosed = ToolGeomPolyline2D.isClosed(this.search_intersect.figure.getParent());
                        if (!this.search_intersect.flag && bClosed && (this.getSurface || this.search_intersect.getSurfaceCount() == 0) && (this.collection1 == collectionTmp && this.judgeLevel(this.search_intersect.getLevel(this.absLevel), this.level1, this.sign1) || this.collection2 == collectionTmp && this.judgeLevel(this.search_intersect.getLevel(this.absLevel), this.level2, this.sign2))) {
                            this.search_polygonAttr = this.search_polygonAttr == 0 ? 5 : 6;
                            this.lastStatus = 2;
                            this.startX = this.search_x = this.search_intersect.x;
                            this.startY = this.search_y = this.search_intersect.y;
                            this.search_intersectLast = this.search_intersect;
                            if (this.search_collection == this.collection1 || this.markSecondCollection) {
                                this.search_intersect.flag = setFlag;
                            }
                            this.search_type = 6;
                            this.search_goForth = true;
                            this.search_currentFigure = null;
                            this.search_figure = this.search_intersect.figure;
                            this.search_intersectNext = IntersectRegionSort.getNextNode(this.search_intersect, true);
                            return 2;
                        }
                        if (!bClosed && (this.getSurface || this.search_intersect.getSurfaceCount() == 0)) {
                            int levelTmp = 0;
                            int levelTmpPrev = 0;
                            IntersectRegionSort intersectSame = this.search_intersect.samePointsRoot;
                            while (intersectSame != null) {
                                if (intersectSame.crossPrevStatus == 1 && intersectSame.crossStatus == 2) {
                                    ++levelTmp;
                                } else if (intersectSame.crossPrevStatus == 2 && intersectSame.crossStatus == 1 || intersectSame.crossPrevStatus == 2 && intersectSame.crossStatus == 0) {
                                    --levelTmp;
                                }
                                intersectSame = intersectSame.samePointsNext;
                            }
                            if (intersectPrev != null) {
                                intersectSame = intersectPrev.samePointsRoot;
                                while (intersectSame != null) {
                                    if (intersectSame.crossPrevStatus == 1 && intersectSame.crossStatus == 2) {
                                        ++levelTmpPrev;
                                    } else if (intersectSame.crossPrevStatus == 2 && intersectSame.crossStatus == 1 || intersectSame.crossPrevStatus == 2 && intersectSame.crossStatus == 0) {
                                        --levelTmpPrev;
                                    }
                                    intersectSame = intersectSame.samePointsNext;
                                }
                            }
                            if (!this.search_intersect.flag && (this.collection1 == collectionTmp && this.judgeLevel(this.search_intersect.getLevel(this.absLevel), this.level1, this.sign1) || this.collection2 == collectionTmp && this.judgeLevel(this.search_intersect.getLevel(this.absLevel), this.level2, this.sign2)) && (bFirstIntersect && this.search_intersect.crossPrevStatus == 0 || this.search_intersect.crossPrevStatus == 2 && this.search_intersect.crossStatus == 0 || !ToolGeom2D.equalPoints(this.search_intersect.x, this.search_intersect.y, this.search_intersect.figure.getX2(), this.search_intersect.figure.getY2()) || this.search_intersect.figure.getNext() != null)) {
                                this.search_polygonAttr = this.search_polygonAttr == 0 ? 5 : 6;
                                this.lastStatus = 2;
                                this.search_intersectLast = this.search_intersect;
                                if (this.search_collection == this.collection1 || this.markSecondCollection) {
                                    this.search_intersect.flag = setFlag;
                                }
                                this.search_type = 6;
                                this.search_goForth = true;
                                this.search_currentFigure = null;
                                if (bFirstIntersect && this.search_intersect.crossPrevStatus == 0 || this.search_intersect.crossPrevStatus == 2 && this.search_intersect.crossStatus == 0 || this.search_intersect.crossPrevStatus == 0 && this.search_intersect.crossStatus == 0) {
                                    this.search_figure = (IFigure2D)this.polylineTmp.firstElement();
                                    this.startX = this.search_x = this.search_figure.getX1();
                                    this.startY = this.search_y = this.search_figure.getY1();
                                } else {
                                    this.search_figure = this.search_intersect.figure;
                                    this.startX = this.search_x = this.search_intersect.x;
                                    this.startY = this.search_y = this.search_intersect.y;
                                }
                                this.search_intersectNext = this.search_intersect;
                                do {
                                    this.search_intersectNext = IntersectRegionSort.getNextNode(this.search_intersectNext, false);
                                    if (this.search_intersectNext == null || this.search_collection != this.collection1 && !this.markSecondCollection) continue;
                                    this.search_intersectNext.flag = setFlag;
                                } while (this.search_intersectNext != null && this.search_intersectNext.crossPrevStatus == this.search_intersectNext.crossStatus);
                                if (this.search_intersectNext != null && (this.search_collection == this.collection1 || this.markSecondCollection)) {
                                    this.search_intersectNext.flag = setFlag;
                                }
                                return 2;
                            }
                            if (intersectPrev == null && !this.search_intersect.flag && (this.collection1 == collectionTmp && this.judgeLevel(this.search_intersect.getLevel(this.absLevel) + levelTmp, this.level1, this.sign1) || this.collection2 == collectionTmp && this.judgeLevel(this.search_intersect.getLevel(this.absLevel) + levelTmp, this.level2, this.sign2)) || intersectPrev != null && !intersectPrev.flag && (this.collection1 == collectionTmp && this.judgeLevel(intersectPrev.getLevel(this.absLevel) + levelTmpPrev, this.level1, this.sign1) || this.collection2 == collectionTmp && this.judgeLevel(intersectPrev.getLevel(this.absLevel) + levelTmpPrev, this.level2, this.sign2))) {
                                this.search_polygonAttr = this.search_polygonAttr == 0 ? 5 : 6;
                                this.lastStatus = 2;
                                this.search_intersectNext = this.search_intersect;
                                do {
                                    this.search_intersect = IntersectRegionSort.getPrevNode(this.search_intersect, false);
                                    if (this.search_intersect == null || this.search_collection != this.collection1 && !this.markSecondCollection) continue;
                                    this.search_intersect.flag = setFlag;
                                } while (this.search_intersect != null && this.search_intersect.crossPrevStatus == this.search_intersect.crossStatus);
                                if (this.search_intersect == null) {
                                    this.search_intersect = this.search_intersectNext;
                                    this.search_intersectNext = IntersectRegionSort.getNextNode(this.search_intersect, false);
                                    this.startX = this.search_x = this.polylineTmp.getFirstX();
                                    this.startY = this.search_y = this.polylineTmp.getFirstY();
                                    this.search_figure = this.search_currentFigure = (IFigure2D)this.polylineTmp.firstElement();
                                } else {
                                    this.startX = this.search_x = this.search_intersect.x;
                                    this.startY = this.search_y = this.search_intersect.y;
                                    this.search_figure = this.search_intersect.figure;
                                }
                                this.search_intersectLast = this.search_intersect;
                                this.search_type = 6;
                                this.search_goForth = true;
                                if (this.search_intersect != null && (this.search_collection == this.collection1 || this.markSecondCollection)) {
                                    this.search_intersect.flag = setFlag;
                                }
                                return 2;
                            }
                        }
                    } else if (!this.search_intersect.flag && this.search_intersect.getLevel(this.absLevel) > 0 && (this.getSurface || this.search_intersect.getSurfaceCount() == 0)) {
                        if (!this.checkOpenPolyline(false)) {
                            this.checkOpenPolyline(true);
                        } else if (!this.doesIncludeOthers()) {
                            this.search_polygonAttr = this.search_polygonAttr == 0 ? 5 : 6;
                            this.level1 = this.level2 = this.search_intersect.getLevel(this.absLevel);
                            this.lastStatus = 2;
                            this.startX = this.search_x = this.search_intersect.x;
                            this.startY = this.search_y = this.search_intersect.y;
                            this.search_intersectLast = this.search_intersect;
                            if (this.search_collection == this.collection1 || this.markSecondCollection) {
                                this.search_intersect.flag = setFlag;
                            }
                            this.search_type = 6;
                            this.search_goForth = true;
                            this.search_currentFigure = null;
                            this.search_figure = this.search_intersect.figure;
                            this.search_intersectNext = IntersectRegionSort.getNextNode(this.search_intersect, true);
                            return 2;
                        }
                    }
                    this.search_intersect = this.search_manager.getNext();
                    continue;
                }
                if (this.search_manager != null && this.search_manager.size() == 0 && (!and || and && !this.search_manager.checkIncludeInnerRegionPlane())) {
                    int num = this.search_manager.getIncludedLevel();
                    if (!(this.search_manager.getPolyline().getRegion() != 3 && this.search_manager.getPolyline().getRegion() != 4 || this.search_manager.isRegionInside())) {
                        --num;
                    }
                    if (and && num > 0 || !and && (this.search_collection == this.collection1 && this.judgeLevel(num, this.level1, this.sign1) || this.search_collection == this.collection2 && this.judgeLevel(num, this.level2, this.sign2))) {
                        this.search_polygonAttr = this.search_polygonAttr == 0 ? 5 : 6;
                        this.search_independentPlane = true;
                        this.polylineTmp = this.search_collection.get(this.search_polyline);
                        this.search_currentFigure = this.search_figure = (IFigure2D)this.polylineTmp.firstElement();
                        this.startX = this.search_x = this.search_figure.getX1();
                        this.startY = this.search_y = this.search_figure.getY1();
                        this.search_type = 6;
                        this.lastStatus = 2;
                        return 2;
                    }
                }
                if (this.search_group != null) {
                    this.polylineTmp = this.search_group.next();
                    if (this.polylineTmp == null) {
                        this.search_group = null;
                    } else {
                        this.search_manager = (PolylineManager)this.polylineTmp.get(4096);
                        this.search_group = this.search_manager.getGroup();
                    }
                }
                if (this.search_group == null) {
                    do {
                        ++this.search_polyline;
                        if (this.search_polyline >= this.search_collection.size()) break block1;
                        this.polylineTmp = this.search_collection.get(this.search_polyline);
                        this.search_manager = (PolylineManager)this.polylineTmp.get(4096);
                        if (and && this.search_group != this.search_manager.getGroup() && this.search_manager.getGroup() != null) {
                            this.getOverlapTop(this.search_manager.getGroup());
                        }
                        this.search_group = this.search_manager.getGroup();
                    } while (this.search_group != null && this.search_group.getFirst() != this.polylineTmp);
                    this.search_polygonAttr = 0;
                }
                if (!and && this.search_group != null && this.search_group.getFirst() == this.polylineTmp) {
                    this.search_group.iterFirst();
                    this.search_intersect = this.search_group.outerMostPoint;
                    continue;
                }
                bFirstIntersect = true;
                this.search_intersect = this.search_manager.getFirst();
            }
            --this.search_fase;
            this.search_collection = this.collection2;
            this.search_polyline = -1;
            this.search_manager = null;
            this.search_intersect = null;
        }
        this.search_figure = null;
        this.search_intersectNext = null;
        this.search_intersectLast = null;
        this.lastStatus = -1;
        return -1;
    }

    void getOverlapTop(CrossPolylineGroup group) {
        IPolyline2D polyline = group.iterFirst();
        while (polyline != null) {
            PolylineManager manager = (PolylineManager)polyline.get(4096);
            IntersectRegionSort intersect = manager.getFirst();
            IntersectRegionSort intersectPrev1 = IntersectRegionSort.getPrevNode(intersect, true);
            while (intersectPrev1 != intersect && intersectPrev1.getLevel(this.absLevel) == intersect.getLevel(this.absLevel)) {
                intersectPrev1 = IntersectRegionSort.getPrevNode(intersectPrev1, true);
            }
            IntersectRegionSort intersectPrev2 = IntersectRegionSort.getPrevNode(intersectPrev1, true);
            while (intersectPrev2 != intersect && intersectPrev2.getLevel(this.absLevel) == intersectPrev1.getLevel(this.absLevel)) {
                intersectPrev2 = IntersectRegionSort.getPrevNode(intersectPrev2, true);
            }
            while (intersect != null) {
                if (!(intersectPrev1.flag || !this.getSurface && intersectPrev1.getSurfaceCount() != 0 || intersectPrev1.getLevel(this.absLevel) != intersect.getLevel(this.absLevel) && intersectPrev2.getLevel(this.absLevel) < intersectPrev1.getLevel(this.absLevel) && intersectPrev1.getLevel(this.absLevel) > intersect.getLevel(this.absLevel))) {
                    IntersectRegionSort tmp = intersectPrev1;
                    while (tmp != intersect) {
                        if (this.search_collection == this.collection1 || this.markSecondCollection) {
                            tmp.flag = true;
                        }
                        tmp = IntersectRegionSort.getNextNode(tmp, true);
                    }
                }
                if (intersectPrev1.getLevel(this.absLevel) != intersect.getLevel(this.absLevel)) {
                    intersectPrev2 = intersectPrev1;
                    intersectPrev1 = intersect;
                }
                intersect = manager.getNext();
            }
            polyline = group.next();
        }
    }

    boolean checkOpenPolyline(boolean setFlag) {
        IntersectRegionSort intersect = this.search_intersect;
        double xs = intersect.x;
        double ys = intersect.y;
        double xs2 = 0.0;
        double ys2 = 0.0;
        this.search_intersectNext = this.search_intersect;
        this.search_goForth = true;
        if (setFlag) {
            intersect.flag = setFlag;
        }
        this.level1 = this.level2 = intersect.getLevel(this.absLevel);
        int cnt = 0;
        while (this.searchAtIntersect(setFlag) != -1) {
            if (this.equalPoints(xs, ys, this.search_intersectNext.x, this.search_intersectNext.y)) {
                this.search_intersect = intersect;
                return true;
            }
            ++cnt;
        }
        this.search_intersect = intersect;
        return false;
    }

    boolean doesIncludeOthers() {
        this.lastStatus = 2;
        double x = this.search_x = this.search_intersect.x;
        this.startX = this.search_x;
        double y = this.search_y = this.search_intersect.y;
        this.startY = this.search_y;
        this.search_intersectLast = this.search_intersect;
        this.search_type = 6;
        this.search_goForth = true;
        this.search_currentFigure = null;
        this.search_figure = this.search_intersect.figure;
        this.search_intersectNext = IntersectRegionSort.getNextNode(this.search_intersect, true);
        int cnt = 0;
        while (this.findNext(false, false) != -1) {
            if (IFigureType.isLine(this.getType())) {
                ToolGeom2D.getFitRectangle(this.rect2, x, y, this.getX(), this.getY());
            } else if (IFigureType.isArc(this.getType())) {
                ToolGeom2D.getFitRectangle(this.rect2, x, y, this.getX(), this.getY(), this.getXC(), this.getYC(), this.getRadius(), this.getType() == 2);
            }
            x = this.getX();
            y = this.getY();
            if (cnt == 0) {
                this.startX = x;
                this.startY = y;
                this.rect1[0] = this.rect2[0];
                this.rect1[1] = this.rect2[1];
                this.rect1[2] = this.rect2[2];
                this.rect1[3] = this.rect2[3];
            } else {
                ToolGeom2D.getFitRectangleOr(this.rect1, this.rect1[0], this.rect1[1], this.rect1[2], this.rect1[3], this.rect2[0], this.rect2[1], this.rect2[2], this.rect2[3]);
            }
            if (this.equalPoints(this.startX, this.startY, x, y)) break;
            ++cnt;
        }
        this.search_vector.clear();
        ToolGeomPolyline2D.search(this.search_vector, this.collection1, this.rect1[0], this.rect1[1], this.rect1[2], this.rect1[3]);
        for (int j = 0; j < this.search_vector.size(); ++j) {
            double yp;
            double xp;
            int check;
            RectangleSupplier rs;
            CrossPolylineGroup group;
            IPolyline2D polyline = (IPolyline2D)this.search_vector.get(j);
            PolylineManager manager = (PolylineManager)polyline.get(4096);
            if (this.search_manager == manager || (group = manager.getGroup()) != null && group.getFirst() != polyline) continue;
            if (group != null && group.regionInside) {
                return false;
            }
            RectangleSupplier rectangleSupplier = rs = polyline instanceof RectangleSupplier ? (RectangleSupplier)((Object)polyline) : null;
            if (rs != null && (ToolGeom2D.compareDistance(rs.getLeft(), this.rect1[0]) < 0 || ToolGeom2D.compareDistance(rs.getLower(), this.rect1[1]) < 0 || ToolGeom2D.compareDistance(rs.getRight(), this.rect1[2]) > 0 || ToolGeom2D.compareDistance(rs.getUpper(), this.rect1[3]) > 0) || (check = this.determinatePoint(xp = group != null ? group.x : ((IFigure2D)polyline.firstElement()).getX1(), yp = group != null ? group.y : ((IFigure2D)polyline.firstElement()).getY1())) != 3) continue;
            return true;
        }
        return false;
    }

    int determinatePoint(double xp, double yp) {
        double angleTotal = 0.0;
        double angle2 = 0.0;
        this.lastStatus = 2;
        double x = this.search_x = this.search_intersect.x;
        this.startX = this.search_x;
        double y = this.search_y = this.search_intersect.y;
        this.startY = this.search_y;
        this.search_intersectLast = this.search_intersect;
        this.search_type = 6;
        this.search_goForth = true;
        this.search_currentFigure = null;
        this.search_figure = this.search_intersect.figure;
        this.search_intersectNext = IntersectRegionSort.getNextNode(this.search_intersect, true);
        x = this.getX();
        y = this.getY();
        this.findNext(false, false);
        double angle1 = Math.atan2(y - yp, x - xp);
        int cnt = 0;
        while (this.findNext(false, false) != -1) {
            double angle;
            angle2 = Math.atan2(this.getY() - yp, this.getX() - xp);
            if (this.equalPoints(x, y, this.getX(), this.getY())) {
                return 5;
            }
            if (this.getType() == 1) {
                angle = angle2 - angle1;
                if (angle < -Math.PI) {
                    angle += Math.PI * 2;
                } else if (angle > Math.PI) {
                    angle -= Math.PI * 2;
                }
                if (Math.abs(Math.abs(angle) - Math.PI) <= 1.0E-8) {
                    return 5;
                }
            } else if (this.getType() == 2 || this.getType() == 3) {
                double distance = ToolGeom2D.getDistance(this.getXC(), this.getYC(), xp, yp);
                if (distance < this.getRadius()) {
                    angle = this.getType() == 2 && angle1 < angle2 ? angle2 - angle1 - Math.PI * 2 : (this.getType() == 3 && angle1 > angle2 ? Math.PI * 2 - angle1 - angle2 : angle2 - angle1);
                } else {
                    angle = angle2 - angle1;
                    if (angle < -Math.PI) {
                        angle += Math.PI * 2;
                    } else if (angle > Math.PI) {
                        angle -= Math.PI * 2;
                    }
                }
            } else {
                return 0;
            }
            angleTotal += angle;
            if (this.equalPoints(this.startX, this.startY, this.getX(), this.getY())) break;
            x = this.getX();
            y = this.getY();
            ++cnt;
            angle1 = angle2;
        }
        if (Math.abs(angleTotal) > 5.654866776461628) {
            return 3;
        }
        if (Math.abs(angleTotal) <= 0.01) {
            return 4;
        }
        return 0;
    }

    int searchAtIntersect(boolean setFlag) {
        IntersectRegionSort tmp = this.search_intersectNext.samePointsRoot;
        IPolyline2DCollection collection = tmp.figure.getParent().getParent();
        this.search_currentFigure = null;
        if (this.equalPoints(this.startX, this.startY, tmp.x, tmp.y)) {
            tmp = null;
        } else {
            if (!tmp.flag && (this.getSurface || tmp.getSurfaceCount() == 0) && tmp != this.search_intersectLast && (collection == this.collection1 && this.judgeLevel(tmp.getLevel(this.absLevel), this.level1, this.sign1) || collection == this.collection2 && this.judgeLevel(tmp.getLevel(this.absLevel), this.level2, this.sign2))) {
                this.search_goForth = true;
                this.lastStatus = 3;
                this.search_figure = tmp.figure;
                this.search_intersectLast = tmp;
                if (collection == this.collection1 || this.markSecondCollection) {
                    this.search_intersectLast.flag = setFlag;
                }
                this.search_intersectNext = IntersectRegionSort.getNextNode(this.search_intersectLast, true);
                return 3;
            }
            IntersectRegionSort tmpPrev = IntersectRegionSort.getPrevNode(tmp, true);
            if (!tmpPrev.flag && (this.getSurface || tmpPrev.getSurfaceCount() == 0) && tmpPrev != this.search_intersectLast && (collection == this.collection1 && this.judgeLevel(tmpPrev.getLevel(this.absLevel), this.level1, this.sign1) || collection == this.collection2 && this.judgeLevel(tmpPrev.getLevel(this.absLevel), this.level2, this.sign2))) {
                this.search_goForth = false;
                this.lastStatus = 3;
                this.search_figure = tmp.figure;
                if (this.equalPoints(this.search_x, this.search_y, this.search_figure.getX1(), this.search_figure.getY1())) {
                    this.search_figure = this.search_figure.getPrev() == null ? (IFigure2D)this.search_figure.getParent().lastElement() : (IFigure2D)this.search_figure.getPrev();
                }
                this.search_intersectLast = tmp;
                this.search_intersectNext = tmpPrev;
                if (collection == this.collection1 || this.markSecondCollection) {
                    this.search_intersectNext.flag = setFlag;
                }
                return 3;
            }
        }
        while (tmp != null) {
            IntersectRegionSort pair = tmp.pair.samePointsRoot;
            collection = pair.figure.getParent().getParent();
            if (!pair.flag && (this.getSurface || pair.getSurfaceCount() == 0) && pair != this.search_intersectLast && pair != this.search_intersectNext && (collection == this.collection1 && this.judgeLevel(pair.getLevel(this.absLevel), this.level1, this.sign1) || collection == this.collection2 && this.judgeLevel(pair.getLevel(this.absLevel), this.level2, this.sign2))) {
                this.search_goForth = true;
                this.lastStatus = 3;
                this.search_figure = pair.figure;
                if (this.equalPoints(this.search_x, this.search_y, this.search_figure.getX2(), this.search_figure.getY2())) {
                    this.search_figure = ToolGeomFigure2D.getNext(this.search_figure) == null ? (IFigure2D)this.search_figure.getParent().firstElement() : ToolGeomFigure2D.getNext(this.search_figure);
                }
                this.search_intersectLast = pair;
                this.search_intersectNext = IntersectRegionSort.getNextNode(this.search_intersectLast, true);
                if (collection == this.collection1 || this.markSecondCollection) {
                    this.search_intersectLast.flag = setFlag;
                }
                return 3;
            }
            IntersectRegionSort pairPrev = IntersectRegionSort.getPrevNode(pair, true);
            if (!pairPrev.flag && (this.getSurface || pairPrev.getSurfaceCount() == 0) && pairPrev != this.search_intersectLast && pairPrev != this.search_intersectNext && (collection == this.collection1 && this.judgeLevel(pairPrev.getLevel(this.absLevel), this.level1, this.sign1) || collection == this.collection2 && this.judgeLevel(pairPrev.getLevel(this.absLevel), this.level2, this.sign2))) {
                this.search_goForth = false;
                this.lastStatus = 3;
                this.search_figure = pair.figure;
                if (this.equalPoints(this.search_x, this.search_y, this.search_figure.getX1(), this.search_figure.getY1())) {
                    this.search_figure = this.search_figure.getPrev() == null ? (IFigure2D)this.search_figure.getParent().lastElement() : (IFigure2D)this.search_figure.getPrev();
                }
                this.search_intersectLast = pair;
                this.search_intersectNext = pairPrev;
                if (collection == this.collection1 || this.markSecondCollection) {
                    this.search_intersectNext.flag = setFlag;
                }
                return 3;
            }
            tmp = tmp.samePointsNext;
        }
        this.search_figure = null;
        this.search_intersectNext = null;
        this.search_intersectLast = null;
        this.lastStatus = -1;
        return -1;
    }
}

