/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.math.geom.logicaloperation;

import java.util.Vector;
import jp.kitec.math.geom.ToolGeom2D;
import jp.kitec.math.geom.datapassing.IPolyline2D;
import jp.kitec.math.geom.datapassing.IPolyline2DCollection;
import jp.kitec.math.geom.datapassing.plane.ToolPlane2D;
import jp.kitec.math.geom.datapassing.polylines.ToolGeomPolyline2D;
import jp.kitec.math.geom.logicaloperation.CrossPolylineGroup;
import jp.kitec.math.geom.logicaloperation.HierarchyStructure;
import jp.kitec.math.geom.logicaloperation.PolylineManager;
import jp.kitec.math.searches.regiontree.RectangleSupplier;

public abstract class InOutChecker {
    Vector vectorPolylines = new Vector(10, 10);
    double[] rect = new double[4];

    public boolean process(IPolyline2DCollection collection) {
        for (int i = 0; i < collection.size(); ++i) {
            IPolyline2D polyline1 = collection.get(i);
            PolylineManager manager1 = (PolylineManager)polyline1.get(4096);
            CrossPolylineGroup group1 = manager1.getGroup();
            if (group1 != null && group1.getFirst() != polyline1) continue;
            RectangleSupplier rs1 = polyline1 instanceof RectangleSupplier ? (RectangleSupplier)((Object)polyline1) : null;
            this.vectorPolylines.clear();
            ToolGeomPolyline2D.search(this.vectorPolylines, collection, polyline1);
            for (int j = 0; j < this.vectorPolylines.size(); ++j) {
                boolean result;
                RectangleSupplier rs2;
                IPolyline2D polyline2 = (IPolyline2D)this.vectorPolylines.get(j);
                if (polyline1 == polyline2) continue;
                PolylineManager manager2 = (PolylineManager)polyline2.get(4096);
                CrossPolylineGroup group2 = manager2.getGroup();
                if (group1 != null && group2 != null && group1 == group2) continue;
                RectangleSupplier rectangleSupplier = rs2 = polyline2 instanceof RectangleSupplier ? (RectangleSupplier)((Object)polyline2) : null;
                if (rs1 != null && rs2 != null && (ToolGeom2D.compareDistance(rs1.getLeft(), rs2.getLeft()) < 0 || ToolGeom2D.compareDistance(rs1.getRight(), rs2.getRight()) > 0 || ToolGeom2D.compareDistance(rs1.getLower(), rs2.getLower()) < 0 || ToolGeom2D.compareDistance(rs1.getUpper(), rs2.getUpper()) > 0) || !(result = this.determinate(polyline1, polyline2))) continue;
                if (group1 != null) {
                    group1.addIncludedLevel(manager2.isRegionInside() ? 1 : -1);
                } else {
                    manager1.addIncludedLevel(manager2.isRegionInside() ? 1 : -1);
                }
                if (manager1.isRegionInside()) {
                    manager2.setIncludeInnerRegionPlane(true);
                    continue;
                }
                manager2.setIncludeOuterRegionPlane(true);
            }
        }
        return true;
    }

    public boolean process(IPolyline2DCollection collection1, IPolyline2DCollection collection2) {
        double x1 = 0.0;
        double y1 = 0.0;
        double x2 = 0.0;
        double y2 = 0.0;
        for (int i = 0; i < collection1.size(); ++i) {
            RectangleSupplier rs1;
            IPolyline2D polyline1 = collection1.get(i);
            PolylineManager manager1 = (PolylineManager)polyline1.get(4096);
            CrossPolylineGroup group1 = manager1.getGroup();
            if (group1 != null && group1.getFirst() != polyline1) continue;
            RectangleSupplier rectangleSupplier = rs1 = polyline1 instanceof RectangleSupplier ? (RectangleSupplier)((Object)polyline1) : null;
            if (group1 != null) {
                x1 = group1.rect[0];
                y1 = group1.rect[1];
                x2 = group1.rect[2];
                y2 = group1.rect[3];
            } else if (rs1 != null) {
                x1 = rs1.getLeft();
                y1 = rs1.getLower();
                x2 = rs1.getRight();
                y2 = rs1.getUpper();
            }
            this.vectorPolylines.clear();
            ToolGeomPolyline2D.search(this.vectorPolylines, collection2, polyline1);
            for (int j = 0; j < this.vectorPolylines.size(); ++j) {
                boolean result;
                RectangleSupplier rs2;
                IPolyline2D polyline2 = (IPolyline2D)this.vectorPolylines.get(j);
                if (polyline1 == polyline2) continue;
                PolylineManager manager2 = (PolylineManager)polyline2.get(4096);
                CrossPolylineGroup group2 = manager2.getGroup();
                if (group1 != null && group2 != null && group1 == group2) continue;
                RectangleSupplier rectangleSupplier2 = rs2 = polyline2 instanceof RectangleSupplier ? (RectangleSupplier)((Object)polyline2) : null;
                if (rs1 != null && rs2 != null && (ToolGeom2D.compareDistance(x1, rs2.getLeft()) < 0 || ToolGeom2D.compareDistance(x2, rs2.getRight()) > 0 || ToolGeom2D.compareDistance(y1, rs2.getLower()) < 0 || ToolGeom2D.compareDistance(y2, rs2.getUpper()) > 0) || !(result = this.determinate(polyline1, polyline2))) continue;
                if (group1 != null) {
                    group1.addIncludedLevel(manager2.isRegionInside() ? 1 : -1);
                } else {
                    manager1.addIncludedLevel(manager2.isRegionInside() ? 1 : -1);
                }
                if (manager1.isRegionInside()) {
                    manager2.setIncludeInnerRegionPlane(true);
                    continue;
                }
                manager2.setIncludeOuterRegionPlane(true);
            }
        }
        return true;
    }

    public boolean processOfHierarchy(IPolyline2DCollection collection) {
        for (int i = 0; i < collection.size(); ++i) {
            IPolyline2D polyline1 = collection.get(i);
            HierarchyStructure hierarchy1 = (HierarchyStructure)polyline1.get(4098);
            if (hierarchy1 == null) {
                hierarchy1 = new HierarchyStructure(polyline1);
                polyline1.put(hierarchy1);
            }
            RectangleSupplier rs1 = polyline1 instanceof RectangleSupplier ? (RectangleSupplier)((Object)polyline1) : null;
            this.vectorPolylines.clear();
            ToolGeomPolyline2D.search(this.vectorPolylines, collection, polyline1);
            double dMinArea = Double.MAX_VALUE;
            HierarchyStructure hierarchyMin = null;
            for (int j = 0; j < this.vectorPolylines.size(); ++j) {
                double dArea;
                boolean result;
                RectangleSupplier rs2;
                IPolyline2D polyline2 = (IPolyline2D)this.vectorPolylines.get(j);
                if (polyline1 == polyline2) continue;
                HierarchyStructure hierarchy2 = (HierarchyStructure)polyline2.get(4098);
                if (hierarchy2 == null) {
                    hierarchy2 = new HierarchyStructure(polyline2);
                    polyline2.put(hierarchy2);
                }
                RectangleSupplier rectangleSupplier = rs2 = polyline2 instanceof RectangleSupplier ? (RectangleSupplier)((Object)polyline2) : null;
                if (rs1 != null && rs2 != null && (ToolGeom2D.compareDistance(rs1.getLeft(), rs2.getLeft()) < 0 || ToolGeom2D.compareDistance(rs1.getRight(), rs2.getRight()) > 0 || ToolGeom2D.compareDistance(rs1.getLower(), rs2.getLower()) < 0 || ToolGeom2D.compareDistance(rs1.getUpper(), rs2.getUpper()) > 0) || !(result = this.determinate(polyline1, polyline2))) continue;
                if (rs2 != null) {
                    dArea = (rs2.getUpper() - rs2.getLower()) * (rs2.getRight() - rs2.getLeft());
                } else {
                    ToolPlane2D.getFitRectangle(this.rect, polyline1);
                    dArea = (this.rect[2] - this.rect[0]) * (this.rect[3] - this.rect[1]);
                }
                if (!(dArea < dMinArea)) continue;
                dMinArea = dArea;
                hierarchyMin = hierarchy2;
            }
            if (hierarchyMin == null) continue;
            hierarchyMin.addChild(hierarchy1);
        }
        return true;
    }

    public abstract boolean determinate(IPolyline2D var1, IPolyline2D var2);
}

