/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.math.geom.datapassing.polylines;

import java.util.Vector;
import jp.kitec.math.algebra.AlgebraException;
import jp.kitec.math.geom.ToolGeom2D;
import jp.kitec.math.geom.datapassing.ICollectionEditable;
import jp.kitec.math.geom.datapassing.IFigure2D;
import jp.kitec.math.geom.datapassing.IFigure2DArc;
import jp.kitec.math.geom.datapassing.IFigureType;
import jp.kitec.math.geom.datapassing.IPolyline2D;
import jp.kitec.math.geom.datapassing.IPolyline2DCollection;
import jp.kitec.math.geom.datapassing.ISearchable;
import jp.kitec.math.geom.datapassing.PolylineEditable;
import jp.kitec.math.geom.datapassing.ToolGeomFigure2D;
import jp.kitec.math.geom.datapassing.complete.MPolyline;
import jp.kitec.math.geom.datapassing.plane.ToolPlane2D;
import jp.kitec.math.searches.regiontree.RectangleSupplier;
import jp.kitec.math.searches.regiontree.RegionTreeBuilder;

public class ToolGeomPolyline2D
extends ToolPlane2D {
    static final double SearchTolerance = 1.0E-8;

    public static boolean isClosed(IPolyline2D polyline) {
        IFigure2D figure1 = (IFigure2D)polyline.firstElement();
        IFigure2D figure2 = (IFigure2D)polyline.lastElement();
        return ToolGeom2D.equalPoints(figure1.getX1(), figure1.getY1(), figure2.getX2(), figure2.getY2());
    }

    public static boolean makeTree(IPolyline2DCollection collection) {
        return ToolGeomPolyline2D.makeTree(collection, new RegionTreeBuilder());
    }

    public static boolean makeTree(IPolyline2DCollection collection, RegionTreeBuilder rtb) {
        if (!(collection instanceof ISearchable)) {
            return false;
        }
        ISearchable search = (ISearchable)((Object)collection);
        search.makeTree(rtb);
        return true;
    }

    public static boolean makeTree(IPolyline2D polyline) {
        return ToolGeomPolyline2D.makeTree(polyline, new RegionTreeBuilder());
    }

    public static boolean makeTree(IPolyline2D polyline, RegionTreeBuilder rtb) {
        if (!(polyline instanceof ISearchable)) {
            return false;
        }
        ISearchable search = (ISearchable)((Object)polyline);
        search.makeTree(rtb);
        return true;
    }

    public static int search(Vector vectorOut, Object searchable, double left, double lower, double right, double upper) {
        return ToolGeomPolyline2D.search(vectorOut, searchable, left, lower, right, upper, 1.0E-8);
    }

    public static int search(Vector vectorOut, Object searchable, double left, double lower, double right, double upper, double searchTolerance) {
        int num;
        block3: {
            block4: {
                block2: {
                    num = vectorOut.size();
                    if (!(searchable instanceof ISearchable)) break block2;
                    ISearchable se = (ISearchable)searchable;
                    se.search(vectorOut, left - searchTolerance, lower - searchTolerance, right + searchTolerance, upper + searchTolerance);
                    break block3;
                }
                if (!(searchable instanceof IPolyline2DCollection)) break block4;
                IPolyline2DCollection collection = (IPolyline2DCollection)searchable;
                for (int i = 0; i < collection.size(); ++i) {
                    IPolyline2D polyline = collection.get(i);
                    vectorOut.add(polyline);
                }
                break block3;
            }
            if (!(searchable instanceof IPolyline2D)) break block3;
            IPolyline2D polyline = (IPolyline2D)searchable;
            IFigure2D figure = (IFigure2D)polyline.firstElement();
            while (figure != null) {
                vectorOut.add(figure);
                figure = ToolGeomFigure2D.getNext(figure);
            }
        }
        return vectorOut.size() - num;
    }

    public static int search(Vector vectorOut, Object searchable, Object rectangleSupplier) {
        return ToolGeomPolyline2D.search(vectorOut, searchable, rectangleSupplier, 1.0E-8);
    }

    public static int search(Vector vectorOut, Object searchable, Object rectangleSupplier, double searchTolerance) {
        int num;
        block3: {
            block4: {
                block2: {
                    num = vectorOut.size();
                    if (!(searchable instanceof ISearchable) || !(rectangleSupplier instanceof RectangleSupplier)) break block2;
                    ISearchable se = (ISearchable)searchable;
                    RectangleSupplier rs = (RectangleSupplier)rectangleSupplier;
                    se.search(vectorOut, rs.getLeft() - searchTolerance, rs.getLower() - searchTolerance, rs.getRight() + searchTolerance, rs.getUpper() + searchTolerance);
                    break block3;
                }
                if (!(searchable instanceof IPolyline2DCollection)) break block4;
                IPolyline2DCollection collection = (IPolyline2DCollection)searchable;
                for (int i = 0; i < collection.size(); ++i) {
                    IPolyline2D polylineTmp = collection.get(i);
                    vectorOut.add(polylineTmp);
                }
                break block3;
            }
            if (!(searchable instanceof IPolyline2D)) break block3;
            IPolyline2D polyline = (IPolyline2D)searchable;
            IFigure2D figure = (IFigure2D)polyline.firstElement();
            while (figure != null) {
                vectorOut.add(figure);
                figure = ToolGeomFigure2D.getNext(figure);
            }
        }
        return vectorOut.size() - num;
    }

    public static int getIntersectPointsWithLine(double[] result, IPolyline2D polyline, double x1, double y1, double x2, double y2) throws AlgebraException {
        int j;
        int i;
        double[] tmp = new double[8];
        int out = 0;
        IFigure2D figure = (IFigure2D)polyline.firstElement();
        while (figure != null) {
            int num;
            switch (figure.getType()) {
                case 1: {
                    num = ToolGeomPolyline2D.getIntersectPoints(tmp, figure.getX1(), figure.getY1(), figure.getX2(), figure.getY2(), x1, y1, x2, y2) ? 1 : 0;
                    break;
                }
                case 2: 
                case 3: {
                    IFigure2DArc arc = (IFigure2DArc)figure;
                    num = ToolGeomPolyline2D.getIntersectPoints(tmp, x1, y1, x2, y2, arc.getX1(), arc.getY1(), arc.getX2(), arc.getY2(), arc.getCX(), arc.getCY(), arc.getRadius(), arc.isCw());
                    break;
                }
                default: {
                    num = 0;
                }
            }
            block5: for (i = 0; i < num; ++i) {
                for (j = 0; j < out; ++j) {
                    if (ToolGeomPolyline2D.equalPoints(tmp[i * 2], tmp[i * 2 + 1], result[j * 2], result[j * 2 + 1])) break block5;
                }
                result[out * 2] = tmp[i * 2];
                result[out * 2 + 1] = tmp[i * 2 + 1];
                ++out;
            }
            figure = ToolGeomFigure2D.getNext(figure);
        }
        double[] parameters = new double[out];
        for (i = 0; i < out; ++i) {
            parameters[i] = ToolGeom2D.getParameter(result[i * 2], result[i * 2 + 1], x1, y1, x2, y2);
        }
        for (i = 0; i < out; ++i) {
            for (j = 0; j < out - 1; ++j) {
                if (!(parameters[j] > parameters[j + 1])) continue;
                double dTmp = result[j * 2];
                result[j * 2] = result[(j + 1) * 2];
                result[(j + 1) * 2] = dTmp;
                dTmp = result[j * 2 + 1];
                result[j * 2 + 1] = result[(j + 1) * 2 + 1];
                result[(j + 1) * 2 + 1] = dTmp;
                dTmp = parameters[j];
                parameters[j] = parameters[j + 1];
                parameters[j + 1] = dTmp;
            }
        }
        return out;
    }

    public static int getIntersectPointsWithLinear(double[] result, IPolyline2D polyline, double x1, double y1, double x2, double y2) throws AlgebraException {
        double[] tmp = new double[8];
        int out = 0;
        IFigure2D figure = (IFigure2D)polyline.firstElement();
        while (figure != null) {
            int num;
            switch (figure.getType()) {
                case 1: {
                    num = ToolGeomPolyline2D.getIntersectPointsExtension(tmp, figure.getX1(), figure.getY1(), figure.getX2(), figure.getY2(), x1, y1, x2, y2) ? 1 : 0;
                    break;
                }
                case 2: 
                case 3: {
                    IFigure2DArc arc = (IFigure2DArc)figure;
                    num = ToolGeomPolyline2D.getIntersectPointsExtension(tmp, x1, y1, x2, y2, arc.getCX(), arc.getCY(), arc.getRadius());
                    break;
                }
                default: {
                    num = 0;
                }
            }
            for (int i = 0; i < num; ++i) {
                if (!ToolGeomFigure2D.checkPointOnWithoutDistance(tmp[i * 2], tmp[i * 2 + 1], figure)) continue;
                result[out * 2] = tmp[i * 2];
                result[out * 2 + 1] = tmp[i * 2 + 1];
                ++out;
            }
            figure = ToolGeomFigure2D.getNext(figure);
        }
        return out;
    }

    public static boolean getFewestLinesBetweenTwoPolylines(IPolyline2D polylineOut, IPolyline2D polylineRight, IPolyline2D polylineLeft, double dFirstX, double dFirstY, double dEndX, double dEndY, int division, boolean bAscend, boolean onlyOne) throws AlgebraException {
        IFigure2D figure;
        double divisionTmp;
        MPolyline polylineTmp = new MPolyline(null, 0);
        double min = 100.0;
        if (!(polylineOut instanceof PolylineEditable)) {
            return false;
        }
        PolylineEditable pe = (PolylineEditable)((Object)polylineOut);
        if ((double)division == 0.0) {
            return ToolGeomPolyline2D.getFewestLinesBetweenTwoPolylines_(polylineOut, polylineRight, polylineLeft, dFirstX, dFirstY, dEndX, dEndY, divisionTmp, bAscend, onlyOne);
        }
        for (divisionTmp = (double)division; divisionTmp > 0.0; divisionTmp -= (double)division / 10.0) {
            ToolGeomPolyline2D.getFewestLinesBetweenTwoPolylines_(polylineTmp, polylineRight, polylineLeft, dFirstX, dFirstY, dEndX, dEndY, divisionTmp, bAscend, onlyOne);
            double lengthMax = 0.0;
            double lengthAverage = 0.0;
            double lengthMin = Double.MAX_VALUE;
            figure = polylineTmp.firstElement();
            while (figure != null) {
                double length = ToolGeomFigure2D.getLength(figure);
                lengthAverage += length;
                if (length < lengthMin) {
                    lengthMin = length;
                }
                if (length > lengthMax) {
                    lengthMax = length;
                }
                figure = ToolGeomFigure2D.getNext(figure);
            }
            if (lengthMin > (lengthAverage /= (double)polylineTmp.size()) / 2.0 && lengthMin > lengthMax / 3.0 || divisionTmp < (double)division / 10.0) break;
            polylineTmp.removeAll();
        }
        if (polylineOut.size() == 0) {
            pe.setFirstX(polylineTmp.getFirstX());
            pe.setFirstY(polylineTmp.getFirstY());
        }
        figure = polylineTmp.firstElement();
        while (figure != null) {
            IFigure2D figureOut = pe.add(figure.getType());
            figureOut.setX2(figure.getX2());
            figureOut.setY2(figure.getY2());
            if (IFigureType.isArc(figureOut.getType())) {
                IFigure2DArc arc = (IFigure2DArc)figure;
                IFigure2DArc arcOut = (IFigure2DArc)figureOut;
                arcOut.setCX(arc.getCX());
                arcOut.setCY(arc.getCY());
                arcOut.setRadius(arc.getRadius());
            }
            figure = ToolGeomFigure2D.getNext(figure);
        }
        return true;
    }

    public static boolean getFewestLinesBetweenTwoPolylines_(IPolyline2D polylineOut, IPolyline2D polylineRight, IPolyline2D polylineLeft, double dFirstX, double dFirstY, double dEndX, double dEndY, double division, boolean bAscend, boolean onlyOne) throws AlgebraException {
        IFigure2D figureOut;
        IPolyline2D polylineBase = null;
        IPolyline2D polylineAnother = null;
        IFigure2D[] figureTmp = new IFigure2D[1];
        double[] intersect = new double[10];
        double lastX = dFirstX;
        double lastY = dFirstY;
        double tmpX = 0.0;
        double tmpY = 0.0;
        double parameter = 0.0;
        double parameterPrev = -1.0;
        double parameterEnd = -1.0;
        int iAdd = bAscend ? 1 : -1;
        boolean bRoop = true;
        boolean check = false;
        boolean bCw = false;
        if (polylineRight.size() <= 2 || polylineLeft.size() <= 2 || ToolGeomPolyline2D.equalPoints(dFirstX, dFirstY, dEndX, dEndY)) {
            return false;
        }
        if (!(polylineOut instanceof PolylineEditable)) {
            return false;
        }
        PolylineEditable pe = (PolylineEditable)((Object)polylineOut);
        double angle = 0.0;
        IFigure2D figure = (IFigure2D)polylineRight.firstElement();
        IFigure2D figure2 = ToolGeomFigure2D.getNext(figure);
        while (figure2 != null) {
            angle += ToolGeomFigure2D.getAngleTwoTangentsOfFiguresAtJoint(figure, figure2);
            figure = figure2;
            figure2 = ToolGeomFigure2D.getNext(figure2);
        }
        if (angle < 0.0) {
            bCw = true;
            polylineBase = polylineLeft;
            polylineAnother = polylineRight;
        } else {
            bCw = false;
            polylineBase = polylineRight;
            polylineAnother = polylineLeft;
        }
        if (!bAscend) {
            bCw = !bCw;
        }
        figure = (IFigure2D)polylineBase.firstElement();
        while (figure != null) {
            if (ToolGeomFigure2D.getPerpendicularPoint(intersect, dFirstX, dFirstY, figure) && ToolGeomFigure2D.checkPointOn(intersect[0], intersect[1], figure)) {
                parameterPrev = ToolGeomFigure2D.getParameter(dFirstX, dFirstY, figure);
                parameterPrev += (double)figure.getIndex();
            }
            if (ToolGeomFigure2D.getPerpendicularPoint(intersect, dEndX, dEndY, figure) && ToolGeomFigure2D.checkPointOn(intersect[0], intersect[1], figure)) {
                parameterEnd = ToolGeomFigure2D.getParameter(dEndX, dEndY, figure);
                parameterEnd += (double)figure.getIndex();
            }
            figure = ToolGeomFigure2D.getNext(figure);
        }
        if (parameterEnd < 0.0) {
            double d = parameterEnd = bAscend ? (double)(polylineBase.size() + 1) : 0.0;
        }
        if (parameterPrev < 0.0) {
            parameterPrev = bAscend ? 0.0 : (double)(polylineBase.size() + 1);
        }
        double divide = division != 0.0 ? Math.abs(parameterEnd - parameterPrev) / division : 0.0;
        check = false;
        while (bRoop) {
            double angleFittest = bCw ? -10.0 : 10.0;
            ToolGeomPolyline2D.getMinimumDistance(figureTmp, polylineAnother, lastX, lastY);
            figure = figureTmp[0];
            double anglePrev = 0.0;
            int i = 0;
            while (figure != null) {
                double y;
                double x;
                if (bAscend) {
                    x = figure.getX2();
                    y = figure.getY2();
                } else {
                    x = figure.getX1();
                    y = figure.getY1();
                }
                angle = Math.atan2(y - lastY, x - lastX);
                if (i > 0 && (anglePrev < -1.5707963267948966 && angle > 1.5707963267948966 || anglePrev > 1.5707963267948966 && angle < -1.5707963267948966)) {
                    angle += angle > 1.5707963267948966 ? Math.PI * -2 : Math.PI * 2;
                }
                if (bCw && angle > angleFittest || !bCw && angle < angleFittest) {
                    tmpX = x;
                    tmpY = y;
                    angleFittest = angle;
                }
                anglePrev = angle;
                figure = bAscend ? ToolGeomFigure2D.getNext(figure) : (IFigure2D)figure.getPrev();
                ++i;
            }
            if (angleFittest < -Math.PI && angleFittest > Math.PI) break;
            figure = (IFigure2D)polylineBase.firstElement();
            while (figure != null) {
                switch (figure.getType()) {
                    case 1: {
                        check = ToolGeomPolyline2D.getIntersectPointsExtension(intersect, lastX, lastY, tmpX, tmpY, figure.getX1(), figure.getY1(), figure.getX2(), figure.getY2());
                        break;
                    }
                    case 2: 
                    case 3: {
                        IFigure2DArc arc = (IFigure2DArc)figure;
                        check = ToolGeomPolyline2D.getIntersectPointsExtension(intersect, lastX, lastY, tmpX, tmpY, arc.getCX(), arc.getCY(), arc.getRadius()) > 0;
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                if (check) {
                    check = ToolGeomFigure2D.checkPointOnWithoutDistance(intersect[0], intersect[1], figure);
                }
                if (check) {
                    parameter = ToolGeomFigure2D.getParameter(intersect[0], intersect[1], figure);
                    if (bAscend && (parameter += (double)figure.getIndex()) - parameterPrev > 1.0E-4 || !bAscend && parameter - parameterPrev < -1.0E-4) break;
                    check = false;
                }
                figure = ToolGeomFigure2D.getNext(figure);
            }
            if (!check) break;
            bRoop = bAscend ? parameter < parameterEnd : parameter > parameterEnd;
            double length = Math.abs((bRoop ? parameter : parameterEnd) - parameterPrev);
            if (divide != 0.0 && length > divide) {
                figureOut = (IFigure2D)polylineOut.lastElement();
                parameter = parameterPrev + (bAscend ? divide : -divide);
                figure = (IFigure2D)polylineBase.firstElement();
                while (figure != null) {
                    if (figure.getIndex() == (int)parameter) {
                        ToolGeomFigure2D.getPointFromParameter(intersect, figure, parameter - (double)figure.getIndex());
                        break;
                    }
                    figure = ToolGeomFigure2D.getNext(figure);
                }
            }
            if (bRoop) {
                lastX = intersect[0];
                lastY = intersect[1];
            } else {
                lastX = dEndX;
                lastY = dEndY;
            }
            figureOut = pe.add(1);
            if (polylineOut.size() == 1) {
                figureOut.setX1(dFirstX);
                figureOut.setY1(dFirstY);
            }
            figureOut.setX2(lastX);
            figureOut.setY2(lastY);
            parameterPrev = parameter;
            if (!onlyOne) continue;
        }
        if (!onlyOne) {
            int num;
            figureOut = (IFigure2D)polylineOut.lastElement();
            if (figureOut != null && !ToolGeomPolyline2D.equalPoints(dEndX, dEndY, figureOut.getX2(), figureOut.getY2())) {
                figureOut = pe.add(1);
                figureOut.setX2(dEndX);
                figureOut.setY2(dEndY);
            }
            if ((num = ToolGeomPolyline2D.getIntersectPointsWithLine(intersect, polylineAnother, (figureOut = (IFigure2D)polylineOut.lastElement()).getX1(), figureOut.getY1(), figureOut.getX2(), figureOut.getY2())) > 0) {
                parameter = parameterEnd;
                figure = (IFigure2D)polylineBase.firstElement();
                while (figure != null) {
                    if (figure.getIndex() == (int)parameter) {
                        ToolGeomFigure2D.getPointFromParameter(intersect, figure, parameter - (double)figure.getIndex());
                        figureOut.setX2(intersect[0]);
                        figureOut.setY2(intersect[1]);
                        break;
                    }
                    figure = ToolGeomFigure2D.getNext(figure);
                }
                if (parameter == (double)(polylineBase.size() + 1)) {
                    figure = (IFigure2D)polylineBase.lastElement();
                    figureOut.setX2(figure.getX2());
                    figureOut.setY2(figure.getY2());
                }
            }
        } else if (ToolGeomPolyline2D.equalPoints(dFirstX, dFirstY, lastX, lastY)) {
            if (polylineOut.size() == 0) {
                figureOut = pe.add(1);
                figureOut.setX1(dFirstX);
                figureOut.setY1(dFirstY);
                figureOut.setX2(dEndX);
                figureOut.setY2(dEndY);
            }
            return false;
        }
        return true;
    }

    public static boolean getFewestLinesBetweenTwoPolylines(IPolyline2D polylineOut, IPolyline2D polylineRight, IPolyline2D polylineLeft, double dFirstX, double dFirstY, double dEndX, double dEndY, boolean bAscend) throws AlgebraException {
        IFigure2DArc arcOut;
        IFigure2DArc arc;
        IFigure2D figureOut;
        double length2;
        double length1;
        IFigure2D figure;
        MPolyline polylineOut1 = new MPolyline(null, 0);
        MPolyline polylineOut2 = new MPolyline(null, 0);
        double x1 = dFirstX;
        double y1 = dFirstY;
        double x2 = dEndX;
        double y2 = dEndY;
        double tolerance = 0.01;
        boolean out = false;
        if (!(polylineOut instanceof PolylineEditable)) {
            return false;
        }
        PolylineEditable pe = (PolylineEditable)((Object)polylineOut);
        while (ToolGeomPolyline2D.getFewestLinesBetweenTwoPolylines(polylineOut1, polylineRight, polylineLeft, x1, y1, x2, y2, 0, bAscend, true)) {
            figure = polylineOut1.lastElement();
            x1 = figure.getX2();
            if (!ToolGeomPolyline2D.getFewestLinesBetweenTwoPolylines(polylineOut2, polylineRight, polylineLeft, x2, y2, x1, y1 = figure.getY2(), 0, !bAscend, true)) break;
            figure = polylineOut2.lastElement();
            x2 = figure.getX2();
            y2 = figure.getY2();
        }
        if (polylineOut1.size() != polylineOut2.size() && polylineOut2.size() > 0) {
            figure = (IFigure2D)polylineOut1.lastElement().getPrev();
            length1 = ToolGeomFigure2D.getLength(figure);
            figure = polylineOut2.lastElement();
            length2 = ToolGeomFigure2D.getLength(figure);
            figure = polylineOut1.lastElement();
            double length3 = ToolGeomFigure2D.getLength(figure);
            if (ToolGeomPolyline2D.compare(length1, length2, tolerance) != 0 || length3 < length1 * 0.5 || length3 > length1 * 2.0) {
                if (polylineOut1.size() > 0) {
                    polylineOut1.remove(polylineOut1.lastElement());
                }
                if (polylineOut1.size() > 0) {
                    polylineOut1.remove(polylineOut1.lastElement());
                }
                if (polylineOut2.size() > 0) {
                    polylineOut2.remove(polylineOut2.lastElement());
                }
                if ((figure = polylineOut1.lastElement()) != null) {
                    x1 = figure.getX2();
                    y1 = figure.getY2();
                } else {
                    x1 = dFirstX;
                    y1 = dFirstY;
                }
                figure = polylineOut2.lastElement();
                if (figure != null) {
                    x2 = figure.getX2();
                    y2 = figure.getY2();
                } else {
                    x2 = dEndX;
                    y2 = dEndY;
                }
                ToolGeomPolyline2D.getFewestLinesBetweenTwoPolylines(polylineOut1, polylineRight, polylineLeft, x1, y1, x2, y2, 3, bAscend, false);
            }
        } else if (polylineOut1.size() > 0 && polylineOut2.size() > 0 && polylineOut1.size() == polylineOut2.size()) {
            figure = polylineOut1.lastElement();
            length1 = ToolGeomFigure2D.getLength(figure);
            if (ToolGeomPolyline2D.compare(length1, length2 = ToolGeomFigure2D.getLength(figure = polylineOut2.lastElement()), tolerance) != 0) {
                polylineOut1.remove(polylineOut1.lastElement());
                polylineOut2.remove(polylineOut2.lastElement());
                figure = polylineOut1.lastElement();
                if (figure != null) {
                    x1 = figure.getX2();
                    y1 = figure.getY2();
                } else {
                    x1 = dFirstX;
                    y1 = dFirstY;
                }
                figure = polylineOut2.lastElement();
                if (figure != null) {
                    x2 = figure.getX2();
                    y2 = figure.getY2();
                } else {
                    x2 = dEndX;
                    y2 = dEndY;
                }
                ToolGeomPolyline2D.getFewestLinesBetweenTwoPolylines(polylineOut1, polylineRight, polylineLeft, x1, y1, x2, y2, 2, bAscend, false);
            }
        }
        if (polylineOut.size() == 0) {
            pe.setFirstX(polylineOut1.getFirstX());
            pe.setFirstY(polylineOut1.getFirstY());
        }
        figure = polylineOut1.firstElement();
        while (figure != null) {
            figureOut = pe.add(figure.getType());
            switch (figureOut.getType()) {
                case 2: 
                case 3: {
                    arc = (IFigure2DArc)figure;
                    arcOut = (IFigure2DArc)figureOut;
                    arcOut.setCX(arc.getCX());
                    arcOut.setCY(arc.getCY());
                    arcOut.setRadius(arc.getRadius());
                }
            }
            figureOut.setX2(figure.getX2());
            figureOut.setY2(figure.getY2());
            figure = ToolGeomFigure2D.getNext(figure);
        }
        for (figure = polylineOut2.lastElement(); figure != null; figure = (IFigure2D)figure.getPrev()) {
            figureOut = pe.add(IFigureType.getReverseType(figure.getType()));
            switch (figureOut.getType()) {
                case 2: 
                case 3: {
                    arc = (IFigure2DArc)figure;
                    arcOut = (IFigure2DArc)figureOut;
                    arcOut.setCX(arc.getCX());
                    arcOut.setCY(arc.getCY());
                    arcOut.setRadius(arc.getRadius());
                }
            }
            figureOut.setX2(figure.getX1());
            figureOut.setY2(figure.getY1());
        }
        return true;
    }

    public static boolean connectPolylines(IPolyline2DCollection collectionIn, double tolerance, boolean extensionalFigureOnly) {
        double[] point = new double[2];
        if (!(collectionIn instanceof ICollectionEditable)) {
            return false;
        }
        ICollectionEditable ce = (ICollectionEditable)((Object)collectionIn);
        block0: for (int i = 0; i < collectionIn.size(); ++i) {
            IPolyline2D polyline = collectionIn.get(i);
            PolylineEditable pe = (PolylineEditable)((Object)polyline);
            IFigure2D figure = (IFigure2D)polyline.lastElement();
            for (int j = 0; j < collectionIn.size(); ++j) {
                double distance;
                IPolyline2D polylineOut = collectionIn.get(j);
                if (polyline == polylineOut) continue;
                IFigure2D figure2 = (IFigure2D)polylineOut.firstElement();
                if (ToolGeom2D.getDistance(figure.getX2(), figure.getY2(), figure2.getX1(), figure2.getY1()) > tolerance) continue;
                ToolGeomFigure2D.getPerpendicularPoint(point, figure2.getX2(), figure2.getY2(), figure);
                double parameter = ToolGeomFigure2D.getParameter(point[0], point[1], figure);
                if (parameter <= 1.0 || !((distance = ToolGeom2D.getDistance(point[0], point[1], figure2.getX2(), figure2.getY2())) <= tolerance)) continue;
                figure.setX2(figure2.getX2());
                figure.setY2(figure2.getY2());
                for (figure2 = (IFigure2D)figure2.getNext(); figure2 != null; figure2 = (IFigure2D)figure2.getNext()) {
                    IFigure2D figureOut = pe.add(figure2.getType());
                    figureOut.setX2(figure2.getX2());
                    figureOut.setY2(figure2.getY2());
                    if (!IFigureType.isArc(figure2.getType())) continue;
                    IFigure2DArc arcOut = (IFigure2DArc)figureOut;
                    IFigure2DArc arc = (IFigure2DArc)figure2;
                    arcOut.setCX(arc.getCX());
                    arcOut.setCY(arc.getCY());
                    arcOut.setRadius(arc.getRadius());
                    arcOut.setCw(arc.isCw());
                }
                ce.remove(polylineOut);
                --i;
                continue block0;
            }
        }
        return true;
    }

    public static double getDistance(IPolyline2D polylineIn, double dx, double dy) {
        double distanceMin = Double.MAX_VALUE;
        double[] point = new double[2];
        for (IFigure2D figure = (IFigure2D)polylineIn.firstElement(); figure != null; figure = (IFigure2D)figure.getNext()) {
            ToolGeomFigure2D.getPerpendicularPoint(point, dx, dy, figure);
            double distance = ToolGeomPolyline2D.getDistance(dx, dy, point[0], point[1]);
            if (!ToolGeomFigure2D.checkPointOnWithoutDistance(dx, dy, figure) || !(distance < distanceMin)) continue;
            distanceMin = distance;
        }
        return distanceMin;
    }
}

