/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.math.geom.datapassing.plane;

import jp.kitec.math.geom.ToolGeom2D;
import jp.kitec.math.geom.ToolJudge2D;
import jp.kitec.math.geom.datapassing.IFigure2D;
import jp.kitec.math.geom.datapassing.IFigure2DArc;
import jp.kitec.math.geom.datapassing.IPolyline2D;
import jp.kitec.math.geom.datapassing.IPolyline2DCollection;
import jp.kitec.math.geom.datapassing.ToolGeomFigure2D;

public class ToolPlane2D
extends ToolGeom2D {
    public static final int ERROR = -1;
    public static final int FAIL = 0;
    public static final int CW = 1;
    public static final int CCW = 2;
    public static final int INSIDE = 3;
    public static final int OUTSIDE = 4;
    public static final int ONFIGURE = 5;

    public static double findArea(IPolyline2D polyline, boolean cw) {
        IFigure2D figureStart = (IFigure2D)polyline.firstElement();
        IFigure2D figureEnd = (IFigure2D)polyline.lastElement();
        if (figureStart.getX1() != figureEnd.getX2() || figureStart.getY1() != figureEnd.getY2()) {
            return 0.0;
        }
        double dArcArea = 0.0;
        double dLineArea = 0.0;
        IFigure2D figure = figureStart;
        while (figure != null) {
            dLineArea += figure.getX1() * figure.getY2() - figure.getX2() * figure.getY1();
            if (figure.getType() == 2 || figure.getType() == 3) {
                IFigure2DArc arc = (IFigure2DArc)figure;
                double dSegmentArea = ToolGeomFigure2D.findAreaOfSegment(arc);
                dArcArea = arc.isCw() ? (dArcArea += cw ? dSegmentArea : -dSegmentArea) : (dArcArea += !cw ? dSegmentArea : -dSegmentArea);
            }
            figure = ToolGeomFigure2D.getNext(figure);
        }
        dLineArea = Math.abs(dLineArea / 2.0);
        return dLineArea + dArcArea;
    }

    public static int getDirection(IPolyline2D polyline) {
        double dRelatedAngle = 0.0;
        boolean bRoop = true;
        IFigure2D figure1 = (IFigure2D)polyline.lastElement();
        IFigure2D figure2 = (IFigure2D)polyline.firstElement();
        while (figure2 != null) {
            block8: {
                double dAngle;
                block7: {
                    block6: {
                        if (figure2.getType() != 2 && figure2.getType() != 3) break block6;
                        dAngle = ToolGeomFigure2D.getAngleOfArc((IFigure2DArc)figure2);
                        dRelatedAngle += dAngle;
                        break block7;
                    }
                    if (ToolGeom2D.equalPoints(figure2.getX1(), figure2.getY1(), figure2.getX2(), figure2.getY2())) break block8;
                }
                dAngle = ToolGeomFigure2D.getAngleTwoTangentsOfFiguresAtJoint(figure1, figure2);
                if (ToolPlane2D.compare(Math.abs(dAngle), Math.PI, 1.0E-8) == 0) {
                    return -1;
                }
                dRelatedAngle += dAngle;
                figure1 = figure2;
            }
            figure2 = ToolGeomFigure2D.getNext(figure2);
        }
        while (6.303185307179586 < Math.abs(dRelatedAngle)) {
            dRelatedAngle += dRelatedAngle > 0.0 ? Math.PI * -2 : Math.PI * 2;
        }
        int ubDirection = ToolPlane2D.compare(dRelatedAngle, Math.PI * 2, 0.01) == 0 ? 2 : (ToolPlane2D.compare(dRelatedAngle, Math.PI * -2, 0.01) == 0 ? 1 : 0);
        return ubDirection;
    }

    public static int determinatePoint(IPolyline2DCollection collection, double x, double y) {
        IPolyline2D polyline;
        int result = 4;
        for (int i = 0; i < collection.size() && (result = ToolPlane2D.determinatePoint(polyline = collection.get(i), x, y)) != 3 && result != 5; ++i) {
        }
        return result;
    }

    public static int determinatePoint(IPolyline2D polyline, double x, double y) {
        IFigure2D figure = (IFigure2D)polyline.firstElement();
        double angleTotal = 0.0;
        double angle2 = 0.0;
        if (ToolJudge2D.equalPoints(x, y, figure.getX1(), figure.getY1())) {
            return 5;
        }
        double angle1 = Math.atan2(figure.getY1() - y, figure.getX1() - x);
        while (figure != null) {
            double angle;
            angle2 = Math.atan2(figure.getY2() - y, figure.getX2() - x);
            if (ToolJudge2D.equalPoints(x, y, figure.getX2(), figure.getY2())) {
                return 5;
            }
            if (figure.getType() == 1) {
                angle = angle2 - angle1;
                if (angle < -Math.PI) {
                    angle += Math.PI * 2;
                } else if (angle > Math.PI) {
                    angle -= Math.PI * 2;
                }
                if (Math.abs(Math.abs(angle) - Math.PI) <= 1.0E-8) {
                    return 5;
                }
            } else if (figure.getType() == 2 || figure.getType() == 3) {
                IFigure2DArc arc = (IFigure2DArc)figure;
                double distance = ToolPlane2D.getDistance(arc.getCX(), arc.getCY(), x, y);
                if (distance < arc.getRadius()) {
                    angle = arc.isCw() && angle1 < angle2 ? angle2 - angle1 - Math.PI * 2 : (!arc.isCw() && angle1 > angle2 ? Math.PI * 2 - angle1 + angle2 : angle2 - angle1);
                } else {
                    angle = angle2 - angle1;
                    if (angle < -Math.PI) {
                        angle += Math.PI * 2;
                    } else if (angle > Math.PI) {
                        angle -= Math.PI * 2;
                    }
                }
            } else {
                return 0;
            }
            angleTotal += angle;
            figure = ToolGeomFigure2D.getNext(figure);
            angle1 = angle2;
        }
        if (Math.abs(angleTotal) > 5.654866776461628) {
            return 3;
        }
        if (Math.abs(angleTotal) <= 0.01) {
            return 4;
        }
        return 0;
    }

    public static int determinatePoint(double[] points, double x, double y, double tolerance) {
        double angleTotal = 0.0;
        double angle2 = 0.0;
        double[] pointTmp = new double[2];
        if (ToolJudge2D.equalPoints(x, y, points[0], points[1])) {
            return 5;
        }
        double preX = points[points.length - 2];
        double preY = points[points.length - 1];
        double angle1 = Math.atan2(preY - y, preX - x);
        int i = 0;
        while (i + 1 < points.length) {
            angle2 = Math.atan2(points[i + 1] - y, points[i] - x);
            ToolPlane2D.getPerpendicularPoint(pointTmp, x, y, preX, preY, points[i], points[i + 1]);
            double distance = ToolPlane2D.getDistance(x, y, pointTmp[0], pointTmp[1]);
            if (distance <= tolerance && ToolPlane2D.checkPointOnLinearWithoutDistance(pointTmp[0], pointTmp[1], preX, preY, points[i], points[i + 1])) {
                return 5;
            }
            if (ToolJudge2D.equalPoints(x, y, points[i], points[i + 1])) {
                return 5;
            }
            double angle = angle2 - angle1;
            if (angle < -Math.PI) {
                angle += Math.PI * 2;
            } else if (angle > Math.PI) {
                angle -= Math.PI * 2;
            }
            if (Math.abs(Math.abs(angle) - Math.PI) <= 1.0E-8) {
                return 5;
            }
            angleTotal += angle;
            preX = points[i];
            preY = points[i + 1];
            i += 2;
            angle1 = angle2;
        }
        if (Math.abs(angleTotal) > 5.654866776461628) {
            return 3;
        }
        if (Math.abs(angleTotal) <= 0.01) {
            return 4;
        }
        return 0;
    }

    public static void getGravityPoint(double[] gpoint, IPolyline2D polyline) {
        double xG = 0.0;
        double yG = 0.0;
        IFigure2D figure = (IFigure2D)polyline.firstElement();
        while (figure != null) {
            xG += figure.getX2();
            yG += figure.getY2();
            figure = ToolGeomFigure2D.getNext(figure);
        }
        gpoint[0] = xG / (double)polyline.size();
        gpoint[1] = yG / (double)polyline.size();
    }

    public static double getMinimumDistance(IPolyline2D polyline, double x, double y) {
        IFigure2D figure = (IFigure2D)polyline.firstElement();
        double[] point = new double[2];
        double min = Double.MAX_VALUE;
        figure = (IFigure2D)polyline.firstElement();
        while (figure != null) {
            double distance = ToolGeomFigure2D.getMinimumDistance(x, y, figure);
            if (distance < min) {
                min = distance;
            }
            figure = ToolGeomFigure2D.getNext(figure);
        }
        return min;
    }

    public static double getMinimumDistance(IFigure2D[] figureOut, IPolyline2D polyline, double x, double y) {
        IFigure2D figure = (IFigure2D)polyline.firstElement();
        double[] point = new double[2];
        double min = Double.MAX_VALUE;
        figure = (IFigure2D)polyline.firstElement();
        while (figure != null) {
            double distance = ToolGeomFigure2D.getMinimumDistance(x, y, figure);
            if (distance < min) {
                figureOut[0] = figure;
                min = distance;
            }
            figure = ToolGeomFigure2D.getNext(figure);
        }
        return min;
    }

    public static boolean getFitRectangle(double[] rect, IPolyline2D polyline) {
        double x1 = 0.0;
        double y1 = 0.0;
        double x2 = 0.0;
        double y2 = 0.0;
        int cnt = 0;
        int out = 0;
        IFigure2D figure = (IFigure2D)polyline.firstElement();
        while (figure != null) {
            if (ToolGeomFigure2D.getFitRectangle(rect, figure)) {
                if (cnt == 0) {
                    x1 = rect[0];
                    y1 = rect[1];
                    x2 = rect[2];
                    y2 = rect[3];
                } else {
                    if (rect[0] < x1) {
                        x1 = rect[0];
                    }
                    if (rect[1] < y1) {
                        y1 = rect[1];
                    }
                    if (x2 < rect[2]) {
                        x2 = rect[2];
                    }
                    if (y2 < rect[3]) {
                        y2 = rect[3];
                    }
                }
                ++out;
            }
            figure = ToolGeomFigure2D.getNext(figure);
            ++cnt;
        }
        rect[0] = x1;
        rect[1] = y1;
        rect[2] = x2;
        rect[3] = y2;
        return out != 0;
    }
}

