/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.math.geom.datapassing.plane;

import jp.kitec.math.algebra.AlgebraException;
import jp.kitec.math.geom.datapassing.IFigure2D;
import jp.kitec.math.geom.datapassing.IPolyline2D;
import jp.kitec.math.geom.datapassing.plane.ToolPlane2D;
import jp.kitec.math.geom.datapassing.polylines.ToolGeomPolyline2D;

public class ToolClip2D
extends ToolPlane2D {
    public static double[] clip(IPolyline2D polylineIn, IFigure2D figureIn) throws AlgebraException {
        return ToolClip2D.clip(polylineIn, figureIn.getX1(), figureIn.getY1(), figureIn.getX2(), figureIn.getY2());
    }

    public static double[] clip(IPolyline2D polylineIn, double dx1, double dy1, double dx2, double dy2) throws AlgebraException {
        int i;
        double[] points = new double[polylineIn.size()];
        int num = ToolGeomPolyline2D.getIntersectPointsWithLine(points, polylineIn, dx1, dy1, dx2, dy2);
        int iOut = 0;
        boolean prevResult = false;
        if (num == 0) {
            int iTmp = ToolPlane2D.determinatePoint(polylineIn, dx1, dy1);
            if (iTmp == 3 || iTmp == 5) {
                return new double[]{dx1, dy1, dx2, dy2};
            }
            return null;
        }
        double[] result = new double[num * 4];
        double x1 = dx1;
        double y1 = dy1;
        for (i = 0; i <= num; ++i) {
            double y2;
            double x2;
            if (i < num) {
                x2 = points[i * 2];
                y2 = points[i * 2 + 1];
            } else {
                x2 = dx2;
                y2 = dy2;
            }
            if (ToolClip2D.equalPoints(x1, y1, x2, y2)) continue;
            double xm = (x1 + x2) / 2.0;
            double ym = (y1 + y2) / 2.0;
            int iTmp = ToolPlane2D.determinatePoint(polylineIn, xm, ym);
            if (iTmp == 3 || iTmp == 5) {
                if (prevResult && iOut > 0) {
                    result[iOut - 2] = x2;
                    result[iOut - 1] = y2;
                } else {
                    result[iOut++] = x1;
                    result[iOut++] = y1;
                    result[iOut++] = x2;
                    result[iOut++] = y2;
                }
                prevResult = true;
            } else {
                prevResult = false;
            }
            x1 = x2;
            y1 = y2;
        }
        if (iOut == 0) {
            return null;
        }
        double[] resultOut = new double[iOut];
        for (i = 0; i < iOut; ++i) {
            resultOut[i] = result[i];
        }
        return resultOut;
    }
}

