/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.math.geom.datapassing.complete;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.List;
import jp.kitec.math.geom.datapassing.IAdditData;
import jp.kitec.math.geom.datapassing.IFigure2D;
import jp.kitec.math.geom.datapassing.IFigure2DArc;
import jp.kitec.math.geom.datapassing.IPolyline2D;
import jp.kitec.math.geom.datapassing.IPolyline2DCollection;
import jp.kitec.math.geom.datapassing.ISearchable;
import jp.kitec.math.geom.datapassing.PolylineEditable;
import jp.kitec.math.geom.datapassing.ToolGeomFigure2D;
import jp.kitec.math.geom.datapassing.complete.MArc;
import jp.kitec.math.geom.datapassing.complete.MFigure;
import jp.kitec.math.geom.datapassing.complete.MPolylineCollection;
import jp.kitec.math.searches.regiontree.RectangleSupplier;
import jp.kitec.math.searches.regiontree.RegionTree;
import jp.kitec.math.searches.regiontree.RegionTreeBuilder;

public class MPolyline
implements IPolyline2D,
PolylineEditable,
ISearchable,
RectangleSupplier,
Serializable {
    protected MPolylineCollection parent;
    protected IFigure2D first;
    protected IFigure2D last;
    protected int N;
    protected double x;
    protected double y;
    protected double[] rect;
    protected RegionTree tree;
    protected int index;
    protected byte region;
    protected Hashtable<Integer, IAdditData> hash = new Hashtable();
    protected boolean bChanged;

    public MPolyline(IPolyline2DCollection parent, int index) {
        this.rect = new double[4];
        this.init(parent, index);
    }

    private void init(IPolyline2DCollection parent, int index) {
        this.parent = (MPolylineCollection)parent;
        this.last = null;
        this.first = null;
        this.N = 0;
        this.rect[3] = 0.0;
        this.rect[2] = 0.0;
        this.rect[1] = 0.0;
        this.rect[0] = 0.0;
        this.tree = null;
        this.index = index;
        this.region = 0;
        this.bChanged = false;
    }

    public int getType() {
        return 6;
    }

    @Override
    public void setParent(IPolyline2DCollection collection) {
        this.parent = (MPolylineCollection)collection;
    }

    @Override
    public IPolyline2DCollection getParent() {
        return this.parent;
    }

    public IFigure2D firstElement() {
        return this.first;
    }

    public IFigure2D lastElement() {
        return this.last;
    }

    public IFigure2D elementAt(int i) {
        int count = 0;
        IFigure2D it = this.firstElement();
        IFigure2D result = null;
        while (true) {
            if (count == i) break;
            ++count;
            if (it == this.lastElement()) {
                it = this.firstElement();
                continue;
            }
            it = (IFigure2D)it.getNext();
        }
        result = it;
        return result;
    }

    @Override
    public int size() {
        return this.N;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public void setRegion(byte region) {
        this.region = region;
    }

    @Override
    public byte getRegion() {
        return this.region;
    }

    @Override
    public IFigure2D add(int type) {
        MFigure figure = null;
        switch (type) {
            case 1: {
                figure = new MFigure(this, this.N);
                break;
            }
            case 2: 
            case 3: {
                figure = new MArc(this, this.N);
            }
        }
        figure.type = (byte)type;
        figure.setPrev(this.last);
        if (this.first == null) {
            this.first = figure;
        } else {
            MFigure tmp = (MFigure)this.last;
            tmp.setNext(figure);
        }
        this.last = figure;
        ++this.N;
        return figure;
    }

    @Override
    public IPolyline2D addAll(IPolyline2D polylineBase) {
        this.setFirstX(((IFigure2D)polylineBase.firstElement()).getX1());
        this.setFirstY(((IFigure2D)polylineBase.firstElement()).getY1());
        IFigure2D figure = (IFigure2D)polylineBase.firstElement();
        while (figure != null) {
            MFigure figureNew = (MFigure)this.add(figure.getType());
            figureNew.setX2(figure.getX2());
            figureNew.setY2(figure.getY2());
            switch (figure.getType()) {
                case 1: {
                    break;
                }
                case 2: 
                case 3: {
                    IFigure2DArc arc = (IFigure2DArc)figure;
                    IFigure2DArc arcNew = (IFigure2DArc)((Object)figureNew);
                    arcNew.setCX(arc.getCX());
                    arcNew.setCY(arc.getCY());
                    arcNew.setRadius(arc.getRadius());
                    break;
                }
            }
            figure = ToolGeomFigure2D.getNext(figure);
        }
        return null;
    }

    @Override
    public boolean remove(IFigure2D figure) {
        MFigure figurePrev = null;
        MFigure figureTmp = (MFigure)this.firstElement();
        MFigure figureNext = (MFigure)figureTmp.getNext();
        while (figureTmp != null) {
            if (figure == figureTmp) {
                if (figureTmp == this.firstElement()) {
                    this.first = figureNext;
                }
                if (figureTmp == this.lastElement()) {
                    this.last = figurePrev;
                }
                if (figurePrev != null) {
                    figurePrev.setNext(figureNext);
                }
                if (figureNext != null) {
                    figureNext.setPrev(figurePrev);
                }
                --this.N;
                return true;
            }
            figurePrev = figureTmp;
            figureTmp = figureNext;
            figureNext = (MFigure)(figureNext != null ? figureNext.getNext() : null);
        }
        return false;
    }

    public void removeAll() {
        MFigure figurePrev = null;
        MFigure figureTmp = (MFigure)this.firstElement();
        MFigure figureNext = (MFigure)figureTmp.getNext();
        while (figureTmp != null) {
            figureTmp.setPrev(null);
            figureTmp.setNext(null);
            figurePrev = figureTmp;
            figureTmp = figureNext;
            figureNext = (MFigure)(figureNext != null ? figureNext.getNext() : null);
        }
        this.init(this.parent, this.index);
    }

    @Override
    public double getLeft() {
        if (this.bChanged) {
            this.makeTree(new RegionTreeBuilder());
        }
        return this.rect[0];
    }

    @Override
    public double getRight() {
        if (this.bChanged) {
            this.makeTree(new RegionTreeBuilder());
        }
        return this.rect[2];
    }

    @Override
    public double getLower() {
        if (this.bChanged) {
            this.makeTree(new RegionTreeBuilder());
        }
        return this.rect[1];
    }

    @Override
    public double getUpper() {
        if (this.bChanged) {
            this.makeTree(new RegionTreeBuilder());
        }
        return this.rect[3];
    }

    @Override
    public void makeTree(RegionTreeBuilder builder) {
        boolean bFirst = true;
        if (!this.bChanged) {
            return;
        }
        if (builder == null) {
            builder = new RegionTreeBuilder();
        }
        MFigure figure = (MFigure)this.firstElement();
        while (figure != null) {
            MFigure fig = figure;
            fig.setRect();
            builder.addNodes(figure);
            if (bFirst) {
                this.rect[0] = figure.getLeft();
                this.rect[1] = figure.getLower();
                this.rect[2] = figure.getRight();
                this.rect[3] = figure.getUpper();
            } else {
                this.rect[0] = Math.min(this.rect[0], figure.getLeft());
                this.rect[1] = Math.min(this.rect[1], figure.getLower());
                this.rect[2] = Math.max(this.rect[2], figure.getRight());
                this.rect[3] = Math.max(this.rect[3], figure.getUpper());
            }
            figure = (MFigure)ToolGeomFigure2D.getNext(figure);
            bFirst = false;
        }
        if (this.tree == null) {
            this.tree = new RegionTree();
        }
        builder.build(this.tree);
        this.bChanged = false;
    }

    @Override
    public int search(List<RectangleSupplier> result, double left, double lower, double right, double upper) {
        if (this.bChanged) {
            this.makeTree(new RegionTreeBuilder());
        }
        if (this.tree != null) {
            return this.tree.search(result, left, lower, right, upper);
        }
        return 0;
    }

    @Override
    public IAdditData get(int key) {
        return this.hash.get(key);
    }

    @Override
    public IAdditData put(IAdditData value) {
        return this.hash.put(value.getKey(), value);
    }

    @Override
    public void setFirstX(double x) {
        this.x = x;
        this.setChangedFlag();
    }

    @Override
    public void setFirstY(double y) {
        this.y = y;
        this.setChangedFlag();
    }

    @Override
    public double getFirstX() {
        return this.x;
    }

    @Override
    public double getFirstY() {
        return this.y;
    }

    void setChangedFlag() {
        if (this.parent != null) {
            this.parent.setChangedFlag();
        }
        this.bChanged = true;
    }
}

