/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.math.geom.datapassing.complete;

import java.io.Serializable;
import java.util.Hashtable;
import jp.kitec.lib.geom.K2DPathFigure;
import jp.kitec.math.geom.ToolGeom2D;
import jp.kitec.math.geom.datapassing.IAdditData;
import jp.kitec.math.geom.datapassing.IFigure2D;
import jp.kitec.math.geom.datapassing.IFigure2DArc;
import jp.kitec.math.geom.datapassing.IPolyline2D;
import jp.kitec.math.geom.datapassing.complete.MPolyline;
import jp.kitec.math.searches.regiontree.RectangleSupplier;

public class MFigure
implements IFigure2D,
RectangleSupplier,
Serializable {
    protected MPolyline parent;
    protected byte type;
    protected IFigure2D prev;
    protected IFigure2D next;
    protected Hashtable hash;
    protected double x;
    protected double y;
    protected double[] rect;
    protected int index;

    MFigure(IPolyline2D parent, int index) {
        this.parent = (MPolyline)parent;
        this.next = null;
        this.prev = null;
        this.hash = new Hashtable();
        this.y = Double.MAX_VALUE;
        this.x = Double.MAX_VALUE;
        this.rect = new double[4];
        this.rect[3] = 0.0;
        this.rect[2] = 0.0;
        this.rect[1] = 0.0;
        this.rect[0] = 0.0;
        this.index = index;
    }

    public int getType() {
        return this.type;
    }

    public double getX1() {
        MFigure figure = (MFigure)this.prev;
        if (figure != null) {
            return figure.x;
        }
        return this.parent.getFirstX();
    }

    public double getY1() {
        MFigure figure = (MFigure)this.prev;
        if (figure != null) {
            return figure.y;
        }
        return this.parent.getFirstY();
    }

    public double getX2() {
        return this.x;
    }

    public double getY2() {
        return this.y;
    }

    @Override
    public IPolyline2D getParent() {
        return this.parent;
    }

    public K2DPathFigure getPrev() {
        return this.prev;
    }

    public K2DPathFigure getNext() {
        return this.next;
    }

    public void setX1(double x) {
        MFigure figure = (MFigure)this.prev;
        if (figure != null) {
            this.parent.setChangedFlag();
            figure.x = x;
        } else {
            this.parent.setFirstX(x);
        }
    }

    public void setY1(double y) {
        MFigure figure = (MFigure)this.prev;
        if (figure != null) {
            this.parent.setChangedFlag();
            figure.y = y;
        } else {
            this.parent.setFirstY(y);
        }
    }

    public void setX2(double x) {
        this.parent.setChangedFlag();
        this.x = x;
    }

    public void setY2(double y) {
        this.parent.setChangedFlag();
        this.y = y;
    }

    void setPrev(IFigure2D figure) {
        this.parent.setChangedFlag();
        this.prev = figure;
    }

    void setNext(IFigure2D figure) {
        this.parent.setChangedFlag();
        this.next = figure;
    }

    public void setRect() {
        switch (this.type) {
            case 1: {
                ToolGeom2D.getFitRectangle(this.rect, this.getX1(), this.getY1(), this.getX2(), this.getY2());
                break;
            }
            case 2: 
            case 3: {
                IFigure2DArc arc = (IFigure2DArc)((Object)this);
                ToolGeom2D.getFitRectangle(this.rect, this.getX1(), this.getY1(), this.getX2(), this.getY2(), arc.getCX(), arc.getCY(), arc.getRadius(), arc.isCw());
            }
        }
    }

    @Override
    public double getLeft() {
        return this.rect[0];
    }

    @Override
    public double getRight() {
        return this.rect[2];
    }

    @Override
    public double getLower() {
        return this.rect[1];
    }

    @Override
    public double getUpper() {
        return this.rect[3];
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public IAdditData get(int key) {
        return (IAdditData)this.hash.get(Integer.toString(key));
    }

    @Override
    public IAdditData put(IAdditData value) {
        return this.hash.put(Integer.toString(value.getKey()), value);
    }
}

