/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.math.geom.datapassing.complete;

import java.io.Serializable;
import jp.kitec.math.geom.ToolGeom2D;
import jp.kitec.math.geom.datapassing.IFigure2DArc;
import jp.kitec.math.geom.datapassing.IPolyline2D;
import jp.kitec.math.geom.datapassing.complete.MFigure;

public class MArc
extends MFigure
implements IFigure2DArc,
Serializable {
    private double xc;
    private double yc = Double.MAX_VALUE;
    private double radius = -1.0;

    public MArc(IPolyline2D parent, int index) {
        super(parent, index);
        this.xc = Double.MAX_VALUE;
    }

    public double getCX() {
        return this.xc;
    }

    public double getCY() {
        return this.yc;
    }

    public double getRadius() {
        return this.radius;
    }

    public boolean isCw() {
        return this.type == 2;
    }

    public void setCX(double x) {
        this.parent.setChangedFlag();
        this.xc = x;
    }

    public void setCY(double y) {
        this.parent.setChangedFlag();
        this.yc = y;
    }

    public void setCw(boolean cw) {
        this.parent.setChangedFlag();
        this.type = (byte)(cw ? 2 : 3);
    }

    public void setRadius(double radius) {
        this.parent.setChangedFlag();
        this.radius = radius;
        this.adjustArc();
    }

    private boolean adjustArc() {
        if (this.xc != Double.MAX_VALUE && this.yc != Double.MAX_VALUE && this.getX1() != Double.MAX_VALUE && this.getY1() != Double.MAX_VALUE && this.x != Double.MAX_VALUE && this.y != Double.MAX_VALUE) {
            double d2;
            double d1 = ToolGeom2D.getDistance(this.getX1(), this.getY1(), this.xc, this.yc);
            if (ToolGeom2D.compareDistance(d1, d2 = ToolGeom2D.getDistance(this.getX2(), this.getY2(), this.xc, this.yc)) != 0) {
                double xm = (this.getX1() + this.getX2()) / 2.0;
                double ym = (this.getY1() + this.getY2()) / 2.0;
                double dX = this.getX2() - this.getX1();
                double dY = this.getY2() - this.getY1();
                double length = ToolGeom2D.getDistance(this.getX1(), this.getY1(), this.getX2(), this.getY2());
                byte bSide = ToolGeom2D.getSideOfPointWithLine(this.xc, this.yc, this.getX1(), this.getY1(), this.getX2(), this.getY2());
                double xd = bSide == 1 ? dY : -(dY *= this.radius / length);
                double yd = bSide == 1 ? -dX : (dX *= this.radius / length);
            } else if (ToolGeom2D.compare(d1, this.radius) != 0) {
                this.radius = (d1 + d2) / 2.0;
            }
            return true;
        }
        return false;
    }
}

