/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.math.geom.datapassing;

import jp.kitec.math.algebra.AlgebraException;
import jp.kitec.math.geom.ToolGeom2D;
import jp.kitec.math.geom.datapassing.IFigure2D;
import jp.kitec.math.geom.datapassing.IFigure2DArc;
import jp.kitec.math.geom.datapassing.IPolyline2D;

public class ToolGeomFigure2D {
    public static IFigure2D getNext(IFigure2D figure) {
        IPolyline2D polyline = figure.getParent();
        IFigure2D next = (IFigure2D)figure.getNext();
        if (next == (IFigure2D)polyline.firstElement()) {
            return null;
        }
        return next;
    }

    public static synchronized byte getSideOfPoint(double px, double py, IFigure2D figure) {
        switch (figure.getType()) {
            case 1: {
                return ToolGeom2D.getSideOfPointWithLine(px, py, figure.getX1(), figure.getY1(), figure.getX2(), figure.getY2());
            }
        }
        return 0;
    }

    public static int getIntersectPointsExtension(double[] result, IFigure2D figure1, IFigure2D figure2) throws AlgebraException {
        if (figure1.getType() == 1 && figure2.getType() == 1) {
            return ToolGeom2D.getIntersectPointsExtension(result, figure1.getX1(), figure1.getY1(), figure1.getX2(), figure1.getY2(), figure2.getX1(), figure2.getY1(), figure2.getX2(), figure2.getY2()) ? 1 : 0;
        }
        if (figure1.getType() == 1 || figure2.getType() == 2 || figure2.getType() == 3) {
            IFigure2DArc arc = (IFigure2DArc)figure2;
            return ToolGeom2D.getIntersectPointsExtension(result, figure1.getX1(), figure1.getY1(), figure1.getX2(), figure1.getY2(), arc.getCX(), arc.getCY(), arc.getRadius());
        }
        if (figure1.getType() == 2 || figure1.getType() == 3 || figure2.getType() == 1) {
            IFigure2DArc arc = (IFigure2DArc)figure1;
            return ToolGeom2D.getIntersectPointsExtension(result, figure2.getX1(), figure2.getY1(), figure2.getX2(), figure2.getY2(), arc.getCX(), arc.getCY(), arc.getRadius());
        }
        if (!(figure1.getType() != 2 && figure1.getType() != 3 || figure2.getType() != 2 && figure2.getType() != 3)) {
            IFigure2DArc arc1 = (IFigure2DArc)figure1;
            IFigure2DArc arc2 = (IFigure2DArc)figure2;
            return ToolGeom2D.getIntersectPointsExtension(result, arc1.getCX(), arc1.getCY(), arc1.getRadius(), arc2.getCX(), arc2.getCY(), arc2.getRadius());
        }
        return 0;
    }

    public static int getIntersectPointsExtension(double[] result, IFigure2D figure1, double x1, double y1, double x2, double y2) throws AlgebraException {
        if (figure1.getType() == 1) {
            return ToolGeom2D.getIntersectPointsExtension(result, figure1.getX1(), figure1.getY1(), figure1.getX2(), figure1.getY2(), x1, y1, x2, y2) ? 1 : 0;
        }
        if (figure1.getType() == 2 || figure1.getType() == 3) {
            IFigure2DArc arc = (IFigure2DArc)figure1;
            return ToolGeom2D.getIntersectPointsExtension(result, x1, y1, x2, y2, arc.getCX(), arc.getCY(), arc.getRadius());
        }
        return 0;
    }

    public static int getIntersectPoints(double[] result, IFigure2D figure1, IFigure2D figure2) throws AlgebraException {
        if (figure1.getType() == 1 && figure2.getType() == 1) {
            return ToolGeom2D.getIntersectPoints(result, figure1.getX1(), figure1.getY1(), figure1.getX2(), figure1.getY2(), figure2.getX1(), figure2.getY1(), figure2.getX2(), figure2.getY2()) ? 1 : 0;
        }
        if (figure1.getType() == 1 && (figure2.getType() == 2 || figure2.getType() == 3)) {
            IFigure2DArc arc = (IFigure2DArc)figure2;
            return ToolGeom2D.getIntersectPoints(result, figure1.getX1(), figure1.getY1(), figure1.getX2(), figure1.getY2(), arc.getX1(), arc.getY1(), arc.getX2(), arc.getY2(), arc.getCX(), arc.getCY(), arc.getRadius(), arc.isCw());
        }
        if ((figure1.getType() == 2 || figure1.getType() == 3) && figure2.getType() == 1) {
            IFigure2DArc arc = (IFigure2DArc)figure1;
            return ToolGeom2D.getIntersectPoints(result, figure2.getX1(), figure2.getY1(), figure2.getX2(), figure2.getY2(), arc.getX1(), arc.getY1(), arc.getX2(), arc.getY2(), arc.getCX(), arc.getCY(), arc.getRadius(), arc.isCw());
        }
        if (!(figure1.getType() != 2 && figure1.getType() != 3 || figure2.getType() != 2 && figure2.getType() != 3)) {
            IFigure2DArc arc1 = (IFigure2DArc)figure1;
            IFigure2DArc arc2 = (IFigure2DArc)figure2;
            return ToolGeom2D.getIntersectPoints(result, arc1.getX1(), arc1.getY1(), arc1.getX2(), arc1.getY2(), arc1.getCX(), arc1.getCY(), arc1.getRadius(), arc1.isCw(), arc2.getX1(), arc2.getY1(), arc2.getX2(), arc2.getY2(), arc2.getCX(), arc2.getCY(), arc2.getRadius(), arc2.isCw());
        }
        return 0;
    }

    public static int getIntersectPoints(double[] result, IFigure2D figure1, double x1, double y1, double x2, double y2) throws AlgebraException {
        if (figure1.getType() == 1) {
            return ToolGeom2D.getIntersectPoints(result, figure1.getX1(), figure1.getY1(), figure1.getX2(), figure1.getY2(), x1, y1, x2, y2) ? 1 : 0;
        }
        if (figure1.getType() == 2 || figure1.getType() == 3) {
            IFigure2DArc arc = (IFigure2DArc)figure1;
            return ToolGeom2D.getIntersectPoints(result, x1, y1, x2, y2, arc.getX1(), arc.getY1(), arc.getX2(), arc.getY2(), arc.getCX(), arc.getCY(), arc.getRadius(), arc.isCw());
        }
        return 0;
    }

    public static int getIntersectPoints(double[] result, IFigure2D figure1, double x1, double y1, double x2, double y2, double xc, double yc, double radius, boolean isCw) throws AlgebraException {
        if (figure1.getType() == 1) {
            return ToolGeom2D.getIntersectPoints(result, figure1.getX1(), figure1.getY1(), figure1.getX2(), figure1.getY2(), x1, y1, x2, y2, xc, yc, radius, isCw);
        }
        if (figure1.getType() == 2 || figure1.getType() == 3) {
            IFigure2DArc arc1 = (IFigure2DArc)figure1;
            return ToolGeom2D.getIntersectPoints(result, arc1.getX1(), arc1.getY1(), arc1.getX2(), arc1.getY2(), arc1.getCX(), arc1.getCY(), arc1.getRadius(), arc1.isCw(), x1, y1, x2, y2, xc, yc, radius, isCw);
        }
        return 0;
    }

    public static synchronized boolean checkPointOnWithoutDistance(double px, double py, IFigure2D figure) {
        switch (figure.getType()) {
            case 1: {
                return ToolGeom2D.checkPointOnLinearWithoutDistance(px, py, figure.getX1(), figure.getY1(), figure.getX2(), figure.getY2());
            }
            case 2: 
            case 3: {
                IFigure2DArc arc = (IFigure2DArc)figure;
                return ToolGeom2D.checkPointOnCircleWithoutDistance(px, py, arc.getX1(), arc.getY1(), arc.getX2(), arc.getY2(), arc.getCX(), arc.getCY(), arc.isCw());
            }
        }
        return false;
    }

    public static synchronized boolean checkPointOn(double px, double py, IFigure2D figure) {
        switch (figure.getType()) {
            case 1: {
                return ToolGeom2D.checkPointOn(px, py, figure.getX1(), figure.getY1(), figure.getX2(), figure.getY2());
            }
            case 2: 
            case 3: {
                IFigure2DArc arc = (IFigure2DArc)figure;
                return ToolGeom2D.checkPointOn(px, py, arc.getX1(), arc.getY1(), arc.getX2(), arc.getY2(), arc.getCX(), arc.getCY(), arc.getRadius(), arc.isCw());
            }
        }
        return false;
    }

    public static double getParameter(double px, double py, IFigure2D figure) {
        switch (figure.getType()) {
            case 1: {
                return ToolGeom2D.getParameter(px, py, figure.getX1(), figure.getY1(), figure.getX2(), figure.getY2());
            }
            case 2: 
            case 3: {
                IFigure2DArc arc = (IFigure2DArc)figure;
                return ToolGeom2D.getParameter(px, py, figure.getX1(), figure.getY1(), figure.getX2(), figure.getY2(), arc.getCX(), arc.getCY(), arc.getRadius(), arc.isCw());
            }
        }
        return -1.0;
    }

    public static void getPointFromParameter(double[] point, IFigure2D figure, double parameter) {
        switch (figure.getType()) {
            case 1: {
                ToolGeom2D.getPointFromParameter(point, figure.getX1(), figure.getY1(), figure.getX2(), figure.getY2(), parameter);
                break;
            }
            case 2: 
            case 3: {
                IFigure2DArc arc = (IFigure2DArc)figure;
                ToolGeom2D.getPointFromParameter(point, arc.getX1(), arc.getY1(), arc.getX2(), arc.getY2(), arc.getCX(), arc.getCY(), arc.getRadius(), arc.isCw(), parameter);
            }
        }
    }

    public static boolean getPointFromDistance(double[] point, IFigure2D figure, double distance, boolean bFirstPoint) {
        switch (figure.getType()) {
            case 1: {
                ToolGeom2D.getPointFromDistance(point, figure.getX1(), figure.getY1(), figure.getX2(), figure.getY2(), distance, bFirstPoint);
                return true;
            }
            case 2: 
            case 3: {
                IFigure2DArc arc = (IFigure2DArc)figure;
                ToolGeom2D.getPointFromDistance(point, arc.getX1(), arc.getY1(), arc.getX2(), arc.getY2(), arc.getCX(), arc.getCY(), arc.getRadius(), arc.isCw(), distance, bFirstPoint);
                return true;
            }
        }
        return false;
    }

    public static double getDistance(double px, double py, IFigure2D figure) {
        switch (figure.getType()) {
            case 1: {
                return ToolGeom2D.getDistance(px, py, figure.getX1(), figure.getY1(), figure.getX2(), figure.getY2());
            }
        }
        return -1.0;
    }

    public static double getMinimumDistance(double px, double py, IFigure2D figure) {
        switch (figure.getType()) {
            case 1: {
                return ToolGeom2D.getMinimumDistance(px, py, figure.getX1(), figure.getY1(), figure.getX2(), figure.getY2());
            }
            case 2: 
            case 3: {
                IFigure2DArc arc = (IFigure2DArc)figure;
                return ToolGeom2D.getMinimumDistance(px, py, arc.getX1(), arc.getY1(), arc.getX2(), arc.getY2(), arc.getCX(), arc.getCY(), arc.getRadius(), arc.isCw());
            }
        }
        return -1.0;
    }

    public static boolean getPerpendicularPoint(double[] result, double px, double py, IFigure2D figure) {
        switch (figure.getType()) {
            case 1: {
                return ToolGeom2D.getPerpendicularPoint(result, px, py, figure.getX1(), figure.getY1(), figure.getX2(), figure.getY2());
            }
            case 2: 
            case 3: {
                IFigure2DArc arc = (IFigure2DArc)figure;
                return ToolGeom2D.getPerpendicularPoint(result, px, py, figure.getX1(), figure.getY1(), figure.getX2(), figure.getY2(), arc.getCX(), arc.getCY(), arc.getRadius(), arc.isCw());
            }
        }
        return false;
    }

    public static boolean getFitRectangle(double[] result, IFigure2D figure) {
        switch (figure.getType()) {
            case 1: {
                ToolGeom2D.getFitRectangle(result, figure.getX1(), figure.getY1(), figure.getX2(), figure.getY2());
                return true;
            }
            case 2: 
            case 3: {
                IFigure2DArc arc = (IFigure2DArc)figure;
                ToolGeom2D.getFitRectangle(result, arc.getX1(), arc.getY1(), arc.getX2(), arc.getY2(), arc.getCX(), arc.getCY(), arc.getRadius(), arc.isCw());
                return true;
            }
        }
        return false;
    }

    public static double findAreaOfSegment(IFigure2DArc arc) {
        return ToolGeom2D.findAreaOfSegment(arc.getX1(), arc.getY1(), arc.getX2(), arc.getY2(), arc.getCX(), arc.getCY(), arc.getRadius(), arc.isCw());
    }

    public static double getAngleOfArc(IFigure2DArc arc) {
        return ToolGeom2D.getAngleOfArc(arc.getX1(), arc.getY1(), arc.getX2(), arc.getY2(), arc.getCX(), arc.getCY(), arc.isCw());
    }

    public static double getAngleTwoTangentsOfFiguresAtJoint(IFigure2D figure1, IFigure2D figure2) {
        if (figure1.getType() == 1 && figure2.getType() == 1) {
            return ToolGeom2D.getAngleTwoTangentsOfFiguresAtJoint(figure1.getX1(), figure1.getY1(), figure1.getX2(), figure1.getY2(), 0.0, 0.0, 1, figure2.getX1(), figure2.getY1(), figure2.getX2(), figure2.getY2(), 0.0, 0.0, 1);
        }
        if (figure1.getType() == 1 && (figure2.getType() == 2 || figure2.getType() == 3)) {
            IFigure2DArc arc = (IFigure2DArc)figure2;
            return ToolGeom2D.getAngleTwoTangentsOfFiguresAtJoint(figure1.getX1(), figure1.getY1(), figure1.getX2(), figure1.getY2(), 0.0, 0.0, 1, arc.getX1(), arc.getY1(), arc.getX2(), arc.getY2(), arc.getCX(), arc.getCY(), arc.getType());
        }
        if ((figure1.getType() == 2 || figure1.getType() == 3) && figure2.getType() == 1) {
            IFigure2DArc arc = (IFigure2DArc)figure1;
            return ToolGeom2D.getAngleTwoTangentsOfFiguresAtJoint(arc.getX1(), arc.getY1(), arc.getX2(), arc.getY2(), arc.getCX(), arc.getCY(), arc.getType(), figure2.getX1(), figure2.getY1(), figure2.getX2(), figure2.getY2(), 0.0, 0.0, figure2.getType());
        }
        if (!(figure1.getType() != 2 && figure1.getType() != 3 || figure2.getType() != 2 && figure2.getType() != 3)) {
            IFigure2DArc arc1 = (IFigure2DArc)figure1;
            IFigure2DArc arc2 = (IFigure2DArc)figure2;
            return ToolGeom2D.getAngleTwoTangentsOfFiguresAtJoint(arc1.getX1(), arc1.getY1(), arc1.getX2(), arc1.getY2(), arc1.getCX(), arc1.getCY(), arc1.getType(), arc2.getX1(), arc2.getY1(), arc2.getX2(), arc2.getY2(), arc2.getCX(), arc2.getCY(), arc2.getType());
        }
        return Math.PI;
    }

    public static void getMidPoint(double[] result, IFigure2D figure) {
        switch (figure.getType()) {
            case 1: {
                ToolGeom2D.getMidPoint(result, figure.getX1(), figure.getY1(), figure.getX2(), figure.getY2());
                break;
            }
            case 2: 
            case 3: {
                IFigure2DArc arc = (IFigure2DArc)figure;
                ToolGeom2D.getMidPoint(result, arc.getX1(), arc.getY1(), arc.getX2(), arc.getY2(), arc.getCX(), arc.getCY(), arc.getRadius(), arc.isCw());
            }
        }
    }

    public static double getLength(IFigure2D figure) {
        switch (figure.getType()) {
            case 1: {
                return ToolGeom2D.getLength(figure.getX1(), figure.getY1(), figure.getX2(), figure.getY2());
            }
            case 2: 
            case 3: {
                IFigure2DArc arc = (IFigure2DArc)figure;
                return ToolGeom2D.getLength(arc.getX1(), arc.getY1(), arc.getX2(), arc.getY2(), arc.getCX(), arc.getCY(), arc.getRadius(), arc.isCw());
            }
        }
        return -1.0;
    }

    public static boolean getOffset(double[] result, IFigure2D figure, double offsetDistance, boolean rightSide) {
        switch (figure.getType()) {
            case 1: {
                ToolGeom2D.getOffsetOfLine(result, figure.getX1(), figure.getY1(), figure.getX2(), figure.getY2(), offsetDistance, rightSide);
                return true;
            }
            case 2: {
                IFigure2DArc arc = (IFigure2DArc)figure;
                return ToolGeom2D.getOffsetOfArc(result, figure.getX1(), figure.getY1(), figure.getX2(), figure.getY2(), arc.getCX(), arc.getCY(), arc.getRadius(), offsetDistance, true, rightSide);
            }
            case 3: {
                IFigure2DArc arc = (IFigure2DArc)figure;
                return ToolGeom2D.getOffsetOfArc(result, figure.getX1(), figure.getY1(), figure.getX2(), figure.getY2(), arc.getCX(), arc.getCY(), arc.getRadius(), offsetDistance, true, rightSide);
            }
        }
        return false;
    }
}

