/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.math.geom;

public class ToolJudge2D {
    public static final int FAIL = 0;
    public static final int RIGHT = 1;
    public static final int LEFT = 2;
    public static final int ONLINE = 3;
    public static final int LESS = -1;
    public static final int EQUAL = 0;
    public static final int GREATER = 1;
    public static final double TOLERANCE_ANGLE = 1.0E-4;
    public static final double POINT_TOLERANCE = 1.0E-8;
    private static final double JUDGE_POINT_TOLERANCE = 1.0E-6;

    public static int compare(double x1, double x2, double tolerance) {
        if (Math.abs(x1 - x2) <= tolerance) {
            return 0;
        }
        if (x1 < x2) {
            return -1;
        }
        return 1;
    }

    public static synchronized byte getSideOfPointWithLine(double px, double py, double x1, double y1, double x2, double y2) {
        double dDivide;
        double tolerance = 1.0E-6;
        double dX1 = x2 - x1;
        double dY1 = y2 - y1;
        double dX2 = px - x1;
        double dY2 = py - y1;
        double dMin = Math.min(Math.abs(dX1), Math.abs(dY1));
        double dMax = Math.max(Math.abs(dX1), Math.abs(dY1));
        if (dMin < 1.0E-8 && dMin > 1.0E-10) {
            dMin = 1.0E-8;
            dX1 /= dMin;
            dY1 /= dMin;
        }
        dMin = Math.min(Math.abs(dX2), Math.abs(dY2));
        dMax = Math.max(Math.abs(dX2), Math.abs(dY2));
        if (dMin < 1.0E-8 && dMin != 0.0) {
            dMin = 1.0E-8;
            dX2 /= dMin;
            dY2 /= dMin;
        }
        if (ToolJudge2D.compare(dDivide = dX2 * dX2 + dY2 * dY2, 0.0, 1.0E-12) == 0) {
            return 0;
        }
        double dParameter = Math.sqrt(dX1 * dX1 + dY1 * dY1) / Math.sqrt(dDivide);
        double dResult = dY1 * (dX2 *= dParameter) - dX1 * (dY2 *= dParameter);
        if (ToolJudge2D.compare(dResult, 0.0, tolerance) == 0) {
            return 3;
        }
        if (dResult > 0.0) {
            return 1;
        }
        return 2;
    }

    public static boolean equalPoints(double x1, double y1, double x2, double y2) {
        return Math.abs(x1 - x2) <= 1.0E-8 && Math.abs(y1 - y2) <= 1.0E-8;
    }

    public static boolean equalPoints(double x1, double y1, double x2, double y2, double tolerance) {
        return Math.abs(x1 - x2) <= tolerance && Math.abs(y1 - y2) <= tolerance;
    }
}

