/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.math.geom;

import jp.kitec.math.algebra.AlgebraException;
import jp.kitec.math.algebra.ToolAlgebra2DQuadratic;
import jp.kitec.math.geom.ToolGeom2D;
import jp.kitec.math.geom.ToolJudge2D;

public class ToolIntersectPoint2D
extends ToolJudge2D {
    public static final double TOLERANCE_DISTANCE = 1.0E-8;
    public static final double TOLERANCE = 1.0E-8;
    private static ToolAlgebra2DQuadratic __getIntersectPointsExtension_ToolAlgebra2DQuadratic_1 = new ToolAlgebra2DQuadratic();
    private static ToolAlgebra2DQuadratic __getIntersectPointsExtension_ToolAlgebra2DQuadratic_2 = new ToolAlgebra2DQuadratic();
    private static ToolAlgebra2DQuadratic __getIntersectPointsExtension_ToolAlgebra2DQuadratic_3 = new ToolAlgebra2DQuadratic();
    private static ToolAlgebra2DQuadratic __getIntersectPointsExtension_ToolAlgebra2DQuadratic_4 = new ToolAlgebra2DQuadratic();
    private static ToolAlgebra2DQuadratic __getIntersectPointsExtension_ToolAlgebra2DQuadratic_5 = new ToolAlgebra2DQuadratic();
    private static ToolAlgebra2DQuadratic __getIntersectPointsExtension_ToolAlgebra2DQuadratic_6 = new ToolAlgebra2DQuadratic();

    public static int compareDistance(double d1, double d2) {
        if (Math.abs(d1 - d2) <= 1.0E-8) {
            return 0;
        }
        if (d1 < d2) {
            return -1;
        }
        return 1;
    }

    public static int compare(double x1, double x2) {
        if (Math.abs(x1 - x2) <= 1.0E-8) {
            return 0;
        }
        if (x1 < x2) {
            return -1;
        }
        return 1;
    }

    public static double getDistance(double px, double py, double x1, double y1, double x2, double y2) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        return Math.abs(dy * px - dx * py - dy * x1 + dx * y1) / Math.sqrt(dx * dx + dy * dy);
    }

    public static double getDistance(double x1, double y1, double x2, double y2) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        return Math.sqrt(dx * dx + dy * dy);
    }

    public static synchronized boolean getIntersectPointsExtension(double[] result, double l1x1, double l1y1, double l1x2, double l1y2, double l2x1, double l2y1, double l2x2, double l2y2) throws AlgebraException {
        ToolAlgebra2DQuadratic quadratic1 = __getIntersectPointsExtension_ToolAlgebra2DQuadratic_1;
        ToolAlgebra2DQuadratic quadratic2 = __getIntersectPointsExtension_ToolAlgebra2DQuadratic_2;
        quadratic1.linear(0.0, 0.0, l1x2 -= l1x1, l1y2 -= l1y1);
        quadratic2.linear(l2x1 -= l1x1, l2y1 -= l1y1, l2x2 -= l1x1, l2y2 -= l1y1);
        if (quadratic1.solve(quadratic2) == 1) {
            result[0] = quadratic1.getSolutionX(0) + l1x1;
            result[1] = quadratic1.getSolutionY(0) + l1y1;
            return true;
        }
        return false;
    }

    public static synchronized int getIntersectPointsExtension(double[] result, double lx1, double ly1, double lx2, double ly2, double axc, double ayc, double aR) throws AlgebraException {
        ToolAlgebra2DQuadratic quadratic1 = __getIntersectPointsExtension_ToolAlgebra2DQuadratic_3;
        ToolAlgebra2DQuadratic quadratic2 = __getIntersectPointsExtension_ToolAlgebra2DQuadratic_4;
        lx1 -= axc;
        ly1 -= ayc;
        lx2 -= axc;
        ly2 -= ayc;
        quadratic1.linear(lx1 /= aR, ly1 /= aR, lx2 /= aR, ly2 /= aR);
        quadratic2.circle(0.0, 0.0, 1.0);
        int iOut = quadratic1.solve(quadratic2);
        for (int i = 0; i < iOut; ++i) {
            result[i * 2] = quadratic1.getSolutionX(i) * aR + axc;
            result[i * 2 + 1] = quadratic1.getSolutionY(i) * aR + ayc;
        }
        return iOut;
    }

    public static synchronized int getIntersectPointsExtension(double[] result, double a1xc, double a1yc, double a1R, double a2xc, double a2yc, double a2R) {
        ToolAlgebra2DQuadratic quadratic1 = __getIntersectPointsExtension_ToolAlgebra2DQuadratic_5;
        ToolAlgebra2DQuadratic quadratic2 = __getIntersectPointsExtension_ToolAlgebra2DQuadratic_6;
        a2xc -= a1xc;
        a2yc -= a1yc;
        quadratic1.circle(0.0, 0.0, 1.0);
        quadratic2.circle(a2xc /= a1R, a2yc /= a1R, a2R /= a1R);
        int iOut = quadratic1.solve(quadratic2);
        for (int i = 0; i < iOut; ++i) {
            result[i * 2] = quadratic1.getSolutionX(i) * a1R + a1xc;
            result[i * 2 + 1] = quadratic1.getSolutionY(i) * a1R + a1yc;
        }
        return iOut;
    }

    public static synchronized boolean getIntersectPoints(double[] result, double l1x1, double l1y1, double l1x2, double l1y2, double l2x1, double l2y1, double l2x2, double l2y2) throws AlgebraException {
        if (!ToolIntersectPoint2D.getIntersectPointsExtension(result, l1x1, l1y1, l1x2, l1y2, l2x1, l2y1, l2x2, l2y2)) {
            return false;
        }
        return ToolIntersectPoint2D.checkPointOnLinearWithoutDistance(result[0], result[1], l1x1, l1y1, l1x2, l1y2) && ToolIntersectPoint2D.checkPointOnLinearWithoutDistance(result[0], result[1], l2x1, l2y1, l2x2, l2y2);
    }

    public static synchronized int getIntersectPoints(double[] result, double lx1, double ly1, double lx2, double ly2, double ax1, double ay1, double ax2, double ay2, double axc, double ayc, double aR, boolean cw) throws AlgebraException {
        int value = ToolIntersectPoint2D.getIntersectPointsExtension(result, lx1, ly1, lx2, ly2, axc, ayc, aR);
        int iOut = 0;
        for (int i = 0; i < value; ++i) {
            if (!ToolIntersectPoint2D.checkPointOnLinearWithoutDistance(result[i * 2], result[i * 2 + 1], lx1, ly1, lx2, ly2) || !ToolIntersectPoint2D.checkPointOnCircleWithoutDistance(result[i * 2], result[i * 2 + 1], ax1, ay1, ax2, ay2, axc, ayc, cw)) continue;
            if (i != iOut) {
                result[iOut * 2] = result[i * 2];
                result[iOut * 2 + 1] = result[i * 2 + 1];
            }
            ++iOut;
        }
        if (iOut == 0) {
            double tolerance = 1.0E-8;
            double dist = ToolIntersectPoint2D.getDistance(lx1, ly1, axc, ayc);
            if (Math.abs(dist - aR) <= tolerance && ToolIntersectPoint2D.checkPointOnCircleWithoutDistance(lx1, ly1, ax1, ay1, ax2, ay2, axc, ayc, cw)) {
                result[iOut * 2] = lx1;
                result[iOut * 2 + 1] = ly1;
                ++iOut;
            }
            if (Math.abs((dist = ToolIntersectPoint2D.getDistance(lx2, ly2, axc, ayc)) - aR) <= tolerance && ToolIntersectPoint2D.checkPointOnCircleWithoutDistance(lx2, ly2, ax1, ay1, ax2, ay2, axc, ayc, cw) && (iOut == 0 || !ToolIntersectPoint2D.equalPoints(lx2, ly2, result[iOut * 2 - 2], result[iOut * 2 - 1]))) {
                result[iOut * 2] = lx2;
                result[iOut * 2 + 1] = ly2;
                ++iOut;
            }
            if (iOut < 2 && Math.abs(dist = ToolIntersectPoint2D.getDistance(ax1, ay1, lx1, ly1, lx2, ly2)) <= tolerance && ToolIntersectPoint2D.checkPointOnLinearWithoutDistance(ax1, ay1, lx1, ly1, lx2, ly2) && (iOut == 0 || !ToolIntersectPoint2D.equalPoints(ax1, ay1, result[iOut * 2 - 2], result[iOut * 2 - 1]))) {
                result[iOut * 2] = ax1;
                result[iOut * 2 + 1] = ay1;
                ++iOut;
            }
            if (iOut < 2 && Math.abs(dist = ToolIntersectPoint2D.getDistance(ax2, ay2, lx1, ly1, lx2, ly2)) <= tolerance && ToolIntersectPoint2D.checkPointOnLinearWithoutDistance(ax2, ay2, lx1, ly1, lx2, ly2) && (iOut == 0 || !ToolIntersectPoint2D.equalPoints(ax2, ay2, result[iOut * 2 - 2], result[iOut * 2 - 1]))) {
                result[iOut * 2] = ax2;
                result[iOut * 2 + 1] = ay2;
                ++iOut;
            }
        }
        return iOut;
    }

    public static synchronized int getIntersectPoints(double[] result, double a1x1, double a1y1, double a1x2, double a1y2, double a1xc, double a1yc, double a1R, boolean a1cw, double a2x1, double a2y1, double a2x2, double a2y2, double a2xc, double a2yc, double a2R, boolean a2cw) {
        int value = ToolIntersectPoint2D.getIntersectPointsExtension(result, a1xc, a1yc, a1R, a2xc, a2yc, a2R);
        int iOut = 0;
        for (int i = 0; i < value; ++i) {
            if (!ToolIntersectPoint2D.checkPointOnCircleWithoutDistance(result[i * 2], result[i * 2 + 1], a1x1, a1y1, a1x2, a1y2, a1xc, a1yc, a1cw) || !ToolIntersectPoint2D.checkPointOnCircleWithoutDistance(result[i * 2], result[i * 2 + 1], a2x1, a2y1, a2x2, a2y2, a2xc, a2yc, a2cw)) continue;
            if (i != iOut) {
                result[iOut * 2] = result[i * 2];
                result[iOut * 2 + 1] = result[i * 2 + 1];
            }
            ++iOut;
        }
        return iOut;
    }

    public static synchronized boolean checkPointOnWithoutDistance(double px, double py, double x1, double y1, double x2, double y2) {
        double[] point = new double[2];
        ToolGeom2D.getPerpendicularPoint(point, px, py, x1, y1, x2, y2);
        return ToolIntersectPoint2D.checkPointOnLinearWithoutDistance(point[0], point[1], x1, y1, x2, y2);
    }

    public static boolean checkPointOnWithoutDistance(double px, double py, double x1, double y1, double x2, double y2, double xc, double yc, boolean cw) {
        double[] point = new double[2];
        double radius = ToolGeom2D.getRadius(x1, y1, x2, y2, xc, yc);
        ToolGeom2D.getPerpendicularPoint(point, px, py, x1, y1, x2, y2, xc, yc, radius, cw);
        return ToolIntersectPoint2D.checkPointOnCircleWithoutDistance(point[0], point[1], x1, y1, x2, y2, xc, yc, cw);
    }

    public static synchronized boolean checkPointOnLinearWithoutDistance(double px, double py, double x1, double y1, double x2, double y2) {
        return ToolIntersectPoint2D.compareDistance(px, Math.min(x1, x2)) != -1 && ToolIntersectPoint2D.compareDistance(Math.max(x1, x2), px) != -1 && ToolIntersectPoint2D.compareDistance(py, Math.min(y1, y2)) != -1 && ToolIntersectPoint2D.compareDistance(Math.max(y1, y2), py) != -1;
    }

    public static boolean checkPointOnCircleWithoutDistance(double px, double py, double x1, double y1, double x2, double y2, double xc, double yc, boolean cw) {
        x1 -= xc;
        y1 -= yc;
        x2 -= xc;
        y2 -= yc;
        px -= xc;
        py -= yc;
        xc = 0.0;
        yc = 0.0;
        byte side = ToolIntersectPoint2D.getSideOfPointWithLine(px, py, x1, y1, x2, y2);
        if (side == 0) {
            return true;
        }
        return side == 3 || side == 1 && !cw || side == 2 && cw;
    }

    public static synchronized boolean checkPointOn(double px, double py, double x1, double y1, double x2, double y2) {
        double dist = ToolIntersectPoint2D.getDistance(px, py, x1, y1, x2, y2);
        if (ToolIntersectPoint2D.compareDistance(dist, 0.0) != 0) {
            return false;
        }
        return ToolIntersectPoint2D.checkPointOnLinearWithoutDistance(px, py, x1, y1, x2, y2);
    }

    public static synchronized boolean checkPointOn(double px, double py, double x1, double y1, double x2, double y2, double xc, double yc, double radius, boolean cw) {
        double dist = ToolIntersectPoint2D.getDistance(px, py, xc, yc);
        if (ToolIntersectPoint2D.compareDistance(dist, radius) != 0) {
            return false;
        }
        return ToolIntersectPoint2D.checkPointOnCircleWithoutDistance(px, py, x1, y1, x2, y2, xc, yc, cw);
    }
}

