/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.math.geom;

import jp.kitec.math.geom.ToolGeom2D;

public class ToolIntersectDirect2D
extends ToolGeom2D {
    public static final byte NEUTRAL = 0;
    public static final byte RIGHT = 1;
    public static final byte LEFT = 2;
    public static final byte CROSS_RIGHT = 3;
    public static final byte CROSS_LEFT = 4;
    public static final byte SUPERPOSITION = 5;
    public static final byte EXTENSION = 6;

    public static byte getDirectionOfLineToLine(double lx1, double ly1, double lx2, double ly2, double lox1, double loy1, double lox2, double loy2) {
        int result = 0;
        if (ToolIntersectDirect2D.checkPointOn(lox1, loy1, lx1, ly1, lx2, ly2)) {
            result = ToolIntersectDirect2D.getSideOfPointWithLine(lox2, loy2, lx1, ly1, lx2, ly2);
            if (result == 3) {
                if (!ToolIntersectDirect2D.equalPoints(lox1, loy1, lx1, ly1) && !ToolIntersectDirect2D.equalPoints(lox1, loy1, lx2, ly2) || ToolIntersectDirect2D.checkPointOnLinearWithoutDistance(lox2, loy2, lx1, ly1, lx2, ly2) || ToolIntersectDirect2D.checkPointOnLinearWithoutDistance(lx1, ly1, lox1, loy1, lox2, loy2) && ToolIntersectDirect2D.checkPointOnLinearWithoutDistance(lx2, ly2, lox1, loy1, lox2, loy2)) {
                    return 5;
                }
                return 6;
            }
        } else if (ToolIntersectDirect2D.checkPointOn(lox2, loy2, lx1, ly1, lx2, ly2)) {
            result = ToolIntersectDirect2D.getSideOfPointWithLine(lox1, loy1, lx1, ly1, lx2, ly2);
            if (result == 3) {
                if (!ToolIntersectDirect2D.equalPoints(lox2, loy2, lx1, ly1) && !ToolIntersectDirect2D.equalPoints(lox2, loy2, lx2, ly2) || ToolIntersectDirect2D.checkPointOnLinearWithoutDistance(lox1, loy1, lx1, ly1, lx2, ly2) || ToolIntersectDirect2D.checkPointOnLinearWithoutDistance(lx1, ly1, lox1, loy1, lox2, loy2) && ToolIntersectDirect2D.checkPointOnLinearWithoutDistance(lx2, ly2, lox1, loy1, lox2, loy2)) {
                    return 5;
                }
                return 6;
            }
        } else {
            result = ToolIntersectDirect2D.getSideOfPointWithLine(lox1, loy1, lx1, ly1, lx2, ly2);
            byte result2 = ToolIntersectDirect2D.getSideOfPointWithLine(lox2, loy2, lx1, ly1, lx2, ly2);
            if (result == 3 && result == 3) {
                result = ToolIntersectDirect2D.checkPointOnLinearWithoutDistance(lx1, ly1, lox1, loy1, lox2, loy2) ? 5 : 6;
            } else if (result == 2 && result2 == 1) {
                result = 3;
            } else if (result == 1 && result2 == 2) {
                result = 4;
            } else if (result == 3) {
                result = result2;
            }
        }
        return (byte)result;
    }

    public static byte getDirectionOfLineToArc(double ax1, double ay1, double ax2, double ay2, double axc, double ayc, double radius, boolean isCw, double lox1, double loy1, double lox2, double loy2) {
        double lx1 = 0.0;
        double ly1 = 0.0;
        double lx2 = 0.0;
        double ly2 = 0.0;
        int result = 0;
        if (ToolIntersectDirect2D.checkPointOn(lox1, loy1, ax1, ay1, ax2, ay2, axc, ayc, radius, isCw)) {
            lx1 = lox1;
            ly1 = loy1;
            double dx = lx1 - axc;
            double dy = ly1 - ayc;
            lx2 = lx1 + (isCw ? dy : -dy);
            ly2 = ly1 + (isCw ? -dx : dx);
        } else if (ToolIntersectDirect2D.checkPointOn(lox2, loy2, ax1, ay1, ax2, ay2, axc, ayc, radius, isCw)) {
            lx1 = lox2;
            ly1 = loy2;
            double dx = lx1 - axc;
            double dy = ly1 - ayc;
            lx2 = lx1 + (isCw ? dy : -dy);
            ly2 = ly1 + (isCw ? -dx : dx);
        } else {
            double dx = lox2 - axc;
            double dy = loy2 - ayc;
            double dist = Math.sqrt(dx * dx + dy * dy);
            if (dist < radius) {
                return isCw ? (byte)3 : 4;
            }
            return isCw ? (byte)4 : 3;
        }
        result = ToolIntersectDirect2D.getDirectionOfLineToLine(lx1, ly1, lx2, ly2, lox1, loy1, lox2, loy2);
        if (result == 5) {
            result = isCw ? 2 : 1;
        }
        return (byte)result;
    }

    public static byte getDirectionOfArcToLine(double lx1, double ly1, double lx2, double ly2, double aox1, double aoy1, double aox2, double aoy2, double aoxc, double aoyc, double aoRadius, boolean aoIsCw) {
        double lox1 = 0.0;
        double loy1 = 0.0;
        double lox2 = 0.0;
        double loy2 = 0.0;
        byte result = 0;
        if (ToolIntersectDirect2D.checkPointOn(aox1, aoy1, lx1, ly1, lx2, ly2)) {
            lox1 = aox1;
            loy1 = aoy1;
            double dx = lox1 - aoxc;
            double dy = loy1 - aoyc;
            lox2 = lox1 + (aoIsCw ? dy : -dy);
            loy2 = loy1 + (aoIsCw ? -dx : dx);
        } else if (ToolIntersectDirect2D.checkPointOn(aox2, aoy2, lx1, ly1, lx2, ly2)) {
            lox1 = aox2;
            loy1 = aoy2;
            double dx = lox1 - aoxc;
            double dy = loy1 - aoyc;
            lox2 = lox1 + (aoIsCw ? dy : -dy);
            loy2 = loy1 + (aoIsCw ? -dx : dx);
        } else {
            return ToolIntersectDirect2D.getSideOfPointWithLine(aox1, aoy1, lx1, ly1, lx2, ly2);
        }
        result = ToolIntersectDirect2D.getDirectionOfLineToLine(lx1, ly1, lx2, ly2, lox1, loy1, lox2, loy2);
        if (result == 5) {
            result = ToolIntersectDirect2D.getSideOfPointWithLine(aoxc, aoyc, lx1, ly1, lx2, ly2);
        }
        return result;
    }

    public static byte getDirectionOfArcToArc(double ax1, double ay1, double ax2, double ay2, double axc, double ayc, double aRadius, boolean aIsCw, double aox1, double aoy1, double aox2, double aoy2, double aoxc, double aoyc, double aoRadius, boolean aoIsCw) {
        double loy2;
        double lox2;
        double ly2;
        double lx2;
        double ly1;
        double loy1;
        double lx1;
        double lox1;
        int result = 0;
        if (ToolIntersectDirect2D.equalPoints(axc, ayc, aoxc, aoyc) && ToolIntersectDirect2D.compareDistance(aRadius, aoRadius) == 0) {
            if (ToolIntersectDirect2D.equalPoints(ax1, ay1, aox1, aoy1)) {
                return aIsCw == aoIsCw ? (byte)5 : 6;
            }
            if (ToolIntersectDirect2D.equalPoints(ax1, ay1, aox2, aoy2)) {
                return aIsCw != aoIsCw ? (byte)5 : 6;
            }
            if (ToolIntersectDirect2D.equalPoints(ax2, ay2, aox1, aoy1)) {
                return aIsCw != aoIsCw ? (byte)5 : 6;
            }
            if (ToolIntersectDirect2D.equalPoints(ax2, ay2, aox2, aoy2)) {
                return aIsCw == aoIsCw ? (byte)5 : 6;
            }
            if (ToolIntersectDirect2D.checkPointOn(aox1, aoy1, ax1, ay1, ax2, ay2, axc, ayc, aRadius, aIsCw) || ToolIntersectDirect2D.checkPointOn(aox2, aoy2, ax1, ay1, ax2, ay2, axc, ayc, aRadius, aIsCw) || ToolIntersectDirect2D.checkPointOn(ax1, ay1, aox1, aoy1, aox2, aoy2, aoxc, aoyc, aoRadius, aoIsCw) || ToolIntersectDirect2D.checkPointOn(ax2, ay2, aox1, aoy1, aox2, aoy2, aoxc, aoyc, aoRadius, aoIsCw)) {
                return 5;
            }
            return 6;
        }
        if (ToolIntersectDirect2D.checkPointOn(aox1, aoy1, ax1, ay1, ax2, ay2, axc, ayc, aRadius, aIsCw)) {
            lx1 = lox1 = aox1;
            ly1 = loy1 = aoy1;
            double dx = lx1 - axc;
            double dy = ly1 - ayc;
            lx2 = lx1 + (aIsCw ? dy : -dy);
            ly2 = ly1 + (aIsCw ? -dx : dx);
            dx = lox1 - aoxc;
            dy = loy1 - aoyc;
            lox2 = lox1 + (aoIsCw ? dy : -dy);
            loy2 = loy1 + (aoIsCw ? -dx : dx);
        } else if (ToolIntersectDirect2D.checkPointOn(aox2, aoy2, ax1, ay1, ax2, ay2, axc, ayc, aRadius, aIsCw)) {
            lx1 = lox1 = aox2;
            ly1 = loy1 = aoy2;
            double dx = lx1 - axc;
            double dy = ly1 - ayc;
            lx2 = lx1 + (aIsCw ? dy : -dy);
            ly2 = ly1 + (aIsCw ? -dx : dx);
            dx = lox1 - aoxc;
            dy = loy1 - aoyc;
            lox2 = lox1 + (aoIsCw ? dy : -dy);
            loy2 = loy1 + (aoIsCw ? -dx : dx);
        } else {
            double dx = aox2 - axc;
            double dy = aoy2 - ayc;
            double dist = Math.sqrt(dx * dx + dy * dy);
            if (dist < aRadius) {
                return aIsCw ? (byte)3 : 4;
            }
            return aIsCw ? (byte)4 : 3;
        }
        result = ToolIntersectDirect2D.getDirectionOfLineToLine(lx1, ly1, lx2, ly2, lox1, loy1, lox2, loy2);
        if (result == 5) {
            double dist = ToolIntersectDirect2D.getDistance(axc, ayc, aoxc, aoyc);
            result = Math.abs(dist) <= 1.0E-7 ? 5 : (Math.abs(dist - aRadius - aoRadius) <= 1.0E-7 ? (aIsCw ? 2 : 1) : (aIsCw ? 1 : 2));
        }
        return (byte)result;
    }
}

