/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.math.geom;

import jp.kitec.math.algebra.ToolAlgebra1D;
import jp.kitec.math.geom.ToolGeom2D;

public class ToolGeom3D {
    public static void main(String[] arg) {
        ToolGeom3D.test6();
    }

    static void test1() {
        double[] points = new double[]{10.0, 13.0, 15.0, 20.0, 20.0, 16.0, 12.0, 40.0, 29.0, 28.0, 17.0, 25.0, 8.0, 24.0, 30.0, 14.0, 9.0, 22.0, 18.0, 8.0, 23.0, 54.0, 16.0, 7.0, 68.0, 41.0, 68.0, 43.0, 54.0, 16.0, 7.0, 6.0, 7.0, 63.0, 17.0, 9.0, 8.0, 7.0, 9.0};
        double[] center = new double[3];
        double r = ToolGeom3D.getCenterOfCapsularSphere(center, points);
    }

    static void test2() {
        double[] viewPoint = new double[3];
        ToolGeom3D.getViewPointOfSphereFittingScreen(viewPoint, 0.0, 0.0, 0.0, 10000.0, 10000.0, 10000.0, 100.0, 1.5707963267948966, 0.0);
    }

    static void test3() {
        double[] points = new double[]{10000.0, 10000.0, 10000.0, 10000.0, 10010.0, 10000.0, 10000.0, 10000.0, 10010.0, 10000.0, 10000.0, 9990.0, 10000.0, 9990.0, 10000.0};
        double[] center = new double[3];
        double[] viewPoint = new double[3];
        ToolGeom3D.getViewPoitnsOfFittingScreen(viewPoint, center, points, 10000.0, 0.0, 10000.0, 0.0, 0.0, 1.0, 1.5707963267948966, 1.5707963267948966, 0.0);
    }

    static void test4() {
        double[] points = new double[]{10.0, 10.0, 10.0, 10.0, 10.0, -10.0, 10.0, 10.0, 0.0, -10.0, 10.0, 10.0, -10.0, 10.0, -10.0, -10.0, 10.0, 0.0};
        double[] center = new double[3];
        double[] viewPoint = new double[3];
        ToolGeom3D.getViewPoitnsOfFittingScreen(viewPoint, center, points, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.5707963267948966, 1.5707963267948966, 0.0);
    }

    static void test5() {
        double[] points = new double[]{10000.0, 10000.0, 10000.0, 10000.0, 10010.0, 10000.0, 10010.0, 10000.0, 10000.0, 9990.0, 10000.0, 10000.0, 10000.0, 9990.0, 10000.0};
        double[] center = new double[3];
        double[] viewPoint = new double[3];
        ToolGeom3D.getViewPoitnsOfFittingScreen(viewPoint, center, points, 10000.0, 9900.0, 10000.0, 0.0, 0.0, 1.0, 1.5707963267948966, 1.5707963267948966, 0.0);
    }

    static void test6() {
        double[] points = new double[]{0.0, 0.0, 0.0, 100.0, 0.0, 0.0, 100.0, 100.0, 0.0, 0.0, 100.0, 0.0, 50.0, 50.0, 0.0};
        double[] center = new double[3];
        double[] viewPoint = new double[3];
        ToolGeom3D.getViewPoitnsOfFittingScreen(viewPoint, center, points, -100.0, -100.0, 100.0, 0.0, 0.0, 1.0, 1.5707963267948966, 1.5707963267948966, 0.0);
    }

    public static double getCenterOfCapsularSphere(double[] center, double[] points) {
        double z1 = Double.MAX_VALUE;
        double y1 = Double.MAX_VALUE;
        double x1 = Double.MAX_VALUE;
        double z2 = -1.7976931348623157E308;
        double y2 = -1.7976931348623157E308;
        double x2 = -1.7976931348623157E308;
        for (int i = 0; i < points.length; i += 3) {
            if (points[i] < x1) {
                x1 = points[i];
            }
            if (points[i] > x2) {
                x2 = points[i];
            }
            if (points[i + 1] < y1) {
                y1 = points[i + 1];
            }
            if (points[i + 1] > y2) {
                y2 = points[i + 1];
            }
            if (points[i + 2] < z1) {
                z1 = points[i + 2];
            }
            if (!(points[i + 2] > z2)) continue;
            z2 = points[i + 2];
        }
        double xc = (x2 + x1) / 2.0;
        double yc = (y2 + y1) / 2.0;
        double zc = (z2 + z1) / 2.0;
        double min = 0.0;
        double max = 0.0;
        double xcMin = xc;
        double ycMin = yc;
        double zcMin = zc;
        double minR = Double.MAX_VALUE;
        for (int i = 0; i < 10; ++i) {
            double ave = 0.0;
            double xv = 0.0;
            double yv = 0.0;
            double zv = 0.0;
            min = Double.MAX_VALUE;
            max = Double.MIN_VALUE;
            for (int j = 0; j < points.length; j += 3) {
                double dist = ToolGeom3D.getDistance(xc, yc, zc, points[j], points[j + 1], points[j + 2]);
                if (dist < min) {
                    min = dist;
                }
                if (dist > max) {
                    xv = points[j];
                    yv = points[j + 1];
                    zv = points[j + 2];
                    max = dist;
                }
                ave += dist;
            }
            if (max < minR) {
                xcMin = xc;
                ycMin = yc;
                zcMin = zc;
                minR = max;
            }
            double parameter = (max - (ave /= (double)(points.length / 3))) / max;
            xc += (xv - xc) * parameter;
            yc += (yv - yc) * parameter;
            zc += (zv - zc) * parameter;
        }
        center[0] = xcMin;
        center[1] = ycMin;
        center[2] = zcMin;
        return minR;
    }

    public static double getDistance(double x1, double y1, double z1, double x2, double y2, double z2) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        double dz = z2 - z1;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public static void transfer(double[] vector, double xo, double yo, double zo, double vectorXx, double vectorXy, double vectorXz, double vectorYx, double vectorYy, double vectorYz, double vectorZx, double vectorZy, double vectorZz, double x, double y, double z) {
        double dx = Math.sqrt(vectorXx * vectorXx + vectorXy * vectorXy + vectorXz * vectorXz);
        double dy = Math.sqrt(vectorYx * vectorYx + vectorYy * vectorYy + vectorYz * vectorYz);
        double dz = Math.sqrt(vectorZx * vectorZx + vectorZy * vectorZy + vectorZz * vectorZz);
        vector[0] = vectorXx / dx * (x - xo) + vectorXy / dx * (y - yo) + vectorXz / dx * (z - zo);
        vector[1] = vectorYx / dy * (x - xo) + vectorYy / dy * (y - yo) + vectorYz / dy * (z - zo);
        vector[2] = vectorZx / dz * (x - xo) + vectorZy / dz * (y - yo) + vectorZz / dz * (z - zo);
    }

    public static void getViewPointOfSphereFittingScreen(double[] viewPoint, double viewX, double viewY, double viewZ, double centerX, double centerY, double centerZ, double radius, double viewAngle, double margin) {
        double dist = ToolGeom3D.getDistance(viewX, viewY, viewZ, centerX, centerY, centerZ);
        double sin = Math.sin(viewAngle / 2.0);
        double parameter = (radius + margin) / sin;
        double tan = Math.tan(viewAngle / 2.0) * parameter;
        double coeff = tan / dist;
        viewPoint[0] = (viewX - centerX) * coeff + centerX;
        viewPoint[1] = (viewY - centerY) * coeff + centerY;
        viewPoint[2] = (viewZ - centerZ) * coeff + centerZ;
    }

    public static boolean getViewPoitnsOfFittingScreen(double[] viewPoint, double[] centerPoint, double[] points, double viewX, double viewY, double viewZ, double upperVecX, double upperVecY, double upperVecZ, double viewAngleW, double viewAngleH, double margin) {
        double angleB;
        double angleA;
        double viewAngle;
        double length;
        double[] output = new double[10];
        double distProperMin = 0.0;
        double distProperMax = 0.0;
        double distProper = 0.0;
        double distXYMin = 0.0;
        double distXZMin = 0.0;
        double distXYMax = 0.0;
        double distXZMax = 0.0;
        double percent = 1.0;
        viewAngleW *= 1.32;
        viewAngleH *= 1.32;
        viewPoint[0] = viewX;
        viewPoint[1] = viewY;
        viewPoint[2] = viewZ;
        double r = ToolGeom3D.getCenterOfCapsularSphere(centerPoint, points);
        if (r * 2.0 > (length = ToolGeom3D.getDistance(viewPoint[0], viewPoint[1], viewPoint[2], centerPoint[0], centerPoint[1], centerPoint[2]))) {
            viewPoint[0] = ToolGeom2D.getValueFromParameter(centerPoint[0], viewPoint[0], r / length * 2.0);
            viewPoint[1] = ToolGeom2D.getValueFromParameter(centerPoint[1], viewPoint[1], r / length * 2.0);
            viewPoint[2] = ToolGeom2D.getValueFromParameter(centerPoint[2], viewPoint[2], r / length * 2.0);
            length = ToolGeom3D.getDistance(viewPoint[0], viewPoint[1], viewPoint[2], centerPoint[0], centerPoint[1], centerPoint[2]);
        }
        if ((distProper = ToolGeom3D.getPerspectiveAngle(output, points, viewPoint[0], viewPoint[1], viewPoint[2], upperVecX, upperVecY, upperVecZ)) < 0.0) {
            return false;
        }
        double angleXYMin = output[0];
        double angleXYMax = output[1];
        double angleXZMin = output[2];
        double angleXZMax = output[3];
        distXYMin = output[4];
        distXYMax = output[5];
        distXZMin = output[6];
        distXZMax = output[7];
        double angleXYMid = Math.atan2(centerPoint[1] - viewPoint[1], centerPoint[0] - viewPoint[0]);
        double angleXZMid = Math.asin((centerPoint[2] - viewPoint[2]) / length);
        double angleXY = Math.abs(angleXYMax - angleXYMin);
        double angleXZ = Math.abs(angleXZMax - angleXZMin);
        if (angleXY > Math.PI) {
            angleXY = Math.PI * 2 - angleXY;
        }
        if (angleXZ > Math.PI) {
            angleXZ = Math.PI * 2 - angleXZ;
        }
        if (1.0 - Math.abs(angleXY / viewAngleW) < 1.0 - Math.abs(angleXZ / viewAngleH)) {
            viewAngle = viewAngleW;
            double angle = angleXY;
            distProperMin = distXYMin;
            distProperMax = distXYMax;
            angleA = angleXYMid - angleXYMin;
            angleB = angleXYMax - angleXYMid;
        } else {
            viewAngle = viewAngleH;
            double angle = angleXZ;
            distProperMin = distXZMin;
            distProperMax = distXZMax;
            angleA = angleXZMid - angleXZMin;
            angleB = angleXZMax - angleXZMid;
        }
        double sinA = distProperMin * Math.sin(angleA);
        double cosA = distProperMin * Math.cos(angleA);
        double sinB = distProperMax * Math.sin(angleB);
        double cosB = distProperMax * Math.cos(angleB);
        double tanAll = Math.tan(viewAngle);
        ToolAlgebra1D eq = new ToolAlgebra1D(tanAll, tanAll * cosB - sinA - sinB + cosA * tanAll, cosA * (tanAll * cosB - sinB) - sinA * (tanAll * sinB + cosB));
        int num = eq.solve();
        double d = eq.getSolution(0) > eq.getSolution(1) ? eq.getSolution(0) : eq.getSolution(1);
        double length3 = ToolGeom3D.getDistance(viewPoint[0], viewPoint[1], viewPoint[2], centerPoint[0], centerPoint[1], centerPoint[2]);
        double angle5 = Math.atan2(centerPoint[1] - viewPoint[1], centerPoint[0] - viewPoint[0]);
        double angle6 = Math.asin((centerPoint[2] - viewPoint[2]) / length);
        viewPoint[0] = ToolGeom2D.getValueFromParameter(centerPoint[0], viewPoint[0], (d + length) / length);
        viewPoint[1] = ToolGeom2D.getValueFromParameter(centerPoint[1], viewPoint[1], (d + length) / length);
        viewPoint[2] = ToolGeom2D.getValueFromParameter(centerPoint[2], viewPoint[2], (d + length) / length);
        double length4 = ToolGeom3D.getDistance(viewPoint[0], viewPoint[1], viewPoint[2], centerPoint[0], centerPoint[1], centerPoint[2]);
        double angle7 = Math.atan2(centerPoint[1] - viewPoint[1], centerPoint[0] - viewPoint[0]);
        double angle8 = Math.asin((centerPoint[2] - viewPoint[2]) / length4);
        distProper = ToolGeom3D.getPerspectiveAngle(output, points, viewPoint[0], viewPoint[1], viewPoint[2], upperVecX, upperVecY, upperVecZ);
        if (distProper < 0.0) {
            return false;
        }
        angleXYMin = output[0];
        angleXYMax = output[1];
        angleXZMin = output[2];
        angleXZMax = output[3];
        distXYMin = output[4];
        distXZMin = output[5];
        angleXYMid = (angleXYMin + angleXYMax) / 2.0;
        angleXZMid = (angleXZMin + angleXZMax) / 2.0;
        angleXY = Math.abs(angleXYMax - angleXYMin);
        angleXZ = Math.abs(angleXZMax - angleXZMin);
        length = ToolGeom3D.getDistance(viewPoint[0], viewPoint[1], viewPoint[2], centerPoint[0], centerPoint[1], centerPoint[2]);
        centerPoint[0] = Math.sin(1.5707963267948966 - angleXZMid) * Math.cos(angleXYMid) * length + viewPoint[0];
        centerPoint[1] = Math.sin(1.5707963267948966 - angleXZMid) * Math.sin(angleXYMid) * length + viewPoint[1];
        centerPoint[2] = Math.cos(1.5707963267948966 - angleXZMid) * length + viewPoint[2];
        distProper = ToolGeom3D.getPerspectiveAngle(output, points, viewPoint[0], viewPoint[1], viewPoint[2], upperVecX, upperVecY, upperVecZ);
        if (distProper < 0.0) {
            return false;
        }
        angleXYMin = output[0];
        angleXYMax = output[1];
        angleXZMin = output[2];
        angleXZMax = output[3];
        distXYMin = output[4];
        distXZMin = output[5];
        double length5 = ToolGeom3D.getDistance(viewPoint[0], viewPoint[1], viewPoint[2], centerPoint[0], centerPoint[1], centerPoint[2]);
        double angle9 = Math.atan2(centerPoint[1] - viewPoint[1], centerPoint[0] - viewPoint[0]);
        double angle10 = Math.asin((centerPoint[2] - viewPoint[2]) / length5);
        angleXYMid = (angleXYMin + angleXYMax) / 2.0;
        angleXZMid = (angleXZMin + angleXZMax) / 2.0;
        angleXY = Math.abs(angleXYMax - angleXYMin);
        angleXZ = Math.abs(angleXZMax - angleXZMin);
        if (ToolGeom2D.compare(viewPoint[0], 0.0) == 0) {
            viewPoint[0] = 0.0;
        }
        if (ToolGeom2D.compare(viewPoint[1], 0.0) == 0) {
            viewPoint[1] = 0.0;
        }
        if (ToolGeom2D.compare(viewPoint[2], 0.0) == 0) {
            viewPoint[2] = 0.0;
        }
        if (ToolGeom2D.compare(centerPoint[0], 0.0) == 0) {
            centerPoint[0] = 0.0;
        }
        if (ToolGeom2D.compare(centerPoint[1], 0.0) == 0) {
            centerPoint[1] = 0.0;
        }
        if (ToolGeom2D.compare(centerPoint[2], 0.0) == 0) {
            centerPoint[2] = 0.0;
        }
        return true;
    }

    static double getPerspectiveAngle(double[] result, double[] points, double viewX, double viewY, double viewZ, double upperVecX, double upperVecY, double upperVecZ) {
        double angleXZ;
        double angleXY;
        double z;
        double y;
        double x;
        double[] vectorTmp1 = new double[3];
        double[] vectorTmp2 = new double[3];
        double distXYMin = Double.MAX_VALUE;
        double distXZMin = Double.MAX_VALUE;
        double distXYMax = Double.MAX_VALUE;
        double distXZMax = Double.MAX_VALUE;
        double angleXYMin = Double.MAX_VALUE;
        double angleXZMin = Double.MAX_VALUE;
        double angleXYMax = -1.7976931348623157E308;
        double angleXZMax = -1.7976931348623157E308;
        double dist = 0.0;
        double distProper = 0.0;
        double d = ToolGeom3D.getDistance(0.0, 0.0, 0.0, upperVecX, upperVecY, upperVecZ);
        int xyMin = 0;
        int xyMax = 0;
        int xzMin = 0;
        int xzMax = 0;
        ToolGeom3D.getAPerpendicularUnitVector(vectorTmp1, upperVecX, upperVecY, upperVecZ);
        ToolGeom3D.getVectorProduct(vectorTmp2, upperVecX, upperVecY, upperVecZ, vectorTmp1[0], vectorTmp1[1], vectorTmp1[2]);
        double l1 = vectorTmp1[0] / d;
        double m1 = vectorTmp1[1] / d;
        double n1 = vectorTmp1[2] / d;
        double l2 = vectorTmp2[0] / d;
        double m2 = vectorTmp2[1] / d;
        double n2 = vectorTmp2[2] / d;
        double l3 = upperVecX / d;
        double m3 = upperVecY / d;
        double n3 = upperVecZ / d;
        int i = 0;
        while (i + 2 < points.length) {
            x = l1 * (points[i] - viewX) + m1 * (points[i + 1] - viewY) + n1 * (points[i + 2] - viewZ);
            y = l2 * (points[i] - viewX) + m2 * (points[i + 1] - viewY) + n2 * (points[i + 2] - viewZ);
            z = l3 * (points[i] - viewX) + m3 * (points[i + 1] - viewY) + n3 * (points[i + 2] - viewZ);
            dist = Math.sqrt(x * x + y * y + z * z);
            distProper += dist;
            angleXY = Math.atan2(y, x);
            angleXZ = Math.asin(z / dist);
            if (angleXY < angleXYMin) {
                angleXYMin = angleXY;
                distXYMin = dist;
                xyMin = i;
            }
            if (angleXY > angleXYMax) {
                angleXYMax = angleXY;
                distXYMax = dist;
                xyMax = i;
            }
            if (angleXZ < angleXZMin) {
                angleXZMin = angleXZ;
                distXZMin = dist;
                xzMin = i;
            }
            if (angleXZ > angleXZMax) {
                angleXZMax = angleXZ;
                distXZMax = dist;
                xzMax = i;
            }
            i += 3;
        }
        distProper /= (double)(points.length / 3);
        if (ToolGeom2D.compareAngle(angleXYMax - angleXYMin, Math.PI) == 0) {
            return -1.0;
        }
        result[0] = angleXYMin;
        result[1] = angleXYMax;
        result[2] = angleXZMin;
        result[3] = angleXZMax;
        result[4] = distXYMin;
        result[5] = distXYMax;
        result[6] = distXZMin;
        result[7] = distXZMax;
        double tmpX = (points[xyMin] + points[xyMax]) / 2.0;
        double tmpY = (points[xyMin + 1] + points[xyMax + 1]) / 2.0;
        double tmpZ = (points[xyMin + 2] + points[xyMax + 2]) / 2.0;
        x = l1 * (tmpX - viewX) + m1 * (tmpY - viewY) + n1 * (tmpZ - viewZ);
        y = l2 * (tmpX - viewX) + m2 * (tmpY - viewY) + n2 * (tmpZ - viewZ);
        z = l3 * (tmpX - viewX) + m3 * (tmpY - viewY) + n3 * (tmpZ - viewZ);
        dist = Math.sqrt(x * x + y * y + z * z);
        angleXY = Math.atan2(y, x);
        angleXZ = Math.asin(z / dist);
        result[8] = angleXY;
        result[9] = angleXZ;
        return distProper;
    }

    public static void getAPerpendicularUnitVector(double[] result, double vectorX, double vectorY, double vectorZ) {
        if (vectorZ != 0.0) {
            result[2] = 0.0;
            if (vectorX == 0.0) {
                result[0] = 1.0;
                result[1] = 0.0;
                return;
            }
        } else {
            if (vectorY != 0.0) {
                result[1] = 0.0;
                result[0] = 0.0;
                result[2] = 1.0;
                return;
            }
            result[2] = 0.0;
            result[0] = 0.0;
            result[1] = 1.0;
            return;
        }
        result[0] = -vectorY / vectorX;
        result[1] = 1.0;
        double d = ToolGeom3D.getDistance(0.0, 0.0, 0.0, result[0], result[1], result[2]);
        result[0] = result[0] / d;
        result[1] = result[1] / d;
        result[2] = result[2] / d;
    }

    public static void getVectorProduct(double[] result, double vectorX1, double vectorY1, double vectorZ1, double vectorX2, double vectorY2, double vectorZ2) {
        result[0] = vectorY1 * vectorZ2 - vectorZ1 * vectorY2;
        result[1] = vectorZ1 * vectorX2 - vectorX1 * vectorZ2;
        result[2] = vectorX1 * vectorY2 - vectorY1 * vectorX2;
        double d = ToolGeom3D.getDistance(0.0, 0.0, 0.0, result[0], result[1], result[2]);
        result[0] = result[0] / d;
        result[1] = result[1] / d;
        result[2] = result[2] / d;
    }

    public static void getGravityPoint(double[] result, double[] points) {
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        int i = 0;
        while (i + 2 < points.length) {
            x += points[i];
            y += points[i + 1];
            z += points[i + 2];
            i += 3;
        }
        result[0] = x / (double)(points.length / 3);
        result[1] = y / (double)(points.length / 3);
        result[2] = z / (double)(points.length / 3);
    }
}

