/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.math.geom;

import jp.kitec.math.algebra.AlgebraException;
import jp.kitec.math.geom.ToolIntersectPoint2D;

public class ToolGeom2D
extends ToolIntersectPoint2D {
    public static final int LINE = 1;
    public static final int ARCCW = 2;
    public static final int ARCCCW = 3;

    public static void main(String[] arg) {
        double[] result = new double[4];
        double d = 2.0 / Math.sqrt(2.0);
        try {
            int num = ToolGeom2D.getIntersectPoints(result, 0.0, d, d, 0.0, 1.0, 0.0, -1.0, 0.0, 0.0, 0.0, 1.0, false);
        }
        catch (AlgebraException e) {
            // empty catch block
        }
    }

    public static int compareAngle(double angle1, double angle2) {
        if (Math.abs(angle2 - angle1) < 1.0E-4) {
            return 0;
        }
        if (angle1 < angle2) {
            return -1;
        }
        return 1;
    }

    public static double getParameter(double px, double x1, double x2) {
        double dx = x2 - x1;
        double parameter = Double.POSITIVE_INFINITY;
        if (Math.abs(dx) > 1.0E-8) {
            parameter = (px - x1) / dx;
        }
        if (Math.abs(parameter) <= 1.0E-10) {
            parameter = 0.0;
        }
        return parameter;
    }

    public static double getParameter(double px, double py, double x1, double y1, double x2, double y2) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        double parameter = Double.POSITIVE_INFINITY;
        if (Math.abs(dx) > 1.0E-8) {
            parameter = (px - x1) / dx;
        } else if (Math.abs(dy) > 1.0E-8) {
            parameter = (py - y1) / dy;
        }
        if (Math.abs(parameter) <= 1.0E-10) {
            parameter = 0.0;
        }
        return parameter;
    }

    public static double getParameter(double px, double py, double x1, double y1, double x2, double y2, double xc, double yc, double radius, boolean cw) {
        double angleAll;
        double parameter = Double.POSITIVE_INFINITY;
        int sw = 0;
        double angle1 = Math.atan2(y1 - yc, x1 - xc);
        double angle2 = Math.atan2(y2 - yc, x2 - xc);
        double angle = Math.atan2(py - yc, px - xc);
        if (cw && angle1 < angle2) {
            angleAll = angle2 - angle1 - Math.PI * 2;
            sw = 1;
        } else if (!cw && angle1 > angle2) {
            angleAll = Math.PI * 2 - angle1 + angle2;
            sw = 2;
        } else {
            angleAll = angle2 - angle1;
        }
        switch (sw) {
            case 1: {
                if (!(angle1 < angle)) break;
                angle -= Math.PI * 2;
                break;
            }
            case 2: {
                if (!(angle1 > angle)) break;
                angle += Math.PI * 2;
            }
        }
        parameter = (angle - angle1) / angleAll;
        return parameter;
    }

    public static double getValueFromParameter(double v1, double v2, double parameter) {
        double d = v2 - v1;
        return v1 + d * parameter;
    }

    public static void getPointFromParameter(double[] point, double x1, double y1, double x2, double y2, double parameter) {
        point[0] = ToolGeom2D.getValueFromParameter(x1, x2, parameter);
        point[1] = ToolGeom2D.getValueFromParameter(y1, y2, parameter);
    }

    public static void getPointFromParameter(double[] point, double x1, double y1, double x2, double y2, double xc, double yc, double radius, boolean cw, double parameter) {
        double angle1 = Math.atan2(y1 - yc, x1 - xc);
        double angle2 = Math.atan2(y2 - yc, x2 - xc);
        double angleDiff = cw && angle1 < angle2 ? angle2 - (angle1 + Math.PI * 2) : (!cw && angle1 > angle2 ? angle2 - (angle1 - Math.PI * 2) : angle2 - angle1);
        double angle = parameter * angleDiff + angle1;
        if (angle > Math.PI) {
            angle -= Math.PI * 2;
        } else if (angle < -Math.PI) {
            angle += Math.PI * 2;
        }
        point[0] = xc + Math.cos(angle) * radius;
        point[1] = yc + Math.sin(angle) * radius;
    }

    public static void getPointFromDistance(double[] point, double x1, double y1, double x2, double y2, double distance, boolean bFirstPoint) {
        double length = ToolGeom2D.getLength(x1, y1, x2, y2);
        double parameter = bFirstPoint ? distance / length : (length - distance) / length;
        ToolGeom2D.getPointFromParameter(point, x1, y1, x2, y2, parameter);
    }

    public static void getPointFromDistance(double[] point, double x1, double y1, double x2, double y2, double xc, double yc, double radius, boolean isCw, double distance, boolean bFirstPoint) {
        double length = ToolGeom2D.getLength(x1, y1, x2, y2, xc, yc, radius, isCw);
        double parameter = bFirstPoint ? distance / length : (length - distance) / length;
        ToolGeom2D.getPointFromParameter(point, x1, y1, x2, y2, xc, yc, radius, isCw, parameter);
    }

    public static boolean getPerpendicularPoint(double[] result, double px, double py, double x1, double y1, double x2, double y2) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        if (ToolGeom2D.compare(dx, 0.0, 1.0E-8) == 0) {
            result[0] = (x1 + x2) / 2.0;
            result[1] = py;
        } else if (ToolGeom2D.compare(dy, 0.0, 1.0E-8) == 0) {
            result[0] = px;
            result[1] = (y1 + y2) / 2.0;
        } else {
            double len = Math.sqrt(dx * dx + dy * dy);
            double dist = ((x1 - px) * (y2 - py) - (y1 - py) * (x2 - px)) / len;
            double vx = -dy * (dist / len);
            double vy = dx * (dist / len);
            result[0] = px + vx;
            result[1] = py + vy;
            double checkX = result[0] - x1;
            double rasio1 = checkX / dx;
            double checkY = result[1] - y1;
            double rasio2 = checkY / dy;
            if (Math.abs(rasio1 - rasio2) > 1.0E-8) {
                result[0] = px - vx;
                result[1] = py - vy;
            }
        }
        return true;
    }

    public static boolean getPerpendicularPoint(double[] result, double px, double py, double x1, double y1, double x2, double y2, double xc, double yc, double radius, boolean isCw) {
        double dx = px - xc;
        double dy = py - yc;
        double dist = Math.sqrt(dx * dx + dy * dy);
        if (dist == 0.0) {
            return false;
        }
        result[0] = xc + dx * (radius / dist);
        result[1] = yc + dy * (radius / dist);
        return true;
    }

    public static void getFitRectangle(double[] result, double x1, double y1, double x2, double y2) {
        result[0] = Math.min(x1, x2);
        result[1] = Math.min(y1, y2);
        result[2] = Math.max(x1, x2);
        result[3] = Math.max(y1, y2);
    }

    public static void getFitRectangle(double[] result, double x1, double y1, double x2, double y2, double xc, double yc, double radius, boolean cw) {
        double dAngle2;
        double dAngle1;
        if (ToolGeom2D.compareDistance(radius, 0.0) == 0) {
            radius = ToolGeom2D.getRadius(x1, y1, x2, y2, xc, yc);
        }
        if (!cw) {
            dAngle1 = Math.atan2(y1 - yc, x1 - xc);
            dAngle2 = Math.atan2(y2 - yc, x2 - xc);
        } else {
            dAngle1 = Math.atan2(y2 - yc, x2 - xc);
            dAngle2 = Math.atan2(y1 - yc, x1 - xc);
        }
        if (x1 < x2) {
            result[0] = x1;
            result[2] = x2;
        } else {
            result[0] = x2;
            result[2] = x1;
        }
        if (y1 < y2) {
            result[1] = y1;
            result[3] = y2;
        } else {
            result[1] = y2;
            result[3] = y1;
        }
        if (dAngle1 < dAngle2) {
            if (dAngle1 < -1.5707963267948966 && dAngle2 > -1.5707963267948966) {
                result[1] = yc - radius;
            }
            if (dAngle1 < 0.0 && dAngle2 > 0.0) {
                result[2] = xc + radius;
            }
            if (dAngle1 < 1.5707963267948966 && dAngle2 > 1.5707963267948966) {
                result[3] = yc + radius;
            }
        } else {
            result[0] = xc - radius;
            if (dAngle1 < -1.5707963267948966 || dAngle2 > -1.5707963267948966) {
                result[1] = yc - radius;
            }
            if (dAngle1 < 0.0 || dAngle2 > 0.0) {
                result[2] = xc + radius;
            }
            if (dAngle1 < 1.5707963267948966 || dAngle2 > 1.5707963267948966) {
                result[3] = yc + radius;
            }
        }
    }

    public static void getFitRectangleOr(double[] result, double rect1x1, double rect1y1, double rect1x2, double rect1y2, double rect2x1, double rect2y1, double rect2x2, double rect2y2) {
        result[0] = Math.min(rect1x1, rect2x1);
        result[1] = Math.min(rect1y1, rect2y1);
        result[2] = Math.max(rect1x2, rect2x2);
        result[3] = Math.max(rect1y2, rect2y2);
    }

    public static boolean getFitRectangleAnd(double[] result, double rect1x1, double rect1y1, double rect1x2, double rect1y2, double rect2x1, double rect2y1, double rect2x2, double rect2y2) {
        if (rect1x2 < rect2x1 || rect1x1 > rect2x2 || rect1y2 < rect2y1 || rect1y1 > rect2y2) {
            return false;
        }
        result[0] = rect1x1 >= rect2x1 && rect1x1 <= rect2x2 ? rect1x1 : rect2x1;
        if (rect1y1 >= rect2y1 && rect1y1 <= rect2y2) {
            result[1] = rect1y1;
        } else if (rect2y1 >= rect1y1 && rect2y1 <= rect1y2) {
            result[1] = rect2y1;
        }
        result[2] = rect1x2 >= rect2x1 && rect1x2 <= rect2x2 ? rect1x2 : rect2x2;
        result[3] = rect1y2 >= rect2y1 && rect1y2 <= rect2y2 ? rect1y2 : rect2y2;
        return true;
    }

    public static boolean checkFitRectangleIntersect(double rect1x1, double rect1y1, double rect1x2, double rect1y2, double rect2x1, double rect2y1, double rect2x2, double rect2y2) {
        return ToolGeom2D.compare(rect1x2, rect2x1) >= 0 && ToolGeom2D.compare(rect1x1, rect2x2) <= 0 && ToolGeom2D.compare(rect1y2, rect2y1) >= 0 && ToolGeom2D.compare(rect1y1, rect2y2) <= 0;
    }

    public static double findAreaOfSegment(double x1, double y1, double x2, double y2, double centerX, double centerY, double dR, boolean cw) {
        double dAngle = 0.0;
        double angle1 = Math.atan2(y1 - centerY, x1 - centerX);
        double angle2 = Math.atan2(y2 - centerY, x2 - centerX);
        dAngle = cw ? (angle2 > angle1 ? Math.PI - (angle2 - angle1) : angle1 - angle2) : (angle1 > angle2 ? Math.PI - (angle1 - angle2) : angle2 - angle1);
        dAngle = Math.abs(dAngle);
        double dArea = dR * dR * dAngle / 2.0;
        return dArea -= dR * dR * Math.sin(dAngle) / 2.0;
    }

    public static double getAngleOfArc(double x1, double y1, double x2, double y2, double xc, double yc, boolean cw) {
        double angle1 = Math.atan2(y1 - yc, x1 - xc);
        double angle2 = Math.atan2(y2 - yc, x2 - xc);
        double angleAll = cw && angle1 < angle2 ? angle2 - angle1 - Math.PI * 2 : (!cw && angle1 > angle2 ? Math.PI * 2 - angle1 - angle2 : angle2 - angle1);
        return angleAll;
    }

    public static double getAngleTwoTangentsOfFiguresAtJoint(double f1x1, double f1y1, double f1x2, double f1y2, double f1xc, double f1yc, int type1, double f2x1, double f2y1, double f2x2, double f2y2, double f2xc, double f2yc, int type2) {
        double angle;
        double angle2;
        double angle1;
        if (type1 == 1) {
            angle1 = Math.atan2(f1y2 - f1y1, f1x2 - f1x1);
        } else {
            angle1 = Math.atan2(f1y2 - f1yc, f1x2 - f1xc);
            angle1 += type1 == 2 ? -1.5707963267948966 : 1.5707963267948966;
        }
        if (type2 == 1) {
            angle2 = Math.atan2(f2y2 - f2y1, f2x2 - f2x1);
        } else {
            angle2 = Math.atan2(f2y1 - f2yc, f2x1 - f2xc);
            angle2 += type2 == 2 ? -1.5707963267948966 : 1.5707963267948966;
        }
        if (angle1 <= -Math.PI) {
            angle1 += Math.PI * 2;
        }
        if (angle1 > Math.PI) {
            angle1 -= Math.PI * 2;
        }
        if (angle2 <= -Math.PI) {
            angle2 += Math.PI * 2;
        }
        if (angle2 > Math.PI) {
            angle2 -= Math.PI * 2;
        }
        if (ToolGeom2D.compareAngle(Math.abs(angle = angle2 - angle1), Math.PI) == 0) {
            if (type1 == 2 || type1 == 3) {
                double dY;
                double dX;
                if (type2 == 3) {
                    dX = f2x1 + f2y1 - f1yc;
                    dY = f2y1 - f2x1 - f1xc;
                } else if (type2 == 2) {
                    dX = f2x1 - f2y1 - f1yc;
                    dY = f2y1 + f2x1 - f1xc;
                } else {
                    dX = f2x1;
                    dY = f2y1;
                }
                byte side = ToolGeom2D.getSideOfPointWithLine(dX, dY, f2x2, f2y2, f1xc, f1yc);
                if (side == 1) {
                    return -Math.abs(angle);
                }
                return Math.abs(angle);
            }
            if (type2 == 2 || type2 == 3) {
                double dY;
                double dX;
                if (type1 == 3) {
                    dX = f1x2 + f1y2 - f1yc;
                    dY = f1y2 - f1x2 - f1xc;
                } else if (type1 == 2) {
                    dX = f1x2 - f1y2 - f1yc;
                    dY = f1y2 + f1x2 - f1xc;
                } else {
                    dX = f1x1;
                    dY = f1y1;
                }
                byte side = ToolGeom2D.getSideOfPointWithLine(dX, dY, f1x2, f1y2, f2xc, f2yc);
                if (side == 1) {
                    return -Math.abs(angle);
                }
                return Math.abs(angle);
            }
            if (type1 == 1 && type2 == 1) {
                return Math.PI;
            }
        }
        if (ToolGeom2D.compareAngle(angle, -Math.PI) == -1) {
            return angle + Math.PI * 2;
        }
        if (ToolGeom2D.compareAngle(angle, Math.PI) == 1) {
            return angle - Math.PI * 2;
        }
        return angle;
    }

    public static void getMidPoint(double[] result, double x1, double y1, double x2, double y2) {
        result[0] = (x1 + x2) / 2.0;
        result[1] = (y1 + y2) / 2.0;
    }

    public static void getMidPoint(double[] result, double x1, double y1, double x2, double y2, double xc, double yc, double radius, boolean cw) {
        byte side = ToolGeom2D.getSideOfPointWithLine(xc, yc, x1, y1, x2, y2);
        if (side == 3) {
            double dx = xc - x1;
            double dy = yc - y1;
            result[0] = xc + (cw ? -dy : dy);
            result[1] = yc + (cw ? dx : -dx);
            return;
        }
        double x = (x1 + x2) / 2.0;
        double y = (y1 + y2) / 2.0;
        double dx = x - xc;
        double dy = y - yc;
        double parameter = radius / Math.sqrt(dx * dx + dy * dy);
        if (cw && side == 1 || !cw && side == 2) {
            result[0] = dx * parameter + xc;
            result[1] = dy * parameter + yc;
        } else {
            result[0] = dx * -parameter + xc;
            result[1] = dy * -parameter + yc;
        }
    }

    public static double getRadius(double x1, double y1, double x2, double y2, double xc, double yc) {
        double d1 = ToolGeom2D.getDistance(x1, y1, xc, yc);
        double d2 = ToolGeom2D.getDistance(x2, y2, xc, yc);
        return (d1 + d2) / 2.0;
    }

    public static double getLength(double x1, double y1, double x2, double y2) {
        return ToolGeom2D.getDistance(x1, y1, x2, y2);
    }

    public static double getLength(double x1, double y1, double x2, double y2, double xc, double yc, double radius, boolean cw) {
        double angle = ToolGeom2D.getAngleOfArc(x1, y1, x2, y2, xc, yc, cw);
        return angle * radius * 2.0;
    }

    public static void getOffsetOfLine(double[] result, double x1, double y1, double x2, double y2, double distance, boolean rightSide) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        double dist = Math.sqrt(dx * dx + dy * dy);
        dx *= distance / dist;
        dy *= distance / dist;
        if (rightSide) {
            result[0] = x1 + dy;
            result[1] = y1 - dx;
            result[2] = x2 + dy;
            result[3] = y2 - dx;
        } else {
            result[0] = x1 - dy;
            result[1] = y1 + dx;
            result[2] = x2 - dy;
            result[3] = y2 + dx;
        }
    }

    public static boolean getOffsetOfArc(double[] result, double x1, double y1, double x2, double y2, double xc, double yc, double radius, double offsetDistance, boolean isCw, boolean rightSide) {
        double dist = radius + (isCw == rightSide ? -offsetDistance : offsetDistance);
        result[0] = ToolGeom2D.getValueFromParameter(x1, xc, dist / radius);
        result[1] = ToolGeom2D.getValueFromParameter(y1, yc, dist / radius);
        result[2] = ToolGeom2D.getValueFromParameter(x2, xc, dist / radius);
        result[3] = ToolGeom2D.getValueFromParameter(y2, yc, dist / radius);
        result[4] = dist;
        return dist > 0.0;
    }

    public static double getMinimumDistance(double px, double py, double x1, double y1, double x2, double y2) {
        double dist2;
        double[] point = new double[2];
        if (ToolGeom2D.getPerpendicularPoint(point, px, py, x1, y1, x2, y2) && ToolGeom2D.checkPointOn(point[0], point[1], x1, y1, x2, y2)) {
            return ToolGeom2D.getDistance(px, py, point[0], point[1]);
        }
        double dist1 = ToolGeom2D.getDistance(px, py, x1, y1);
        return dist1 <= (dist2 = ToolGeom2D.getDistance(px, py, x2, y2)) ? dist1 : dist2;
    }

    public static double getMinimumDistance(double px, double py, double x1, double y1, double x2, double y2, double xc, double yc, double radius, boolean isCw) {
        double dist2;
        double[] point = new double[2];
        if (ToolGeom2D.getPerpendicularPoint(point, px, py, x1, y1, x2, y2, xc, yc, radius, isCw) && ToolGeom2D.checkPointOn(point[0], point[1], x1, y1, x2, y2, xc, yc, radius, isCw)) {
            return ToolGeom2D.getDistance(px, py, point[0], point[1]);
        }
        double dist1 = ToolGeom2D.getDistance(px, py, x1, y1);
        return dist1 <= (dist2 = ToolGeom2D.getDistance(px, py, x2, y2)) ? dist1 : dist2;
    }
}

