/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.math.applications.regionslt;

import java.util.Vector;
import jp.kitec.lib.geom.K2DPathFigure;
import jp.kitec.math.algebra.AlgebraException;
import jp.kitec.math.applications.regionslt.CRBasicFunc;
import jp.kitec.math.geom.ToolGeom2D;
import jp.kitec.math.geom.datapassing.IFigure2D;
import jp.kitec.math.geom.datapassing.IFigure2DArc;
import jp.kitec.math.geom.datapassing.IFigureType;
import jp.kitec.math.geom.datapassing.IPolyline2D;
import jp.kitec.math.geom.datapassing.PolylineEditable;
import jp.kitec.math.geom.datapassing.ToolGeomFigure2D;
import jp.kitec.math.geom.datapassing.complete.MFigure;
import jp.kitec.math.geom.datapassing.complete.MPolylineCollection;
import jp.kitec.math.geom.datapassing.plane.IntersectSortedParameter;
import jp.kitec.math.geom.datapassing.plane.IntersectSortedParameters;
import jp.kitec.math.geom.datapassing.plane.ToolPlane2D;
import jp.kitec.math.geom.datapassing.polylines.ToolGeomPolyline2D;
import jp.kitec.math.searches.regiontree.RectangleSupplier;

public class CoveredRegionChecker
extends CRBasicFunc {
    public static final int INIT = 0;
    public static final int VERTICAL = 1;
    public static final int HORIZONTAL = 2;
    public static final int SKEW = 4;
    public static final int ALL = 7;
    public static final int BOOTH = 8;
    public static final int CHECK_COVERED_REGION_CORRECT = 0;
    public static final int CHECK_COVERED_REGION_DEFICIT_AT_END = 1;
    public static final int CHECK_COVERED_REGION_EXCESS_AT_END = 2;
    public static final int CHECK_COVERED_REGION_DEFICIT_ON_NEITHER_SIDE = 3;
    public static final int CHECK_COVERED_REGION_EXCESS_ON_NEITHER_SIDE = 4;
    public static final int CHECK_COVERED_REGION_LESS_THAN_LEAST_LINES = 5;

    public static boolean checkLegalInterval(double[] points, double x1, double y1, double x2, double y2, double endLimitMin, double endLimitMax, double intervalLimitMin, double intervalLimitMax, double tolerance) {
        int i;
        double[] parameters = new double[points.length / 2];
        double length = ToolGeom2D.getDistance(x1, y1, x2, y2);
        int[] index = new int[points.length / 2];
        if (length < intervalLimitMin + endLimitMin * 2.0 && points.length == 2) {
            return true;
        }
        block0: for (i = 0; i < points.length / 2; ++i) {
            double parameter = ToolGeom2D.getParameter(points[i * 2], points[i * 2 + 1], x1, y1, x2, y2);
            for (int j = 0; j < i; ++j) {
                if (!(parameter < parameters[j])) continue;
                for (int k = i; k > j; --k) {
                    parameters[k] = parameters[k - 1];
                    index[k] = index[k - 1];
                }
                parameters[j] = parameter;
                index[j] = i;
                continue block0;
            }
            parameters[i] = parameter;
            index[i] = i;
        }
        double distance = ToolGeom2D.getDistance(x1, y1, points[index[0] * 2], points[index[0] * 2 + 1]);
        if (distance < endLimitMin - tolerance || endLimitMax + tolerance < distance) {
            return false;
        }
        i = 0;
        while (i + 1 < index.length) {
            distance = ToolGeom2D.getDistance(points[index[i] * 2], points[index[i] * 2 + 1], points[index[i + 1] * 2], points[index[i + 1] * 2 + 1]);
            if (distance < intervalLimitMin - tolerance || intervalLimitMax + tolerance < distance) {
                return false;
            }
            ++i;
        }
        distance = ToolGeom2D.getDistance(points[index[index.length - 1] * 2], points[index[index.length - 1] * 2 + 1], x2, y2);
        return !(distance < endLimitMin - tolerance) && !(endLimitMax + tolerance < distance);
    }

    public int checkCoveredRegion(IPolyline2D polygon, double[] points, double endLimitMin, double endLimitMax, double intervalLimitMin, double intervalLimitMax, double width, double tolerance, int leastCount, int targetInterim, int mode, boolean bCheckBottom, boolean bCheckTop) throws AlgebraException {
        MFigure figure1;
        IPolyline2D polyline;
        MPolylineCollection collection = new MPolylineCollection();
        IntersectSortedParameters parameters = new IntersectSortedParameters();
        IntersectSortedParameters parametersOffset = new IntersectSortedParameters();
        Vector<RectangleSupplier> vectorFigures = new Vector<RectangleSupplier>(10, 10);
        double[] intersect = new double[10];
        double v0 = 0.0;
        double diff = 1.0E-4;
        int skew1 = 0;
        int skew2 = 0;
        int result = 0;
        boolean bIgnoreSkewMinDistAtHV = false;
        int i = 0;
        while (i + 3 < points.length) {
            polyline = collection.add();
            PolylineEditable pe = (PolylineEditable)((Object)polyline);
            pe.setFirstX(points[i]);
            pe.setFirstY(points[i + 1]);
            figure1 = (MFigure)pe.add(1);
            figure1.setX2(points[i + 2]);
            figure1.setY2(points[i + 3]);
            i += 4;
        }
        ToolGeomPolyline2D.makeTree(collection);
        ToolGeomPolyline2D.makeTree(polygon);
        int direction = ToolPlane2D.getDirection(polygon);
        figure1 = (MFigure)polygon.firstElement();
        block9: while (figure1 != null) {
            if (!(Math.abs(figure1.getX1() - figure1.getX2()) <= diff ? mode != 1 : (Math.abs(figure1.getY1() - figure1.getY2()) <= diff ? mode != 2 : mode != 8))) {
                class Type {
                    int type;

                    Type(int type) {
                        this.type = type;
                    }
                }
                double distance;
                double vie;
                double distance2;
                double vi2;
                double v2;
                int type2;
                double vis;
                double distance1;
                double vi1;
                double v1;
                int type1;
                IntersectSortedParameter isp;
                double ve;
                double vs;
                int num;
                parameters.clear();
                parametersOffset.clear();
                vectorFigures.clear();
                int total = 0;
                collection.search(vectorFigures, figure1.getLeft() - width - tolerance, figure1.getLower() - width - tolerance, figure1.getRight() + width + tolerance, figure1.getUpper() + width + tolerance);
                for (i = 0; i < vectorFigures.size(); ++i) {
                    int j;
                    boolean viable;
                    polyline = (IPolyline2D)((Object)vectorFigures.get(i));
                    MFigure figure2 = (MFigure)polyline.firstElement();
                    int type = Math.abs(figure2.getX1() - figure2.getX2()) <= diff ? 1 : (Math.abs(figure2.getY1() - figure2.getY2()) <= diff ? 2 : (Math.abs(figure2.getX1() - figure2.getX2()) > diff && Math.abs(figure2.getY1() - figure2.getY2()) > diff ? 4 : 0));
                    boolean bl = viable = !(direction == 1 && ToolGeomFigure2D.getSideOfPoint(figure2.getX1(), figure2.getY1(), figure1) != 1 && ToolGeomFigure2D.getSideOfPoint(figure2.getX2(), figure2.getY2(), figure1) != 1 || direction == 2 && ToolGeomFigure2D.getSideOfPoint(figure2.getX1(), figure2.getY1(), figure1) != 2 && ToolGeomFigure2D.getSideOfPoint(figure2.getX2(), figure2.getY2(), figure1) != 2);
                    if (viable && ((targetInterim & 1) != 0 && type == 1 || (targetInterim & 2) != 0 && type == 2 || (targetInterim & 4) != 0 && type == 4)) {
                        num = ToolGeomFigure2D.getIntersectPoints(intersect, figure1, figure2);
                        for (j = 0; j < num; ++j) {
                            parameters.add(figure1, figure2, new Type(type), intersect[j * 2], intersect[j * 2 + 1]);
                        }
                    }
                    num = type == 4 ? this.getIntersectWithOffset(intersect, figure1, figure2, width / 2.0, tolerance, direction) : (viable ? ToolGeomFigure2D.getIntersectPoints(intersect, figure1, figure2) : 0);
                    for (j = 0; j < num; ++j) {
                        parametersOffset.add(figure1, figure2, new Type(type), intersect[j * 2], intersect[j * 2 + 1]);
                    }
                    if (num == 0) continue;
                    ++total;
                }
                if (total < leastCount) {
                    result = 5;
                    break;
                }
                MFigure figurePrev = (MFigure)(figure1.getPrev() != null ? figure1.getPrev() : (K2DPathFigure)figure1.getParent().firstElement());
                MFigure figureNext = (MFigure)(figure1.getNext() != null ? figure1.getNext() : (K2DPathFigure)figure1.getParent().lastElement());
                skew2 = 0;
                skew1 = 0;
                num = 0;
                switch (mode) {
                    case 2: {
                        Type typeTmp;
                        vs = figure1.getX1();
                        ve = figure1.getX2();
                        skew1 = this.comp(figurePrev.getX2() - figurePrev.getX1(), 0.0);
                        skew2 = this.comp(figureNext.getX2() - figureNext.getX1(), 0.0);
                        isp = null;
                        do {
                            isp = isp == null ? parametersOffset.getFirst() : isp.getNext();
                            typeTmp = (Type)isp.get();
                            type1 = typeTmp.type;
                        } while (bIgnoreSkewMinDistAtHV && skew1 == 0 && type1 == 4);
                        v1 = isp.getX();
                        double d = vi1 = parameters.getFirst() != null ? parameters.getFirst().getX() : Double.MAX_VALUE;
                        if (this.comp(Math.abs(vs - vi1), intervalLimitMax) > 0 && isp.getNext() != null && isp.getPairFigure() == isp.getNext().getPairFigure()) {
                            isp = isp.getNext();
                            vi1 = isp.getX();
                        }
                        distance1 = Math.min(Math.abs(vs - v1), Math.abs(vs - vi1));
                        int n = num = parametersOffset.size() > 0 ? ToolGeomFigure2D.getIntersectPoints(intersect, figure1, parametersOffset.getFirst().getPairFigure()) : 0;
                        vis = vs < ve ? (num > 0 && intersect[0] < vs + endLimitMax ? intersect[0] : v1) : (num > 0 && intersect[0] > vs - endLimitMax ? intersect[0] : v1);
                        isp = null;
                        do {
                            isp = isp == null ? parametersOffset.getLast() : isp.getNext();
                            typeTmp = (Type)isp.get();
                            type2 = typeTmp.type;
                        } while (bIgnoreSkewMinDistAtHV && skew2 == 0 && type2 == 4);
                        v2 = isp.getX();
                        double d2 = vi2 = parameters.getLast() != null ? parameters.getLast().getX() : Double.MAX_VALUE;
                        if (this.comp(Math.abs(ve - vi2), intervalLimitMax) > 0 && isp.getPrev() != null && isp.getPairFigure() == isp.getPrev().getPairFigure()) {
                            isp = isp.getPrev();
                            vi2 = isp.getX();
                        }
                        distance2 = Math.min(Math.abs(ve - v2), Math.abs(ve - vi2));
                        int n2 = num = parametersOffset.size() > 0 ? ToolGeomFigure2D.getIntersectPoints(intersect, figure1, parametersOffset.getLast().getPairFigure()) : 0;
                        if (vs < ve) {
                            vie = num > 0 && intersect[0] > ve - endLimitMax ? intersect[0] : v2;
                            break;
                        }
                        vie = num > 0 && intersect[0] < ve + endLimitMax ? intersect[0] : v2;
                        break;
                    }
                    case 1: {
                        Type typeTmp;
                        vs = figure1.getY1();
                        ve = figure1.getY2();
                        skew1 = this.comp(figurePrev.getY2() - figurePrev.getY1(), 0.0);
                        skew2 = this.comp(figureNext.getY2() - figureNext.getY1(), 0.0);
                        isp = null;
                        do {
                            isp = isp == null ? parametersOffset.getFirst() : isp.getNext();
                            typeTmp = (Type)isp.get();
                            type1 = typeTmp.type;
                        } while (bIgnoreSkewMinDistAtHV && skew1 == 0 && type1 == 4);
                        v1 = isp.getY();
                        double d = vi1 = parameters.getFirst() != null ? parameters.getFirst().getY() : Double.MAX_VALUE;
                        if (this.comp(Math.abs(vs - vi1), intervalLimitMax) > 0 && isp.getNext() != null && isp.getPairFigure() == isp.getNext().getPairFigure()) {
                            isp = isp.getNext();
                            vi1 = isp.getY();
                        }
                        distance1 = Math.min(Math.abs(vs - v1), Math.abs(vs - vi1));
                        int n = num = parametersOffset.size() > 0 ? ToolGeomFigure2D.getIntersectPoints(intersect, figure1, parametersOffset.getFirst().getPairFigure()) : 0;
                        vis = vs < ve ? (num > 0 && intersect[1] < vs + endLimitMax ? intersect[1] : v1) : (num > 0 && intersect[1] > vs - endLimitMax ? intersect[1] : v1);
                        isp = null;
                        do {
                            isp = isp == null ? parametersOffset.getLast() : isp.getNext();
                            typeTmp = (Type)isp.get();
                            type2 = typeTmp.type;
                        } while (bIgnoreSkewMinDistAtHV && skew2 == 0 && type2 == 4);
                        v2 = isp.getY();
                        double d3 = vi2 = parameters.getLast() != null ? parameters.getLast().getY() : Double.MAX_VALUE;
                        if (this.comp(Math.abs(ve - vi2), intervalLimitMax) > 0 && isp.getPrev() != null && isp.getPairFigure() == isp.getPrev().getPairFigure()) {
                            isp = isp.getPrev();
                            vi2 = isp.getY();
                        }
                        distance2 = Math.min(Math.abs(ve - v2), Math.abs(ve - vi2));
                        int n3 = num = parametersOffset.size() > 0 ? ToolGeomFigure2D.getIntersectPoints(intersect, figure1, parametersOffset.getLast().getPairFigure()) : 0;
                        if (vs < ve) {
                            vie = num > 0 && intersect[1] > ve - endLimitMax ? intersect[1] : v2;
                            break;
                        }
                        vie = num > 0 && intersect[1] < ve + endLimitMax ? intersect[1] : v2;
                        break;
                    }
                    default: {
                        vie = 0.0;
                        vis = 0.0;
                        vi2 = 0.0;
                        vi1 = 0.0;
                        v2 = 0.0;
                        v1 = 0.0;
                        ve = 0.0;
                        vs = 0.0;
                        type2 = 0;
                        type1 = 0;
                        distance2 = 0.0;
                        distance1 = 0.0;
                    }
                }
                if (vs < ve && bCheckBottom || vs > ve && bCheckTop) {
                    if (skew1 == 0 && type1 != 4 && distance1 < endLimitMin - tolerance) {
                        result = 1;
                        break;
                    }
                    if (endLimitMax + tolerance < distance1) {
                        result = 2;
                        break;
                    }
                }
                if (vs < ve && bCheckTop || vs > ve && bCheckBottom) {
                    if (skew2 == 0 && type2 != 4 && distance2 < endLimitMin - tolerance) {
                        result = 1;
                        break;
                    }
                    if (endLimitMax + tolerance < distance2) {
                        result = 2;
                        break;
                    }
                }
                if (parameters.size() == 0) {
                    distance = Math.abs(vis - vie);
                    Type typeObj1 = (Type)parametersOffset.getFirst().get();
                    Type typeObj2 = (Type)parametersOffset.getLast().get();
                    if (typeObj1.type != 4 && typeObj2.type != 4 && distance < intervalLimitMin - tolerance) {
                        result = 3;
                        break;
                    }
                    if (intervalLimitMax + tolerance < distance) {
                        result = 4;
                        break;
                    }
                } else {
                    if (parameters.size() > 0 && Math.abs(vis - vi1) > width) {
                        distance = Math.abs(vis - vi1);
                        Type typeObj = (Type)parametersOffset.getFirst().get();
                        if (typeObj.type != 4 && distance < intervalLimitMin - tolerance) {
                            result = 3;
                            break;
                        }
                        if (intervalLimitMax + tolerance < distance) {
                            result = 4;
                            break;
                        }
                    }
                    if (parameters.size() > 0 && Math.abs(vie - vi2) > width) {
                        distance = Math.abs(vie - vi2);
                        Type typeObj = (Type)parametersOffset.getLast().get();
                        if (typeObj.type != 4 && distance < intervalLimitMin - tolerance) {
                            result = 3;
                            break;
                        }
                        if (intervalLimitMax + tolerance < distance) {
                            result = 4;
                            break;
                        }
                    }
                    IntersectSortedParameter ispLast = null;
                    block17: for (isp = parameters.getFirst(); isp != null && isp.getNext() != null; isp = isp.getNext()) {
                        IntersectSortedParameter ispTmp;
                        IntersectSortedParameter ispNext = isp.getNext();
                        skew1 = this.comp(isp.getPairFigure().getY1(), isp.getPairFigure().getY2());
                        skew2 = this.comp(ispNext.getPairFigure().getY1(), ispNext.getPairFigure().getY2());
                        if (skew1 == 0) {
                            ispLast = isp;
                        }
                        switch (mode) {
                            case 2: {
                                if (ispLast != null) {
                                    v0 = ispLast.getX();
                                }
                                v1 = isp.getX();
                                v2 = ispNext.getX();
                                distance = Math.abs(v1 - v2);
                                break;
                            }
                            case 1: {
                                if (ispLast != null) {
                                    v0 = ispLast.getY();
                                }
                                v1 = isp.getY();
                                v2 = ispNext.getY();
                                distance = Math.abs(v1 - v2);
                                break;
                            }
                            default: {
                                distance = 0.0;
                            }
                        }
                        if (ispLast != null && skew2 == 0 && Math.abs(v0 - v2) < intervalLimitMin - tolerance) {
                            result = 3;
                            break block9;
                        }
                        if (!(intervalLimitMax + tolerance < distance)) continue;
                        boolean bChecked = false;
                        if (isp == parameters.getFirst()) {
                            ispTmp = parametersOffset.getFirst();
                            while (ispTmp.getPairFigure() == isp.getPairFigure()) {
                                distance = Math.abs(ispTmp.getY() - v2);
                                if (intervalLimitMax + tolerance >= distance) {
                                    bChecked = true;
                                    continue block17;
                                }
                                ispTmp = ispTmp.getNext();
                            }
                        } else if (ispNext.getNext() == null) {
                            ispTmp = parametersOffset.getLast();
                            while (ispTmp.getPairFigure() == isp.getPairFigure()) {
                                distance = Math.abs(v1 - ispTmp.getY());
                                if (intervalLimitMax + tolerance >= distance) {
                                    bChecked = true;
                                    continue block17;
                                }
                                ispTmp = ispTmp.getPrev();
                            }
                        }
                        result = 4;
                        break block9;
                    }
                }
            }
            figure1 = (MFigure)ToolGeomFigure2D.getNext(figure1);
        }
        return result;
    }

    private int getIntersectWithOffset(double[] result, IFigure2D figure1, IFigure2D figure2, double offsetDistance, double tolerance, int direction) throws AlgebraException {
        int num;
        double[] offset = new double[8];
        double[] intersect = new double[4];
        int out = 0;
        boolean p1 = true;
        boolean p2 = true;
        ToolGeomFigure2D.getOffset(offset, figure2, offsetDistance + tolerance, true);
        if (direction == 1 && ToolGeomFigure2D.getSideOfPoint(offset[0], offset[1], figure1) != 1 && ToolGeomFigure2D.getSideOfPoint(offset[2], offset[3], figure1) != 1 || direction == 2 && ToolGeomFigure2D.getSideOfPoint(offset[0], offset[1], figure1) != 2 && ToolGeomFigure2D.getSideOfPoint(offset[2], offset[3], figure1) != 2) {
            p1 = false;
            num = 0;
        } else {
            num = this.getIntersect(intersect, offset, figure1, figure2, tolerance);
        }
        if (num > 0) {
            result[out++] = intersect[0];
            result[out++] = intersect[1];
        } else {
            ToolGeomFigure2D.getOffset(offset, figure2, offsetDistance, true);
            num = this.getIntersect(intersect, offset, figure1, figure2, tolerance);
            if (num > 0) {
                result[out++] = intersect[0];
                result[out++] = intersect[1];
            } else {
                ToolGeomFigure2D.getOffset(offset, figure2, offsetDistance - tolerance, true);
                num = this.getIntersect(intersect, offset, figure1, figure2, tolerance);
                if (num > 0) {
                    result[out++] = intersect[0];
                    result[out++] = intersect[1];
                }
            }
        }
        for (int i = 0; i < offset.length / 2; ++i) {
            offset[i + offset.length / 2] = offset[i];
        }
        ToolGeomFigure2D.getOffset(offset, figure2, offsetDistance + tolerance, false);
        if (direction == 1 && ToolGeomFigure2D.getSideOfPoint(offset[0], offset[1], figure1) != 1 && ToolGeomFigure2D.getSideOfPoint(offset[2], offset[3], figure1) != 1 || direction == 2 && ToolGeomFigure2D.getSideOfPoint(offset[0], offset[1], figure1) != 2 && ToolGeomFigure2D.getSideOfPoint(offset[2], offset[3], figure1) != 2) {
            p2 = false;
            num = 0;
        } else {
            num = this.getIntersect(intersect, offset, figure1, figure2, tolerance);
        }
        if (num > 0) {
            result[out++] = intersect[0];
            result[out++] = intersect[1];
        } else {
            ToolGeomFigure2D.getOffset(offset, figure2, offsetDistance, false);
            num = this.getIntersect(intersect, offset, figure1, figure2, tolerance);
            if (num > 0) {
                result[out++] = intersect[0];
                result[out++] = intersect[1];
            } else {
                ToolGeomFigure2D.getOffset(offset, figure2, offsetDistance - tolerance, false);
                num = this.getIntersect(intersect, offset, figure1, figure2, tolerance);
                if (num > 0) {
                    result[out++] = intersect[0];
                    result[out++] = intersect[1];
                }
            }
        }
        if (p1 || p2) {
            double[] offset2 = new double[]{offset[0], offset[1], offset[offset.length / 2], offset[offset.length / 2 + 1]};
            num = this.getIntersect(intersect, offset2, figure1, figure2, tolerance);
            if (num > 0) {
                result[out++] = intersect[0];
                result[out++] = intersect[1];
            }
            if ((num = this.getIntersect(intersect, offset2 = new double[]{offset[2], offset[3], offset[offset.length / 2 + 2], offset[offset.length / 2 + 3]}, figure1, figure2, tolerance)) > 0) {
                result[out++] = intersect[0];
                result[out++] = intersect[1];
            }
        }
        if (out / 2 == 2) {
            double param1 = ToolGeomFigure2D.getParameter(result[0], result[1], figure1);
            double param2 = ToolGeomFigure2D.getParameter(result[2], result[3], figure1);
            if (!(ToolGeom2D.compare(param1, 0.0) >= 0 && ToolGeom2D.compare(param1, 1.0) <= 0 || ToolGeom2D.compare(param2, 0.0) >= 0 && ToolGeom2D.compare(param2, 1.0) <= 0)) {
                out = 0;
            } else if (ToolGeom2D.compare(param1, 0.0) < 0) {
                result[0] = figure1.getX1();
                result[1] = figure1.getY1();
            } else if (ToolGeom2D.compare(param1, 1.0) > 0) {
                result[0] = figure1.getX2();
                result[1] = figure1.getY2();
            } else if (ToolGeom2D.compare(param2, 0.0) < 0) {
                result[2] = figure1.getX1();
                result[3] = figure1.getY1();
            } else if (ToolGeom2D.compare(param2, 1.0) > 0) {
                result[2] = figure1.getX2();
                result[3] = figure1.getY2();
            }
        } else if (out / 2 == 1 && !ToolGeomFigure2D.checkPointOnWithoutDistance(result[0], result[1], figure1)) {
            out = 0;
        }
        return out / 2;
    }

    private int getIntersect(double[] intersect, double[] figure2EdgePoints, IFigure2D figure1, IFigure2D figure2, double tolerance) throws AlgebraException {
        int num = 0;
        int result = 0;
        if (IFigureType.isLine(figure2.getType())) {
            ToolGeom2D.getPointFromDistance(intersect, figure2EdgePoints[0], figure2EdgePoints[1], figure2EdgePoints[2], figure2EdgePoints[3], -tolerance, true);
            figure2EdgePoints[0] = intersect[0];
            figure2EdgePoints[1] = intersect[1];
            ToolGeom2D.getPointFromDistance(intersect, figure2EdgePoints[0], figure2EdgePoints[1], figure2EdgePoints[2], figure2EdgePoints[3], -tolerance, false);
            figure2EdgePoints[2] = intersect[0];
            figure2EdgePoints[3] = intersect[1];
            num = ToolGeomFigure2D.getIntersectPointsExtension(intersect, figure1, figure2EdgePoints[0], figure2EdgePoints[1], figure2EdgePoints[2], figure2EdgePoints[3]);
            for (int i = 0; i < num; ++i) {
                if (!ToolGeom2D.checkPointOnLinearWithoutDistance(intersect[i * 2], intersect[i * 2 + 1], figure2EdgePoints[0], figure2EdgePoints[1], figure2EdgePoints[2], figure2EdgePoints[3])) continue;
                if (i != result) {
                    intersect[result * 2] = intersect[i * 2];
                    intersect[result * 2 + 1] = intersect[i * 2 + 1];
                }
                ++result;
            }
        } else {
            IFigure2DArc arc = (IFigure2DArc)figure2;
            ToolGeom2D.getPointFromDistance(intersect, figure2EdgePoints[0], figure2EdgePoints[1], figure2EdgePoints[2], figure2EdgePoints[3], arc.getCX(), arc.getCY(), figure2EdgePoints[5], arc.isCw(), -tolerance, true);
            figure2EdgePoints[0] = intersect[0];
            figure2EdgePoints[1] = intersect[1];
            ToolGeom2D.getPointFromDistance(intersect, figure2EdgePoints[0], figure2EdgePoints[1], figure2EdgePoints[2], figure2EdgePoints[3], arc.getCX(), arc.getCY(), figure2EdgePoints[5], arc.isCw(), -tolerance, false);
            figure2EdgePoints[2] = intersect[0];
            figure2EdgePoints[3] = intersect[1];
            num = ToolGeomFigure2D.getIntersectPointsExtension(intersect, figure1, arc);
            for (int i = 0; i < num; ++i) {
                if (!ToolGeom2D.checkPointOnCircleWithoutDistance(intersect[i * 2], intersect[i * 2 + 1], figure2EdgePoints[0], figure2EdgePoints[1], figure2EdgePoints[2], figure2EdgePoints[3], arc.getCX(), arc.getCY(), arc.isCw())) continue;
                if (i != result) {
                    intersect[result * 2] = intersect[i * 2];
                    intersect[result * 2 + 1] = intersect[i * 2 + 1];
                }
                ++result;
            }
        }
        return result;
    }
}

