/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.math.applications.regionslt;

import java.util.Vector;
import jp.kitec.lib.geom.K2DPathFigure;
import jp.kitec.math.algebra.AlgebraException;
import jp.kitec.math.applications.regionslt.Line;
import jp.kitec.math.geom.ToolGeom2D;
import jp.kitec.math.geom.datapassing.IAdditData;
import jp.kitec.math.geom.datapassing.ICollectionEditable;
import jp.kitec.math.geom.datapassing.IFigure2D;
import jp.kitec.math.geom.datapassing.IFigure2DArc;
import jp.kitec.math.geom.datapassing.IFigureType;
import jp.kitec.math.geom.datapassing.ILine2D;
import jp.kitec.math.geom.datapassing.IPoint2D;
import jp.kitec.math.geom.datapassing.IPolyline2D;
import jp.kitec.math.geom.datapassing.IPolyline2DCollection;
import jp.kitec.math.geom.datapassing.PolylineEditable;
import jp.kitec.math.geom.datapassing.ToolGeomFigure2D;
import jp.kitec.math.geom.datapassing.complete.MPolyline;
import jp.kitec.math.geom.datapassing.complete.MPolylineCollection;
import jp.kitec.math.geom.datapassing.plane.ToolPlane2D;
import jp.kitec.math.geom.datapassing.polylines.ToolGeomPolyline2D;
import jp.kitec.math.geom.datapassing.polylines.ToolHashPolylines;
import jp.kitec.math.searches.NodeComparator;
import jp.kitec.math.searches.binarysort.BinarySort;
import jp.kitec.math.searches.regiontree.RegionTreeBuilder;

public class CRBasicFunc {
    protected double tolerance = 0.001;

    protected int comp(double v1, double v2) {
        if (Math.abs(v1 - v2) < this.tolerance) {
            return 0;
        }
        return v1 < v2 ? -1 : 1;
    }

    protected double getMinimumDistance(IPolyline2D[] polylineOutFound, IPolyline2DCollection collectionIn, IFigure2D figureIn, double x1, double y1, double x2, double y2, boolean bFirst) throws AlgebraException {
        double distanceMin = Double.MAX_VALUE;
        double v1 = Math.min(collectionIn.getLower(), Math.min(y1, y2)) - 10.0;
        double v2 = Math.max(collectionIn.getUpper(), Math.max(y1, y2)) + 10.0;
        for (int i = 0; i < collectionIn.size(); ++i) {
            IPolyline2D polyline = collectionIn.get(i);
            for (IFigure2D figure = (IFigure2D)polyline.firstElement(); figure != null; figure = (IFigure2D)figure.getNext()) {
                double distance = this.getDistance(figureIn, figure, x1, y1, x2, y2, v1, v2, bFirst, true);
                if (!(distance < distanceMin)) continue;
                distanceMin = distance;
                if (polylineOutFound == null) continue;
                polylineOutFound[0] = polyline;
            }
        }
        return distanceMin;
    }

    protected double getMaximumDistance(IPolyline2D[] polylineOutFound, IPolyline2DCollection collectionIn, IFigure2D figureIn, boolean bFirst) throws AlgebraException {
        IFigure2D figureMin = null;
        double distanceMin = Double.MAX_VALUE;
        double distanceMax = Double.MAX_VALUE;
        double v1 = collectionIn.getLower() - 10.0;
        double v2 = collectionIn.getUpper() + 10.0;
        for (int i = 0; i < collectionIn.size(); ++i) {
            IPolyline2D polyline = collectionIn.get(i);
            for (IFigure2D figure = (IFigure2D)polyline.firstElement(); figure != null; figure = (IFigure2D)figure.getNext()) {
                if (this.comp(Math.min(figureIn.getX1(), figureIn.getX2()), Math.min(figure.getX1(), figure.getX2())) < 0 || this.comp(Math.max(figureIn.getX1(), figureIn.getX2()), Math.max(figure.getX1(), figure.getX2())) > 0) continue;
                double distance = this.getDistance(figure, figureIn, figure.getX1(), figure.getY1(), figure.getX2(), figure.getY2(), v1, v2, !bFirst, true);
                if (!(distance < distanceMin)) continue;
                distanceMin = distance;
                figureMin = figure;
                if (polylineOutFound == null) continue;
                polylineOutFound[0] = polyline;
            }
        }
        if (figureMin != null) {
            distanceMax = this.getDistance(figureMin, figureIn, figureMin.getX1(), figureMin.getY1(), figureMin.getX2(), figureMin.getY2(), v1, v2, !bFirst, false);
        }
        return distanceMax;
    }

    protected double getDistance(IFigure2D figure1, IFigure2D figure2, double x1, double y1, double x2, double y2, double v1, double v2, boolean bFirst, boolean bMinimum) throws AlgebraException {
        double distance;
        int checkY;
        boolean checkX;
        double distanceMinMax = bMinimum ? Double.MAX_VALUE : 0.0;
        double[] intersect = new double[4];
        double overlap = 175.0;
        boolean bOverlap = true;
        double dMin1 = Math.min(x1, x2);
        double dMax1 = Math.max(x1, x2);
        IPolyline2D polyline = figure1.getParent();
        if (figure1.getPrev() != null && figure1.getPrev() == figure2 || figure1.getPrev() == null && polyline.lastElement() == figure2 || figure1 == figure2 || figure1.getNext() != null && figure1.getNext() == figure2 || figure1.getNext() == null && polyline.firstElement() == figure2) {
            return distanceMinMax;
        }
        double dMin2 = Math.min(figure2.getX1(), figure2.getX2());
        double dMax2 = Math.max(figure2.getX1(), figure2.getX2());
        if (this.comp(dMax1 - overlap, dMin2) < 0 || this.comp(dMin1 + overlap, dMax2) > 0) {
            return distanceMinMax;
        }
        if (ToolGeom2D.getIntersectPoints(intersect, x1, y1, x2, y2, figure2.getX1(), v1, figure2.getX1(), v2)) {
            checkX = this.comp(intersect[0], Math.min(x1, x2) + overlap) > 0 && this.comp(intersect[0], Math.max(x1, x2) - overlap) < 0;
            checkY = this.comp(intersect[1], figure2.getY1());
            if ((bOverlap || checkX) && (!bFirst && checkY >= 0 || bFirst && checkY <= 0)) {
                distance = ToolGeom2D.getDistance(intersect[0], intersect[1], figure2.getX1(), figure2.getY1());
                if (bMinimum && distance < distanceMinMax || !bMinimum && distance > distanceMinMax) {
                    distanceMinMax = distance;
                }
            }
        }
        if (ToolGeom2D.getIntersectPoints(intersect, x1, y1, x2, y2, figure2.getX2(), v1, figure2.getX2(), v2)) {
            checkX = this.comp(intersect[0], Math.min(x1, x2) + overlap) > 0 && this.comp(intersect[0], Math.max(x1, x2) - overlap) < 0;
            checkY = this.comp(intersect[1], figure2.getY2());
            if ((bOverlap || checkX) && (!bFirst && checkY >= 0 || bFirst && checkY <= 0)) {
                distance = ToolGeom2D.getDistance(intersect[0], intersect[1], figure2.getX2(), figure2.getY2());
                if (bMinimum && distance < distanceMinMax || !bMinimum && distance > distanceMinMax) {
                    distanceMinMax = distance;
                }
            }
        }
        if (IFigureType.isLine(figure2.getType())) {
            if (ToolGeom2D.getIntersectPoints(intersect, figure2.getX1(), figure2.getY1(), figure2.getX2(), figure2.getY2(), x1, v1, x1, v2)) {
                checkX = this.comp(intersect[0], Math.min(figure2.getX1(), figure2.getX2()) + overlap) > 0 && this.comp(intersect[0], Math.max(figure2.getX1(), figure2.getX2()) - overlap) < 0;
                checkY = this.comp(intersect[1], y1);
                if ((bOverlap || checkX) && (bFirst && checkY > 0 || !bFirst && checkY < 0)) {
                    distance = ToolGeom2D.getDistance(intersect[0], intersect[1], x1, y1);
                    if (bMinimum && distance < distanceMinMax || !bMinimum && distance > distanceMinMax) {
                        distanceMinMax = distance;
                    }
                }
            }
            if (ToolGeom2D.getIntersectPoints(intersect, figure2.getX1(), figure2.getY1(), figure2.getX2(), figure2.getY2(), x2, v1, x2, v2)) {
                checkX = this.comp(intersect[0], Math.min(figure2.getX1(), figure2.getX2()) + overlap) > 0 && this.comp(intersect[0], Math.max(figure2.getX1(), figure2.getX2()) - overlap) < 0;
                checkY = this.comp(intersect[1], y2);
                if ((bOverlap || checkX) && (bFirst && checkY > 0 || !bFirst && checkY < 0)) {
                    distance = ToolGeom2D.getDistance(intersect[0], intersect[1], x2, y2);
                    if (bMinimum && distance < distanceMinMax || !bMinimum && distance > distanceMinMax) {
                        distanceMinMax = distance;
                    }
                }
            }
        } else {
            IFigure2DArc arc = (IFigure2DArc)figure2;
            if (ToolGeomFigure2D.getIntersectPoints(intersect, arc, x1, v1, x1, v2) > 0) {
                checkX = this.comp(intersect[0], Math.min(x1, x2) + overlap) > 0 && this.comp(intersect[0], Math.max(x1, x2) - overlap) < 0 && this.comp(intersect[0], Math.min(arc.getX1(), arc.getX2()) + overlap) > 0 && this.comp(intersect[0], Math.max(arc.getX1(), arc.getX2()) - overlap) < 0;
                checkY = this.comp(intersect[1], figure2.getY1());
                if ((bOverlap || checkX) && (!bFirst && checkY >= 0 || bFirst && checkY <= 0)) {
                    distance = ToolGeom2D.getDistance(intersect[0], intersect[1], x1, y1);
                    if (bMinimum && distance < distanceMinMax || !bMinimum && distance > distanceMinMax) {
                        distanceMinMax = distance;
                    }
                }
            }
            if (ToolGeomFigure2D.getIntersectPoints(intersect, arc, x2, v1, x2, v2) > 0) {
                checkX = this.comp(intersect[0], Math.min(x1, x2) + overlap) > 0 && this.comp(intersect[0], Math.max(x1, x2) - overlap) < 0 && this.comp(intersect[0], Math.min(arc.getX1(), arc.getX2()) + overlap) > 0 && this.comp(intersect[0], Math.max(arc.getX1(), arc.getX2()) - overlap) < 0;
                checkY = this.comp(intersect[1], figure2.getY2());
                if ((bOverlap || checkX) && (!bFirst && checkY >= 0 || bFirst && checkY <= 0)) {
                    distance = ToolGeom2D.getDistance(intersect[0], intersect[1], x2, y2);
                    if (bMinimum && distance < distanceMinMax || !bMinimum && distance > distanceMinMax) {
                        distanceMinMax = distance;
                    }
                }
            }
            if (ToolGeom2D.getIntersectPoints(intersect, x1, y1, x2, y2, arc.getCX(), v1, arc.getCX(), v2)) {
                checkX = this.comp(intersect[0], Math.min(x1, x2) + overlap) > 0 && this.comp(intersect[0], Math.max(x1, x2) - overlap) < 0 && this.comp(intersect[0], Math.min(arc.getX1(), arc.getX2()) + overlap) > 0 && this.comp(intersect[0], Math.max(arc.getX1(), arc.getX2()) - overlap) < 0;
                checkY = this.comp(intersect[1], figure2.getY1());
                if ((bOverlap || checkX) && (!bFirst && checkY >= 0 || bFirst && checkY <= 0) && this.comp(distance = ToolGeom2D.getDistance(intersect[0], intersect[1], arc.getCX(), arc.getCY()), arc.getRadius()) >= 0 && (bMinimum && distance - arc.getRadius() < distanceMinMax || !bMinimum && distance - arc.getRadius() > distanceMinMax)) {
                    distanceMinMax = distance - arc.getRadius();
                }
            }
        }
        return distanceMinMax;
    }

    protected double getMinimumDistance(ILine2D[] polylineOutFound, Vector collectionIn, IFigure2D figureIn, double x1, double y1, double x2, double y2, double v1, double v2, boolean bFirst) throws AlgebraException {
        double distanceMin = Double.MAX_VALUE;
        double lengthMin = 0.0;
        double[] intersect = new double[4];
        double overlap = 5.0;
        boolean bOverlap = true;
        double dMin1 = Math.min(x1, x2);
        double dMax1 = Math.max(x1, x2);
        double length = ToolGeomFigure2D.getLength(figureIn);
        for (int i = 0; i < collectionIn.size(); ++i) {
            double distance;
            int checkY;
            boolean checkX;
            ILine2D line = (ILine2D)collectionIn.get(i);
            double lengthTmp = ToolGeom2D.getLength(line.getStartPoint().getXd(), line.getStartPoint().getYd(), line.getEndPoint().getXd(), line.getEndPoint().getYd());
            double dMin2 = Math.min(line.getStartPoint().getXd(), line.getEndPoint().getXd());
            double dMax2 = Math.max(line.getStartPoint().getXd(), line.getEndPoint().getXd());
            if (this.comp(dMax1, dMin2) <= 0 || this.comp(dMin1, dMax2) >= 0) continue;
            if (ToolGeom2D.getIntersectPoints(intersect, x1, y1, x2, y2, line.getStartPoint().getXd(), v1, line.getStartPoint().getXd(), v2)) {
                checkX = this.comp(intersect[0], Math.min(x1, x2) + overlap) > 0 && this.comp(intersect[0], Math.max(x1, x2) - overlap) < 0;
                checkY = this.comp(intersect[1], line.getStartPoint().getYd());
                if ((bOverlap || checkX) && (!bFirst && checkY >= 0 || bFirst && checkY <= 0) && ((distance = ToolGeom2D.getDistance(intersect[0], intersect[1], line.getStartPoint().getXd(), line.getStartPoint().getYd())) < distanceMin || distance == distanceMin && Math.abs(length - lengthTmp) < Math.abs(length - lengthMin))) {
                    distanceMin = distance;
                    lengthMin = lengthTmp;
                    if (polylineOutFound != null) {
                        polylineOutFound[0] = line;
                    }
                }
            }
            if (ToolGeom2D.getIntersectPoints(intersect, x1, y1, x2, y2, line.getEndPoint().getXd(), v1, line.getEndPoint().getXd(), v2)) {
                checkX = this.comp(intersect[0], Math.min(x1, x2) + overlap) > 0 && this.comp(intersect[0], Math.max(x1, x2) - overlap) < 0;
                checkY = this.comp(intersect[1], line.getEndPoint().getYd());
                if ((bOverlap || checkX) && (!bFirst && checkY >= 0 || bFirst && checkY <= 0) && ((distance = ToolGeom2D.getDistance(intersect[0], intersect[1], line.getEndPoint().getXd(), line.getEndPoint().getYd())) < distanceMin || distance == distanceMin && Math.abs(length - lengthTmp) < Math.abs(length - lengthMin))) {
                    distanceMin = distance;
                    lengthMin = lengthTmp;
                    if (polylineOutFound != null) {
                        polylineOutFound[0] = line;
                    }
                }
            }
            if (ToolGeom2D.getIntersectPoints(intersect, line.getStartPoint().getXd(), line.getStartPoint().getYd(), line.getEndPoint().getXd(), line.getEndPoint().getYd(), x1, v1, x1, v2)) {
                checkX = this.comp(intersect[0], Math.min(line.getStartPoint().getXd(), line.getEndPoint().getXd()) + overlap) > 0 && this.comp(intersect[0], Math.max(line.getStartPoint().getXd(), line.getEndPoint().getXd()) - overlap) < 0;
                checkY = this.comp(intersect[1], y1);
                if ((bOverlap || checkX) && (bFirst && checkY > 0 || !bFirst && checkY < 0) && ((distance = ToolGeom2D.getDistance(intersect[0], intersect[1], x1, y1)) < distanceMin || distance == distanceMin && Math.abs(length - lengthTmp) < Math.abs(length - lengthMin))) {
                    distanceMin = distance;
                    lengthMin = lengthTmp;
                    if (polylineOutFound != null) {
                        polylineOutFound[0] = line;
                    }
                }
            }
            if (!ToolGeom2D.getIntersectPoints(intersect, line.getStartPoint().getXd(), line.getStartPoint().getYd(), line.getEndPoint().getXd(), line.getEndPoint().getYd(), x2, v1, x2, v2)) continue;
            checkX = this.comp(intersect[0], Math.min(line.getStartPoint().getXd(), line.getEndPoint().getXd()) + overlap) > 0 && this.comp(intersect[0], Math.max(line.getStartPoint().getXd(), line.getEndPoint().getXd()) - overlap) < 0;
            checkY = this.comp(intersect[1], y2);
            if (!bOverlap && !checkX || (!bFirst || checkY <= 0) && (bFirst || checkY >= 0) || !((distance = ToolGeom2D.getDistance(intersect[0], intersect[1], x2, y2)) < distanceMin) && (distance != distanceMin || !(Math.abs(length - lengthTmp) < Math.abs(length - lengthMin)))) continue;
            distanceMin = distance;
            lengthMin = lengthTmp;
            if (polylineOutFound == null) continue;
            polylineOutFound[0] = line;
        }
        return distanceMin;
    }

    protected IPolyline2D createCoverLine(IPolyline2DCollection collectionIn, MPolylineCollection collectionOther, MPolylineCollection collectionMain, IFigure2D figureIn, double value, double valueVersa, double prevValue, double nextValue, double subtractDistance, double addition, double marginMin, double marginMax, double intervalMin, double intervalMax, double lengthMinimum, boolean bHorizontal, boolean lessSide, boolean isEndLine, boolean bFirst, boolean cutOff, boolean notExtend) throws AlgebraException {
        return this.createCoverLine(collectionIn, collectionOther, collectionMain, figureIn, value, valueVersa, prevValue, nextValue, subtractDistance, addition, marginMin, marginMax, intervalMin, intervalMax, lengthMinimum, bHorizontal, lessSide, isEndLine, bFirst, cutOff, notExtend, true, true);
    }

    protected IPolyline2D createCoverLine(IPolyline2DCollection collectionIn, MPolylineCollection collectionOther, MPolylineCollection collectionMain, IFigure2D figureIn, double value, double valueVersa, double prevValue, double nextValue, double subtractDistance, double addition, double marginMin, double marginMax, double intervalMin, double intervalMax, double lengthMinimum, boolean bHorizontal, boolean lessSide, boolean isEndLine, boolean bFirst, boolean cutOff, boolean notExtend, boolean useExistLine, boolean bHash) throws AlgebraException {
        return this.createCoverLine(collectionIn, collectionOther, collectionMain, figureIn, figureIn.getX1(), figureIn.getY1(), figureIn.getX2(), figureIn.getY2(), value, valueVersa, prevValue, nextValue, subtractDistance, addition, marginMin, marginMax, intervalMin, intervalMax, lengthMinimum, bHorizontal, lessSide, isEndLine, bFirst, cutOff, notExtend, useExistLine, bHash);
    }

    protected IPolyline2D createCoverLine(IPolyline2DCollection collectionIn, MPolylineCollection collectionOther, MPolylineCollection collectionMain, IFigure2D figureIn, double x1, double y1, double x2, double y2, double value, double valueVersa, double prevValue, double nextValue, double subtractDistance, double addition, double marginMin, double marginMax, double intervalMin, double intervalMax, double lengthMinimum, boolean bHorizontal, boolean lessSide, boolean isEndLine, boolean bFirst, boolean cutOff, boolean notExtend, boolean useExistLine, boolean bHash) throws AlgebraException {
        IFigure2D figure;
        double tmp;
        IPolyline2D[] polylineOut = new IPolyline2D[1];
        double[] intersect = new double[4];
        double add = addition;
        if (bHorizontal) {
            if (x1 > x2) {
                tmp = x1;
                x1 = x2;
                x2 = tmp;
                tmp = y1;
                y1 = y2;
                y2 = tmp;
            }
        } else if (y1 > y2) {
            tmp = y1;
            y1 = y2;
            y2 = tmp;
            tmp = x1;
            x1 = x2;
            x2 = tmp;
        }
        double distanceMin = this.getMinimumDistance(null, collectionIn, figureIn, x1, y1, x2, y2, bFirst);
        if ((subtractDistance > 0.0 && this.comp(distanceMin, add + subtractDistance + intervalMin) < 0 || subtractDistance <= 0.0 && this.comp(distanceMin, add * 2.0 + intervalMin) < 0) && this.comp(distanceMin, marginMin * 2.0 + intervalMin) >= 0 && this.comp(add, marginMin) >= 0 && this.comp(add, marginMax) <= 0) {
            if (!isEndLine) {
                add = distanceMin - marginMax;
                if (this.comp(add, intervalMin) < 0) {
                    add = intervalMin;
                }
            } else {
                add = (distanceMin - intervalMin) / 2.0;
                if (this.comp(add, marginMax) > 0) {
                    add = marginMax;
                } else if (this.comp(add, marginMin) < 0) {
                    add = marginMin;
                }
            }
        }
        if (bHorizontal) {
            if (lessSide && x1 > value || !lessSide && x1 < value) {
                x1 = value;
                y1 = valueVersa;
            }
            if (lessSide && x2 > value || !lessSide && x2 < value) {
                x2 = value;
                y2 = valueVersa;
            }
        } else {
            if (lessSide && y1 > value || !lessSide && y1 < value) {
                x1 = valueVersa;
                y1 = value;
            }
            if (lessSide && y2 > value || !lessSide && y2 < value) {
                x2 = valueVersa;
                y2 = value;
            }
        }
        if (cutOff) {
            double tmp2;
            tmp = bHorizontal ? ((lessSide ? prevValue : nextValue) - x1) / (x2 - x1) : ((lessSide ? prevValue : nextValue) - y1) / (y2 - y1);
            double d = tmp2 = lessSide ? x2 - prevValue : nextValue - x1;
            if (this.comp(0.0, tmp) <= 0 && this.comp(1.0, tmp) >= 0 && this.comp(tmp2, lengthMinimum) >= 0) {
                if (lessSide) {
                    x1 = ToolGeom2D.getValueFromParameter(x1, x2, tmp);
                    y1 = ToolGeom2D.getValueFromParameter(y1, y2, tmp);
                } else {
                    x2 = ToolGeom2D.getValueFromParameter(x1, x2, tmp);
                    y2 = ToolGeom2D.getValueFromParameter(y1, y2, tmp);
                }
            }
        }
        boolean bSkew = this.comp(x1, x2) != 0 && this.comp(y1, y2) != 0;
        boolean bP1 = ToolGeom2D.equalPoints(x1, y1, figureIn.getX1(), figureIn.getY1()) || ToolGeom2D.equalPoints(x2, y2, figureIn.getX1(), figureIn.getY1());
        boolean bP2 = ToolGeom2D.equalPoints(x1, y1, figureIn.getX2(), figureIn.getY2()) || ToolGeom2D.equalPoints(x2, y2, figureIn.getX2(), figureIn.getY2());
        IPolyline2D polyline = figureIn.getParent();
        IFigure2D figurePrev = (IFigure2D)(figureIn.getPrev() != null ? figureIn.getPrev() : (K2DPathFigure)polyline.lastElement());
        IFigure2D figureNext = (IFigure2D)(figureIn.getNext() != null ? figureIn.getNext() : (K2DPathFigure)polyline.firstElement());
        if (IFigureType.isArc(figurePrev.getType())) {
            bP1 = false;
        }
        if (IFigureType.isArc(figureNext.getType())) {
            bP2 = false;
        }
        if (bHorizontal) {
            y1 += bFirst ? add : -add;
            y2 += bFirst ? add : -add;
        } else {
            x1 += bFirst ? add : -add;
            x2 += bFirst ? add : -add;
        }
        if (bSkew && !notExtend && this.comp(Math.abs(x2 - x1), lengthMinimum) < 0) {
            double[] point = new double[2];
            double tmpX = 0.0;
            double tmpY = 0.0;
            boolean check1 = this.createShortestLine(point, collectionOther, value, valueVersa + (bFirst ? add : -add), lessSide);
            if (check1) {
                tmpX = point[0];
                tmpY = point[1];
            }
            boolean check2 = this.createShortestLine(point, collectionIn, value + (double)(lessSide ? -1 : 1), valueVersa + (bFirst ? add : -add), lessSide);
            if (check1 || check2) {
                if (check1 == check2 && (lessSide && tmpX > point[0] || !lessSide && tmpX < point[0]) || !check2) {
                    point[0] = tmpX;
                    point[1] = tmpY;
                }
                if (this.comp(value, x1) == 0) {
                    x2 = point[0];
                    y2 = point[1];
                } else if (this.comp(value, x2) == 0) {
                    x1 = point[0];
                    y1 = point[1];
                }
            }
        } else if (!bSkew) {
            double p2;
            int ok;
            figure = figurePrev;
            if (bP1) {
                double p1;
                int num = ToolGeomFigure2D.getIntersectPointsExtension(intersect, figure, x1, y1, x2, y2);
                ok = 0;
                for (int i = 0; i < num; ++i) {
                    if (!ToolGeomFigure2D.checkPointOnWithoutDistance(intersect[i * 2], intersect[i * 2 + 1], figure)) continue;
                    if (i != ok) {
                        intersect[ok * 2] = intersect[i * 2];
                        intersect[ok * 2 + 1] = intersect[i * 2 + 1];
                    }
                    ++ok;
                }
                if (ok == 2 && ((p1 = ToolGeom2D.getParameter(intersect[0], intersect[1], x1, y1, x2, y2)) < 0.0 && p2 < 0.0) == p1 < (p2 = ToolGeom2D.getParameter(intersect[2], intersect[3], x1, y1, x2, y2))) {
                    intersect[0] = intersect[2];
                    intersect[1] = intersect[3];
                }
                if (ok > 0) {
                    double p = ToolGeom2D.getParameter(intersect[0], intersect[1], x1, y1, x2, y2);
                    if (p < 0.0) {
                        x1 = intersect[0];
                        y1 = intersect[1];
                    } else if (p > 1.0) {
                        x2 = intersect[0];
                        y2 = intersect[1];
                    }
                }
            }
            figure = figureNext;
            if (bP2) {
                double p1;
                int num = ToolGeomFigure2D.getIntersectPointsExtension(intersect, figure, x1, y1, x2, y2);
                ok = 0;
                for (int i = 0; i < num; ++i) {
                    if (!ToolGeomFigure2D.checkPointOnWithoutDistance(intersect[i * 2], intersect[i * 2 + 1], figure)) continue;
                    if (i != ok) {
                        intersect[ok * 2] = intersect[i * 2];
                        intersect[ok * 2 + 1] = intersect[i * 2 + 1];
                    }
                    ++ok;
                }
                if (ok == 2 && ((p1 = ToolGeom2D.getParameter(intersect[0], intersect[1], x1, y1, x2, y2)) > 1.0 && p2 > 1.0) == p1 > (p2 = ToolGeom2D.getParameter(intersect[2], intersect[3], x1, y1, x2, y2))) {
                    intersect[0] = intersect[2];
                    intersect[1] = intersect[3];
                }
                if (ok > 0) {
                    double p = ToolGeom2D.getParameter(intersect[0], intersect[1], x1, y1, x2, y2);
                    if (p < 0.0) {
                        x1 = intersect[0];
                        y1 = intersect[1];
                    } else if (p > 1.0) {
                        x2 = intersect[0];
                        y2 = intersect[1];
                    }
                }
            }
        }
        MPolylineCollection collectionOut = this.comp(x1, x2) == 0 || this.comp(y1, y2) == 0 ? collectionMain : collectionOther;
        if (useExistLine) {
            if (!this.findExtendFigure(polylineOut, collectionMain, null, x1, y1, x2, y2, lessSide)) {
                return polylineOut[0];
            }
            if (polylineOut[0] == null && !this.findExtendFigure(polylineOut, collectionOther, null, x1, y1, x2, y2, lessSide)) {
                return polylineOut[0];
            }
            if (polylineOut[0] != null) {
                figure = (IFigure2D)polylineOut[0].firstElement();
                if (this.comp(x2, figure.getX2()) > 0) {
                    figure.setX2(x2);
                    figure.setY2(y2);
                }
                if (this.comp(x1, figure.getX1()) < 0) {
                    figure.setX1(x1);
                    figure.setY1(y1);
                }
                return polylineOut[0];
            }
        }
        polylineOut[0] = collectionOut.add();
        PolylineEditable pe = (PolylineEditable)((Object)polylineOut[0]);
        figure = pe.add(1);
        if (isEndLine) {
            pe.setRegion(bFirst ? (byte)1 : 2);
        }
        figure.setX1(x1);
        figure.setY1(y1);
        figure.setX2(x2);
        figure.setY2(y2);
        Type type = new Type();
        type.offsetLine = isEndLine;
        figure.put(type);
        if (bHash) {
            ToolHashPolylines hash = new ToolHashPolylines();
            hash.process(collectionMain, collectionOther);
            hash.process(collectionOther, collectionMain);
            polylineOut[0] = null;
        }
        return polylineOut[0];
    }

    protected boolean createShortestLine(double[] pointOut, IPolyline2DCollection collectionComp, double x, double y, boolean lessSide) throws AlgebraException {
        Vector vectorPolylines = new Vector(10, 10);
        double[] intersect = new double[4];
        double xMin = Double.MAX_VALUE;
        double x2 = lessSide ? collectionComp.getLeft() : collectionComp.getRight();
        double parameterMin = Double.MAX_VALUE;
        vectorPolylines.clear();
        ToolGeomPolyline2D.search(vectorPolylines, collectionComp, collectionComp.getLeft(), y, collectionComp.getRight(), y);
        for (int i = 0; i < vectorPolylines.size(); ++i) {
            IPolyline2D polyline = (IPolyline2D)vectorPolylines.get(i);
            for (IFigure2D figure = (IFigure2D)polyline.firstElement(); figure != null; figure = (IFigure2D)figure.getNext()) {
                int num = ToolGeomFigure2D.getIntersectPoints(intersect, figure, x, y, x2, y);
                for (int j = 0; j < num; ++j) {
                    double parameterTmp = ToolGeom2D.getParameter(intersect[0], intersect[1], x, y, x2, y);
                    if (!(parameterTmp < parameterMin)) continue;
                    parameterMin = parameterTmp;
                    xMin = intersect[0];
                }
            }
        }
        pointOut[0] = xMin;
        pointOut[1] = y;
        return xMin != Double.MAX_VALUE;
    }

    protected void cutLineAll(Coordinate crd, double value, boolean bHorizontal, boolean lessSide) {
        IPolyline2D polyline;
        IPolyline2DCollection collection;
        if (bHorizontal) {
            double tmp = value;
            double tmp2 = ToolGeom2D.getValueFromParameter(crd.original.getY1(), crd.original.getY2(), (tmp - crd.original.getX1()) / (crd.original.getX2() - crd.original.getX1()));
            if (lessSide) {
                crd.original.setX1(tmp);
                crd.original.setY1(tmp2);
            } else {
                crd.original.setX2(tmp);
                crd.original.setY2(tmp2);
            }
        } else {
            double tmp = value;
            double tmp2 = ToolGeom2D.getValueFromParameter(crd.original.getX1(), crd.original.getX2(), (tmp - crd.original.getY1()) / (crd.original.getY2() - crd.original.getY1()));
            if (lessSide) {
                crd.original.setY1(tmp);
                crd.original.setX1(tmp2);
            } else {
                crd.original.setY2(tmp);
                crd.original.setX2(tmp2);
            }
        }
        double length = ToolGeomFigure2D.getLength(crd.original);
        if (length <= 1.0E-8 && (collection = (polyline = crd.original.getParent()).getParent()) instanceof ICollectionEditable) {
            ICollectionEditable ce = (ICollectionEditable)((Object)collection);
            ce.remove(polyline);
        }
    }

    protected void cutLine(Coordinate crd, double value, double prevValue, double nextValue, boolean bHorizontal, boolean lessSide) {
        IPolyline2D polyline;
        IPolyline2DCollection collection;
        IFigure2D figure;
        MPolylineCollection collection2;
        if (lessSide) {
            if (crd.lessSide) {
                if (bHorizontal) {
                    double tmp;
                    if (this.comp(prevValue, crd.original.getX1()) > 0) {
                        tmp = ToolGeom2D.getValueFromParameter(crd.original.getY1(), crd.original.getY2(), (prevValue - crd.original.getX1()) / (crd.original.getX2() - crd.original.getX1()));
                        collection2 = (MPolylineCollection)crd.original.getParent().getParent();
                        MPolyline polyline2 = (MPolyline)collection2.add();
                        figure = polyline2.add(1);
                        figure.setX1(crd.original.getX1());
                        figure.setY1(crd.original.getY1());
                        figure.setX2(prevValue);
                        figure.setY2(tmp);
                    }
                    tmp = ToolGeom2D.getValueFromParameter(crd.original.getY1(), crd.original.getY2(), (value - crd.original.getX1()) / (crd.original.getX2() - crd.original.getX1()));
                    crd.original.setX1(value);
                    crd.original.setY1(tmp);
                } else {
                    double tmp;
                    if (this.comp(prevValue, crd.original.getY1()) > 0) {
                        tmp = ToolGeom2D.getValueFromParameter(crd.original.getX1(), crd.original.getX2(), (prevValue - crd.original.getY1()) / (crd.original.getY2() - crd.original.getY1()));
                        collection2 = (MPolylineCollection)crd.original.getParent().getParent();
                        MPolyline polyline3 = (MPolyline)collection2.add();
                        figure = polyline3.add(1);
                        figure.setX1(crd.original.getX1());
                        figure.setY1(crd.original.getY1());
                        figure.setY2(prevValue);
                        figure.setX2(tmp);
                    }
                    tmp = ToolGeom2D.getValueFromParameter(crd.original.getX1(), crd.original.getX2(), (value - crd.original.getY1()) / (crd.original.getY2() - crd.original.getY1()));
                    crd.original.setY1(value);
                    crd.original.setX1(tmp);
                }
            } else if (bHorizontal) {
                double tmp = prevValue > crd.original.getX1() ? prevValue : crd.original.getX1();
                double tmp2 = ToolGeom2D.getValueFromParameter(crd.original.getY1(), crd.original.getY2(), (tmp - crd.original.getX1()) / (crd.original.getX2() - crd.original.getX1()));
                crd.original.setX2(tmp);
                crd.original.setY2(tmp2);
            } else {
                double tmp = prevValue > crd.original.getY1() ? prevValue : crd.original.getY1();
                double tmp2 = ToolGeom2D.getValueFromParameter(crd.original.getX1(), crd.original.getX2(), (tmp - crd.original.getY1()) / (crd.original.getY2() - crd.original.getY1()));
                crd.original.setY2(tmp);
                crd.original.setX2(tmp2);
            }
        } else if (crd.lessSide) {
            if (bHorizontal) {
                double tmp;
                if (this.comp(nextValue, crd.original.getX2()) < 0) {
                    tmp = ToolGeom2D.getValueFromParameter(crd.original.getY1(), crd.original.getY2(), (nextValue - crd.original.getX1()) / (crd.original.getX2() - crd.original.getX1()));
                    collection2 = (MPolylineCollection)crd.original.getParent().getParent();
                    MPolyline polyline4 = (MPolyline)collection2.add();
                    figure = polyline4.add(1);
                    figure.setX1(nextValue);
                    figure.setY1(tmp);
                    figure.setX2(crd.original.getX2());
                    figure.setY2(crd.original.getY2());
                }
                tmp = ToolGeom2D.getValueFromParameter(crd.original.getY1(), crd.original.getY2(), (value - crd.original.getX1()) / (crd.original.getX2() - crd.original.getX1()));
                crd.original.setX2(value);
                crd.original.setY2(tmp);
            } else {
                double tmp;
                if (this.comp(nextValue, crd.original.getY2()) < 0) {
                    tmp = ToolGeom2D.getValueFromParameter(crd.original.getX1(), crd.original.getX2(), (nextValue - crd.original.getY1()) / (crd.original.getY2() - crd.original.getY1()));
                    collection2 = (MPolylineCollection)crd.original.getParent().getParent();
                    MPolyline polyline5 = (MPolyline)collection2.add();
                    figure = polyline5.add(1);
                    figure.setY1(nextValue);
                    figure.setX1(tmp);
                    figure.setX2(crd.original.getX2());
                    figure.setY2(crd.original.getY2());
                }
                tmp = ToolGeom2D.getValueFromParameter(crd.original.getX1(), crd.original.getX2(), (value - crd.original.getY1()) / (crd.original.getY2() - crd.original.getY1()));
                crd.original.setY2(value);
                crd.original.setX2(tmp);
            }
        } else if (bHorizontal) {
            double tmp = nextValue < crd.original.getX2() ? nextValue : crd.original.getX2();
            double tmp2 = ToolGeom2D.getValueFromParameter(crd.original.getY1(), crd.original.getY2(), (tmp - crd.original.getX1()) / (crd.original.getX2() - crd.original.getX1()));
            crd.original.setX1(tmp);
            crd.original.setY1(tmp2);
        } else {
            double tmp = nextValue < crd.original.getY2() ? nextValue : crd.original.getY2();
            double tmp2 = ToolGeom2D.getValueFromParameter(crd.original.getX1(), crd.original.getX2(), (tmp - crd.original.getY1()) / (crd.original.getY2() - crd.original.getY1()));
            crd.original.setY1(tmp);
            crd.original.setX1(tmp2);
        }
        double length = ToolGeomFigure2D.getLength(crd.original);
        if (length <= 1.0E-8 && (collection = (polyline = crd.original.getParent()).getParent()) instanceof ICollectionEditable) {
            ICollectionEditable ce = (ICollectionEditable)((Object)collection);
            ce.remove(polyline);
        }
    }

    protected boolean findExtendFigure(IPolyline2D[] polylineOut, IPolyline2DCollection collectionIn, IPolyline2D polylineIn, double x, double y, double xComp, double yComp, boolean lessSide) {
        Vector vector = new Vector(10, 10);
        double tolerance = 1.0E-6;
        polylineOut[0] = null;
        ToolGeomPolyline2D.search(vector, collectionIn, Math.min(x, xComp), Math.min(y, yComp), Math.max(x, xComp), Math.max(y, yComp));
        for (int i = 0; i < vector.size(); ++i) {
            IPolyline2D polyline = (IPolyline2D)vector.get(i);
            if (!(polyline instanceof PolylineEditable) || polylineIn != null && polylineIn == polyline) continue;
            IFigure2D figure = (IFigure2D)polyline.firstElement();
            double distance1 = ToolGeom2D.getDistance(x, y, figure.getX1(), figure.getY1(), figure.getX2(), figure.getY2());
            double distance2 = ToolGeom2D.getDistance(xComp, yComp, figure.getX1(), figure.getY1(), figure.getX2(), figure.getY2());
            int check1 = this.comp(Math.max(x, xComp), Math.min(figure.getX1(), figure.getX2()));
            int check2 = this.comp(Math.max(figure.getX1(), figure.getX2()), Math.min(x, xComp));
            if ((check1 <= 0 || check2 <= 0) && distance1 <= tolerance && distance2 <= tolerance) {
                if (polylineOut[0] != null) {
                    IFigure2D figureOut = (IFigure2D)polylineOut[0].firstElement();
                    if (lessSide) {
                        distance1 = ToolGeom2D.getDistance(xComp, yComp, figure.getX2(), figure.getY2());
                        distance2 = ToolGeom2D.getDistance(xComp, yComp, figureOut.getX2(), figureOut.getY2());
                    } else {
                        distance1 = ToolGeom2D.getDistance(x, y, figure.getX1(), figure.getY1());
                        distance2 = ToolGeom2D.getDistance(x, y, figureOut.getX1(), figureOut.getY1());
                    }
                    if (!(distance1 < distance2)) continue;
                    polylineOut[0] = polyline;
                    continue;
                }
                polylineOut[0] = polyline;
                continue;
            }
            if (check1 <= 0 || check2 <= 0 || !(distance1 <= tolerance) || !(distance2 <= tolerance)) continue;
            polylineOut[0] = polyline;
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void createSort(BinarySort sortOut, IPolyline2DCollection collectionIn, double x1, double y1, double x2, double y2, boolean bHorizontal, boolean lessSide, boolean lough) throws AlgebraException {
        Vector vectorFigure = new Vector(10, 10);
        double[] intersect = new double[4];
        double tolerance = 0.001;
        int i = 0;
        block4: while (i < collectionIn.size()) {
            IPolyline2D polyline = collectionIn.get(i);
            ToolGeomPolyline2D.search(vectorFigure, polyline, x1, y1, x2, y2, tolerance);
            int j = 0;
            while (true) {
                int num;
                IFigure2D figure;
                if (j < vectorFigure.size()) {
                    figure = (IFigure2D)vectorFigure.get(j);
                    num = lough ? ToolGeomFigure2D.getIntersectPointsExtension(intersect, figure, x1, y1, x2, y2) : ToolGeomFigure2D.getIntersectPoints(intersect, figure, x1, y1, x2, y2);
                } else {
                    vectorFigure.clear();
                    ++i;
                    continue block4;
                }
                block6: for (int k = 0; k < num; ++k) {
                    double x = intersect[k * 2];
                    double y = intersect[k * 2 + 1];
                    if (lough) {
                        switch (figure.getType()) {
                            case 1: {
                                if (ToolGeom2D.compare(Math.min(figure.getX1(), figure.getX2()), x, tolerance) <= 0 && ToolGeom2D.compare(Math.max(figure.getX1(), figure.getX2()), x, tolerance) >= 0) break;
                                continue block6;
                            }
                            case 2: 
                            case 3: {
                                IFigure2DArc arc = (IFigure2DArc)figure;
                                int check1 = ToolGeom2D.compare(figure.getX1(), x, tolerance);
                                int check2 = ToolGeom2D.compare(figure.getX2(), x, tolerance);
                                boolean check = ToolGeomFigure2D.checkPointOnWithoutDistance(x, y, figure);
                                if (!check && (y < arc.getCY() != figure.getY1() < arc.getCY() || check1 != 0 && (y < arc.getCY() != figure.getY2() < arc.getCY() || check2 != 0))) continue block6;
                            }
                        }
                    }
                    Coordinate crd = bHorizontal ? new Coordinate(y) : new Coordinate(x);
                    crd.original = figure;
                    if (ToolGeom2D.equalPoints(figure.getX1(), figure.getY1(), x, y, tolerance)) {
                        byte res = ToolGeom2D.getSideOfPointWithLine(figure.getX2(), figure.getY2(), x1, y1, x2, y2);
                        if ((!lessSide || res != 2) && (lessSide || res != 1)) continue;
                        if (lessSide) {
                            crd.lessSide = true;
                        } else {
                            crd.moreSide = true;
                        }
                        sortOut.add(crd);
                        continue;
                    }
                    if (ToolGeom2D.equalPoints(figure.getX2(), figure.getY2(), x, y, tolerance)) {
                        byte res = ToolGeom2D.getSideOfPointWithLine(figure.getX1(), figure.getY1(), x1, y1, x2, y2);
                        if ((!lessSide || res != 2) && (lessSide || res != 1)) continue;
                        if (lessSide) {
                            crd.lessSide = true;
                        } else {
                            crd.moreSide = true;
                        }
                        sortOut.add(crd);
                        continue;
                    }
                    crd.moreSide = true;
                    crd.lessSide = true;
                    sortOut.add(crd);
                }
                ++j;
            }
            break;
        }
        return;
    }

    protected void changeSort(Vector vector) {
        Coordinate crdCurrent;
        int i;
        for (i = 0; i < vector.size(); ++i) {
            crdCurrent = (Coordinate)vector.get(i);
            if (crdCurrent.next == null) continue;
            int k = 1;
            Coordinate crdTarget = crdCurrent.next;
            while (crdTarget != null) {
                block5: {
                    for (int j = 0; j < k; ++j) {
                        Coordinate crdCompare = (Coordinate)vector.get(i + j);
                        int check = this.comp(Math.min(crdTarget.original.getY1(), crdTarget.original.getY2()), Math.min(crdCompare.original.getY1(), crdCompare.original.getY2()));
                        if (check == 0) {
                            check = this.comp(Math.max(crdTarget.original.getY1(), crdTarget.original.getY2()), Math.max(crdCompare.original.getY1(), crdCompare.original.getY2()));
                        }
                        if (check >= 0) continue;
                        vector.add(i + j, crdTarget);
                        break block5;
                    }
                    vector.add(i + k, crdTarget);
                }
                crdTarget = crdTarget.next;
                ++k;
            }
            i += k - 1;
        }
        for (i = 0; i < vector.size(); ++i) {
            crdCurrent = (Coordinate)vector.get(i);
            crdCurrent.next = null;
        }
    }

    protected void createSortOfIntersect(BinarySort sortOut, MPolylineCollection collectionIn, MPolylineCollection collectionComp, boolean bHorizontal) throws AlgebraException {
        Vector vectorFigure = new Vector(10, 10);
        double[] intersect = new double[4];
        double tolerance = 0.001;
        collectionIn.makeTree(new RegionTreeBuilder());
        for (int i = 0; i < collectionIn.size(); ++i) {
            MPolyline polyline1 = (MPolyline)collectionIn.get(i);
            IFigure2D figure1 = polyline1.firstElement();
            ToolGeomPolyline2D.search(vectorFigure, collectionComp != null ? collectionComp : collectionIn, polyline1.getLeft(), polyline1.getLower(), polyline1.getRight(), polyline1.getUpper());
            for (int j = 0; j < vectorFigure.size(); ++j) {
                MPolyline polyline2 = (MPolyline)vectorFigure.get(j);
                if (polyline1 == polyline2) continue;
                IFigure2D figure2 = polyline2.firstElement();
                int num = ToolGeomFigure2D.getIntersectPoints(intersect, figure1, figure2);
                for (int k = 0; k < num; ++k) {
                    double x = intersect[k * 2];
                    double y = intersect[k * 2 + 1];
                    Coordinate crd = bHorizontal ? new Coordinate(x) : new Coordinate(y);
                    crd.original = figure2;
                    sortOut.add(crd);
                }
            }
            vectorFigure.clear();
        }
    }

    protected void createSortOfIntersect(BinarySort sortOut, IPolyline2DCollection collectionIn, double x1, double y1, double x2, double y2, double xc, double yc, double radius, boolean cw) throws AlgebraException {
        Vector vectorFigure = new Vector(10, 10);
        double[] intersect = new double[4];
        double tolerance = 10.0;
        ToolGeom2D.getFitRectangle(intersect, x1, y1, x2, y2, xc, yc, radius, cw);
        ToolGeomPolyline2D.search(vectorFigure, collectionIn, intersect[0] - tolerance, intersect[1] - tolerance, intersect[2] + tolerance, intersect[3] + tolerance);
        for (int i = 0; i < vectorFigure.size(); ++i) {
            MPolyline polyline = (MPolyline)vectorFigure.get(i);
            IFigure2D figure = polyline.firstElement();
            if (this.comp(Math.min(x1, x2), Math.max(figure.getX1(), figure.getX2())) >= 0 || this.comp(Math.max(x1, x2), Math.min(figure.getX1(), figure.getX2())) <= 0) continue;
            int iNum = ToolGeomFigure2D.getIntersectPoints(intersect, figure, x1, y1, x2, y2, xc, yc, radius, cw);
            for (int j = 0; j < iNum; ++j) {
                double parameter = ToolGeom2D.getParameter(intersect[j * 2], intersect[j * 2 + 1], x1, y1, x2, y2, xc, yc, radius, cw);
                Coordinate crd = new Coordinate(parameter);
                double[] point = new double[]{intersect[j * 2], intersect[j * 2 + 1]};
                crd.original = figure;
                crd.originalObj = point;
                sortOut.add(crd);
            }
        }
    }

    protected void createSortOfIntersect(BinarySort sortOut, IPolyline2DCollection collectionIn, double x1, double y1, double x2, double y2, boolean bRegistX) throws AlgebraException {
        Vector vectorFigure = new Vector(10, 10);
        double[] intersect = new double[4];
        double tolerance = 10.0;
        ToolGeom2D.getFitRectangle(intersect, x1, y1, x2, y2);
        ToolGeomPolyline2D.search(vectorFigure, collectionIn, intersect[0] - tolerance, intersect[1] - tolerance, intersect[2] + tolerance, intersect[3] + tolerance);
        for (int i = 0; i < vectorFigure.size(); ++i) {
            MPolyline polyline = (MPolyline)vectorFigure.get(i);
            for (IFigure2D figure = polyline.firstElement(); figure != null; figure = (IFigure2D)figure.getNext()) {
                int iNum = ToolGeomFigure2D.getIntersectPoints(intersect, figure, x1, y1, x2, y2);
                for (int j = 0; j < iNum; ++j) {
                    Coordinate crd = new Coordinate(intersect[j * 2 + (bRegistX ? 0 : 1)]);
                    double[] point = new double[]{intersect[j * 2], intersect[j * 2 + 1]};
                    crd.original = figure;
                    crd.originalObj = point;
                    sortOut.add(crd);
                }
            }
        }
    }

    protected void createSortOfPoints(BinarySort sortOut, Vector vectorPoints, double x1, double y1, double x2, double y2) throws AlgebraException {
        double tolerance = 0.001;
        double[] pointTmp = new double[2];
        int iDiffX = this.comp(x1, x2);
        int iDiffY = this.comp(y1, y2);
        for (int i = 0; i < vectorPoints.size(); ++i) {
            Coordinate crd;
            IPoint2D point = (IPoint2D)vectorPoints.get(i);
            double x = point.getXd();
            double y = point.getYd();
            ToolGeom2D.getPerpendicularPoint(pointTmp, x, y, x1, y1, x2, y2);
            double distance = ToolGeom2D.getDistance(x, y, pointTmp[0], pointTmp[1]);
            if (!(distance <= tolerance) || !ToolGeom2D.checkPointOnLinearWithoutDistance(pointTmp[0], pointTmp[1], x1, y1, x2, y2)) continue;
            if (iDiffY == 0) {
                crd = new Coordinate(point.getXd());
            } else {
                if (iDiffX != 0) continue;
                crd = new Coordinate(point.getYd());
            }
            crd.originalObj = point;
            sortOut.add(crd);
        }
    }

    protected void createSortOfAllPoints(BinarySort sortOut, Vector vectorPoints, double x1, double y1, double x2, double y2) throws AlgebraException {
        Coordinate crd = null;
        int iDiffX = this.comp(x1, x2);
        int iDiffY = this.comp(y1, y2);
        for (int i = 0; i < vectorPoints.size(); ++i) {
            IPoint2D point = (IPoint2D)vectorPoints.get(i);
            double x = point.getXd();
            double y = point.getYd();
            if ((iDiffX != 0 || this.comp(y1, point.getYd()) > 0 || this.comp(y2, point.getYd()) < 0) && (iDiffY != 0 || this.comp(x1, point.getXd()) > 0 || this.comp(x2, point.getXd()) < 0)) continue;
            if (iDiffY == 0) {
                crd = new Coordinate(point.getXd());
            } else {
                if (iDiffX != 0) continue;
                crd = new Coordinate(point.getYd());
            }
            crd.originalObj = point;
            sortOut.add(crd);
        }
    }

    protected void createSortOfPoints(BinarySort sortOut, Vector vectorLumberGirder, Vector vectorPoints, IFigure2D figureOriginal, double[] polygon) throws AlgebraException {
        double valueTmp;
        int result;
        IPoint2D point;
        int i;
        boolean bHorizontal;
        Vector<IPoint2D> vector = new Vector<IPoint2D>(10, 10);
        double min = 0.0;
        double max = 0.0;
        double value = -1.7976931348623157E308;
        double prevValue = -1.7976931348623157E308;
        double valueMax = -1.7976931348623157E308;
        double maxDist = 0.0;
        int count = 0;
        int countMax = 0;
        boolean bFirst = true;
        boolean bl = bHorizontal = this.comp(figureOriginal.getY1(), figureOriginal.getY2()) == 0;
        boolean bObverse = bHorizontal ? this.comp(figureOriginal.getX1(), figureOriginal.getX2()) < 0 : this.comp(figureOriginal.getY1(), figureOriginal.getY2()) > 0;
        prevValue = bObverse ? -1.7976931348623157E308 : Double.MAX_VALUE;
        for (i = 0; i < vectorPoints.size(); ++i) {
            double y;
            point = (IPoint2D)vectorPoints.get(i);
            double x = point.getXd();
            result = ToolPlane2D.determinatePoint(polygon, x, y = point.getYd(), this.tolerance);
            if (result != 3 && result != 5) continue;
            vector.add(point);
        }
        while (true) {
            value = bObverse ? Double.MAX_VALUE : -1.7976931348623157E308;
            boolean check = false;
            for (i = 0; i < vector.size(); ++i) {
                point = (IPoint2D)vector.get(i);
                double d = valueTmp = bHorizontal ? point.getYd() : point.getXd();
                if ((!bObverse || this.comp(value, valueTmp) <= 0 || this.comp(prevValue, valueTmp) >= 0) && (bObverse || this.comp(value, valueTmp) >= 0 || this.comp(prevValue, valueTmp) <= 0)) continue;
                value = valueTmp;
                count = 0;
                max = bHorizontal ? point.getXd() : point.getYd();
                min = max;
                check = true;
            }
            if (!check) break;
            prevValue = value;
            for (int j = 0; j < vector.size(); ++j) {
                point = (IPoint2D)vector.get(j);
                double d = valueTmp = bHorizontal ? point.getYd() : point.getXd();
                if (!this.checkPoint(vectorLumberGirder, point.getXd(), point.getYd()) || this.comp(value, valueTmp) != 0) continue;
                double valueTmp2 = bHorizontal ? point.getXd() : point.getYd();
                ++count;
                if (this.comp(valueTmp2, min) < 0) {
                    min = valueTmp2;
                }
                if (this.comp(valueTmp2, max) <= 0) continue;
                max = valueTmp2;
            }
            result = this.comp(Math.abs(max - min), maxDist);
            if (count < 2 || this.comp(min, max) == 0 || result <= 0 && (result != 0 || count <= countMax)) continue;
            maxDist = Math.abs(max - min);
            valueMax = value;
            countMax = count;
        }
        for (i = 0; i < vector.size(); ++i) {
            point = (IPoint2D)vector.get(i);
            double d = valueTmp = bHorizontal ? point.getYd() : point.getXd();
            if (this.comp(valueTmp, valueMax) != 0) continue;
            Coordinate crd = bHorizontal ? new Coordinate(point.getXd()) : new Coordinate(point.getYd());
            crd.originalObj = point;
            sortOut.add(crd);
        }
    }

    protected void createSortOfIntersect(BinarySort sortOut, Vector vectorLines, double x1, double y1, double x2, double y2, double exceptDistance) throws AlgebraException {
        double[] intersect = new double[4];
        int iDiffX = this.comp(x1, x2);
        int iDiffY = this.comp(y1, y2);
        for (int i = 0; i < vectorLines.size(); ++i) {
            Coordinate crd;
            ILine2D line = (ILine2D)vectorLines.get(i);
            if (!ToolGeom2D.getIntersectPoints(intersect, line.getStartPoint().getXd(), line.getStartPoint().getYd(), line.getEndPoint().getXd(), line.getEndPoint().getYd(), x1, y1, x2, y2) || exceptDistance > 0.0 && (ToolGeom2D.getDistance(line.getStartPoint().getXd(), line.getStartPoint().getYd(), intersect[0], intersect[1]) < exceptDistance || ToolGeom2D.getDistance(line.getEndPoint().getXd(), line.getEndPoint().getYd(), intersect[0], intersect[1]) < exceptDistance)) continue;
            if (iDiffY == 0) {
                crd = new Coordinate(intersect[0]);
            } else {
                if (iDiffX != 0) continue;
                crd = new Coordinate(intersect[1]);
            }
            sortOut.add(crd);
        }
    }

    protected void createSortOfIntersect(BinarySort sortOut, Vector vectorLines, double x1, double y1, double x2, double y2, double xc, double yc, double radius, double exceptDistance, boolean cw) throws AlgebraException {
        double[] intersect = new double[4];
        for (int i = 0; i < vectorLines.size(); ++i) {
            ILine2D line = (ILine2D)vectorLines.get(i);
            int iNum = ToolGeom2D.getIntersectPoints(intersect, line.getStartPoint().getXd(), line.getStartPoint().getYd(), line.getEndPoint().getXd(), line.getEndPoint().getYd(), x1, y1, x2, y2, xc, yc, radius, cw);
            if (iNum <= 0) continue;
            for (int j = 0; j < iNum; ++j) {
                if (exceptDistance > 0.0 && (ToolGeom2D.getDistance(line.getStartPoint().getXd(), line.getStartPoint().getYd(), intersect[j * 2], intersect[j * 2 + 1]) < exceptDistance || ToolGeom2D.getDistance(line.getEndPoint().getXd(), line.getEndPoint().getYd(), intersect[j * 2], intersect[j * 2 + 1]) < exceptDistance)) continue;
                double parameter = ToolGeom2D.getParameter(intersect[j * 2], intersect[j * 2 + 1], x1, y1, x2, y2, xc, yc, radius, cw);
                Coordinate crd = new Coordinate(parameter);
                crd.originalObj = line;
                sortOut.add(crd);
            }
        }
    }

    public int getSuperpositionLines(Vector vectorOut, Vector vectorIn, double x1, double y1, double x2, double y2) {
        double tolerance = 0.01;
        double toleranceParam = 1.0E-6;
        double[] perpend = new double[2];
        for (int i = 0; i < vectorIn.size(); ++i) {
            double parameter2;
            ILine2D line = (ILine2D)vectorIn.get(i);
            ToolGeom2D.getPerpendicularPoint(perpend, line.getStartPoint().getXd(), line.getStartPoint().getYd(), x1, y1, x2, y2);
            double distance = ToolGeom2D.getDistance(perpend[0], perpend[1], line.getStartPoint().getXd(), line.getStartPoint().getYd());
            if (distance > tolerance) continue;
            double parameter1 = ToolGeom2D.getParameter(perpend[0], perpend[1], x1, y1, x2, y2);
            ToolGeom2D.getPerpendicularPoint(perpend, line.getEndPoint().getXd(), line.getEndPoint().getYd(), x1, y1, x2, y2);
            distance = ToolGeom2D.getDistance(perpend[0], perpend[1], line.getEndPoint().getXd(), line.getEndPoint().getYd());
            if (distance > tolerance || ToolGeom2D.compare(Math.max(parameter1, parameter2 = ToolGeom2D.getParameter(perpend[0], perpend[1], x1, y1, x2, y2)), 0.0, toleranceParam) <= 0 || ToolGeom2D.compare(Math.min(parameter1, parameter2), 1.0, toleranceParam) >= 0) continue;
            vectorOut.add(line);
        }
        return vectorOut.size();
    }

    protected void joinFigures(Vector vector) {
        double tolerance = 0.01;
        double toleranceParam = 1.0E-6;
        double[] perpend = new double[2];
        for (int i = 0; i < vector.size(); ++i) {
            Line line1 = (Line)vector.get(i);
            for (int j = i + 1; j < vector.size(); ++j) {
                double parameter2;
                Line line2 = (Line)vector.get(j);
                ToolGeom2D.getPerpendicularPoint(perpend, line2.getStartPoint().getXd(), line2.getStartPoint().getYd(), line1.getStartPoint().getXd(), line1.getStartPoint().getYd(), line1.getEndPoint().getXd(), line1.getEndPoint().getYd());
                double distance = ToolGeom2D.getDistance(perpend[0], perpend[1], line2.getStartPoint().getXd(), line2.getStartPoint().getYd());
                if (distance > tolerance) continue;
                double parameter1 = ToolGeom2D.getParameter(perpend[0], perpend[1], line1.getStartPoint().getXd(), line1.getStartPoint().getYd(), line1.getEndPoint().getXd(), line1.getEndPoint().getYd());
                ToolGeom2D.getPerpendicularPoint(perpend, line2.getEndPoint().getXd(), line2.getEndPoint().getYd(), line1.getStartPoint().getXd(), line1.getStartPoint().getYd(), line1.getEndPoint().getXd(), line1.getEndPoint().getYd());
                distance = ToolGeom2D.getDistance(perpend[0], perpend[1], line2.getEndPoint().getXd(), line2.getEndPoint().getYd());
                if (distance > tolerance || ToolGeom2D.compare(Math.max(parameter1, parameter2 = ToolGeom2D.getParameter(perpend[0], perpend[1], line1.getStartPoint().getXd(), line1.getStartPoint().getYd(), line1.getEndPoint().getXd(), line1.getEndPoint().getYd())), 0.0, toleranceParam) < 0 || ToolGeom2D.compare(Math.min(parameter1, parameter2), 1.0, toleranceParam) > 0) continue;
                if (parameter1 < 0.0) {
                    line1.setX1(line2.getStartPoint().getXd());
                    line1.setY1(line2.getStartPoint().getYd());
                } else if (parameter1 > 1.0) {
                    line1.setX2(line2.getStartPoint().getXd());
                    line1.setY2(line2.getStartPoint().getYd());
                }
                if (parameter2 < 0.0) {
                    line1.setX1(line2.getEndPoint().getXd());
                    line1.setY1(line2.getEndPoint().getYd());
                } else if (parameter2 > 1.0) {
                    line1.setX2(line2.getEndPoint().getXd());
                    line1.setY2(line2.getEndPoint().getYd());
                }
                vector.remove(j);
                --j;
            }
        }
    }

    public boolean checkCrossed(IPolyline2DCollection collectionIn, double x1, double y1, double x2, double y2, boolean bIncludeExtreme) throws AlgebraException {
        return this.getCrossed(collectionIn, x1, y1, x2, y2, bIncludeExtreme) != null;
    }

    public IFigure2D getCrossed(IPolyline2DCollection collectionIn, double x1, double y1, double x2, double y2, boolean bIncludeExtreme) throws AlgebraException {
        Object polylineOut = null;
        Vector vector = new Vector(10, 10);
        Vector vector2 = new Vector(10, 10);
        double tolerance = 1.0E-6;
        double[] intersect = new double[4];
        ToolGeomPolyline2D.search(vector, collectionIn, Math.min(x1, x2), Math.min(y1, y2), Math.max(x1, x2), Math.max(y1, y2));
        for (int i = 0; i < vector.size(); ++i) {
            IPolyline2D polyline = (IPolyline2D)vector.get(i);
            if (!(polyline instanceof PolylineEditable)) continue;
            ToolGeomPolyline2D.search(vector2, polyline, Math.min(x1, x2), Math.min(y1, y2), Math.max(x1, x2), Math.max(y1, y2));
            for (int j = 0; j < vector2.size(); ++j) {
                IFigure2D figure = (IFigure2D)vector2.get(j);
                int num = ToolGeomFigure2D.getIntersectPoints(intersect, figure, x1, y1, x2, y2);
                if (num > 0 && bIncludeExtreme) {
                    return figure;
                }
                for (int k = 0; k < num; ++k) {
                    if (ToolGeom2D.equalPoints(intersect[k * 2], intersect[k * 2 + 1], x1, y1) || ToolGeom2D.equalPoints(intersect[k * 2], intersect[k * 2 + 1], x2, y2)) continue;
                    return figure;
                }
            }
            vector2.clear();
        }
        return null;
    }

    public boolean checkCrossed(double line_x1, double line_y1, double line_x2, double line_y2, double arc_x1, double arc_y1, double arc_x2, double arc_y2, double arc_xc, double arc_yc, double arc_radius, boolean arc_cw, boolean bIncludeStart, boolean bIncludeEnd) throws AlgebraException {
        double[] intersect = new double[4];
        double tolerance = 5.0;
        int num = ToolGeom2D.getIntersectPointsExtension(intersect, line_x1, line_y1, line_x2, line_y2, arc_xc, arc_yc, arc_radius);
        if (num <= 1) {
            return false;
        }
        for (int k = 0; k < num; ++k) {
            if (!ToolGeom2D.checkPointOnLinearWithoutDistance(intersect[k * 2], intersect[k * 2 + 1], line_x1, line_y1, line_x2, line_y2) || !ToolGeom2D.checkPointOnCircleWithoutDistance(intersect[k * 2], intersect[k * 2 + 1], arc_x1, arc_y1, arc_x2, arc_y2, arc_xc, arc_yc, arc_cw)) continue;
            double dist1 = ToolGeom2D.getDistance(intersect[k * 2], intersect[k * 2 + 1], line_x1, line_y1);
            double dist2 = ToolGeom2D.getDistance(intersect[k * 2], intersect[k * 2 + 1], line_x2, line_y2);
            if (!bIncludeStart && !(dist1 > tolerance) || !bIncludeEnd && !(dist2 > tolerance)) continue;
            return true;
        }
        return false;
    }

    public boolean checkCrossed(double line1_x1, double line1_y1, double line1_x2, double line1_y2, double line2_x1, double line2_y1, double line2_x2, double line2_y2, boolean bIncludeStart, boolean bIncludeEnd) throws AlgebraException {
        double[] intersect = new double[4];
        boolean check = ToolGeom2D.getIntersectPoints(intersect, line1_x1, line1_y1, line1_x2, line1_y2, line2_x1, line2_y1, line2_x2, line2_y2);
        return !(!check || !bIncludeStart && ToolGeom2D.equalPoints(intersect[0], intersect[1], line1_x1, line1_y1) || !bIncludeEnd && ToolGeom2D.equalPoints(intersect[0], intersect[1], line1_x2, line1_y2));
    }

    protected boolean checkIntersect(Vector vectorLines, double x1, double y1, double x2, double y2, double rangeDistance) throws AlgebraException {
        double[] intersect = new double[4];
        for (int i = 0; i < vectorLines.size(); ++i) {
            ILine2D line = (ILine2D)vectorLines.get(i);
            if (!ToolGeom2D.getIntersectPoints(intersect, line.getStartPoint().getXd(), line.getStartPoint().getYd(), line.getEndPoint().getXd(), line.getEndPoint().getYd(), x1, y1, x2, y2) || !(rangeDistance > 0.0) || !(ToolGeom2D.getDistance(line.getStartPoint().getXd(), line.getStartPoint().getYd(), intersect[0], intersect[1]) < rangeDistance) && !(ToolGeom2D.getDistance(line.getEndPoint().getXd(), line.getEndPoint().getYd(), intersect[0], intersect[1]) < rangeDistance)) continue;
            return true;
        }
        return false;
    }

    protected void findOutTCross(Vector vectorIn, Vector vectorComp) throws AlgebraException {
        double tolerance = 1.0E-6;
        double[] intersect = new double[4];
        for (int i = 0; i < vectorIn.size(); i += 2) {
            boolean[] flag;
            ILine2D line = (ILine2D)vectorIn.get(i);
            if (i + 1 < vectorIn.size() && vectorIn.get(i + 1) instanceof boolean[]) {
                flag = (boolean[])vectorIn.get(i + 1);
            } else {
                flag = new boolean[]{false, false};
                vectorIn.add(i + 1, flag);
            }
            if (this.comp(line.getStartPoint().getYd(), line.getEndPoint().getYd()) == 0) continue;
            for (int j = 0; j < vectorComp.size(); ++j) {
                boolean bPosition;
                boolean bLess;
                boolean bFirst;
                ILine2D lineComp = (ILine2D)vectorComp.get(j);
                if (this.comp(lineComp.getStartPoint().getYd(), lineComp.getEndPoint().getYd()) != 0 || !ToolGeom2D.getIntersectPoints(intersect, line.getStartPoint().getXd(), line.getStartPoint().getYd(), line.getEndPoint().getXd(), line.getEndPoint().getYd(), lineComp.getStartPoint().getXd(), lineComp.getStartPoint().getYd(), lineComp.getEndPoint().getXd(), lineComp.getEndPoint().getYd())) continue;
                if (ToolGeom2D.equalPoints(intersect[0], intersect[1], line.getStartPoint().getXd(), line.getStartPoint().getYd())) {
                    bFirst = true;
                } else {
                    if (!ToolGeom2D.equalPoints(intersect[0], intersect[1], line.getEndPoint().getXd(), line.getEndPoint().getYd())) continue;
                    bFirst = false;
                }
                boolean bl = bLess = this.comp(Math.min(line.getStartPoint().getXd(), line.getEndPoint().getXd()), intersect[0]) < 0;
                if (bLess) {
                    bPosition = this.comp(Math.min(lineComp.getStartPoint().getXd(), lineComp.getEndPoint().getXd()), intersect[0]) < 0;
                } else {
                    boolean bl2 = bPosition = this.comp(Math.max(lineComp.getStartPoint().getXd(), lineComp.getEndPoint().getXd()), intersect[0]) > 0;
                }
                if (!bPosition) continue;
                if (bFirst) {
                    flag[0] = true;
                    continue;
                }
                flag[1] = true;
            }
        }
    }

    protected boolean checkDistanceOfPointAndArc(IFigure2D figureArc, double x, double y, double limitDistance) throws AlgebraException {
        IFigure2DArc arc = (IFigure2DArc)figureArc;
        double[] point = new double[4];
        double dist1 = 0.0;
        double dist2 = 0.0;
        int num = ToolGeomFigure2D.getIntersectPoints(point, figureArc, x, arc.getCY() - arc.getRadius(), x, arc.getCY() + arc.getRadius());
        if (num == 0) {
            return false;
        }
        if (num > 0) {
            dist1 = ToolGeom2D.getDistance(point[0], point[1], x, y);
        }
        if (num > 1 && dist1 > (dist2 = ToolGeom2D.getDistance(point[2], point[3], x, y))) {
            dist2 = dist1;
        }
        return this.comp(dist1, limitDistance) <= 0;
    }

    protected boolean checkPoint(Vector vectorLumberGirder, double x, double y) {
        for (int i = 0; i < vectorLumberGirder.size(); ++i) {
            ILine2D line = (ILine2D)vectorLumberGirder.get(i);
            IPoint2D point1 = line.getStartPoint();
            IPoint2D point2 = line.getEndPoint();
            if (!ToolGeom2D.checkPointOn(x, y, point1.getXd(), point1.getYd(), point2.getXd(), point2.getYd())) continue;
            return true;
        }
        return false;
    }

    class Type
    implements IAdditData {
        public boolean offsetLine = false;

        Type() {
        }

        @Override
        public int getKey() {
            return 0;
        }
    }

    protected class Comp
    implements NodeComparator<Coordinate> {
        public static final double tolerance = 1.0E-6;

        @Override
        public synchronized int compare(Coordinate t1, Coordinate t2) {
            if (Math.abs(t1.value - t2.value) <= 1.0E-6) {
                return 0;
            }
            if (t1.value < t2.value) {
                return -1;
            }
            return 1;
        }

        @Override
        public synchronized int compare(Coordinate t, double value) {
            if (Math.abs(t.value - value) <= 1.0E-6) {
                return 0;
            }
            if (t.value < value) {
                return -1;
            }
            return 1;
        }

        @Override
        public synchronized boolean addSameValue(Coordinate t1, Coordinate t2) {
            while (t1 != null && t1.next != null) {
                t1 = t1.next;
            }
            t1.next = t2;
            return true;
        }
    }

    protected class Coordinate {
        public IFigure2D original = null;
        public Object originalObj = null;
        public double value = 0.0;
        public boolean lessSide = false;
        public boolean moreSide = false;
        public Coordinate next = null;

        Coordinate(double dIn) {
            this.value = dIn;
        }
    }
}

