/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.math.algebra;

import jp.kitec.math.algebra.AlgebraException;
import jp.kitec.math.algebra.ToolAlgebra1D;

public class ToolAlgebra2DQuadratic {
    private static double TOLERANCE_1 = 1.0E-10;
    private static double TOLERANCE_2 = 1.0E-8;
    public static final int EQUALITYSIGN_NOT_EQUAL = 0;
    public static final int EQUALITYSIGN_EQUAL = 1;
    public static final int EQUALITYSIGN_LESS_THAN = 2;
    public static final int EQUALITYSIGN_GREATER_THAN = 3;
    public static final int EQUALITYSIGN_LESS_THAN_OR_EQUAL = 4;
    public static final int EQUALITYSIGN_GREATER_THAN_OR_EQUAL = 5;
    private double A;
    private double B;
    private double C;
    private double D;
    private double E;
    private double F;
    private double[] answerX;
    private double[] answerY;
    ToolAlgebra1D __evaluateTwoQuadraticEquations_ToolAlgebra1D_1 = new ToolAlgebra1D();
    ToolAlgebra1D __evaluateTwoQuadraticEquations_ToolAlgebra1D_2 = new ToolAlgebra1D();
    ToolAlgebra1D __evaluateTwoQuadraticEquations_ToolAlgebra1D_3 = new ToolAlgebra1D();

    public ToolAlgebra2DQuadratic() {
        this.answerX = new double[4];
        this.answerY = new double[4];
    }

    public ToolAlgebra2DQuadratic(double a, double b, double c, double d, double e, double f) {
        this();
        this.A = a;
        this.B = b;
        this.C = c;
        this.D = d;
        this.E = e;
        this.F = f;
    }

    static int compare(double x) {
        if (Math.abs(x) <= TOLERANCE_1) {
            return 0;
        }
        if (x < 0.0) {
            return -1;
        }
        return 1;
    }

    static int compare(double x1, double x2) {
        if (Math.abs(x1 - x2) <= TOLERANCE_2) {
            return 0;
        }
        if (x1 < x2) {
            return -1;
        }
        return 1;
    }

    static int compare(double x1, double x2, double tolerance) {
        if (Math.abs(x1 - x2) <= tolerance) {
            return 0;
        }
        if (x1 < x2) {
            return -1;
        }
        return 1;
    }

    private static boolean CheckPositionOfPoint(double dA, double dB, double dC, double dD, double dE, double dF, double dInX, double dInY, int mathequationequalitysign) {
        double dP = dA * dInX * dInX + dB * dInY * dInY + dC * dInX * dInY + dD * dInX + dE * dInY + dF;
        int iResult = ToolAlgebra2DQuadratic.compare(dP, 0.0, 5.0E-10);
        switch (mathequationequalitysign) {
            case 1: {
                if (iResult != 0) break;
                return true;
            }
            case 2: {
                if (iResult >= 0) break;
                return true;
            }
            case 3: {
                if (iResult <= 0) break;
                return true;
            }
            case 4: {
                if (iResult > 0) break;
                return true;
            }
            case 5: {
                if (iResult < 0) break;
                return true;
            }
        }
        return false;
    }

    public boolean linear(double x1, double y1, double x2, double y2) throws AlgebraException {
        return this.linear(x1, y1, x1, y1, x2, y2);
    }

    public boolean linear(double baseX, double baseY, double x1, double y1, double x2, double y2) throws AlgebraException {
        this.C = 0.0;
        this.B = 0.0;
        this.A = 0.0;
        this.D = y2 - y1;
        if (ToolAlgebra2DQuadratic.compare(this.D, 0.0) == 0) {
            this.D = 0.0;
        }
        this.E = -(x2 - x1);
        if (ToolAlgebra2DQuadratic.compare(this.E, 0.0) == 0) {
            this.E = 0.0;
        }
        this.F = -(this.D * baseX + this.E * baseY);
        if (this.D == 0.0 && this.E == 0.0) {
            return false;
        }
        if (this.E != 0.0 && this.D / this.E > 1.0E8 || this.D != 0.0 && this.E / this.D > 1.0E8) {
            throw new AlgebraException();
        }
        return true;
    }

    public boolean halfDividePerpendicularLinear(double x1, double y1, double x2, double y2) throws AlgebraException {
        this.C = 0.0;
        this.B = 0.0;
        this.A = 0.0;
        this.D = x2 - x1;
        if (ToolAlgebra2DQuadratic.compare(this.D, 0.0) == 0) {
            this.D = 0.0;
        }
        this.E = y2 - y1;
        if (ToolAlgebra2DQuadratic.compare(this.E, 0.0) == 0) {
            this.E = 0.0;
        }
        this.F = -(y2 * y2 - y1 * y1 + x2 * x2 - x1 * x1) / 2.0;
        if (this.D == 0.0 && this.E == 0.0) {
            return false;
        }
        if (ToolAlgebra2DQuadratic.compare(this.F, 0.0, 1.0E-15) == 0) {
            this.F = 0.0;
        }
        if (this.E != 0.0 && this.D / this.E > 1.0E8 || this.D != 0.0 && this.E / this.D > 1.0E8) {
            throw new AlgebraException();
        }
        return true;
    }

    public void circle(double x, double y, double r) {
        this.B = 1.0;
        this.A = 1.0;
        this.C = 0.0;
        this.D = -2.0 * x;
        this.E = -2.0 * y;
        this.F = x * x + y * y - r * r;
    }

    public void ellipse(double x, double y, double a, double b) {
        this.A = 1.0 / (a * a);
        this.B = 1.0 / (b * b);
        this.C = 0.0;
        this.D = -2.0 * x * this.A;
        this.E = -2.0 * y * this.B;
        this.F = x * x * this.A + y * y * this.B - 1.0;
    }

    public void ellipse(double a, double b, double c, double d, double dD) {
        double d1 = a - c;
        double d2 = b - d;
        double d3 = a * a - c * c;
        double d4 = b * b - d * d;
        double dD2 = dD * dD;
        this.A = 4.0 * (d1 * d1 - dD2);
        this.B = 4.0 * (d2 * d2 - dD2);
        this.C = 8.0 * (b * d1 - d * d1);
        this.D = -4.0 * (a * (d3 + d4 - dD2) - c * (d3 * d4 + dD2));
        this.E = -4.0 * (b * (d3 + d4 - dD2) - d * (d3 * d4 + dD2));
        this.F = d3 * d3 + d4 * d4 - 2.0 * dD2 * (a * a + b * b + c * c + d * d) + 2.0 * (b * b * d3 - d * d * d3) + dD2 * dD2;
    }

    public int solve(ToolAlgebra2DQuadratic quadratic) {
        int i;
        int iOut = 0;
        int iN = (ToolAlgebra2DQuadratic.compare(this.B) != 0 || ToolAlgebra2DQuadratic.compare(quadratic.B) != 0) && Math.abs(this.D) + Math.abs(quadratic.D) <= Math.abs(this.E) + Math.abs(quadratic.E) ? this.evaluateTwoQuadraticEquations(this.answerX, this.answerY, this.A, this.B, this.C, this.D, this.E, this.F, quadratic.A, quadratic.B, quadratic.C, quadratic.D, quadratic.E, quadratic.F) : ((ToolAlgebra2DQuadratic.compare(this.A) != 0 || ToolAlgebra2DQuadratic.compare(quadratic.A) != 0) && Math.abs(this.D) + Math.abs(quadratic.D) > Math.abs(this.E) + Math.abs(quadratic.E) ? this.evaluateTwoQuadraticEquations(this.answerY, this.answerX, this.B, this.A, this.C, this.E, this.D, this.F, quadratic.B, quadratic.A, quadratic.C, quadratic.E, quadratic.D, quadratic.F) : (ToolAlgebra2DQuadratic.compare(this.C) != 0 || ToolAlgebra2DQuadratic.compare(this.E) != 0 ? this.evaluateTwoQuadraticEquations(this.answerX, this.answerY, this.C, this.D, this.E, this.F, quadratic.C, quadratic.D, quadratic.E, quadratic.F) : this.evaluateTwoQuadraticEquations(this.answerY, this.answerX, this.C, this.E, this.D, this.F, quadratic.C, quadratic.E, quadratic.D, quadratic.F)));
        block0: for (i = 0; i < iN; ++i) {
            for (int j = i + 1; j < iOut; ++j) {
                if (ToolAlgebra2DQuadratic.compare(this.answerX[i], this.answerX[j]) == 0 && ToolAlgebra2DQuadratic.compare(this.answerY[i], this.answerY[j]) == 0) continue block0;
            }
            if (iOut != i) {
                this.answerX[iOut] = this.answerX[i];
                this.answerY[iOut] = this.answerY[i];
            }
            ++iOut;
        }
        for (i = 0; i < iOut; ++i) {
            quadratic.answerX[i] = this.answerX[i];
            quadratic.answerY[i] = this.answerY[i];
        }
        return iOut;
    }

    public double getSolutionX(int index) {
        return this.answerX[index];
    }

    public double getSolutionY(int index) {
        return this.answerY[index];
    }

    private int evaluateTwoQuadraticEquations(double[] dpOutX, double[] dpOutY, double dInA1, double dInB1, double dInC1, double dInD1, double dInE1, double dInF1, double dInA2, double dInB2, double dInC2, double dInD2, double dInE2, double dInF2) {
        ToolAlgebra1D equation1D = this.__evaluateTwoQuadraticEquations_ToolAlgebra1D_1;
        ToolAlgebra1D equation1D_2 = this.__evaluateTwoQuadraticEquations_ToolAlgebra1D_2;
        double dG = dInA1 * dInB2 - dInA2 * dInB1;
        double dH = dInB2 * dInD1 - dInB1 * dInD2;
        double dI = dInC2 * dInE1 + dInC1 * dInE2;
        double dJ = dInB2 * dInC1 - dInB1 * dInC2;
        double dK = dInC1 * dInD2 - dInC2 * dInD1;
        double dL = dInB2 * dInF1 - dInB1 * dInF2;
        double dM = dInA1 * dInB2 + dInA2 * dInB1;
        double dN = dInB2 * dInD1 + dInB1 * dInD2;
        double dO = dInC2 * dInF1 - dInC1 * dInF2;
        double dP = dInB2 * dInF1 + dInB1 * dInF2;
        equation1D.set(dG * dG + dInA1 * dInB1 * dInC2 * dInC2 + dInA2 * dInB2 * dInC1 * dInC1 - dInC1 * dInC2 * dM, 2.0 * dG * dH - dM * dI + 2.0 * dInA1 * dInB1 * dInC2 * dInE2 + 2.0 * dInA2 * dInB2 * dInC1 * dInE1 + dJ * dK, dH * dH - dI * dN - dInE1 * dInE2 * dM + dG * 2.0 * dL - dJ * dO + 2.0 * dInB1 * dInC2 * dInD1 * dInE2 + 2.0 * dInB2 * dInC1 * dInD2 * dInE1 + dInA1 * dInB1 * dInE2 * dInE2 + dInA2 * dInB2 * dInE1 * dInE1, -dI * dP + 2.0 * dH * dL - dInE1 * dInE2 * dN + 2.0 * dInB1 * dInC2 * dInE2 * dInF1 + 2.0 * dInB2 * dInC1 * dInE1 * dInF2 + dInB1 * dInD1 * dInE2 * dInE2 + dInB2 * dInD2 * dInE1 * dInE1, dL * dL - dInE1 * dInE2 * dP + dInB1 * dInE2 * dInE2 * dInF1 + dInB2 * dInE1 * dInE1 * dInF2);
        int iN = equation1D.solve();
        double dA = dInA1 - dInA2;
        double dB = dInB1 - dInB2;
        double dC = dInC1 - dInC2;
        double dD = dInD1 - dInD2;
        double dE = dInE1 - dInE2;
        double dF = dInF1 - dInF2;
        int iOut = 0;
        for (int iCnt = 0; iCnt < iN; ++iCnt) {
            double y;
            double x = equation1D.getSolution(iCnt);
            double dAA = dB;
            double dBB = dC * x + dE;
            double dCC = dA * x * x + dD * x + dF;
            if (ToolAlgebra2DQuadratic.compare(dAA) == 0 && ToolAlgebra2DQuadratic.compare(dBB) == 0 && ToolAlgebra2DQuadratic.compare(dCC) == 0) {
                dAA = dInB1;
                dBB = dInC1 * x + dInE1;
                dCC = dInA1 * x * x + dInD1 * x + dInF1;
            }
            equation1D_2.set(dAA, dBB, dCC);
            int nCheck = equation1D_2.solve();
            if (nCheck >= 1 && (ToolAlgebra2DQuadratic.CheckPositionOfPoint(dInA1, dInB1, dInC1, dInD1, dInE1, dInF1, x, y = equation1D_2.getSolution(0), 1) || ToolAlgebra2DQuadratic.CheckPositionOfPoint(dInA2, dInB2, dInC2, dInD2, dInE2, dInF2, x, y, 1))) {
                dpOutX[iOut] = x;
                dpOutY[iOut] = y;
                ++iOut;
            }
            if (nCheck != 2 || !ToolAlgebra2DQuadratic.CheckPositionOfPoint(dInA1, dInB1, dInC1, dInD1, dInE1, dInF1, x, y = equation1D_2.getSolution(1), 1) && !ToolAlgebra2DQuadratic.CheckPositionOfPoint(dInA2, dInB2, dInC2, dInD2, dInE2, dInF2, x, y, 1)) continue;
            dpOutX[iOut] = x;
            dpOutY[iOut] = y;
            ++iOut;
        }
        return iOut;
    }

    private int evaluateTwoQuadraticEquations(double[] dpOutX, double[] dpOutY, double dInA1, double dInB1, double dInC1, double dInD1, double dInA2, double dInB2, double dInC2, double dInD2) {
        double dTmp;
        ToolAlgebra1D equation1D = this.__evaluateTwoQuadraticEquations_ToolAlgebra1D_3;
        equation1D.set(dInB1 * dInA2 - dInA1 * dInB2, dInB1 * dInC2 - dInB2 * dInC1 + dInA2 * dInD1 - dInA1 * dInD2, dInC2 * dInD1 - dInC1 * dInD2);
        int iN = equation1D.solve();
        if (iN == 1) {
            dpOutX[0] = equation1D.getSolution(0);
            dTmp = dInA1 * dpOutX[0] + dInC1;
            dpOutY[0] = ToolAlgebra2DQuadratic.compare(dTmp) == 0 ? 0.0 : -(dInB1 * dpOutX[0] + dInD1) / dTmp;
        }
        if (iN == 2) {
            dpOutX[1] = equation1D.getSolution(1);
            dTmp = dInA1 * dpOutX[1] + dInC1;
            dpOutY[1] = ToolAlgebra2DQuadratic.compare(dTmp) == 0 ? 0.0 : -(dInB1 * dpOutX[1] + dInD1) / dTmp;
        }
        return iN;
    }

    public static void main(String[] arg) {
        ToolAlgebra2DQuadratic.test2();
    }

    public static void test1() {
        ToolAlgebra2DQuadratic q1 = new ToolAlgebra2DQuadratic();
        ToolAlgebra2DQuadratic q2 = new ToolAlgebra2DQuadratic();
        q1.circle(0.0, 0.0, 10.0);
        q2.circle(15.0, 0.0, 10.0);
        int result = q1.solve(q2);
        for (int i = 0; i < result; ++i) {
            System.out.println("( " + q1.getSolutionX(i) + ", " + q1.getSolutionY(i) + " )");
        }
    }

    public static void test2() {
        ToolAlgebra2DQuadratic q1 = new ToolAlgebra2DQuadratic();
        ToolAlgebra2DQuadratic q2 = new ToolAlgebra2DQuadratic();
        q1.circle(0.0, 0.0, 10.0);
        q2.ellipse(0.0, 0.0, 20.0, 5.0);
        int result = q1.solve(q2);
        for (int i = 0; i < result; ++i) {
            System.out.println("( " + q1.getSolutionX(i) + ", " + q1.getSolutionY(i) + " )");
        }
    }
}

