/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.lib.kwt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public class KVFlowLayout
implements LayoutManager {
    public static final int FIT_OFF = 0;
    public static final int FIT_ON = 1;
    public static final int FIT_CENTER = 2;
    private int vgap;
    private int minWidth = 0;
    private int minHeight = 0;
    private int preferredWidth = 0;
    private int preferredHeight = 0;
    private boolean sizeUnknown = true;
    private int mFitMode = 0;
    private boolean mFirstLeft = false;

    public KVFlowLayout(int v) {
        this.vgap = v;
    }

    public KVFlowLayout(int v, int mode) {
        this.vgap = v;
        this.mFitMode = mode;
    }

    public void setFirstLeft(boolean flag) {
        this.mFirstLeft = flag;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    private void setSizes(Container parent) {
        int nComps = parent.getComponentCount();
        Dimension d = null;
        this.preferredWidth = 0;
        this.preferredHeight = 0;
        this.minWidth = 0;
        this.minHeight = 0;
        int i = 0;
        while (i < nComps) {
            Component c = parent.getComponent(i);
            if (c.isVisible()) {
                d = c.getPreferredSize();
                if (i > 0) {
                    if (this.preferredWidth < d.width) {
                        this.preferredWidth = d.width;
                    }
                    this.preferredHeight += this.vgap;
                } else {
                    this.preferredWidth = d.width;
                }
                this.preferredHeight += d.height;
                this.minWidth = Math.max(c.getMinimumSize().width, this.minWidth);
                this.minHeight = this.preferredHeight;
            }
            ++i;
        }
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Container kparent = parent;
        Dimension dim = new Dimension(0, 0);
        this.setSizes(parent);
        Insets insets = kparent.getInsets();
        dim.width = this.preferredWidth + insets.left + insets.right;
        dim.height = this.preferredHeight + insets.top + insets.bottom;
        this.sizeUnknown = false;
        return dim;
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        Container kparent = parent;
        Dimension dim = new Dimension(0, 0);
        Insets insets = kparent.getInsets();
        dim.width = this.minWidth + insets.left + insets.right;
        dim.height = this.minHeight + insets.top + insets.bottom;
        this.sizeUnknown = false;
        return dim;
    }

    @Override
    public void layoutContainer(Container parent) {
        Container kparent = parent;
        Insets insets = kparent.getInsets();
        int nComps = parent.getComponentCount();
        int previousHeight = 0;
        int x = insets.left;
        int y = insets.top;
        if (this.sizeUnknown) {
            this.setSizes(parent);
        }
        int i = 0;
        while (i < nComps) {
            Component c = parent.getComponent(i);
            if (c.isVisible()) {
                Dimension d = c.getPreferredSize();
                if (i == 0 && this.mFirstLeft) {
                    x = insets.left;
                } else if (this.mFitMode == 1) {
                    d.width = parent.getSize().width - insets.left - insets.right;
                } else {
                    x = this.mFitMode == 2 ? (parent.getSize().width - d.width) / 2 : insets.left;
                }
                if (i > 0) {
                    y += previousHeight + this.vgap;
                }
                c.setBounds(x, y, d.width, d.height);
                previousHeight = d.height;
            }
            ++i;
        }
    }
}

