/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.lib.kwt;

import java.awt.Cursor;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import jp.kitec.lib.kwt.KCursor;

public class KCursorManager {
    private static Map<KCursor, Cursor> mCurs;
    private static Map<KCursor, Integer> mCursType;

    public static Cursor getCursor(KCursor type) throws NoSuchElementException {
        if (mCurs.containsKey(type)) {
            return mCurs.get(type);
        }
        try {
            return Cursor.getSystemCustomCursor(type.name());
        }
        catch (Exception exception) {
            if (mCursType.containsKey(type)) {
                int t = mCursType.get(type);
                return Cursor.getPredefinedCursor(t);
            }
            throw new NoSuchElementException();
        }
    }

    public static void registerCursor(KCursor cursorType, int type) {
        mCursType.put(cursorType, type);
    }

    static {
        mCursType = new HashMap<KCursor, Integer>();
        mCurs = new HashMap<KCursor, Cursor>();
        mCurs.put(KCursor.CURSOR_DEF, new Cursor(0));
        mCurs.put(KCursor.CURSOR_VERT, new Cursor(8));
        mCurs.put(KCursor.CURSOR_MOVE, new Cursor(13));
        mCurs.put(KCursor.CURSOR_HOR, new Cursor(10));
        mCurs.put(KCursor.CURSOR_NE, new Cursor(7));
        mCurs.put(KCursor.CURSOR_NW, new Cursor(6));
        mCurs.put(KCursor.CURSOR_SW, new Cursor(4));
        mCurs.put(KCursor.CURSOR_SE, new Cursor(5));
        mCurs.put(KCursor.CURSOR_WAIT, new Cursor(3));
        mCurs.put(KCursor.CURSOR_HAND, new Cursor(12));
    }
}

