/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.lib.util;

import jp.kitec.lib.util.DigestUtil;
import org.apache.commons.lang.math.RandomUtils;

public class UniqueNameUtil {
    public static final String KEY_SEED = "seed";
    public static final String KEY_SUFFIX = "suffix";
    public static final String KEY_COMPRESS = "_compress";

    protected UniqueNameUtil() {
    }

    public static UniqueNameInfo createUniqueNameInfo(String path) {
        UniqueNameInfo uniqueNameInfo = new UniqueNameInfo();
        uniqueNameInfo.path = path;
        return uniqueNameInfo;
    }

    public static UniqueNameInfo createUniqueNameInfo(String prefix, String suffix) {
        UniqueNameInfo uniqueNameInfo = new UniqueNameInfo();
        uniqueNameInfo.prefix = prefix;
        uniqueNameInfo.epoch = System.currentTimeMillis();
        uniqueNameInfo.seed = Long.toString(RandomUtils.nextLong());
        uniqueNameInfo.suffix = suffix;
        return uniqueNameInfo;
    }

    public static String createUniqueName(UniqueNameInfo uniqueNameInfo) {
        return UniqueNameUtil.createUniqueName(uniqueNameInfo.prefix, uniqueNameInfo.epoch, uniqueNameInfo.seed, uniqueNameInfo.suffix);
    }

    public static String createUniqueName(String prefix, Long epoch, String seed, String suffix) {
        StringBuilder buf = new StringBuilder();
        if (prefix != null) {
            buf.append(prefix);
        }
        if (epoch != null) {
            buf.append(epoch);
        }
        if (seed != null) {
            buf.append(DigestUtil.md5((String)seed));
        }
        if (suffix != null) {
            buf.append(suffix);
        }
        return buf.toString();
    }

    public static String createRequestName(UniqueNameInfo uniqueNameInfo) {
        return String.valueOf(uniqueNameInfo.seed) + "/" + uniqueNameInfo.prefix + uniqueNameInfo.epoch + uniqueNameInfo.suffix;
    }

    public static class UniqueNameInfo {
        public String prefix;
        public Long epoch;
        public String seed;
        public String suffix;
        public String path;
    }
}

