/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.lib.kwt;

import java.awt.Component;
import java.awt.Font;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Vector;
import javax.imageio.ImageIO;
import jp.kitec.lib.io.FileSystem;
import jp.kitec.lib.kwt.KAwtFont;
import jp.kitec.lib.kwt.KAwtImage;
import jp.kitec.lib.kwt.KFont;
import jp.kitec.lib.kwt.KImage;
import jp.kitec.lib.kwt.KRuntime;

public class KAwtRuntime
extends KRuntime {
    private static Vector<KFont> mFonts = new Vector();
    private Component component;

    public static void install() {
        KRuntime.setRuntime((KRuntime)new KAwtRuntime());
    }

    public KFont getFont(Object o) {
        if (o == null || !(o instanceof Font)) {
            return null;
        }
        Font ff = (Font)o;
        return this.getFont(ff.getName(), ff.getStyle(), ff.getSize());
    }

    public KFont getFont(String fontname, int fontstyle, double fontsize) {
        int i = 0;
        while (i < mFonts.size()) {
            KFont f = mFonts.elementAt(i);
            if (f.getName().equalsIgnoreCase(fontname) && Math.abs(f.getSize() - fontsize) < (double)0.1f && fontstyle == f.getStyle()) {
                return f;
            }
            ++i;
        }
        KAwtFont f = new KAwtFont(fontname, fontstyle, fontsize);
        mFonts.addElement(f);
        return f;
    }

    public KImage wrapNativeImage(Object image) {
        if (image instanceof Image) {
            return new KAwtImage((Image)image);
        }
        return null;
    }

    public ImageObserver getImageObserver() {
        return this.component;
    }

    public KImage getImage(FileSystem fs, String s) throws IOException {
        byte[] data = fs.searchNode(null, s);
        if (data == null) {
            throw new IOException();
        }
        return this.wrapNativeImage(ImageIO.read(new ByteArrayInputStream(data)));
    }
}

