/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.lib.gui.tree;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import jp.kitec.lib.gui.event.ActionItem;
import jp.kitec.lib.kwt.KFont;
import jp.kitec.lib.kwt.KFontMetrics;

public class NodeItem
implements ActionItem {
    protected KFont mFont;
    private String mTitle;
    protected Image mRegularImage;
    protected Rectangle mPosRect;
    private Object mParent;
    protected int mSpace;
    private boolean mActive = false;
    private Object mNodeObject;
    private boolean mIsVisible = true;
    public int mIndex = -1;

    protected NodeItem(Object parent, String title, Image ri, int space, KFont fm) {
        this.mFont = fm;
        this.mTitle = title != null ? title : "none";
        this.mParent = parent;
        this.mRegularImage = ri;
        this.mSpace = space;
        this.mPosRect = new Rectangle(0, 0);
        KFontMetrics metrics = this.mFont.getFontMetrics((Object)this);
        this.mPosRect.width = (int)metrics.stringWidth(this.mTitle) + this.mSpace * 2;
        if (this.mRegularImage != null) {
            this.mPosRect.width += this.mRegularImage.getWidth(null) + this.mSpace;
        }
        this.mPosRect.height = (int)metrics.getHeight() + this.mSpace * 2;
        if (this.mRegularImage != null) {
            int imageHeight = this.mRegularImage.getHeight(null) + this.mSpace * 2;
            this.mPosRect.height = this.mPosRect.height > imageHeight ? this.mPosRect.height : imageHeight;
        }
    }

    public void setNodeObject(Object o) {
        this.mNodeObject = o;
    }

    public Object getNodeObject() {
        return this.mNodeObject;
    }

    public Object getActionObject() {
        return null;
    }

    public String getTitle() {
        return this.mTitle;
    }

    public Rectangle setPosition(int x, int y) {
        this.mPosRect.x = x;
        this.mPosRect.y = y;
        return this.mPosRect;
    }

    public Rectangle getPosition() {
        return this.mPosRect;
    }

    public void setParent(Object o) {
        this.mParent = o;
    }

    public Object getParent() {
        return this.mParent;
    }

    public void paint(Graphics g) {
        this.paint(g, this.mRegularImage);
    }

    public void paint(Graphics g, Image i) {
        int x = this.mPosRect.x + this.mSpace;
        int y = this.mPosRect.y;
        KFontMetrics metrics = this.mFont.getFontMetrics((Object)g);
        if (i != null) {
            g.drawImage(i, x, y + this.mSpace, null);
            x += i.getWidth(null);
        }
        if (this.mActive) {
            g.setColor(Color.red);
        } else {
            g.setColor(Color.black);
        }
        y = this.mPosRect.y + this.mPosRect.height - this.mSpace - (int)(((double)this.mPosRect.height - metrics.getAscent()) / 2.0);
        g.drawString(this.mTitle, x + this.mSpace, y);
    }

    public void setActive(boolean flag) {
        this.mActive = flag;
    }

    public boolean isActive() {
        return this.mActive;
    }

    public Object getSource() {
        return this;
    }

    public String getPath(String path) {
        path = path != null ? String.valueOf(this.mTitle) + "\\" + path : this.mTitle;
        if (this.mParent != null) {
            path = ((NodeItem)this.mParent).getPath(path);
        }
        return path;
    }

    public boolean isVisible() {
        return this.mIsVisible;
    }

    public void setVisible(boolean isVisible) {
        this.mIsVisible = isVisible;
    }
}

