/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.kwt.util;

import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import jp.kitec.kwt.KFont;
import jp.kitec.kwt.KFontMetrics;
import jp.kitec.kwt.KFontUtil;
import jp.kitec.lib.io.AbstFile;

public class ImageTool {
    private Container mImageObserver;
    private Graphics mDummyGraphics;
    public static int mImgDefW = 26;
    public static int mImgDefH = 26;

    public ImageTool(Container observer) {
        this.mImageObserver = observer;
        Image img = this.mImageObserver.createImage(1, 1);
        this.mDummyGraphics = img.getGraphics();
    }

    public Container getObserver() {
        return this.mImageObserver;
    }

    public Image changeClear(Image img, int w, int h, int col) {
        int[] pix = new int[w * h];
        PixelGrabber pg = new PixelGrabber(img, 0, 0, w, h, pix, 0, w);
        try {
            pg.grabPixels(1000L);
        }
        catch (Exception e) {
            return img;
        }
        for (int i = 0; i < w * h; ++i) {
            if (pix[i] != col) continue;
            int n = i;
            pix[n] = pix[n] & 0xFFFFFF;
        }
        Image result = this.mImageObserver.createImage(new MemoryImageSource(w, h, pix, 0, w));
        return result;
    }

    public Image changeDarker(Image img, int w, int h, int col, int alpha) {
        int[] pix = new int[w * h];
        PixelGrabber pg = new PixelGrabber(img, 0, 0, w, h, pix, 0, w);
        try {
            pg.grabPixels(1000L);
        }
        catch (Exception e) {
            return img;
        }
        for (int i = 0; i < w * h; ++i) {
            if (pix[i] == col) {
                int n = i;
                pix[n] = pix[n] & 0xFFFFFF;
                continue;
            }
            int r = pix[i] & 0xFF;
            int g = pix[i] >> 8 & 0xFF;
            int b = pix[i] >> 16 & 0xFF;
            float Y = 0.299f * (float)r + 0.587f * (float)g + 0.114f * (float)b;
            g = b = (int)Y;
            r = b;
            pix[i] = r | g << 8 | b << 16 | alpha << 24;
        }
        Image result = this.mImageObserver.createImage(new MemoryImageSource(w, h, pix, 0, w));
        return result;
    }

    public Image createEnableImage(Image img, int w, int h, int alpha) {
        int[] pix = new int[w * h];
        PixelGrabber pg = new PixelGrabber(img, 0, 0, w, h, pix, 0, w);
        try {
            pg.grabPixels(1000L);
        }
        catch (Exception e) {
            return img;
        }
        for (int i = 0; i < w * h; ++i) {
            if ((pix[i] & 0xFF000000) == 0) continue;
            int r = pix[i] & 0xFF;
            int g = pix[i] >> 8 & 0xFF;
            int b = pix[i] >> 16 & 0xFF;
            float Y = 0.299f * (float)r + 0.587f * (float)g + 0.114f * (float)b;
            g = b = (int)Y;
            r = b;
            pix[i] = r | g << 8 | b << 16 | alpha << 24;
        }
        Image result = this.mImageObserver.createImage(new MemoryImageSource(w, h, pix, 0, w));
        return result;
    }

    public static int[] getPix(Image timg, int w, int h) {
        int[] pix = new int[w * h];
        PixelGrabber pg = new PixelGrabber(timg, 0, 0, w, h, pix, 0, w);
        try {
            pg.grabPixels();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return pix;
    }

    public static Image getImage(AbstFile af, Container f) {
        if (af == null) {
            return null;
        }
        return ImageTool.getImage(af.getData(), f);
    }

    public static Image getImage(byte[] data, Container f) {
        if (data == null) {
            return null;
        }
        Image img1 = Toolkit.getDefaultToolkit().createImage(data);
        MediaTracker tracker = new MediaTracker(f);
        tracker.addImage(img1, 0);
        try {
            tracker.waitForAll();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return img1;
    }

    public Image createStrImageWide(String s, KFont f, Color fore, Color back) {
        return this.createStrImageA(s, f, 50, 20, fore, back, 1);
    }

    public Image createStrImage(String s, KFont f, Color fore, Color back, int margin, int wofs, int hofs) {
        KFontMetrics fm = f.getFontMetrics((Object)this.mDummyGraphics);
        return this.createStrImageA(s, f, (int)fm.stringWidth(s) + wofs, (int)fm.getHeight() + hofs, fore, back, margin);
    }

    public Image createStrImageA(String s, KFont f, int w, int h, Color fore, Color back, int margin) {
        String str1 = null;
        String str2 = null;
        String str = "";
        KFontMetrics fm = f.getFontMetrics((Object)this.mDummyGraphics);
        for (int i = 0; i < s.length(); ++i) {
            String tmp = str = str + s.substring(i, i + 1);
            if (fm.stringWidth(tmp) <= (double)(w - margin * 3 * 2)) {
                str = tmp;
                continue;
            }
            if (str1 != null) break;
            str1 = str;
            str = "";
        }
        if (str1 == null) {
            str1 = str;
        } else if (str.length() != 0) {
            str2 = str;
        }
        return this.createStrImageA(new String[]{str1, str2}, f, w, h, fore, back, margin);
    }

    public Image createStrImageA(String[] s, KFont f, int w, int h, Color fore, Color back, int margin) {
        Image img = this.mImageObserver.createImage(w, h);
        Graphics g = img.getGraphics();
        if (back == null) {
            g.setColor(Color.white);
        } else {
            g.setColor(back);
        }
        g.fillRect(0, 0, w, h);
        g.setColor(fore);
        g.setFont(KFontUtil.getFontObject(f));
        String str1 = null;
        String str2 = null;
        if (s.length > 0 && s[0] != null) {
            str1 = s[0];
        }
        if (s.length > 1 && s[1] != null) {
            str2 = s[1];
        }
        KFontMetrics fm = f.getFontMetrics((Object)g);
        if (str1 != null && str2 != null) {
            int h1 = (h - 2) / 2 - margin;
            int h2 = h - 2 - margin;
            g.drawString(str1, (int)((double)w - fm.stringWidth(str1)) / 2 + margin, h1);
            g.drawString(str2, (int)((double)w - fm.stringWidth(str2)) / 2 + margin, h2);
        } else if (str1 != null) {
            int h1 = (int)((double)h - ((double)(h - 0) - fm.getHeight()) / 2.0 - fm.getDescent());
            g.drawString(str1, (int)((double)w - fm.stringWidth(str1)) / 2 + margin, h1);
        }
        g.dispose();
        if (back == null) {
            return this.changeClear(img, w, h, -1);
        }
        return img;
    }
}

