/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.kwt;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.RadialGradientPaint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayDeque;
import java.util.Deque;
import jp.kitec.kwt.AbstractRichGraphics;
import jp.kitec.kwt.IRichGraphics;
import jp.kitec.kwt.KArcType;
import jp.kitec.kwt.KColor;
import jp.kitec.kwt.KDimension;
import jp.kitec.kwt.KFill;
import jp.kitec.kwt.KFont;
import jp.kitec.kwt.KFontMetrics;
import jp.kitec.kwt.KFontUtil;
import jp.kitec.kwt.KGradientFill;
import jp.kitec.kwt.KImage;
import jp.kitec.kwt.KLineType;
import jp.kitec.kwt.KLinearGradientFill;
import jp.kitec.kwt.KPathIterator;
import jp.kitec.kwt.KRadialGradientFill;
import jp.kitec.kwt.KwtAwtConverter;
import jp.kitec.kwt.RichGraphicsUtil;
import jp.kitec.lib.geom.KLocalAxis;

public class KRichGraphics
extends AbstractRichGraphics
implements IRichGraphics {
    protected static Stroke LINETYPE_DEF = new BasicStroke(1.0f);
    private Graphics mGC;
    private RenderingHints qualityHints;
    private AffineTransform mWorkTransform = new AffineTransform();
    private GeneralPath _path = new GeneralPath();
    private boolean mQuality;
    private KFill mColor;
    private Deque<State> mStateStack;

    public void setQuality(boolean quality) {
        this.mQuality = quality;
        if (this.mQuality) {
            this.qualityHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.qualityHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        } else {
            this.qualityHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
    }

    public boolean getQuality() {
        return this.mQuality;
    }

    private void updateDrawQuality(Graphics2D g2) {
        g2.setRenderingHints(this.qualityHints);
    }

    public void setGC(Graphics g) {
        this.mGC = g;
    }

    public Object getGC() {
        return this.mGC;
    }

    public void releaseGC() {
        this.mGC = null;
    }

    public KRichGraphics() {
        this.setQuality(false);
        this.mStateStack = new ArrayDeque<State>();
    }

    public void setTextDrawer(Object o) {
    }

    public void clip(KPathIterator shape) {
        if (this.mGC != null && this.mGC instanceof Graphics2D) {
            Graphics2D g2 = (Graphics2D)this.mGC;
            GeneralPath backup = this._path;
            this._path = new GeneralPath();
            this.pathAdd(shape, null);
            g2.clip(this._path);
            this._path = backup;
        }
    }

    public void setClipArea(double x1, double y1, double x2, double y2) {
        if (this.mGC != null && this.mGC instanceof Graphics2D) {
            Graphics g2 = this.mGC;
            int xa = this.realToDevX(Math.min(x1, x2));
            int ya = this.realToDevY(Math.max(y1, y2));
            int xb = this.realToDevX(Math.max(x1, x2));
            int yb = this.realToDevY(Math.min(y1, y2));
            g2.setClip(xa, ya, xb - xa, yb - ya);
        }
    }

    public void releaseClipArea() {
        if (this.mGC != null && this.mGC instanceof Graphics2D) {
            Graphics g2 = this.mGC;
            KDimension d = this.mDimension;
            g2.setClip(0, 0, d.width, d.height);
        }
    }

    public void save() {
        if (this.mGC != null && this.mGC instanceof Graphics2D) {
            Graphics g2 = this.mGC;
            State cur = new State(this.mColor, g2.getClip(), this.mQuality);
            this.mStateStack.addLast(cur);
        }
    }

    public void restore() {
        if (this.mGC != null && this.mGC instanceof Graphics2D) {
            Graphics g2 = this.mGC;
            State last = this.mStateStack.removeLast();
            this.setColor(last.mColor);
            g2.setClip(last.mClip);
            this.setQuality(last.mQuality);
        }
    }

    public void drawBufferImage(Image img) {
        if (this.mGC != null && this.mGC instanceof Graphics2D) {
            this.mGC.drawImage(img, 0, 0, null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setColor(KFill c) {
        this.mColor = c;
        if (this.mGC == null || !(this.mGC instanceof Graphics2D)) return;
        Graphics2D g2 = (Graphics2D)this.mGC;
        if (c instanceof KColor) {
            g2.setPaint(null);
            g2.setColor(KwtAwtConverter.asAwtColor((KColor)c));
            return;
        } else {
            if (!(c instanceof KGradientFill)) throw new IllegalArgumentException();
            KGradientFill gf = (KGradientFill)c;
            double[] fr = gf.getFractions();
            KColor[] cl = gf.getColor();
            float[] fractions = new float[fr.length];
            Color[] colors = new Color[cl.length];
            for (int i = 0; i < fr.length; ++i) {
                fractions[i] = (float)fr[i];
                colors[i] = KwtAwtConverter.asAwtColor(cl[i]);
            }
            if (c instanceof KLinearGradientFill) {
                KLinearGradientFill f = (KLinearGradientFill)c;
                float sx = this.realToDevX(f.getStartX());
                float sy = this.realToDevY(f.getStartY());
                float ex = this.realToDevX(f.getEndX());
                float ey = this.realToDevY(f.getEndY());
                LinearGradientPaint p = new LinearGradientPaint(sx, sy, ex, ey, fractions, colors);
                g2.setPaint(p);
                return;
            } else {
                if (!(c instanceof KRadialGradientFill)) throw new IllegalArgumentException();
                KRadialGradientFill f = (KRadialGradientFill)c;
                float cx = this.realToDevX(f.getCenterX());
                float cy = this.realToDevY(f.getCenterY());
                float fx = this.realToDevX(f.getFocusX());
                float fy = this.realToDevY(f.getFocusY());
                float radius = (float)(f.getRadius() * this.mDotPerLen);
                RadialGradientPaint p = new RadialGradientPaint(cx, cy, radius, fx, fy, fractions, colors, MultipleGradientPaint.CycleMethod.NO_CYCLE);
                g2.setPaint(p);
            }
        }
    }

    public void drawLine(double x1, double y1, double x2, double y2, KLineType lt) {
        if (this.mGC == null) {
            return;
        }
        double xa = this.realToDevXd(x1);
        double ya = this.realToDevYd(y1);
        double xb = this.realToDevXd(x2);
        double yb = this.realToDevYd(y2);
        if (this.mGC != null && this.mGC instanceof Graphics2D) {
            Graphics2D g2 = (Graphics2D)this.mGC;
            this.updateDrawQuality(g2);
            this.setStroke(g2, lt);
            g2.draw(new Line2D.Double(xa, ya, xb, yb));
            g2.setStroke(LINETYPE_DEF);
        }
    }

    public void drawCircle(double xc1, double yc1, double ra, double ss, double ee, KArcType type, KLineType lt) {
        double xc = this.realToDevXd(xc1);
        double yc = this.realToDevYd(yc1);
        double r = ra * this.mDotPerLen;
        if (xc + r < 0.0 || xc - r > (double)this.mDimension.width) {
            return;
        }
        if (yc + r < 0.0 || yc - r > (double)this.mDimension.height) {
            return;
        }
        if (this.mGC != null && this.mGC instanceof Graphics2D) {
            Graphics2D g2 = (Graphics2D)this.mGC;
            this.updateDrawQuality(g2);
            this.setStroke(g2, lt);
            if (ss == ee) {
                g2.draw(new Arc2D.Double(xc - r, yc - r, r * 2.0, r * 2.0, 0.0, 360.0, this.toArtType(type)));
            } else {
                g2.draw(new Arc2D.Double(xc - r, yc - r, r * 2.0, r * 2.0, ss, ee - ss, this.toArtType(type)));
            }
            g2.setStroke(LINETYPE_DEF);
        }
    }

    public void drawFillCircle(double xc1, double yc1, double ra, double ss, double ee, KArcType type, KLineType lt) {
        double xc = this.realToDevXd(xc1);
        double yc = this.realToDevYd(yc1);
        double r = ra * this.mDotPerLen;
        if (xc + r < 0.0 || xc - r > (double)this.mDimension.width) {
            return;
        }
        if (yc + r < 0.0 || yc - r > (double)this.mDimension.height) {
            return;
        }
        if (this.mGC != null && this.mGC instanceof Graphics2D) {
            Graphics2D g2 = (Graphics2D)this.mGC;
            this.updateDrawQuality(g2);
            this.setStroke(g2, lt);
            if (ss == ee) {
                g2.fill(new Arc2D.Double(xc - r - 0.0, yc - r, r * 2.0, r * 2.0, 0.0, 360.0, this.toArtType(type)));
            } else {
                g2.fill(new Arc2D.Double(xc - r - 0.0, yc - r, r * 2.0, r * 2.0, ss, ee - ss, this.toArtType(type)));
            }
            g2.setStroke(LINETYPE_DEF);
        }
    }

    public void drawEllipse(double xc1, double yc1, double v, double h, double ss, double ee, KArcType type, KLineType lt) {
        double xc = this.realToDevXd(xc1);
        double yc = this.realToDevYd(yc1);
        double vv = v * this.mDotPerLen;
        double hh = h * this.mDotPerLen;
        if (xc + hh < 0.0 || xc - hh > (double)this.mDimension.width) {
            return;
        }
        if (yc + vv < 0.0 || yc - vv > (double)this.mDimension.height) {
            return;
        }
        if (this.mGC != null && this.mGC instanceof Graphics2D) {
            Graphics2D g2 = (Graphics2D)this.mGC;
            this.updateDrawQuality(g2);
            this.setStroke(g2, lt);
            if (ss == ee) {
                g2.draw(new Arc2D.Double(xc - hh, yc - vv, hh * 2.0, vv * 2.0, 0.0, 360.0, this.toArtType(type)));
            } else {
                g2.draw(new Arc2D.Double(xc - hh, yc - vv, hh * 2.0, vv * 2.0, ss, ee - ss, this.toArtType(type)));
            }
            g2.setStroke(LINETYPE_DEF);
        }
    }

    public void drawFillEllipse(double xc1, double yc1, double v, double h, double ss, double ee, KArcType type, KLineType lt) {
        double xc = this.realToDevXd(xc1);
        double yc = this.realToDevYd(yc1);
        double vv = v * this.mDotPerLen;
        double hh = h * this.mDotPerLen;
        if (xc + hh < 0.0 || xc - hh > (double)this.mDimension.width) {
            return;
        }
        if (yc + vv < 0.0 || yc - vv > (double)this.mDimension.height) {
            return;
        }
        if (this.mGC != null && this.mGC instanceof Graphics2D) {
            Graphics2D g2 = (Graphics2D)this.mGC;
            this.updateDrawQuality(g2);
            this.setStroke(g2, lt);
            if (ss == ee) {
                g2.fill(new Arc2D.Double(xc - hh, yc - vv, hh * 2.0, vv * 2.0, 0.0, 360.0, this.toArtType(type)));
            } else {
                g2.fill(new Arc2D.Double(xc - hh, yc - vv, hh * 2.0, vv * 2.0, ss, ee - ss, this.toArtType(type)));
            }
            g2.setStroke(LINETYPE_DEF);
        }
    }

    public void drawRect(double x1, double y1, double x2, double y2, KLineType lt) {
        double tmp;
        double xa = this.realToDevXd(x1);
        double ya = this.realToDevYd(y1);
        double xb = this.realToDevXd(x2);
        double yb = this.realToDevYd(y2);
        if (xa > xb) {
            tmp = xa;
            xa = xb;
            xb = tmp;
        }
        if (ya < yb) {
            tmp = ya;
            ya = yb;
            yb = tmp;
        }
        if (this.mGC != null && this.mGC instanceof Graphics2D) {
            Graphics2D g2 = (Graphics2D)this.mGC;
            this.updateDrawQuality(g2);
            this.setStroke(g2, lt);
            g2.draw(new Rectangle2D.Double(xa, yb, xb - xa + 1.0, ya - yb + 1.0));
            g2.setStroke(LINETYPE_DEF);
        }
    }

    public void drawFillRect(double x1, double y1, double x2, double y2, KLineType lt) {
        double tmp;
        double xa = this.realToDevXd(x1);
        double ya = this.realToDevYd(y1);
        double xb = this.realToDevXd(x2);
        double yb = this.realToDevYd(y2);
        if (xa > xb) {
            tmp = xa;
            xa = xb;
            xb = tmp;
        }
        if (ya < yb) {
            tmp = ya;
            ya = yb;
            yb = tmp;
        }
        if (this.mGC != null && this.mGC instanceof Graphics2D) {
            Graphics2D g2 = (Graphics2D)this.mGC;
            this.updateDrawQuality(g2);
            this.setStroke(g2, lt);
            g2.setStroke(new BasicStroke((float)(3.0 * this.mDotPerLen)));
            g2.fill(new Rectangle2D.Double(xa, yb, xb - xa + 1.0, ya - yb + 1.0));
            g2.setStroke(LINETYPE_DEF);
        }
    }

    public void drawRoundRect(double x1, double y1, double x2, double y2, double round, KLineType lt) {
        double tmp;
        double xa = this.realToDevXd(x1);
        double ya = this.realToDevYd(y1);
        double xb = this.realToDevXd(x2);
        double yb = this.realToDevYd(y2);
        int r = (int)(round * this.mDotPerLen);
        if (xa > xb) {
            tmp = xa;
            xa = xb;
            xb = tmp;
        }
        if (ya < yb) {
            tmp = ya;
            ya = yb;
            yb = tmp;
        }
        if (this.mGC != null && this.mGC instanceof Graphics2D) {
            Graphics2D g2 = (Graphics2D)this.mGC;
            this.updateDrawQuality(g2);
            this.setStroke(g2, lt);
            g2.draw(new RoundRectangle2D.Double(xa, yb, xb - xa + 1.0, ya - yb + 1.0, r, r));
            g2.setStroke(LINETYPE_DEF);
        }
    }

    public void drawFillRoundRect(double x1, double y1, double x2, double y2, double round, KLineType lt) {
        double tmp;
        double xa = this.realToDevXd(x1);
        double ya = this.realToDevYd(y1);
        double xb = this.realToDevXd(x2);
        double yb = this.realToDevYd(y2);
        int r = (int)(round * this.mDotPerLen);
        if (xa > xb) {
            tmp = xa;
            xa = xb;
            xb = tmp;
        }
        if (ya < yb) {
            tmp = ya;
            ya = yb;
            yb = tmp;
        }
        if (this.mGC != null && this.mGC instanceof Graphics2D) {
            Graphics2D g2 = (Graphics2D)this.mGC;
            this.updateDrawQuality(g2);
            this.setStroke(g2, lt);
            g2.fill(new RoundRectangle2D.Double(xa, yb, xb - xa + 1.0, ya - yb + 1.0, r, r));
            g2.setStroke(LINETYPE_DEF);
        }
    }

    public void drawImage(KImage img, double x1, double y1) {
        if (this.mGC != null && this.mGC instanceof Graphics2D) {
            Graphics2D g2 = (Graphics2D)this.mGC;
            this.updateDrawQuality(g2);
            int xa = this.realToDevX(x1);
            int ya = this.realToDevY(y1);
            g2.drawImage((Image)img.getNativeImage(), xa, ya, null);
        }
    }

    public void drawImage(KImage img, String id, double x1, double y1, double x2, double y2) {
        this.drawImage(img, x1, y1, x2, y2);
    }

    public void drawImage(KImage img, String prefix, String id, double x1, double y1, double x2, double y2) {
        this.drawImage(img, x1, y1, x2, y2);
    }

    public void drawImage(KImage img, double x1, double y1, double x2, double y2) {
        if (this.mGC != null && this.mGC instanceof Graphics2D) {
            int tmp;
            Graphics2D g2 = (Graphics2D)this.mGC;
            this.updateDrawQuality(g2);
            int xa = this.realToDevX(x1);
            int ya = this.realToDevY(y1);
            int xb = this.realToDevX(x2);
            int yb = this.realToDevY(y2);
            if (xa > xb) {
                tmp = xa;
                xa = xb;
                xb = tmp;
            }
            if (ya < yb) {
                tmp = ya;
                ya = yb;
                yb = tmp;
            }
            g2.drawImage((Image)img.getNativeImage(), xa, yb, xb - xa, ya - yb, null);
        }
    }

    public void drawImage(KImage img, double cx, double cy, double width, double height, double angle) {
        if (this.mGC != null && this.mGC instanceof Graphics2D) {
            Graphics2D g2 = (Graphics2D)this.mGC;
            this.updateDrawQuality(g2);
            double xa = this.realToDevXd(cx);
            double ya = this.realToDevYd(cy);
            double w = width * this.mDotPerLen;
            double h = height * this.mDotPerLen;
            KDimension size = img.getSize();
            this.mWorkTransform.setToIdentity();
            this.mWorkTransform.translate(xa, ya);
            this.mWorkTransform.rotate(-angle * Math.PI / 180.0);
            this.mWorkTransform.translate(-w / 2.0, -h / 2.0);
            this.mWorkTransform.scale(w / (double)size.width, h / (double)size.height);
            Image image = (Image)img.getNativeImage();
            g2.drawImage(image, this.mWorkTransform, null);
            this.mWorkTransform.setToIdentity();
        }
    }

    public void drawText(String s, double x1, double y1, String fontname, int fonttype, double size, double angl) {
        if (this.mGC != null && this.mGC instanceof Graphics2D) {
            Graphics2D g2 = (Graphics2D)this.mGC;
            this.updateDrawQuality(g2);
            int xa = this.realToDevX(x1);
            int ya = this.realToDevY(y1);
            while (angl < 0.0) {
                angl += 360.0;
            }
            if (this.mDimension == null || this.mDimension.width == 0 && this.mDimension.height == 0) {
                return;
            }
            if ((double)ya - this.mDotPerLen * size > (double)this.mDimension.height || ya < 0) {
                return;
            }
            if (xa > this.mDimension.width) {
                return;
            }
            double tsize = Math.floor(this.mDotPerLen * size);
            KFont font = KFont.getFont((String)fontname, (int)fonttype, (double)tsize);
            if ((double)xa + font.getFontMetrics((Object)this.mGC).stringWidth(s) < 0.0) {
                return;
            }
            g2.setFont(KFontUtil.getFontObject(font));
            if (angl == 0.0) {
                if (s.length() > 1) {
                    KFont orgFont = KFont.getFont((String)fontname, (int)fonttype, (double)size);
                    double totw = orgFont.getFontMetrics((Object)this.mGC).stringWidth(s);
                    KFont scaleFont = font;
                    int totws = 0;
                    for (int i = 0; i < s.length(); ++i) {
                        String ss = s.substring(i, i + 1);
                        totws = (int)((double)totws + scaleFont.getFontMetrics((Object)this.mGC).stringWidth(ss));
                    }
                    double rate = totw / (double)totws;
                    double tmpx = x1;
                    for (int i = 0; i < s.length(); ++i) {
                        String ss = s.substring(i, i + 1);
                        int xx = this.realToDevX(tmpx);
                        if (ss.length() > 0) {
                            g2.drawString(ss, xx, ya);
                        }
                        tmpx += scaleFont.getFontMetrics((Object)this.mGC).stringWidth(ss) * rate;
                    }
                } else if (s.length() > 0) {
                    g2.drawString(s, xa, ya);
                }
            } else {
                this.mWorkTransform.setToIdentity();
                this.mWorkTransform.rotate(-angl * Math.PI / 180.0, xa, ya);
                g2.setTransform(this.mWorkTransform);
                g2.drawString(s, xa, ya);
                this.mWorkTransform.setToIdentity();
                g2.setTransform(this.mWorkTransform);
            }
        }
    }

    public void drawTextCenter(double x1, double y1, KFont f, String s, KColor col) {
        if (this.mGC != null && this.mGC instanceof Graphics2D) {
            Graphics2D g2 = (Graphics2D)this.mGC;
            this.updateDrawQuality(g2);
            int xa = this.realToDevX(x1);
            int ya = this.realToDevY(y1);
            g2.setFont(KFontUtil.getFontObject(f));
            this.setColor((KFill)col);
            KFontMetrics fm = f.getFontMetrics((Object)this.mGC);
            int ofsx = (int)Math.round(fm.stringWidth(s) / 2.0);
            int ofsy = (int)Math.round(fm.getHeight() / 2.0);
            if (s.length() > 0) {
                g2.drawString(s, xa - ofsx, ya + ofsy);
            }
        }
    }

    public void drawMark(double x, double y, int r, int type) {
        int xc = this.realToDevX(x);
        int yc = this.realToDevY(y);
        if (this.mGC != null && this.mGC instanceof Graphics2D) {
            Graphics2D g2 = (Graphics2D)this.mGC;
            this.updateDrawQuality(g2);
            switch (type) {
                case 0: {
                    g2.drawArc(xc - r, yc - r, r * 2, r * 2, 0, 360);
                    break;
                }
                case 1: {
                    g2.fillArc(xc - r, yc - r, r * 2, r * 2, 0, 360);
                    break;
                }
                case 2: {
                    g2.drawRect(xc - r, yc - r, r * 2, r * 2);
                    break;
                }
                case 3: {
                    g2.fillRect(xc - r, yc - r, r * 2, r * 2);
                    break;
                }
                case 4: {
                    g2.drawLine(xc - r, yc, xc + r, yc);
                    g2.drawLine(xc, yc - r, xc, yc + r);
                }
            }
        }
    }

    private void setStroke(Graphics2D g2, KLineType lt) {
        if (lt != null) {
            float lw = lt.getWidth();
            if (lt.getWidthType() == 0) {
                lw = (float)((double)lw * this.mDotPerLen);
            }
            if (lt.getStroke() != null) {
                float[] dash = lt.getStroke();
                if (lt.getWidthType() == 0) {
                    float[] dash2 = new float[dash.length];
                    for (int i = 0; i < dash.length; ++i) {
                        dash2[i] = (float)((double)dash[i] * this.mDotPerLen);
                    }
                    dash = dash2;
                }
                g2.setStroke(new BasicStroke(lw, this.toBasicStroke(lt.getCap()), this.toBasicStroke(lt.getJoin()), (float)lt.getMiterLimit(), dash, 0.0f));
            } else {
                g2.setStroke(new BasicStroke(lw, this.toBasicStroke(lt.getCap()), this.toBasicStroke(lt.getJoin()), (float)lt.getMiterLimit()));
            }
        } else {
            g2.setStroke(LINETYPE_DEF);
        }
    }

    private int toBasicStroke(KLineType.Cap cap) {
        switch (cap) {
            case BUTT: {
                return 0;
            }
            case ROUND: {
                return 1;
            }
            case SQUARE: {
                return 2;
            }
        }
        throw new IllegalArgumentException();
    }

    private int toBasicStroke(KLineType.Join cap) {
        switch (cap) {
            case BEVEL: {
                return 2;
            }
            case MITER: {
                return 0;
            }
            case ROUND: {
                return 1;
            }
        }
        throw new IllegalArgumentException();
    }

    private int toArtType(KArcType type) {
        switch (type) {
            case CHORD: {
                return 1;
            }
            case OPEN: {
                return 0;
            }
            case PIE: {
                return 2;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pathInit(int i) {
        this.pathClear();
        switch (i) {
            case 4096: {
                this._path.setWindingRule(0);
                break;
            }
            case 8192: {
                this._path.setWindingRule(1);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public void pathClear() {
        this._path.reset();
    }

    public void pathMoveTo(double x, double y, KLocalAxis la) {
        Point2D p = this._path.getCurrentPoint();
        float xx = (float)this.getx(x, y, la);
        float yy = (float)this.gety(x, y, la);
        if (p != null && RichGraphicsUtil.isSame2D((double)xx, (double)yy, (double)p.getX(), (double)p.getY())) {
            return;
        }
        this._path.moveTo(xx, yy);
    }

    public void pathLineTo(double x, double y, KLocalAxis la) {
        this._path.lineTo((float)this.getx(x, y, la), (float)this.gety(x, y, la));
    }

    public void pathQuadTo(double x1, double y1, double x2, double y2, KLocalAxis la) {
        this._path.quadTo((float)this.getx(x1, y1, la), (float)this.gety(x1, y1, la), (float)this.getx(x2, y2, la), (float)this.gety(x2, y2, la));
    }

    public void pathCurveTo(double x1, double y1, double x2, double y2, double x3, double y3, KLocalAxis la) {
        this._path.curveTo((float)this.getx(x1, y1, la), (float)this.gety(x1, y1, la), (float)this.getx(x2, y2, la), (float)this.gety(x2, y2, la), (float)this.getx(x3, y3, la), (float)this.gety(x3, y3, la));
    }

    public void pathClose() {
        this._path.closePath();
    }

    public void fillPath(KLineType lt) {
        if (this.mGC != null && this.mGC instanceof Graphics2D) {
            Graphics2D g2 = (Graphics2D)this.mGC;
            this.updateDrawQuality(g2);
            this.setStroke(g2, lt);
            g2.fill(this._path);
            g2.setStroke(LINETYPE_DEF);
        }
    }

    public void drawPath(KLineType lt) {
        if (this.mGC != null && this.mGC instanceof Graphics2D) {
            Graphics2D g2 = (Graphics2D)this.mGC;
            this.updateDrawQuality(g2);
            this.setStroke(g2, lt);
            g2.draw(this._path);
            g2.setStroke(LINETYPE_DEF);
        }
    }

    @Deprecated
    public void shadePath(KLineType lt, double x1, double y1, double x2, double y2, KColor c1, KColor c2, boolean cyclic) {
        if (this.mGC != null && this.mGC instanceof Graphics2D) {
            Graphics2D g2 = (Graphics2D)this.mGC;
            this.updateDrawQuality(g2);
            this.setStroke(g2, lt);
            x1 = this.realToDevXd(x1);
            x2 = this.realToDevXd(x2);
            y1 = this.realToDevYd(y1);
            y2 = this.realToDevYd(y2);
            if (!cyclic) {
                g2.setPaint(new GradientPaint((float)x1, (float)y1, KwtAwtConverter.asAwtColor(c1), (float)x2, (float)y2, KwtAwtConverter.asAwtColor(c2)));
            } else {
                x2 = x1 + (x2 - x1) / 2.0;
                y2 = y1 + (y2 - y1) / 2.0;
                g2.setPaint(new GradientPaint((float)x1, (float)y1, KwtAwtConverter.asAwtColor(c1), (float)x2, (float)y2, KwtAwtConverter.asAwtColor(c2), cyclic));
            }
            g2.fill(this._path);
            g2.setStroke(LINETYPE_DEF);
        }
    }

    protected static class State {
        public KFill mColor;
        public Shape mClip;
        public boolean mQuality;

        public State(KFill color, Shape clip, boolean quality) {
            this.mColor = color;
            this.mClip = clip;
            this.mQuality = quality;
        }
    }
}

