/*
 * Decompiled with CFR 0.152.
 */
package jp.kitec.lib.util.timer;

import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import jp.kitec.lib.util.timer.KTimerIterator;
import jp.kitec.lib.util.timer.KTimerTask;

public class KTimerScheduler {
    private final Timer timer = new Timer();

    public void cancel() {
        this.timer.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(KTimerTask schedulerTask, KTimerIterator iterator) {
        Date time = iterator.next();
        if (time == null) {
            schedulerTask.cancel();
        } else {
            Object object = schedulerTask.lock;
            synchronized (object) {
                if (schedulerTask.state != 0) {
                    throw new IllegalStateException("Task already scheduled or cancelled");
                }
                schedulerTask.state = 1;
                schedulerTask.timerTask = new SchedulerTimerTask(schedulerTask, iterator);
                this.timer.schedule(schedulerTask.timerTask, time);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reschedule(KTimerTask schedulerTask, KTimerIterator iterator) {
        Date time = iterator.next();
        if (time == null) {
            schedulerTask.cancel();
        } else {
            Object object = schedulerTask.lock;
            synchronized (object) {
                if (schedulerTask.state != 2) {
                    schedulerTask.timerTask = new SchedulerTimerTask(schedulerTask, iterator);
                    this.timer.schedule(schedulerTask.timerTask, time);
                }
            }
        }
    }

    class SchedulerTimerTask
    extends TimerTask {
        private KTimerTask schedulerTask;
        private KTimerIterator iterator;

        public SchedulerTimerTask(KTimerTask schedulerTask, KTimerIterator iterator) {
            this.schedulerTask = schedulerTask;
            this.iterator = iterator;
        }

        @Override
        public void run() {
            this.schedulerTask.run();
            KTimerScheduler.this.reschedule(this.schedulerTask, this.iterator);
        }
    }
}

